/*
 * Decompiled with CFR 0.152.
 */
package jstyle;

import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

class JSLineBreaker {
    private static final int BEFORE = 0;
    private static final int AFTER = 1;
    private String[] prefs = new String[]{"().", "()", ").", "+=", "-=", "*=", "/=", "%=", "^=", "||", "&&", "==", "!=", ">=", "<=", "(", ")", "[", "]", "?", ":", ",", ";", "=", "<", ">", "+", "-", "*", "/", "&", "|", "^"};
    private static Hashtable prefTable = new Hashtable();
    private Vector brokenLineVector;
    private StringBuffer wsBuffer;
    private char quoteChar;
    private boolean isInQuote;
    private boolean isInComment;
    private boolean isNestedConnection = true;
    private boolean isCut;
    private boolean isLineComment;
    private int parenDepth;
    private int breakDepth;
    private int preferredLineLength = 70;
    private int lineLengthDeviation = 5;
    private LineBreak previousLineBreak = null;

    JSLineBreaker() {
        this.init();
    }

    private void addBrokenLine(String string, String string2, LineBreak lineBreak, int n, boolean bl) {
        boolean bl2 = false;
        string2 = string2.trim();
        if (this.previousLineBreak != null) {
            String string3 = (String)this.brokenLineVector.lastElement();
            if ((string2.length() + string3.length() <= this.preferredLineLength + this.lineLengthDeviation || string2.startsWith("{")) && (lineBreak == null || this.isNestedConnection && !",".equals(this.previousLineBreak.breakStr) || lineBreak.breakDepth < this.previousLineBreak.breakDepth || lineBreak.breakDepth == this.previousLineBreak.breakDepth && (!this.isNestedConnection && !",".equals(this.previousLineBreak.breakStr) || ",".equals(lineBreak.breakStr) || ";".equals(lineBreak.breakStr) || ")".equals(lineBreak.breakStr) || "]".equals(lineBreak.breakStr)))) {
                this.brokenLineVector.setElementAt(string3 + " " + string2, this.brokenLineVector.size() - 1);
                bl2 = true;
            }
        }
        if (!bl2) {
            if (bl && (this.previousLineBreak == null || !",".equals(this.previousLineBreak.breakStr) || this.previousLineBreak.breakDepth != 0)) {
                string2 = "        " + string2;
            }
            string2 = string + string2;
            this.brokenLineVector.addElement(string2);
        }
        this.previousLineBreak = lineBreak;
    }

    /*
     * Unable to fully structure code
     */
    void breakLine(String var1_1) {
        var2_2 = new StringBuffer();
        var3_3 = new Stack<E>();
        var4_4 = "";
        var5_5 = false;
        var6_6 = ' ';
        var7_7 = '\u0000';
        var10_8 = false;
        var11_9 = false;
        var12_10 = false;
        var14_11 = 0;
        if (var1_1.trim().length() == 0) {
            this.brokenLineVector.addElement("");
            return;
        }
        var6_6 = var1_1.charAt(0);
        var9_12 = 0;
        if (!this.isLineComment) {
            this.isCut = false;
        }
        this.isLineComment = false;
        if (!this.isCut) {
            this.wsBuffer = new StringBuffer();
            while ((var6_6 == ' ' || var6_6 == '\t') && var9_12 < var1_1.length() - 1) {
                this.wsBuffer.append(var6_6);
                var6_6 = var1_1.charAt(++var9_12);
            }
        }
        var8_13 = var9_12;
        while (var8_13 < var1_1.length()) {
            block21: {
                block28: {
                    block27: {
                        block26: {
                            block25: {
                                block24: {
                                    block23: {
                                        block22: {
                                            block20: {
                                                if (var6_6 != ' ' && var6_6 != '\t') {
                                                    var7_7 = var6_6;
                                                }
                                                var6_6 = var1_1.charAt(var8_13);
                                                if (!var5_5) break block20;
                                                var2_2.append(var6_6);
                                                var5_5 = false;
                                                break block21;
                                            }
                                            if (this.isInComment || this.isLineComment || !var1_1.regionMatches(false, var8_13, "\\\\", 0, 2)) break block22;
                                            var2_2.append("\\\\");
                                            ++var8_13;
                                            break block21;
                                        }
                                        if (this.isInComment || this.isLineComment || var6_6 != 92) break block23;
                                        var2_2.append(var6_6);
                                        var5_5 = true;
                                        break block21;
                                    }
                                    if (this.isInQuote || this.isInComment || this.isLineComment || !var1_1.regionMatches(false, var8_13, "//", 0, 2)) break block24;
                                    this.isLineComment = true;
                                    var2_2.append("//");
                                    ++var8_13;
                                    break block21;
                                }
                                if (this.isInQuote || this.isInComment || this.isLineComment || !var1_1.regionMatches(false, var8_13, "/*", 0, 2)) break block25;
                                this.isInComment = true;
                                var2_2.append("/*");
                                ++var8_13;
                                break block21;
                            }
                            if (this.isInQuote || !this.isInComment && !this.isLineComment || !var1_1.regionMatches(false, var8_13, "*/", 0, 2)) break block26;
                            this.isInComment = false;
                            var2_2.append("*/");
                            ++var8_13;
                            break block21;
                        }
                        if (!this.isInComment && !this.isLineComment) break block27;
                        var2_2.append(var6_6);
                        break block21;
                    }
                    if (var6_6 != '\"' && var6_6 != 39) ** GOTO lbl-1000
                    if (this.isInQuote) break block28;
                    this.quoteChar = var6_6;
                    this.isInQuote = true;
                    ** GOTO lbl-1000
                }
                if (this.quoteChar == var6_6) {
                    this.isInQuote = false;
                    var2_2.append(var6_6);
                } else if (this.isInQuote) {
                    var2_2.append(var6_6);
                } else {
                    var2_2.append(var6_6);
                    var15_14 = 0;
                    while (var15_14 < this.prefs.length) {
                        var16_17 = this.prefs[var15_14];
                        if (var1_1.regionMatches(false, var8_13, var16_17, 0, var16_17.length())) {
                            var17_19 = 1;
                            if (var6_6 == '(' || var6_6 == '[' || var6_6 == ')' || var6_6 == ']') {
                                if (!("(".equals(var16_17) || var6_6 == '[' || var6_6 != ')' && var6_6 != ']')) {
                                    --this.parenDepth;
                                }
                                this.breakDepth = ++this.parenDepth;
                                if (var6_6 == ')' || var6_6 == ']' || var16_17.startsWith("()")) {
                                    ++this.breakDepth;
                                }
                                var17_19 = var6_6 == '(' || var6_6 == '[' ? (var7_7 >= 'a' && var7_7 <= 'z' || var7_7 >= 'A' && var7_7 <= 'Z' || var7_7 >= '0' && var7_7 <= '9' || var7_7 == '.' ? 1 : 0) : 1;
                            }
                            if (var16_17.length() > 1) {
                                var2_2.append(var16_17.substring(1));
                                var8_13 += var16_17.length() - 1;
                            }
                            this.registerLineBreak(var3_3, new LineBreak(var16_17, var2_2.length() + var14_11, this.breakDepth, var17_19));
                            this.breakDepth = this.parenDepth;
                            break;
                        }
                        ++var15_14;
                    }
                    var16_16 = var2_2.length() + this.wsBuffer.length() + var4_4.length() + (this.isCut != false ? 8 : 0);
                    var17_18 = null;
                    if (var16_16 > this.preferredLineLength && var8_13 < var1_1.length() - this.lineLengthDeviation) {
                        while (!var3_3.isEmpty()) {
                            var17_18 = (LineBreak)var3_3.elementAt(0);
                            if (var17_18.breakWhere - var14_11 >= 1) break;
                            var17_18 = null;
                            var3_3.removeElementAt(0);
                        }
                        if (var17_18 != null) {
                            var3_3.removeElementAt(0);
                        }
                    }
                    if (var17_18 != null && (var18_20 = var17_18.breakWhere - var14_11 - (var17_18.breakType == 0 ? var17_18.breakStr.length() : 0)) >= 8) {
                        var19_21 = new StringBuffer();
                        var20_22 = var2_2.toString();
                        var21_23 = var20_22.substring(0, var18_20);
                        var19_21.append(var21_23);
                        this.addBrokenLine(this.wsBuffer.toString(), var19_21.toString(), var17_18, this.breakDepth, this.isCut);
                        var14_11 += var18_20;
                        var2_2 = new StringBuffer(var20_22.substring(var18_20));
                        this.isCut = true;
                    }
                }
            }
            ++var8_13;
        }
        var15_15 = new StringBuffer();
        var15_15.append((Object)var2_2);
        this.addBrokenLine(this.wsBuffer.toString(), var15_15.toString(), null, this.breakDepth, this.isCut);
    }

    private int compare(LineBreak lineBreak, LineBreak lineBreak2) {
        int n;
        if (lineBreak.breakDepth < lineBreak2.breakDepth) {
            return 1;
        }
        if (lineBreak.breakDepth > lineBreak2.breakDepth) {
            return -1;
        }
        int n2 = (Integer)prefTable.get(lineBreak.breakStr);
        if (n2 < (n = ((Integer)prefTable.get(lineBreak2.breakStr)).intValue())) {
            return 1;
        }
        return -1;
    }

    boolean hasMoreBrokenLines() {
        return this.brokenLineVector.size() > 0;
    }

    void init() {
        this.brokenLineVector = new Vector();
        this.parenDepth = 0;
        this.breakDepth = 0;
        this.isInQuote = false;
        this.isInComment = false;
        this.isCut = false;
        this.isLineComment = false;
        this.wsBuffer = new StringBuffer();
    }

    String nextBrokenLine() {
        if (!this.hasMoreBrokenLines()) {
            String string = "";
            return "";
        }
        String string = (String)this.brokenLineVector.firstElement();
        this.brokenLineVector.removeElementAt(0);
        return string;
    }

    private void registerLineBreak(Stack stack, LineBreak lineBreak) {
        while (!stack.isEmpty()) {
            LineBreak lineBreak2 = (LineBreak)stack.peek();
            if (this.compare(lineBreak2, lineBreak) >= 0) break;
            stack.pop();
        }
        stack.push(lineBreak);
    }

    void setLineLengthDeviation(int n) {
        this.lineLengthDeviation = n;
    }

    void setNestedConnection(boolean bl) {
        this.isNestedConnection = bl;
    }

    void setPreferredLineLength(int n) {
        this.preferredLineLength = n;
    }

    static {
        prefTable.put("()", new Integer(80));
        prefTable.put("().", new Integer(90));
        prefTable.put(").", new Integer(90));
        prefTable.put("(", new Integer(80));
        prefTable.put(")", new Integer(80));
        prefTable.put("[", new Integer(80));
        prefTable.put("]", new Integer(80));
        prefTable.put(",", new Integer(10));
        prefTable.put(";", new Integer(5));
        prefTable.put("=", new Integer(20));
        prefTable.put("+=", new Integer(20));
        prefTable.put("-=", new Integer(20));
        prefTable.put("*=", new Integer(20));
        prefTable.put("/=", new Integer(20));
        prefTable.put("|=", new Integer(20));
        prefTable.put("&=", new Integer(20));
        prefTable.put("^=", new Integer(20));
        prefTable.put("?", new Integer(25));
        prefTable.put(":", new Integer(25));
        prefTable.put("||", new Integer(30));
        prefTable.put("&&", new Integer(30));
        prefTable.put("==", new Integer(40));
        prefTable.put("!=", new Integer(40));
        prefTable.put(">=", new Integer(40));
        prefTable.put("<=", new Integer(40));
        prefTable.put(">", new Integer(40));
        prefTable.put("<", new Integer(40));
        prefTable.put("+", new Integer(50));
        prefTable.put("-", new Integer(50));
        prefTable.put("*", new Integer(60));
        prefTable.put("/", new Integer(60));
        prefTable.put("%", new Integer(60));
        prefTable.put("&", new Integer(70));
        prefTable.put("|", new Integer(70));
        prefTable.put("^", new Integer(70));
    }

    class LineBreak {
        String breakStr;
        int breakWhere;
        int breakDepth;
        int breakType;

        LineBreak(String string, int n, int n2, int n3) {
            this.breakStr = string;
            this.breakWhere = n;
            this.breakDepth = n2;
            this.breakType = n3;
        }

        void dump() {
            System.out.println("LB: str=" + this.breakStr + " wh=" + this.breakWhere + " dep=" + this.breakDepth + " tp=" + this.breakType);
        }
    }
}

