/*
 * Decompiled with CFR 0.152.
 */
package jedi;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import jedi.Action_About;
import jedi.Action_ShowTipOfTheDay;
import jedi.JediSecurityManager;
import jedi.JediUtils;
import jedi.classexplorer.ClassExplorer;
import jedi.compiler.Action_Abort;
import jedi.compiler.Action_OpenCompilerPrefsFrame;
import jedi.compiler.Action_OpenFrame;
import jedi.compiler.Action_OpenRuntimePrefsFrame;
import jedi.compiler.Action_Run;
import jedi.compiler.Action_SelectMainMethod;
import jedi.compiler.CompilerFrame;
import jedi.compiler.CompilerPrefsFrame;
import jedi.compiler.JavaCompiler;
import jedi.compiler.JavaRuntime;
import jedi.compiler.RuntimePrefsFrame;
import jedi.ds.ProjectLoader;
import jedi.ds.ProjectManager;
import jedi.editor.Action_AddClass;
import jedi.editor.Action_AddConstructor;
import jedi.editor.Action_AddIcon;
import jedi.editor.Action_AddImageLoader;
import jedi.editor.Action_AddInitializer;
import jedi.editor.Action_AddInnerClass;
import jedi.editor.Action_AddInnerInterface;
import jedi.editor.Action_AddInterface;
import jedi.editor.Action_AddMethod;
import jedi.editor.Action_AddPackage;
import jedi.editor.Action_AddProperty;
import jedi.editor.Action_AddResourceLoader;
import jedi.editor.Action_CheckResources;
import jedi.editor.Action_CopyClass;
import jedi.editor.Action_CopyMethod;
import jedi.editor.Action_CopyPackage;
import jedi.editor.Action_DeleteClass;
import jedi.editor.Action_DeleteMethod;
import jedi.editor.Action_DeletePackage;
import jedi.editor.Action_LoadProject;
import jedi.editor.Action_NewProject;
import jedi.editor.Action_OpenNewView;
import jedi.editor.Action_Print;
import jedi.editor.Action_Quit;
import jedi.editor.Action_RemovePackage;
import jedi.editor.Action_SaveProject;
import jedi.editor.Action_Search;
import jedi.editor.EditorFrame;
import jedi.export.Action_Export;
import jedi.help.Action_API;
import jedi.help.Action_CloseHelpBrowser;
import jedi.help.Action_FetchDoc;
import jedi.help.Action_HelpIndex;
import jedi.help.Action_OpenHelpBrowser;
import jedi.help.Action_Tutorial;
import jedi.imprt.Action_Import;
import jedi.information.InformationFrame;
import jedi.javadoc.Action_CloseFrame;
import jedi.javadoc.Action_Compile;
import jedi.javadoc.JavaDocCompiler;
import jedi.javadoc.JavaDocFrame;
import jedi.methodwizard.Action_AddToMethodWizard;
import jedi.methodwizard.MethodWizard;
import jedi.notepad.Action_Clear;
import jedi.notepad.Action_Load;
import jedi.notepad.Action_Save;
import jedi.notepad.NotepadFrame;
import jedi.pluginmanager.PluginManager;
import jedi.prefs.Action_Prefs_ContextMenu_Implements;
import jedi.prefs.Action_Prefs_ContextMenu_Import;
import jedi.prefs.Action_Prefs_ContextMenu_Parameters;
import jedi.prefs.Action_Prefs_ContextMenu_ResultType;
import jedi.prefs.Action_Prefs_ContextMenu_Throws;
import jedi.prefs.Action_Prefs_DocumentationDirectories;
import jedi.prefs.Action_Prefs_HelpBrowser;
import jedi.prefs.JediPrefs;
import jedi.wizard.Action_StartWizard;
import jreqtools.JReqTools;
import jreqtools.ProgressTracker;
import jreqtools.TipOfTheDay;
import swing.addon.Frame;
import swing.addon.GUISystem;
import swing.addon.Prefs;

public final class Jedi {
    private static final ResourceBundle resources = ResourceBundle.getBundle("jedi.resources.jedi");
    private static final Hashtable resourceBundles = new Hashtable();
    private static final Hashtable prefs = new Hashtable();
    private static final String rootDirectory = System.getProperty("jedi.root");
    private static final String pluginDirectory = rootDirectory + File.separator + "plugins";
    private static final String homeDirectory = System.getProperty("user.home") + File.separator + (System.getProperty("jedi.runfrom") != null ? "newjedi" : "jedi");
    private static ProjectManager projectManager = null;
    private static NotepadFrame notepad = null;
    private static InformationFrame information = null;
    private static MethodWizard methodWizard = null;
    private static JavaDocFrame javadocFrame = null;
    private static RuntimePrefsFrame runtimePrefs = null;
    private static CompilerPrefsFrame compilerPrefs = null;
    private static CompilerFrame compiler = null;
    private static ClassExplorer classExplorer = null;
    private static EditorFrame editor = null;
    private static PluginManager pluginManager = null;
    private static TipOfTheDay tipOfTheDay = null;
    private static Action[] myActions = null;

    static final String GRS(String string) {
        try {
            return resources.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            JReqTools.showMessage(missingResourceException.getLocalizedMessage() + ":\n\n'" + string + "'");
            return "MISSING RESOURCE: " + string;
        }
    }

    static final String GRS(String string, String string2) {
        String string3 = Jedi.GRS(string);
        try {
            string3 = MessageFormat.format(string3, string2);
        }
        catch (Exception exception) {
            JReqTools.showException(exception);
        }
        return string3;
    }

    private static String checkExists(String string, String string2) {
        File file = new File(string);
        if (file.exists()) {
            return string;
        }
        file = new File(string2);
        if (file.exists()) {
            return string2;
        }
        JReqTools.showError("Jedi.checkExists():\n\n" + Jedi.GRS("Errors.FileNotFound") + " '" + string2 + "'.");
        return string2;
    }

    public static Action getAction(String string) {
        Action action = null;
        if (myActions == null) {
            Jedi.initActions();
        }
        int n = 0;
        while (n < myActions.length) {
            action = myActions[n];
            if (action.getValue("Name").equals(string)) {
                return action;
            }
            ++n;
        }
        final String string2 = Jedi.GRS("Errors.ActionNotFound", string);
        GUISystem.err.println(string2);
        return new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUISystem.err.println(string2);
            }
        };
    }

    public static Action[] getActions() {
        if (myActions == null) {
            Jedi.initActions();
        }
        return myActions;
    }

    public static Icon getApplicationIcon() {
        return new ImageIcon(Jedi.getRootDirectory() + File.separator + "data" + File.separator + "title.gif");
    }

    public static String getAuthor() {
        return "Markus Hillenbrand";
    }

    public static ClassExplorer getClassExplorer() {
        if (classExplorer == null) {
            classExplorer = new ClassExplorer();
        }
        return classExplorer;
    }

    public static JavaCompiler getCompiler() {
        return Jedi.getCompilerPrefsFrame().getCompiler();
    }

    public static CompilerFrame getCompilerFrame() {
        if (compiler == null) {
            compiler = new CompilerFrame();
        }
        return compiler;
    }

    public static CompilerPrefsFrame getCompilerPrefsFrame() {
        if (compilerPrefs == null) {
            compilerPrefs = new CompilerPrefsFrame();
        }
        return compilerPrefs;
    }

    public static String getContextMenuFile(String string) {
        return Jedi.checkExists(Jedi.getHomeDirectory() + File.separator + "data" + File.separator + string, Jedi.getRootDirectory() + File.separator + "data" + File.separator + string);
    }

    public static String getCopyright() {
        return Jedi.GRS("Copyright");
    }

    public static File getDataDirectory() {
        return new File(Jedi.getRootDirectory(), "data");
    }

    public static String getEMail() {
        return "hillenbr@informatik.uni-kl.de";
    }

    public static EditorFrame getEditor() {
        return editor;
    }

    public static String getHelpDirectory() {
        return Jedi.getRootDirectory() + File.separator + "help";
    }

    public static String getHomeDirectory() {
        return homeDirectory;
    }

    public static Icon getIcon(String string) {
        try {
            return Prefs.getIcon(Class.forName("jedi.Jedi"), string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static InformationFrame getInformationFrame() {
        if (information == null) {
            information = new InformationFrame();
        }
        return information;
    }

    public static JavaDocCompiler getJavaDocCompiler() {
        return Jedi.getJavaDocFrame().getJavaDocCompiler();
    }

    public static JavaDocFrame getJavaDocFrame() {
        if (javadocFrame == null) {
            javadocFrame = new JavaDocFrame();
        }
        return javadocFrame;
    }

    public static String getLastProject() {
        String string = (String)prefs.get("lastProject");
        if (string == null) {
            return "Project1";
        }
        return string;
    }

    public static MethodWizard getMethodWizard() {
        if (methodWizard == null) {
            methodWizard = new MethodWizard();
        }
        return methodWizard;
    }

    public static int getMinorVersion() {
        return 0;
    }

    public static NotepadFrame getNotepad() {
        if (notepad == null) {
            notepad = new NotepadFrame();
        }
        return notepad;
    }

    public static String getPluginDirectory() {
        return pluginDirectory;
    }

    public static PluginManager getPluginManager() {
        return pluginManager;
    }

    public static ProjectManager getProjectManager() {
        return projectManager;
    }

    public static int getRevision() {
        return 3;
    }

    public static String getRootDirectory() {
        return rootDirectory;
    }

    public static JavaRuntime getRuntime() {
        return Jedi.getRuntimePrefsFrame().getRuntime();
    }

    public static RuntimePrefsFrame getRuntimePrefsFrame() {
        if (runtimePrefs == null) {
            runtimePrefs = new RuntimePrefsFrame();
        }
        return runtimePrefs;
    }

    public static String getSaveDirectory() {
        File file = new File(Jedi.getHomeDirectory(), "data");
        file.mkdirs();
        return file.toString();
    }

    public static TipOfTheDay getTipOfTheDayFrame() {
        return tipOfTheDay;
    }

    private static final String[] getTips() {
        Object[] objectArray;
        String string = Locale.getDefault().getLanguage();
        File file = new File(Jedi.getRootDirectory() + File.separator + "data" + File.separator + "TipOfTheDay_" + string);
        if (!file.exists() && !(file = new File(Jedi.getRootDirectory() + File.separator + "data" + File.separator + "TipOfTheDay")).exists()) {
            return new String[]{"No Tips available, sorry."};
        }
        Vector<String> vector = new Vector<String>();
        try {
            String string2;
            objectArray = new BufferedReader(new FileReader(file));
            while ((string2 = objectArray.readLine()) != null) {
                if ((string2 = string2.trim()).startsWith("#") || string2.length() == 0) continue;
                string2 = JediUtils.replaceInString(string2, "\\n", "\n");
                vector.addElement(string2);
            }
            objectArray.close();
        }
        catch (Exception exception) {
            vector.addElement(exception.toString());
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static String getTmpDirectory() {
        File file = new File(Jedi.getHomeDirectory(), "tmp");
        file.mkdirs();
        return file.toString();
    }

    public static int getVersion() {
        return 2;
    }

    public static String getVersionString() {
        return Jedi.getVersion() + "." + Jedi.getRevision() + "." + Jedi.getMinorVersion();
    }

    private static void initActions() {
        Prefs.setInitializerMessage(Jedi.GRS("Initializing"));
        myActions = new Action[]{new jedi.notepad.Action_OpenFrame(), new jedi.notepad.Action_CloseFrame(), new Action_Clear(), new Action_Load(), new Action_Save(), new jedi.information.Action_OpenFrame(), new jedi.information.Action_CloseFrame(), new jedi.methodwizard.Action_OpenFrame(), new jedi.methodwizard.Action_CloseFrame(), new Action_AddToMethodWizard(), new Action_About(), new Action_ShowTipOfTheDay(), new Action_Prefs_HelpBrowser(), new Action_Prefs_DocumentationDirectories(), new Action_Prefs_ContextMenu_Implements(), new Action_Prefs_ContextMenu_Import(), new Action_Prefs_ContextMenu_ResultType(), new Action_Prefs_ContextMenu_Parameters(), new Action_Prefs_ContextMenu_Throws(), new Action_AddPackage(), new Action_AddClass(), new Action_AddInterface(), new Action_AddInnerClass(), new Action_AddInnerInterface(), new Action_AddInitializer(), new Action_AddConstructor(), new Action_AddMethod(), new Action_AddProperty(), new Action_AddIcon(), new Action_RemovePackage(), new Action_DeletePackage(), new Action_DeleteClass(), new Action_DeleteMethod(), new Action_CheckResources(), new Action_CopyPackage(), new Action_CopyClass(), new Action_CopyMethod(), new Action_NewProject(), new Action_LoadProject(), new Action_SaveProject(), new Action_OpenNewView(), new Action_Print(), new Action_Quit(), new Action_Search(), new Action_AddImageLoader(), new Action_AddResourceLoader(), new Action_OpenFrame(), new jedi.compiler.Action_CloseFrame(), new jedi.compiler.Action_Compile(), new Action_Run(), new Action_Abort(), new Action_SelectMainMethod(), new Action_OpenCompilerPrefsFrame(), new Action_OpenRuntimePrefsFrame(), new Action_OpenHelpBrowser(), new Action_CloseHelpBrowser(), new Action_FetchDoc(), new Action_HelpIndex(), new Action_API(), new Action_Tutorial(), new jedi.classexplorer.Action_OpenFrame(), new jedi.classexplorer.Action_CloseFrame(), new jedi.javadoc.Action_OpenFrame(), new Action_CloseFrame(), new Action_Compile(), new Action_Import(), new Action_Export(), new jedi.pluginmanager.Action_OpenFrame(), new Action_StartWizard()};
    }

    public static void invokeAction(String string) {
        Jedi.getAction(string).actionPerformed(null);
    }

    public static boolean isClassExplorerVisible() {
        if (classExplorer == null) {
            return false;
        }
        return classExplorer.isVisible();
    }

    public static void main(String[] stringArray) {
        Prefs.init("Jedi", Jedi.getApplicationIcon(), false);
        Frame.setDefaultHelpFileDirectory(Jedi.getHelpDirectory());
        Prefs.add("Jedi", prefs);
        System.setSecurityManager(new JediSecurityManager());
        editor = new EditorFrame();
        editor.setVisible(true);
        Frame.setDefaultHelpBrowser(JediPrefs.getHelpBrowser());
        pluginManager = new PluginManager();
        PluginManager.start();
        editor.addPluginActions();
        projectManager = new ProjectManager(Jedi.getEditor());
        if (System.getProperty("jedi.runfrom") == null) {
            projectManager.setVisible(true);
        }
        ProjectLoader projectLoader = new ProjectLoader(projectManager.getProjectName());
        new ProgressTracker(projectLoader.getDescriptionForTitle(), null, projectLoader).start(editor);
        editor.setProject(projectLoader.getProject());
        Prefs.openWindows();
        tipOfTheDay = new TipOfTheDay(Jedi.GRS("TipOfTheDay.Title"), Jedi.getTips(), 0, true);
        Prefs.add("Jedi.TipOfTheDay", tipOfTheDay);
        tipOfTheDay.setTip(tipOfTheDay.getTip() + 1);
        if (tipOfTheDay.getShowNextTime()) {
            ((Component)tipOfTheDay).setVisible(true);
        }
    }

    public static void setLastProject(String string) {
        prefs.put("lastProject", string);
    }

    static {
        if (rootDirectory == null) {
            JReqTools.showError("Can't find property for 'jedi.root'.\nPlease set it to the directory where\nJedi is installed.");
            System.exit(10);
        }
        new File(homeDirectory).mkdirs();
    }
}

