/*
 * Decompiled with CFR 0.152.
 */
package jedi.classexplorer;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jedi.Jedi;
import jedi.JediClassLoader;
import jedi.JediUtils;
import jedi.classexplorer.TreeSelectDialog;
import jedi.ds.Method;
import jreqtools.JReqTools;
import swing.addon.ComboBox;
import swing.addon.Frame;
import swing.addon.GUISystem;
import swing.addon.ImageButton;
import swing.addon.Listview;
import swing.addon.MenuItem;
import swing.addon.NButtons;
import swing.addon.PopupMenu;
import swing.addon.Prefs;
import swing.addon.Separator;
import swing.addon.Strut;
import swing.addon.Text;
import swing.addon.TextField;
import swing.addon.YFramePanel;
import swing.addon.util.Sorter;
import swing.addon.util.StringArray;

public class ClassExplorer
extends Frame
implements ActionListener {
    static final ResourceBundle resources = ResourceBundle.getBundle("jedi.classexplorer.resources.classexplorer");
    Listview listview1 = new Listview();
    Listview listview2 = new Listview();
    TextField textfield = new TextField("");
    ImageButton select = new ImageButton(Prefs.getIcon("choice"));
    Text signature = new Text(ClassExplorer.GRS("TextField"), 2);
    ComboBox cycle = new ComboBox(new String[]{ClassExplorer.GRS("ComboBox.1"), ClassExplorer.GRS("ComboBox.2"), ClassExplorer.GRS("ComboBox.3"), ClassExplorer.GRS("ComboBox.4"), ClassExplorer.GRS("ComboBox.5"), ClassExplorer.GRS("ComboBox.6")});
    NButtons buttons = new NButtons(new String[]{ClassExplorer.GRS("Buttons.1"), ClassExplorer.GRS("Buttons.2"), ClassExplorer.GRS("Buttons.3")});
    private TreeSelectDialog dialog;
    private jedi.ds.Class currentClass;
    private Hashtable data;
    private Hashtable methoddata;
    private Hashtable fielddata;
    private Hashtable constructordata;
    private Hashtable declmethoddata;
    private Hashtable declfielddata;
    private Hashtable declconstructordata;
    private String oldClassPath;

    public ClassExplorer() {
        super(ClassExplorer.GRS("Title"));
        this.cycle.setFont(Prefs.getNormalFont());
        this.cycle.setSelectedIndex(0);
        this.cycle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassExplorer.this.setDataPointer();
                ClassExplorer.this.updateFirstListview();
            }
        });
        this.buttons.getComponentNumber(0).setIcon(Prefs.getIcon("dismiss"));
        this.buttons.getComponentNumber(1).setIcon(Prefs.getIcon("help"));
        this.buttons.getComponentNumber(2).setIcon(Prefs.getIcon("apply"));
        this.buttons.addHelpButton("class_explorer");
        this.listview1.add(this.createContextMenu1());
        this.listview1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ClassExplorer.this.updateSecondListview();
            }
        });
        this.listview2.add(this.createContextMenu2());
        this.listview2.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ClassExplorer.this.updateSignature();
            }
        });
        this.signature.setBorder(true);
        this.buttons.addActionListener(this);
        this.textfield.addActionListener(this);
        this.select.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 3, Prefs.getObjectSpace(), 0));
        jPanel.add(this.listview1);
        jPanel.add(this.listview2);
        Box box = Box.createHorizontalBox();
        box.add(this.textfield);
        box.add(this.select);
        YFramePanel yFramePanel = new YFramePanel();
        yFramePanel.add(new Separator(ClassExplorer.GRS("Separator1")));
        yFramePanel.add(box);
        yFramePanel.add(new Strut());
        yFramePanel.add(new Separator(ClassExplorer.GRS("Separator2")));
        yFramePanel.add(this.cycle);
        yFramePanel.add(new Strut());
        yFramePanel.add(new Separator(ClassExplorer.GRS("Separator3")));
        yFramePanel.add(jPanel);
        yFramePanel.add(new Strut());
        yFramePanel.add(new Separator(ClassExplorer.GRS("Separator4")));
        yFramePanel.add(this.signature);
        yFramePanel.add(new Strut());
        yFramePanel.add(this.buttons);
        this.setContentPane(yFramePanel);
        this.pack();
        this.methoddata = new Hashtable();
        this.fielddata = new Hashtable();
        this.constructordata = new Hashtable();
        this.declmethoddata = new Hashtable();
        this.declfielddata = new Hashtable();
        this.declconstructordata = new Hashtable();
        this.setDataPointer();
        this.updateFirstListview();
        Prefs.add("ClassExplorer", this);
        Prefs.add("ClassExplorer.Which", this.cycle);
    }

    static final String GRS(String string) {
        try {
            return resources.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            JReqTools.showMessage(missingResourceException.getLocalizedMessage() + ":\n\n'" + string + "'");
            return "MISSING RESOURCE: " + string;
        }
    }

    static final String GRS(String string, String string2) {
        String string3 = ClassExplorer.GRS(string);
        try {
            string3 = MessageFormat.format(string3, string2);
        }
        catch (Exception exception) {
            JReqTools.showException(exception);
        }
        return string3;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.textfield) {
            this.set(this.textfield.getText());
        } else if (object == this.select) {
            if (this.dialog == null) {
                this.dialog = new TreeSelectDialog(this, ClassExplorer.GRS("TreeSelectDialog.Title"), ClassExplorer.GRS("TreeSelectDialog.RootItem"));
                Prefs.add("ClassExplorer.SelectDialog", this.dialog);
            }
            this.analyzeClasspath();
            this.dialog.setVisible(true);
            String string = this.dialog.getSelectedItemWithFullPath('.');
            if (string != null) {
                this.set(string);
            }
        } else {
            switch (this.buttons.get()) {
                case 0: {
                    this.setVisible(false);
                    break;
                }
                case 1: {
                    Jedi.getCompilerPrefsFrame().setVisible(true);
                    break;
                }
                case 2: {
                    this.set(Jedi.getEditor().getCurrentClass());
                    break;
                }
                default: {
                    GUISystem.err.println(this.getClass().getName() + ".actionPerformed(): internal error.");
                }
            }
        }
    }

    private void addAllMethods() {
        int n = this.listview2.getSelectedIndex();
        if (n == -1) {
            return;
        }
        int n2 = 0;
        while (n2 < this.listview2.length()) {
            this.listview2.setSelectedIndex(n2);
            this.addMethod();
            ++n2;
        }
        this.listview2.setSelectedIndex(n);
    }

    private void addDataFrom(Class clazz) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        int n;
        java.lang.reflect.Method[] methodArray = clazz.getDeclaredMethods();
        int n2 = 0;
        while (n2 < methodArray.length) {
            n = methodArray[n2].getModifiers();
            if (!Modifier.isPrivate(n)) {
                object5 = methodArray[n2].getDeclaringClass().getName();
                object4 = (Hashtable)this.declmethoddata.get(object5);
                if (object4 == null) {
                    object4 = new Hashtable();
                    this.declmethoddata.put(object5, object4);
                }
                ((Hashtable)object4).put(methodArray[n2].getName(), methodArray[n2]);
            }
            ++n2;
        }
        methodArray = clazz.getMethods();
        n = 0;
        while (n < methodArray.length) {
            int n3 = methodArray[n].getModifiers();
            if (!Modifier.isPrivate(n3)) {
                object4 = methodArray[n].getDeclaringClass().getName();
                Hashtable<String, java.lang.reflect.Method> hashtable = (Hashtable<String, java.lang.reflect.Method>)this.methoddata.get(object4);
                if (hashtable == null) {
                    hashtable = new Hashtable<String, java.lang.reflect.Method>();
                    this.methoddata.put(object4, hashtable);
                }
                hashtable.put(methodArray[n].getName(), methodArray[n]);
            }
            ++n;
        }
        object5 = clazz.getDeclaredFields();
        int n4 = 0;
        while (n4 < ((Field[])object5).length) {
            int n5 = object5[n4].getModifiers();
            if (!Modifier.isPrivate(n5)) {
                object3 = object5[n4].getDeclaringClass().getName();
                object2 = (Hashtable)this.fielddata.get(object3);
                if (object2 == null) {
                    object2 = new Hashtable();
                    this.fielddata.put(object3, object2);
                }
                ((Hashtable)object2).put(object5[n4].getName(), object5[n4]);
            }
            ++n4;
        }
        object5 = clazz.getDeclaredFields();
        int n6 = 0;
        while (n6 < ((Field[])object5).length) {
            int n7 = object5[n6].getModifiers();
            if (!Modifier.isPrivate(n7)) {
                object2 = object5[n6].getDeclaringClass().getName();
                Hashtable<String, Field> hashtable = (Hashtable<String, Field>)this.declfielddata.get(object2);
                if (hashtable == null) {
                    hashtable = new Hashtable<String, Field>();
                    this.declfielddata.put(object2, hashtable);
                }
                hashtable.put(object5[n6].getName(), object5[n6]);
            }
            ++n6;
        }
        object3 = clazz.getConstructors();
        int n8 = 0;
        while (n8 < ((Constructor<?>[])object3).length) {
            int n9 = object3[n8].getModifiers();
            if (!Modifier.isPrivate(n9)) {
                String string = object3[n8].getDeclaringClass().getName();
                object = (Hashtable)this.constructordata.get(string);
                if (object == null) {
                    object = new Hashtable();
                    this.constructordata.put(string, object);
                }
                ((Hashtable)object).put(object3[n8].getName(), object3[n8]);
            }
            ++n8;
        }
        object3 = clazz.getDeclaredConstructors();
        int n10 = 0;
        while (n10 < ((Constructor<?>[])object3).length) {
            int n11 = object3[n10].getModifiers();
            if (!Modifier.isPrivate(n11)) {
                object = object3[n10].getDeclaringClass().getName();
                Hashtable hashtable = (Hashtable)this.declconstructordata.get(object);
                if (hashtable == null) {
                    hashtable = new Hashtable();
                    this.declconstructordata.put(object, hashtable);
                }
                hashtable.put(object3[n10].getName(), object3[n10]);
            }
            ++n10;
        }
    }

    private void addMethod() {
        String string = (String)this.listview1.getSelectedValue();
        if (string == null) {
            return;
        }
        Hashtable hashtable = (Hashtable)this.data.get(string);
        String string2 = (String)this.listview2.getSelectedValue();
        if (string2 == null) {
            return;
        }
        Object v = hashtable.get(string2);
        if (v == null) {
            return;
        }
        if (v instanceof java.lang.reflect.Method) {
            java.lang.reflect.Method method = (java.lang.reflect.Method)v;
            Method method2 = Jedi.getEditor().addMethod(method.getName());
            if (method2 != null) {
                int n = method.getModifiers();
                method2.setPublic(Modifier.isPublic(n));
                method2.setProtected(Modifier.isProtected(n));
                method2.setPrivate(Modifier.isPrivate(n));
                method2.setAbstract(false);
                method2.setFinal(Modifier.isFinal(n));
                method2.setStatic(Modifier.isStatic(n));
                method2.setNative(false);
                method2.setSynchronized(Modifier.isSynchronized(n));
                method2.setResultType(method.getReturnType().getName());
                method2.setParameters(JediUtils.convertClassArrayToArgumentString(method.getParameterTypes(), true));
                method2.setThrows(JediUtils.convertClassArrayToArgumentString(method.getExceptionTypes(), false));
                Jedi.getEditor().refreshMethod(method2);
            } else {
                JReqTools.showError(this, ClassExplorer.GRS("Error1"));
            }
        } else {
            JReqTools.showError(this, ClassExplorer.GRS("Error2"));
        }
    }

    public void analyzeClasspath() {
        String string = Jedi.getCompiler().getClasspath();
        if (this.oldClassPath != null && string.equals(this.oldClassPath)) {
            return;
        }
        if (this.oldClassPath != null) {
            this.dialog.clear();
        }
        this.oldClassPath = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            File file = new File(string2);
            ClasspathData.add(file);
            String[] stringArray = ClasspathData.getPackages(file);
            int n = 0;
            while (n < stringArray.length) {
                String[] stringArray2 = this.dialog.addSorted(stringArray[n]);
                this.dialog.add(stringArray2, ClasspathData.getClasses(file, stringArray[n]));
                ++n;
            }
        }
    }

    public PopupMenu createContextMenu1() {
        PopupMenu popupMenu = new PopupMenu("Action");
        MenuItem menuItem = popupMenu.add(new MenuItem(ClassExplorer.GRS("MenuItem1")));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassExplorer.this.addAllMethods();
            }
        });
        return popupMenu;
    }

    public PopupMenu createContextMenu2() {
        PopupMenu popupMenu = new PopupMenu("Action");
        MenuItem menuItem = popupMenu.add(new MenuItem(ClassExplorer.GRS("MenuItem2")));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassExplorer.this.addMethod();
            }
        });
        return popupMenu;
    }

    private Object getSelectedObject() {
        String string = (String)this.listview1.getSelectedValue();
        if (string == null) {
            return null;
        }
        Hashtable hashtable = (Hashtable)this.data.get(string);
        String string2 = (String)this.listview2.getSelectedValue();
        if (string2 == null) {
            return null;
        }
        return hashtable.get(string2);
    }

    private Class loadClass(ClassLoader classLoader, String string) {
        try {
            Class<?> clazz = classLoader.loadClass(string);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private void scanClassData(String string) {
        JediClassLoader jediClassLoader = new JediClassLoader();
        try {
            Class<?> clazz = jediClassLoader.loadClass(string);
            this.addDataFrom(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            JReqTools.showError(this, ClassExplorer.GRS("Error3", string));
        }
    }

    private void scanClassData(jedi.ds.Class clazz) {
        JediClassLoader jediClassLoader = new JediClassLoader();
        Class clazz2 = null;
        String[] stringArray = StringArray.parseFromString(clazz.getExtends(), ", ");
        if (stringArray.length == 0) {
            stringArray = new String[]{"Object"};
        }
        String[] stringArray2 = StringArray.parseFromString(clazz.getImplements(), ", ");
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        int n = 0;
        while (n < stringArray3.length) {
            String string = stringArray3[n];
            String[] stringArray4 = clazz.getImports();
            if (clazz2 != null) {
                GUISystem.err.println(this.getClass().getName() + ".scanMethods(): internal error");
                clazz2 = null;
            }
            int n2 = 0;
            while (n2 < stringArray4.length) {
                if (!stringArray4[n2].endsWith(".*")) {
                    if (stringArray4[n2].substring(stringArray4[n2].lastIndexOf(46) + 1).equals(string)) {
                        clazz2 = this.loadClass(jediClassLoader, stringArray4[n2]);
                    }
                    if (clazz2 != null) break;
                }
                ++n2;
            }
            if (clazz2 == null) {
                clazz2 = this.loadClass(jediClassLoader, "java.lang." + string);
            }
            if (clazz2 == null) {
                clazz2 = this.loadClass(jediClassLoader, clazz.getParent().getName() + "." + string);
            }
            if (clazz2 == null) {
                int n3 = 0;
                while (n3 < stringArray4.length) {
                    if (stringArray4[n3].endsWith(".*") && (clazz2 = this.loadClass(jediClassLoader, stringArray4[n3].substring(0, stringArray4[n3].lastIndexOf(46) + 1) + string)) != null) break;
                    ++n3;
                }
            }
            if (clazz2 != null) {
                this.addDataFrom(clazz2);
                clazz2 = null;
            } else {
                this.methoddata.put(ClassExplorer.GRS("Error3", stringArray3[n]), new Hashtable());
            }
            ++n;
        }
    }

    public void set(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        this.textfield.setText(string);
        this.currentClass = null;
        this.methoddata.clear();
        this.fielddata.clear();
        this.constructordata.clear();
        this.declmethoddata.clear();
        this.declfielddata.clear();
        this.declconstructordata.clear();
        this.cycle.setEnabled(string != null);
        this.listview1.setEnabled(string != null);
        this.listview2.setEnabled(string != null);
        this.scanClassData(string);
        if (this.data == null) {
            this.setDataPointer();
        }
        this.updateFirstListview();
    }

    public void set(jedi.ds.Class clazz) {
        if (clazz == null) {
            return;
        }
        this.textfield.setText(clazz.getFullName());
        this.currentClass = clazz;
        this.methoddata.clear();
        this.fielddata.clear();
        this.constructordata.clear();
        this.declmethoddata.clear();
        this.declfielddata.clear();
        this.declconstructordata.clear();
        this.cycle.setEnabled(clazz != null);
        this.listview1.setEnabled(clazz != null);
        this.listview2.setEnabled(clazz != null);
        this.scanClassData(clazz);
        if (this.data == null) {
            this.setDataPointer();
        }
        this.updateFirstListview();
    }

    private void setDataPointer() {
        switch (this.cycle.getSelectedIndex()) {
            case 0: {
                this.data = this.methoddata;
                break;
            }
            case 1: {
                this.data = this.fielddata;
                break;
            }
            case 2: {
                this.data = this.constructordata;
                break;
            }
            case 3: {
                this.data = this.declmethoddata;
                break;
            }
            case 4: {
                this.data = this.declfielddata;
                break;
            }
            case 5: {
                this.data = this.declconstructordata;
                break;
            }
            default: {
                GUISystem.err.println(this.getClass().getName() + ".setDataPointer(): internal error.");
            }
        }
    }

    private void updateFirstListview() {
        int n = -1;
        String[] stringArray = new String[this.data.size()];
        Enumeration enumeration = this.data.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[++n] = (String)enumeration.nextElement();
        }
        Sorter.sort(stringArray);
        Vector<String> vector = new Vector<String>(stringArray.length);
        n = 0;
        while (n < stringArray.length) {
            vector.addElement(stringArray[n]);
            ++n;
        }
        this.listview1.setElements(vector);
        this.updateSecondListview();
    }

    private void updateSecondListview() {
        String string = (String)this.listview1.getSelectedValue();
        if (string != null) {
            Hashtable hashtable = (Hashtable)this.data.get(string);
            if (hashtable != null) {
                String[] stringArray = new String[hashtable.size()];
                int n = -1;
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    stringArray[++n] = (String)enumeration.nextElement();
                }
                Sorter.sort(stringArray);
                Vector<String> vector = new Vector<String>(stringArray.length);
                n = 0;
                while (n < stringArray.length) {
                    vector.addElement(stringArray[n]);
                    ++n;
                }
                this.listview2.setElements(vector);
            } else {
                JReqTools.showError(this, ClassExplorer.GRS("Error4"));
            }
        } else {
            this.listview2.setElements(new Vector());
        }
        this.updateSignature();
    }

    private void updateSignature() {
        Object object = this.getSelectedObject();
        if (object != null) {
            this.signature.setText(object.toString());
        } else {
            this.signature.setText("");
        }
    }

    static final class ClasspathData {
        private static final String NO_PACKAGE_NAME = " <no package name> ";
        private static final String VERSION = "<version>";
        private static final String LAST_MODIFIED_SUFFIX = "(lastModified)";
        private static Hashtable data = new Hashtable();

        ClasspathData() {
        }

        public static void add(File file) {
            Hashtable hashtable = (Hashtable)data.get(file.getAbsolutePath());
            if (hashtable == null) {
                hashtable = new Hashtable();
                data.put(file.getAbsolutePath(), hashtable);
                data.put(file.getAbsolutePath() + LAST_MODIFIED_SUFFIX, new Long(file.lastModified()));
            } else {
                long l = (Long)data.get(file.getAbsolutePath() + LAST_MODIFIED_SUFFIX);
                if (l == file.lastModified()) {
                    return;
                }
                GUISystem.out.println("Analyzing '" + file + "' again, because the file has changed.");
            }
            if (file.isDirectory()) {
                ClasspathData.addDirectory(file, hashtable);
            } else {
                try {
                    ZipFile zipFile = new ZipFile(file);
                    ClasspathData.addZipFile(zipFile, hashtable);
                }
                catch (Exception exception) {
                    JReqTools.showException(exception);
                }
            }
        }

        private static void addDirectory(File file, Hashtable hashtable) {
        }

        private static void addToVectorIfNotAnonymous(Vector vector, String string) {
            if (string == null) {
                return;
            }
            if (string.equals("")) {
                return;
            }
            if (!Character.isJavaIdentifierStart(string.charAt(0))) {
                return;
            }
            int n = 0;
            while ((n = string.indexOf(36, n)) != -1) {
                if (Character.isJavaIdentifierStart(string.charAt(++n))) continue;
                return;
            }
            vector.addElement(string);
        }

        private static void addZipFile(ZipFile zipFile, Hashtable hashtable) {
            Vector vector = null;
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String string = zipEntry.getName();
                if (!string.endsWith(".class")) continue;
                int n = (string = string.substring(0, string.length() - 6)).lastIndexOf("/");
                if (n != -1) {
                    String string2 = string.substring(0, n).replace('/', '.');
                    vector = (Vector)hashtable.get(string2);
                    if (vector == null) {
                        vector = new Vector();
                        hashtable.put(string2, vector);
                    }
                    ClasspathData.addToVectorIfNotAnonymous(vector, string.substring(n + 1));
                    continue;
                }
                vector = (Vector)data.get(NO_PACKAGE_NAME);
                ClasspathData.addToVectorIfNotAnonymous(vector, string);
            }
        }

        public static String[] getClasses(File file, String string) {
            Hashtable hashtable = (Hashtable)data.get(file.getAbsolutePath());
            if (hashtable == null) {
                return null;
            }
            Vector vector = (Vector)hashtable.get(string);
            if (vector == null) {
                return null;
            }
            int n = vector.size();
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = (String)vector.elementAt(n2);
                ++n2;
            }
            Sorter.sort(stringArray);
            return stringArray;
        }

        public static String[] getPackages(File file) {
            Hashtable hashtable = (Hashtable)data.get(file.getAbsolutePath());
            if (hashtable == null) {
                return null;
            }
            int n = 0;
            String[] stringArray = new String[hashtable.size()];
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                stringArray[n++] = (String)enumeration.nextElement();
            }
            Sorter.sort(stringArray);
            return stringArray;
        }

        static {
            data.put(NO_PACKAGE_NAME, new Vector());
            Prefs.add("ClassExplorer.ClasspathData", data);
            String string = (String)data.get(VERSION);
            if (!(data.size() == 1 || string != null && string.equals("1"))) {
                GUISystem.out.println("Removing all data from ClassExplorer.ClasspathData due to version change.");
                data.clear();
                data.put(NO_PACKAGE_NAME, new Vector());
                data.put(VERSION, "1");
            }
        }
    }
}

