/*
 * Decompiled with CFR 0.152.
 */
package jedi.compiler;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import jedi.Jedi;
import jedi.compiler.ExceptionFrame;
import jedi.ds.CompileError;
import jedi.ds.Method;
import jedi.ds.Package;
import jedi.ds.Project;
import jedi.event.PrefsChangedEvent;
import jedi.event.PrefsChangedListener;
import jreqtools.JReqTools;
import swing.addon.ColorizedText;
import swing.addon.Frame;
import swing.addon.GUISystem;
import swing.addon.Menu;
import swing.addon.MenuBar;
import swing.addon.MenuItem;
import swing.addon.NButtons;
import swing.addon.Prefs;
import swing.addon.Separator;
import swing.addon.SplitPane;
import swing.addon.Table;
import swing.addon.Text;
import swing.addon.TextArea;
import swing.addon.YFramePanel;
import swing.addon.util.NiceThread;

public class CompilerFrame
extends Frame
implements MouseListener,
ActionListener,
PrefsChangedListener {
    public static final int IDLE = 0;
    public static final int COMPILING = 1;
    public static final int RUNNING = 2;
    public static final int ABORTING = 3;
    static final ResourceBundle resources = ResourceBundle.getBundle("jedi.compiler.resources.compiler");
    NButtons buttons = new NButtons(new String[]{CompilerFrame.GRS("Frame.Button1"), this.getCompilerButtonText(), this.getRuntimeButtonText(), CompilerFrame.GRS("Frame.Button4")});
    Table table = new Table();
    TextArea errorMsg = new TextArea();
    Text message = new Text("", 0);
    ColorizedText error = new ColorizedText("", Color.red);
    TableModel model = new TableModel();
    MenuBar menubar = new MenuBar();
    Menu menu = new Menu(CompilerFrame.GRS("Frame.Menu"));
    MenuItem cPrefs = new MenuItem(CompilerFrame.GRS("Frame.MenuItem1"));
    MenuItem rPrefs = new MenuItem(CompilerFrame.GRS("Frame.MenuItem2"));
    MenuItem mainMethod = new MenuItem(CompilerFrame.GRS("Frame.MenuItem3"));
    MenuItem delete = new MenuItem(CompilerFrame.GRS("Frame.MenuItem4"));
    MenuItem close = new MenuItem(CompilerFrame.GRS("Frame.MenuItem5"));
    Vector errors = new Vector(10);
    CompileError lastError = null;
    int mode = 0;
    Method runMethod = null;
    final ExceptionFrame exceptions = new ExceptionFrame();
    static FileWriter logfile = null;

    public CompilerFrame() {
        super(CompilerFrame.GRS("Frame.Title"));
        this.message.setBorder(true);
        this.table.setModel(this.model);
        this.table.setMinWidthForColumn(0, 80);
        this.table.setMinWidthForColumn(1, 80);
        this.table.setMinWidthForColumn(2, 80);
        this.table.setPreferredWidthForColumn(3, 500);
        this.errorMsg.setEditable(false);
        this.errorMsg.setMinimumSize(new Dimension(10, 10));
        this.buttons.getComponentNumber(0).setIcon(Prefs.getIcon("ok"));
        this.buttons.getComponentNumber(1).setIcon(Jedi.getIcon("run"));
        this.buttons.getComponentNumber(2).setIcon(Jedi.getIcon("run"));
        this.buttons.getComponentNumber(3).setIcon(Prefs.getIcon("cancel"));
        this.buttons.getComponentNumber(2).setEnabled(false);
        this.buttons.getComponentNumber(3).setEnabled(false);
        this.buttons.addHelpButton("compile");
        this.menubar.add(this.menu);
        this.menu.add(this.cPrefs);
        this.menu.add(this.rPrefs);
        this.menu.addSeparator();
        this.menu.add(this.mainMethod);
        this.menu.addSeparator();
        this.menu.add(this.delete);
        this.menu.addSeparator();
        this.menu.add(this.close);
        this.table.addMouseListener(this);
        this.buttons.addActionListener(this);
        this.cPrefs.addActionListener(Jedi.getAction("jedi-open-compiler-prefs-window"));
        this.rPrefs.addActionListener(Jedi.getAction("jedi-open-runtime-prefs-window"));
        this.mainMethod.addActionListener(Jedi.getAction("jedi-select-main-method"));
        this.delete.addActionListener(this);
        this.close.addActionListener(this);
        Jedi.getRuntimePrefsFrame().addPrefsChangedListener(this);
        Jedi.getCompilerPrefsFrame().addPrefsChangedListener(this);
        SplitPane splitPane = new SplitPane(0);
        splitPane.setTopComponent(this.table);
        splitPane.setBottomComponent(this.errorMsg);
        YFramePanel yFramePanel = new YFramePanel();
        yFramePanel.add(new Separator(CompilerFrame.GRS("Frame.Separator1")));
        yFramePanel.add(this.message);
        yFramePanel.addStrut();
        yFramePanel.add(splitPane);
        yFramePanel.addStrut();
        yFramePanel.add(this.error);
        yFramePanel.addStrut();
        yFramePanel.add(this.buttons);
        this.setMenuBar(this.menubar);
        this.setContentPane(yFramePanel);
        this.pack();
        Prefs.add("CompileWindow", this);
        Prefs.add("CompileWindow.SplitPanel", splitPane);
    }

    static final String GRS(String string) {
        try {
            return resources.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            JReqTools.showMessage(missingResourceException.getLocalizedMessage() + ":\n\n'" + string + "'");
            return "MISSING RESOURCE: " + string;
        }
    }

    static String GRS(String string, String string2) {
        String string3 = CompilerFrame.GRS(string);
        try {
            string3 = MessageFormat.format(string3, string2);
        }
        catch (Exception exception) {
            JReqTools.showException(exception);
        }
        return string3;
    }

    public void abort() {
        if (this.mode == 2) {
            Jedi.getRuntime().abortProgram();
            this.mode = 3;
        } else if (this.mode == 1) {
            Jedi.getCompiler().abortCompilation();
            this.mode = 3;
        } else {
            this.getToolkit().beep();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.delete) {
            new NiceThread(){

                public void runNice() {
                    if (CompilerFrame.this.mode != 0) {
                        JReqTools.showError(CompilerFrame.this, CompilerFrame.GRS("Frame.Error1"));
                        return;
                    }
                    CompilerFrame.this.setBusy(true);
                    CompilerFrame.this.message.setText(CompilerFrame.GRS("Frame.Message1"));
                    CompilerFrame.this.buttons.getComponentNumber(2).setEnabled(false);
                    Jedi.getEditor().getProject().deleteAllCompiledClasses();
                    CompilerFrame.this.message.setText(CompilerFrame.GRS("Frame.Message2"));
                    CompilerFrame.this.setBusy(false);
                }
            }.start();
        } else if (object == this.close) {
            this.setVisible(false);
        } else if (object == this.buttons) {
            switch (this.buttons.get()) {
                case 0: {
                    this.setVisible(false);
                    break;
                }
                case 1: {
                    this.compile();
                    break;
                }
                case 2: {
                    this.run();
                    break;
                }
                case 3: {
                    this.abort();
                    break;
                }
                default: {
                    GUISystem.err.println(this.getClass().getName() + ".actionPerformed(): internal error 2");
                    break;
                }
            }
        } else {
            GUISystem.err.println(this.getClass().getName() + ".actionPerformed(): internal error 1");
        }
    }

    public void addError(CompileError compileError) {
        Vector vector = this.errors;
        synchronized (vector) {
            int n = Jedi.getCompilerPrefsFrame().errors.getSelectedIndex();
            switch (n) {
                case 0: {
                    if (this.errors.size() != 0) break;
                    this.errors.addElement(compileError);
                    this.model.fire();
                    break;
                }
                case 1: {
                    if (this.lastError != null && this.lastError.errClass == compileError.errClass) break;
                    this.errors.addElement(compileError);
                    this.model.fire();
                    this.lastError = compileError;
                    break;
                }
                case 2: {
                    this.errors.addElement(compileError);
                    this.model.fire();
                }
            }
        }
        if (compileError.errText.startsWith("Note:")) {
            return;
        }
        if (compileError.errText.startsWith("warning:")) {
            return;
        }
        jedi.ds.Class clazz = compileError.errClass;
        while (clazz.isInnerClass()) {
            clazz = clazz.getParentClass();
        }
        File file = new File(Project.compileDir + File.separator + clazz.getParent().getName().replace('.', File.separatorChar) + File.separator + clazz.getName() + ".class");
        file.delete();
        file = new File(Project.sourcesDir + File.separator + clazz.getParent().getName().replace('.', File.separatorChar) + File.separator + clazz.getName() + ".java");
        file.delete();
    }

    void compilationDone(boolean bl) {
        CompilerFrame.log("--- Compilation finished: " + new Date() + " ---");
        Vector vector = this.errors;
        synchronized (vector) {
            this.buttons.getComponentNumber(1).setEnabled(true);
            this.buttons.getComponentNumber(3).setEnabled(false);
            int n = 0;
            int n2 = 0;
            Enumeration enumeration = this.errors.elements();
            while (enumeration.hasMoreElements()) {
                CompileError compileError = (CompileError)enumeration.nextElement();
                if (compileError.errText.startsWith("Note:") || compileError.errText.startsWith("warning:")) {
                    ++n2;
                    continue;
                }
                ++n;
            }
            if (this.mode == 3) {
                this.message.setText(CompilerFrame.GRS("Frame.Message10"));
                this.buttons.getComponentNumber(2).setEnabled(false);
                this.buttons.getComponentNumber(0).requestFocus();
            } else if (n == 0) {
                this.message.setText(CompilerFrame.GRS("Frame.Message3"));
                this.buttons.getComponentNumber(2).setEnabled(true);
                this.buttons.getComponentNumber(2).requestFocus();
            } else {
                this.message.setText(CompilerFrame.GRS("Frame.Message4"));
                this.buttons.getComponentNumber(2).setEnabled(false);
                this.buttons.getComponentNumber(0).requestFocus();
            }
            this.mode = 0;
        }
        if (!bl) {
            this.buttons.getComponentNumber(1).setEnabled(true);
            this.buttons.getComponentNumber(2).setEnabled(false);
        }
    }

    public void compile() {
        if (this.mode != 0) {
            this.getToolkit().beep();
            return;
        }
        CompilerFrame.log("--- Compilation started: " + new Date() + " ---");
        final Project project = Jedi.getEditor().getProject();
        Vector vector = this.errors;
        synchronized (vector) {
            this.errors.setSize(0);
            this.model.fire();
            this.errorMsg.setText("");
        }
        this.buttons.getComponentNumber(1).setEnabled(false);
        this.buttons.getComponentNumber(2).setEnabled(false);
        this.buttons.getComponentNumber(3).setEnabled(true);
        this.error.setText("");
        this.message.setText(CompilerFrame.GRS("Frame.Message8"));
        this.mode = 1;
        new NiceThread(){

            public void runNice() {
                try {
                    boolean bl;
                    CompilerFrame.this.message.setText(CompilerFrame.GRS("Frame.Message5"));
                    project.saveChanges();
                    Vector<jedi.ds.Class> vector = new Vector<jedi.ds.Class>();
                    Package[] packageArray = project.getPackages();
                    int n = 0;
                    while (CompilerFrame.this.mode != 3 && n < packageArray.length) {
                        packageArray[n].saveSource();
                        Vector vector2 = packageArray[n].getClasses();
                        int n2 = 0;
                        while (CompilerFrame.this.mode != 3 && n2 < vector2.size()) {
                            jedi.ds.Class clazz = (jedi.ds.Class)vector2.elementAt(n2);
                            if (!clazz.isInnerClass() && clazz.getNeedsCompilation()) {
                                vector.addElement(clazz);
                            }
                            ++n2;
                        }
                        ++n;
                    }
                    boolean bl2 = bl = vector.size() == 0;
                    if (CompilerFrame.this.mode != 3 && vector.size() > 0) {
                        Object[] objectArray = new jedi.ds.Class[vector.size()];
                        vector.copyInto(objectArray);
                        CompilerFrame.this.message.setText(objectArray.length == 1 ? CompilerFrame.GRS("Frame.Message9a") : CompilerFrame.GRS("Frame.Message9", "" + objectArray.length));
                        bl = Jedi.getCompiler().startCompilation((jedi.ds.Class[])objectArray);
                    }
                    CompilerFrame.this.compilationDone(bl);
                }
                catch (Exception exception) {
                    JReqTools.showException(exception);
                }
            }
        }.start();
    }

    String getCompilerButtonText() {
        String string = Jedi.getCompilerPrefsFrame().getCompiler().getShortDescription();
        return CompilerFrame.GRS("Frame.Button2") + " [" + string + "]";
    }

    public int getMode() {
        return this.mode;
    }

    String getRuntimeButtonText() {
        String string = Jedi.getRuntimePrefsFrame().getRuntime().getShortDescription();
        return CompilerFrame.GRS("Frame.Button3") + " [" + string + "]";
    }

    static final void log(String string) {
        try {
            if (logfile == null) {
                Calendar calendar = Calendar.getInstance();
                int n = calendar.get(1);
                int n2 = calendar.get(2) + 1;
                int n3 = calendar.get(5);
                String string2 = "" + n + "-" + (n2 < 10 ? "0" + n2 : "" + n2) + "-" + (n3 < 10 ? "0" + n3 : "" + n3);
                logfile = new FileWriter(Jedi.getTmpDirectory() + File.separator + "compilerlog-" + string2, true);
            }
            logfile.write(string);
            logfile.write(10);
            logfile.flush();
        }
        catch (IOException iOException) {
            GUISystem.err.println(iOException);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.selected();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void prefsChanged(PrefsChangedEvent prefsChangedEvent) {
        if (prefsChangedEvent.getSource() == Jedi.getRuntimePrefsFrame()) {
            this.buttons.getComponentNumber(2).setText(this.getRuntimeButtonText());
        } else if (prefsChangedEvent.getSource() == Jedi.getCompilerPrefsFrame()) {
            this.buttons.getComponentNumber(1).setText(this.getCompilerButtonText());
        } else {
            GUISystem.err.println(this.getClass().getName() + ".prefsChanged(): internal error");
        }
    }

    public void run() {
        if (this.mode != 0) {
            this.getToolkit().beep();
            return;
        }
        CompilerFrame.log("--- Run finished: " + new Date() + " ---");
        Project project = Jedi.getEditor().getProject();
        Vector vector = project.getMainMethods();
        if (this.runMethod != null) {
            int n = vector.size();
            boolean bl = false;
            int n2 = 0;
            while (n2 < n) {
                Method method = (Method)vector.elementAt(n2);
                if (method == this.runMethod) {
                    bl = true;
                }
                ++n2;
            }
            if (!bl) {
                this.runMethod = null;
            }
        }
        if (vector.size() == 0) {
            JReqTools.showError(this, "No method main found in project");
            return;
        }
        if (this.runMethod == null) {
            if (vector.size() > 1) {
                Jedi.invokeAction("jedi-select-main-method");
                if (this.runMethod == null) {
                    return;
                }
            } else {
                this.runMethod = (Method)vector.elementAt(0);
            }
        }
        this.buttons.getComponentNumber(2).setEnabled(false);
        this.buttons.getComponentNumber(3).setEnabled(true);
        this.buttons.getComponentNumber(1).setEnabled(false);
        this.message.setText(CompilerFrame.GRS("Frame.Message6"));
        this.setVisible(false);
        this.mode = 2;
        this.exceptions.clear();
        new NiceThread(){

            public void runNice() {
                try {
                    int n = Jedi.getRuntime().runProgram(CompilerFrame.this.runMethod, CompilerFrame.this.exceptions);
                    if (n != 0) {
                        JReqTools.showMessage(Jedi.getCompilerFrame(), CompilerFrame.GRS("Frame.Message7", "" + n));
                    }
                    System.gc();
                    CompilerFrame.this.runDone(n);
                }
                catch (Exception exception) {
                    JReqTools.showException(exception);
                }
            }
        }.start();
    }

    void runDone(int n) {
        CompilerFrame.log("--- Run finished: " + new Date() + " ---");
        this.buttons.getComponentNumber(1).setEnabled(true);
        this.buttons.getComponentNumber(2).setEnabled(true);
        this.buttons.getComponentNumber(3).setEnabled(false);
        this.message.setText(CompilerFrame.GRS("Frame.Message7", "" + n));
        this.mode = 0;
    }

    private void selected() {
        Vector vector = this.errors;
        synchronized (vector) {
            int n = this.table.getSelectedRow();
            if (n == -1) {
                return;
            }
            if (n >= this.errors.size()) {
                return;
            }
            CompileError compileError = (CompileError)this.errors.elementAt(n);
            this.error.setText(compileError.sourceText);
            this.error.colorize(compileError.errColumn, compileError.sourceText.length());
            this.errorMsg.setText(compileError.errText);
            Jedi.getEditor().setCompileError(compileError);
        }
    }

    public void setMessage(String string) {
        this.message.setText(string);
    }

    final class TableModel
    extends AbstractTableModel {
        final String notAvailable = CompilerFrame.GRS("Frame.Table.NotAvailable");
        final String[] columnNames = new String[]{CompilerFrame.GRS("Frame.Table.Column1"), CompilerFrame.GRS("Frame.Table.Column2"), CompilerFrame.GRS("Frame.Table.Column3"), CompilerFrame.GRS("Frame.Table.Column4")};

        TableModel() {
        }

        public void fire() {
            this.fireTableDataChanged();
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public int getRowCount() {
            Vector vector = CompilerFrame.this.errors;
            synchronized (vector) {
                int n = CompilerFrame.this.errors.size();
                return n;
            }
        }

        public Object getValueAt(int n, int n2) {
            Vector vector = CompilerFrame.this.errors;
            synchronized (vector) {
                CompileError compileError = (CompileError)CompilerFrame.this.errors.elementAt(n);
                switch (n2) {
                    case 0: {
                        String string = compileError.errPackage != null ? compileError.errPackage.toString() : this.notAvailable;
                        return string;
                    }
                    case 1: {
                        String string = compileError.errClass != null ? compileError.errClass.toString() : this.notAvailable;
                        return string;
                    }
                    case 2: {
                        String string = compileError.errMethod != null ? compileError.errMethod.toString() : this.notAvailable;
                        return string;
                    }
                    case 3: {
                        String string = compileError.errText;
                        return string;
                    }
                }
                Object var9_9 = null;
                return var9_9;
            }
        }
    }
}

