/*
 * Decompiled with CFR 0.152.
 */
package jedi.compiler;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import jedi.Jedi;
import jedi.compiler.CompilerFrame;
import jedi.compiler.Java11Compiler;
import jedi.compiler.Java2SDK12Compiler;
import jedi.compiler.Java2SDK13Compiler;
import jedi.compiler.JavaCompiler;
import jedi.ds.Project;
import jedi.event.PrefsChangedEvent;
import jedi.event.PrefsChangedListener;
import jedi.event.ProjectEvent;
import jedi.event.ProjectListener;
import jreqtools.JReqTools;
import swing.addon.ComboBox;
import swing.addon.Frame;
import swing.addon.GUISystem;
import swing.addon.OkCancelButtons;
import swing.addon.Prefs;
import swing.addon.Separator;
import swing.addon.TabbedPane;
import swing.addon.YFramePanel;

public class CompilerPrefsFrame
extends Frame
implements ActionListener,
ProjectListener {
    Vector listeners = new Vector();
    JavaCompiler[] compilers = new JavaCompiler[]{new Java11Compiler(), new Java2SDK12Compiler(), new Java2SDK13Compiler()};
    TabbedPane tabbedPane = new TabbedPane();
    ComboBox errors = new ComboBox(new String[]{CompilerFrame.GRS("CompilerPrefsFrame.ComboBox.Item1"), CompilerFrame.GRS("CompilerPrefsFrame.ComboBox.Item2"), CompilerFrame.GRS("CompilerPrefsFrame.ComboBox.Item3")});
    OkCancelButtons buttons = new OkCancelButtons();

    public CompilerPrefsFrame() {
        super(CompilerFrame.GRS("CompilerPrefsFrame.Title"));
        int n = 0;
        while (n < this.compilers.length) {
            this.tabbedPane.addTab(this.compilers[n].getName(), this.compilers[n].getOptionPanel());
            ++n;
        }
        this.errors.setSelectedIndex(2);
        this.buttons.addHelpButton("prefs_compiler");
        this.buttons.addActionListener(this);
        Jedi.getEditor().addProjectListener(this);
        YFramePanel yFramePanel = new YFramePanel();
        yFramePanel.add(new Separator(CompilerFrame.GRS("CompilerPrefsFrame.Separator1")));
        yFramePanel.add(this.errors);
        yFramePanel.addStrut();
        yFramePanel.add(new Separator(CompilerFrame.GRS("CompilerPrefsFrame.Separator2")));
        yFramePanel.add(this.tabbedPane);
        yFramePanel.addStrut();
        yFramePanel.add(this.buttons);
        this.setContentPane(yFramePanel);
        this.pack();
        Prefs.add("CompilerPrefsFrame", this);
        Prefs.add("CompilerPrefsFrame.TabbedPane", this.tabbedPane);
        Prefs.add("CompilerPrefsFrame.ErrorOptions", this.errors);
        this.projectChanged(null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Project project = Jedi.getEditor().getProject();
        if (this.buttons.get() == 0) {
            String string;
            if (Jedi.getCompilerFrame().getMode() != 0) {
                JReqTools.showError(this, CompilerFrame.GRS("RuntimePrefsFrame.Error1"));
                return;
            }
            int n = 0;
            while (n < this.compilers.length) {
                this.compilers[n].changeValues();
                ++n;
            }
            String string2 = this.compilers[this.tabbedPane.getSelectedIndex()].getID();
            if (!string2.equals(string = project.getProperty("Compiler")) && JReqTools.showQuestion(CompilerFrame.GRS("CompilerPrefsFrame.Question1"))) {
                project.deleteAllCompiledClasses();
            }
            project.putProperty("Compiler", this.compilers[this.tabbedPane.getSelectedIndex()].getID());
            this.sendPrefsChangedEvent();
        } else {
            int n = 0;
            while (n < this.compilers.length) {
                this.compilers[n].setValues();
                ++n;
            }
            this.selectTab(project.getProperty("Compiler"));
        }
        this.setVisible(false);
    }

    public void addPrefsChangedListener(PrefsChangedListener prefsChangedListener) {
        this.listeners.addElement(prefsChangedListener);
    }

    public JavaCompiler getCompiler() {
        return this.getCompiler(this.tabbedPane.getSelectedIndex());
    }

    JavaCompiler getCompiler(int n) {
        if (n < this.compilers.length) {
            return this.compilers[n];
        }
        GUISystem.err.println(this.getClass().getName() + ".getCompiler(): internal error");
        return this.compilers[0];
    }

    public void projectChanged(ProjectEvent projectEvent) {
        Project project = Jedi.getEditor().getProject();
        String string = project.getProperty("Compiler");
        if (string != null) {
            this.selectTab(string);
        } else {
            project.putProperty("Compiler", this.compilers[this.tabbedPane.getSelectedIndex()].getID());
        }
        int n = 0;
        while (n < this.compilers.length) {
            this.compilers[n].setValues();
            ++n;
        }
        this.sendPrefsChangedEvent();
    }

    public void removePrefsChangedListener(PrefsChangedListener prefsChangedListener) {
        this.listeners.removeElement(prefsChangedListener);
    }

    void selectTab(String string) {
        int n = 0;
        while (n < this.compilers.length) {
            if (this.compilers[n].getID().equals(string)) {
                this.tabbedPane.setSelectedIndex(n);
                return;
            }
            ++n;
        }
        GUISystem.err.println("Trying to selected an unkown compiler ?!?");
    }

    void sendPrefsChangedEvent() {
        int n = 0;
        while (n < this.listeners.size()) {
            ((PrefsChangedListener)this.listeners.elementAt(n)).prefsChanged(new PrefsChangedEvent(this, "CompilerPrefs"));
            ++n;
        }
    }
}

