/*
 * Decompiled with CFR 0.152.
 */
package jedi.compiler;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jedi.Jedi;
import jedi.compiler.CompilerFrame;
import jedi.ds.Class;
import jedi.ds.CompileError;
import jedi.ds.Method;
import jedi.ds.Package;
import jreqtools.JReqTools;
import swing.addon.DismissButton;
import swing.addon.Frame;
import swing.addon.GUISystem;
import swing.addon.Listview;
import swing.addon.NButtons;
import swing.addon.Prefs;
import swing.addon.Strut;
import swing.addon.TextArea;
import swing.addon.YFramePanel;

class ExceptionFrame
extends Frame
implements ActionListener,
MouseListener,
ListSelectionListener {
    Listview list = new Listview();
    NButtons buttons = new NButtons(Prefs.getResourceString("Dismiss"), CompilerFrame.GRS("ExceptionFrame.ShowStack"));
    ExceptionData data = null;
    StackFrame stackFrame = null;

    public ExceptionFrame() {
        super(CompilerFrame.GRS("ExceptionFrame.Title"));
        this.buttons.addHelpButton("exception_frame");
        this.buttons.getComponentNumber(0).setIcon(Prefs.getIcon("dismiss"));
        this.buttons.getComponentNumber(1).setIcon(Prefs.getIcon("apply"));
        this.buttons.addActionListener(this);
        this.list.addListSelectionListener(this);
        this.list.addMouseListener(this);
        YFramePanel yFramePanel = new YFramePanel();
        yFramePanel.add(this.list);
        yFramePanel.add(new Strut());
        yFramePanel.add(this.buttons);
        this.setContentPane(yFramePanel);
        this.pack();
        Prefs.add("ExceptionFrame", this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.buttons) {
            if (this.buttons.get() == 0) {
                if (this.stackFrame != null) {
                    this.stackFrame.setVisible(false);
                }
                this.setVisible(false);
            } else {
                if (this.stackFrame == null) {
                    this.stackFrame = new StackFrame();
                }
                this.stackFrame.setStack(this.data);
                this.stackFrame.setVisible(true);
            }
        } else {
            GUISystem.err.println(this.getClass().getName() + ".actionPerformed(): internal error");
        }
    }

    public void addAtLine(String string) {
        if (this.data == null) {
            return;
        }
        this.data.addAtLine(string);
    }

    public void addException(String string) {
        this.setVisible(true);
        this.data = new ExceptionData(string);
        this.list.addElement(this.data);
        this.list.repaint();
    }

    public void clear() {
        this.list.clear();
        this.data = null;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() != 2) {
            return;
        }
        this.selected();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private void selected() {
        try {
            ExceptionData exceptionData = (ExceptionData)this.list.getSelectedValue();
            if (exceptionData == null) {
                return;
            }
            if (exceptionData.atLines.size() == 0) {
                return;
            }
            String string = (String)exceptionData.atLines.elementAt(0);
            string = string.trim();
            string = string.substring(3);
            String string2 = string.substring(0, string.indexOf(40));
            string = string.substring(string2.length() + 1);
            String string3 = string.substring(0, string.indexOf(58));
            string = string.substring(string3.length() + 1);
            String string4 = string.substring(0, string.length() - 1);
            int n = Integer.parseInt(string4);
            String string5 = string2.substring(string2.lastIndexOf(46) + 1);
            string2 = string2.substring(0, string2.length() - 1 - string5.length());
            String string6 = string2.substring(string2.lastIndexOf(46) + 1);
            String string7 = string2 = string2.substring(0, string2.length() - 1 - string6.length());
            Package[] packageArray = Jedi.getEditor().getProject().getPackages();
            int n2 = 0;
            while (n2 < packageArray.length) {
                if (packageArray[n2].getName().equals(string7)) {
                    Vector vector = packageArray[n2].getClasses();
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        Class clazz = (Class)enumeration.nextElement();
                        if (string6.indexOf(36) != -1) {
                            string6 = string6.substring(0, string6.indexOf(36));
                        }
                        if (!clazz.getName().equals(string6)) continue;
                        Method method = (Method)clazz.getLineResolver().getObject(n);
                        if (method == null) {
                            JReqTools.showError(CompilerFrame.GRS("ExceptionFrame.MethodNotFound"));
                            return;
                        }
                        Jedi.getEditor().setCompileError(new CompileError(packageArray[n2], method.getParent(), method, null, null, clazz.getLineResolver().getObjectLine(n), -1, 4));
                    }
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            JReqTools.showException(exception);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.selected();
    }

    static final class StackFrame
    extends Frame
    implements ActionListener {
        TextArea text = new TextArea();
        DismissButton buttons = new DismissButton();

        public StackFrame() {
            super(CompilerFrame.GRS("ExceptionFrame.StackTitle"));
            this.text.setEditable(false);
            this.buttons.addActionListener(this);
            YFramePanel yFramePanel = new YFramePanel();
            yFramePanel.add(this.text);
            yFramePanel.addStrut();
            yFramePanel.add(this.buttons);
            this.setContentPane(yFramePanel);
            this.pack();
            Prefs.add("ExceptionFrame.StackFrame", this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.setVisible(false);
        }

        public void setStack(ExceptionData exceptionData) {
            String string = exceptionData.toString() + "\n\n";
            int n = 0;
            while (n < exceptionData.atLines.size()) {
                string = string + exceptionData.atLines.elementAt(n) + "\n";
                ++n;
            }
            this.text.setText(string);
        }
    }

    static final class ExceptionData {
        String description;
        Vector atLines = new Vector();

        public ExceptionData(String string) {
            this.description = string;
        }

        public void addAtLine(String string) {
            this.atLines.addElement(string);
        }

        public String toString() {
            return this.description;
        }
    }
}

