/*
 * Decompiled with CFR 0.152.
 */
package jedi.compiler;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;
import jedi.Jedi;
import jedi.compiler.CompilerFrame;
import jedi.compiler.Java11Runtime;
import jedi.compiler.JavaCompiler;
import jedi.ds.Class;
import jedi.ds.CompileError;
import jedi.ds.LineResolver;
import jedi.ds.Method;
import jedi.ds.Package;
import jedi.ds.Project;
import jreqtools.FileRequester;
import jreqtools.JReqTools;
import jreqtools.SelectRequester;
import swing.addon.CheckBox;
import swing.addon.EditableListview;
import swing.addon.FileString;
import swing.addon.GUISystem;
import swing.addon.GridBagConstraints;
import swing.addon.GridBagLayout;
import swing.addon.Insets;
import swing.addon.MenuItem;
import swing.addon.Panel;
import swing.addon.Prefs;
import swing.addon.Separator;
import swing.addon.YFramePanel;
import swing.addon.util.FileUtils;
import swing.addon.util.Sorter;
import swing.addon.util.StringArray;

class Java11Compiler
extends YFramePanel
implements JavaCompiler,
ActionListener {
    private static final boolean DEBUG = true;
    private static final int ID = 0;
    FileString compiler = new FileString(Prefs.isWindowsSystem() ? "C:\\jdk1.1\\bin\\javac.exe" : "/opt/jdk-1.1/bin/javac");
    CheckBox debug = new CheckBox(CompilerFrame.GRS("Java11Compiler.CheckBox1"));
    CheckBox optimize = new CheckBox(CompilerFrame.GRS("Java11Compiler.CheckBox2"));
    CheckBox deprecation = new CheckBox(CompilerFrame.GRS("Java11Compiler.CheckBox3"));
    CheckBox warnings = new CheckBox(CompilerFrame.GRS("Java11Compiler.CheckBox4"));
    CheckBox recompilation = new CheckBox(CompilerFrame.GRS("Java11Compiler.CheckBox5"));
    EditableListview classpath = new EditableListview();
    MenuItem mi_fileRequester = new MenuItem(CompilerFrame.GRS("Java11Compiler.PopupMenuItem1"));
    MenuItem mi_packageManager = new MenuItem(CompilerFrame.GRS("Java11Compiler.PopupMenuItem2"));
    FileRequester fileRequester = new FileRequester();
    SelectRequester packageManager = new SelectRequester(CompilerFrame.GRS("Java11Compiler.PackageRequester.Title"), null, Java11Compiler.createStringArrayFromClasspath());
    Process compileProcess = null;

    public Java11Compiler() {
        this.debug.setSelected(false);
        this.optimize.setSelected(false);
        this.deprecation.setSelected(false);
        this.warnings.setSelected(false);
        this.recompilation.setSelected(false);
        this.classpath.add(this.mi_fileRequester);
        this.classpath.add(this.mi_packageManager);
        this.mi_fileRequester.addActionListener(this);
        this.mi_packageManager.addActionListener(this);
        this.add(new Separator(CompilerFrame.GRS("Java11Compiler.Separator1")));
        this.add(this.compiler);
        this.addStrut();
        this.add(new Separator(CompilerFrame.GRS("Java11Compiler.Separator2")));
        this.add(this.createOptionPanel());
        this.addStrut();
        this.add(new Separator(CompilerFrame.GRS("Java11Compiler.Separator3")));
        this.add(this.classpath);
        Prefs.add("Java11Compiler.FileRequester", this.fileRequester);
        Prefs.add("Java11Compiler.PackageManager", this.packageManager);
        Prefs.add("Java11Compiler.Binary", this.compiler);
    }

    public void abortCompilation() {
        if (this.compileProcess != null) {
            this.compileProcess.destroy();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mi_fileRequester) {
            if (this.fileRequester.request(Jedi.getCompilerPrefsFrame()) != 0) {
                return;
            }
            this.classpath.addItem(this.fileRequester.getFile().getAbsolutePath());
        } else if (object == this.mi_packageManager) {
            if (this.packageManager.request(Jedi.getCompilerPrefsFrame()) != 0) {
                return;
            }
            this.classpath.addItem((String)this.packageManager.getSelectedValue());
        } else {
            GUISystem.err.println(this.getClass().getName() + ".actionPerformed(): internal error");
        }
    }

    public void changeValues() {
        Project project = Jedi.getEditor().getProject();
        project.putProperty("Java11Compiler.Debug", "" + this.debug.isSelected());
        project.putProperty("Java11Compiler.Optimize", "" + this.optimize.isSelected());
        project.putProperty("Java11Compiler.Deprecation", "" + this.deprecation.isSelected());
        project.putProperty("Java11Compiler.Warnings", "" + this.warnings.isSelected());
        project.putProperty("Java11Compiler.Recompilation", "" + this.recompilation.isSelected());
        project.putProperty("Java11Compiler.Classpath", StringArray.toString(this.classpath.get()));
    }

    private Panel createOptionPanel() {
        Panel panel = new Panel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(Prefs.getObjectSpace(), Prefs.getObjectSpace(), Prefs.getObjectSpace(), Prefs.getObjectSpace());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        panel.add((Component)this.debug, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        panel.add((Component)this.optimize, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        panel.add((Component)this.deprecation, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        panel.add((Component)this.warnings, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        panel.add((Component)this.recompilation, gridBagConstraints);
        return panel;
    }

    static String[] createStringArrayFromClasspath() {
        String string = System.getProperty("jedi.class.path");
        if (string == null) {
            return new String[]{CompilerFrame.GRS("Java11Compiler.PackageRequester.Error1")};
        }
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)vector.elementAt(n);
            ++n;
        }
        Sorter.sort(stringArray);
        return stringArray;
    }

    public String getArguments() {
        Project project = Jedi.getEditor().getProject();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("-J-mx64m");
        stringBuffer.append(project.getProperty("Java11Compiler.Debug").equals("true") ? " -g" : "");
        stringBuffer.append(project.getProperty("Java11Compiler.Optimize").equals("true") ? " -O" : "");
        stringBuffer.append(project.getProperty("Java11Compiler.Recompilation").equals("true") ? " -depend" : "");
        stringBuffer.append(project.getProperty("Java11Compiler.Warnings").equals("true") ? " -nowarn" : "");
        stringBuffer.append(project.getProperty("Java11Compiler.Deprecation").equals("true") ? " -deprecation" : "");
        return stringBuffer.toString();
    }

    public String getBinary() {
        return this.compiler.getText();
    }

    public String getClasspath() {
        String string = "";
        String[] stringArray = this.classpath.get();
        int n = 0;
        while (n < stringArray.length) {
            string = string + stringArray[n];
            if (n + 1 < stringArray.length) {
                string = string + File.pathSeparator;
            }
            ++n;
        }
        return string;
    }

    public String getID() {
        return "0";
    }

    public String getName() {
        return CompilerFrame.GRS("Java11Compiler.Name");
    }

    public Panel getOptionPanel() {
        return this;
    }

    public String getShortDescription() {
        return CompilerFrame.GRS("Java11Compiler.Short");
    }

    public void setValues() {
        Project project = Jedi.getEditor().getProject();
        String string = project.getProperty("Java11Compiler.Debug");
        if (string != null) {
            this.debug.setSelected(string.equals("true"));
        } else {
            project.putProperty("Java11Compiler.Debug", "" + this.debug.isSelected());
        }
        string = project.getProperty("Java11Compiler.Optimize");
        if (string != null) {
            this.optimize.setSelected(string.equals("true"));
        } else {
            project.putProperty("Java11Compiler.Optimize", "" + this.optimize.isSelected());
        }
        string = project.getProperty("Java11Compiler.Deprecation");
        if (string != null) {
            this.deprecation.setSelected(string.equals("true"));
        } else {
            project.putProperty("Java11Compiler.Deprecation", "" + this.deprecation.isSelected());
        }
        string = project.getProperty("Java11Compiler.Warnings");
        if (string != null) {
            this.warnings.setSelected(string.equals("true"));
        } else {
            project.putProperty("Java11Compiler.Warnings", "" + this.warnings.isSelected());
        }
        string = project.getProperty("Java11Compiler.Recompilation");
        if (string != null) {
            this.recompilation.setSelected(string.equals("true"));
        } else {
            project.putProperty("Java11Compiler.Recompilation", "" + this.recompilation.isSelected());
        }
        string = project.getProperty("Java11Compiler.Classpath");
        if (string != null) {
            this.classpath.set(StringArray.parseFromString(string));
        } else {
            project.putProperty("Java11Compiler.Classpath", StringArray.toString(this.classpath.get()));
        }
    }

    public boolean startCompilation(Class[] classArray) {
        if (!FileUtils.doesExist(this.getBinary())) {
            JReqTools.showError(CompilerFrame.GRS("Java11Compiler.Error1", this.compiler.getText()));
            return false;
        }
        Project project = Jedi.getEditor().getProject();
        StringBuffer stringBuffer = new StringBuffer(2000);
        String string = this.getClasspath();
        if (string.length() == 0) {
            Jedi.getCompilerPrefsFrame().setVisible(true);
            JReqTools.showError(Jedi.getCompilerPrefsFrame(), CompilerFrame.GRS("Java11Compiler.Error2"));
            return false;
        }
        stringBuffer.append(this.getBinary());
        stringBuffer.append(" -classpath ");
        stringBuffer.append("\"" + Project.compileDir.getAbsolutePath() + File.pathSeparatorChar + string + "\"");
        stringBuffer.append(" " + this.getArguments());
        stringBuffer.append(" -d \"" + Project.compileDir.getAbsolutePath() + "\"");
        int n = 0;
        while (n < classArray.length) {
            stringBuffer.append(" \"" + classArray[n].getSourceFilename() + "\"");
            ++n;
        }
        try {
            CompilerFrame.log("Executing '" + stringBuffer + "'");
            this.compileProcess = Runtime.getRuntime().exec(Java11Runtime.toCommandArray(stringBuffer));
            ErrorFetcher errorFetcher = new ErrorFetcher(new BufferedReader(new InputStreamReader(this.compileProcess.getErrorStream())));
            errorFetcher.start();
            this.compileProcess.waitFor();
            int n2 = this.compileProcess.exitValue();
            this.compileProcess = null;
            return n2 == 0;
        }
        catch (Exception exception) {
            JReqTools.showException(exception);
            return false;
        }
    }

    static final class ErrorFetcher
    extends Thread {
        Project project = Jedi.getEditor().getProject();
        BufferedReader stream = null;
        String destination = Project.compileDir.getAbsolutePath();
        String first = null;
        String second = null;
        String third = null;

        public ErrorFetcher(BufferedReader bufferedReader) {
            super("Jedi Error Fetcher");
            this.setPriority(10);
            this.stream = bufferedReader;
        }

        public void println(String string) {
            CompilerFrame.log(string);
            if (this.first == null) {
                this.first = string.replace('\t', ' ');
                this.second = null;
            } else if (this.second == null) {
                this.second = string.replace('\t', ' ');
                this.third = null;
            } else if (this.third == null) {
                this.third = string.replace('\t', ' ');
                this.processLines();
                this.third = null;
                this.second = null;
                this.first = null;
            } else {
                GUISystem.err.println("REDIRECTED OUTPUT TO STDERR: '" + string + "'");
            }
        }

        void processLines() {
            try {
                this.first = this.first.substring(this.destination.length() + 1);
                StringTokenizer stringTokenizer = new StringTokenizer(this.first, ":");
                String string = stringTokenizer.nextToken();
                string = string.substring(0, string.length() - 5).replace(File.separatorChar, '.').trim();
                String string2 = string.substring(0, string.lastIndexOf("."));
                string = string.substring(string2.length() + 1);
                int n = Integer.parseInt(stringTokenizer.nextToken().trim());
                String string3 = stringTokenizer.nextToken("").substring(2);
                int n2 = this.third.replace('\t', ' ').indexOf("^");
                Package package_ = this.project.get(string2);
                if (package_ == null) {
                    System.err.println(this.getClass().getName() + ".processLines(): internal error 1");
                    return;
                }
                Class clazz = package_.get(string);
                if (clazz == null) {
                    System.err.println(this.getClass().getName() + ".processLines(): internal error 2");
                    return;
                }
                Method method = null;
                LineResolver lineResolver = clazz.getLineResolver();
                Object object = lineResolver.getObject(n);
                if (object instanceof Method) {
                    method = (Method)object;
                    clazz = method.getParent();
                } else {
                    clazz = (Class)object;
                }
                Jedi.getCompilerFrame().addError(new CompileError(package_, clazz, method, string3, this.second, lineResolver.getObjectLine(n), n2, lineResolver.getType(n)));
            }
            catch (Exception exception) {
                System.err.println(this.getClass().getName() + ".processLines(): internal error 3 \n" + exception);
                System.err.println("1 -> " + this.first);
                System.err.println("2 -> " + this.second);
                System.err.println("3 -> " + this.third);
            }
        }

        public void run() {
            String string = "";
            try {
                int n;
                while ((n = this.stream.read()) != -1) {
                    if (n == 10) {
                        this.println(string);
                        string = "";
                        continue;
                    }
                    string = string + (char)n;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

