/*
 * Decompiled with CFR 0.152.
 */
package jedi.compiler;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;
import jedi.Jedi;
import jedi.compiler.CompilerFrame;
import jedi.compiler.ExceptionFrame;
import jedi.compiler.JavaRuntime;
import jedi.ds.Method;
import jedi.ds.Package;
import jedi.ds.Project;
import jreqtools.JReqTools;
import swing.addon.ComboBox;
import swing.addon.FileString;
import swing.addon.Label;
import swing.addon.Panel;
import swing.addon.Prefs;
import swing.addon.TextField;
import swing.addon.util.FileUtils;

class Java11Runtime
extends Panel
implements JavaRuntime {
    private static final int ID = 0;
    FileString vm = new FileString(Prefs.isWindowsSystem() ? "C:\\jdk1.1\\bin\\java.exe" : "/opt/jdk-1.1/bin/java");
    TextField options = new TextField("");
    TextField arguments = new TextField("");
    ComboBox language = new ComboBox(Package.getSupportedLocalesAsDisplayNames());
    Process runProcess = null;

    public Java11Runtime() {
        super(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(Prefs.getObjectSpace(), Prefs.getObjectSpace(), Prefs.getObjectSpace(), Prefs.getObjectSpace());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)new Label(CompilerFrame.GRS("Java11Runtime.Label1"), 2), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.vm, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)new Label(CompilerFrame.GRS("Java11Runtime.Label4"), 2), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.language, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)new Label(CompilerFrame.GRS("Java11Runtime.Label2"), 2), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.options, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)new Label(CompilerFrame.GRS("Java11Runtime.Label3"), 2), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.arguments, gridBagConstraints);
        Prefs.add("Java11Runtime.VM", this.vm);
    }

    public void abortProgram() {
        if (this.runProcess != null) {
            this.runProcess.destroy();
        }
    }

    public void changeValues() {
        Project project = Jedi.getEditor().getProject();
        project.putProperty("Java11Runtime.Options", this.options.getText());
        project.putProperty("Java11Runtime.Arguments", this.arguments.getText());
        project.putProperty("Java11Runtime.Language", "" + this.language.getSelectedIndex());
    }

    public String getArguments() {
        return this.arguments.getText();
    }

    public String getBinary() {
        return this.vm.getText();
    }

    public String getClasspath() {
        return Jedi.getCompilerPrefsFrame().getCompiler(0).getClasspath();
    }

    public String getID() {
        return "0";
    }

    public String getName() {
        return CompilerFrame.GRS("Java11Runtime.Name");
    }

    public Panel getOptionPanel() {
        return this;
    }

    public String getOptions() {
        return this.options.getText();
    }

    public String getShortDescription() {
        return CompilerFrame.GRS("Java11Runtime.Short");
    }

    static String makeLanguageArgument(String string) {
        if (string.indexOf("_") != -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
            return " -Duser.language=" + stringTokenizer.nextToken() + " -Duser.region=" + stringTokenizer.nextToken();
        }
        return " -Duser.language=" + string;
    }

    public int runProgram(Method method, ExceptionFrame exceptionFrame) {
        if (!FileUtils.doesExist(this.vm.getText())) {
            JReqTools.showError(CompilerFrame.GRS("Java11Runtime.Error1", this.vm.getText()));
            return 0;
        }
        Project project = Jedi.getEditor().getProject();
        String string = project.getProperty("Java11Runtime.Options");
        String string2 = project.getProperty("Java11Runtime.Arguments");
        String string3 = project.getProperty("Java11Runtime.Language");
        int n = -1;
        StringBuffer stringBuffer = new StringBuffer(2000);
        stringBuffer.append(this.vm.getText());
        stringBuffer.append(" -Djedi.runfrom=1 -Djedi.directory=\"" + Jedi.getHomeDirectory() + "\"");
        if (!string3.equals("0")) {
            stringBuffer.append(Java11Runtime.makeLanguageArgument(Package.getSupportedLocales()[Integer.parseInt(string3)]));
        }
        stringBuffer.append(" -classpath ");
        stringBuffer.append("\"" + Project.compileDir.getAbsolutePath() + File.pathSeparatorChar + Jedi.getCompilerPrefsFrame().getCompiler(0).getClasspath() + "\"");
        stringBuffer.append(" " + string);
        stringBuffer.append(" \"" + method.getParent().getFullName() + "\"");
        stringBuffer.append(" " + string2);
        try {
            CompilerFrame.log("Executing '" + stringBuffer + "'");
            this.runProcess = Runtime.getRuntime().exec(Java11Runtime.toCommandArray(stringBuffer));
            OutputFetcher outputFetcher = new OutputFetcher(new BufferedReader(new InputStreamReader(this.runProcess.getInputStream())));
            outputFetcher.start();
            ErrorFetcher errorFetcher = new ErrorFetcher(new BufferedReader(new InputStreamReader(this.runProcess.getErrorStream())), exceptionFrame);
            errorFetcher.start();
            this.runProcess.waitFor();
            n = this.runProcess.exitValue();
            this.runProcess = null;
        }
        catch (Exception exception) {
            JReqTools.showException(exception);
        }
        return n;
    }

    public void setValues() {
        Project project = Jedi.getEditor().getProject();
        String string = project.getProperty("Java11Runtime.Options");
        if (string != null) {
            this.options.setText(string);
        } else {
            project.putProperty("Java11Runtime.Options", this.options.getText());
        }
        string = project.getProperty("Java11Runtime.Arguments");
        if (string != null) {
            this.arguments.setText(string);
        } else {
            project.putProperty("Java11Runtime.Arguments", this.arguments.getText());
        }
        string = project.getProperty("Java11Runtime.Language");
        if (string != null) {
            this.language.setSelectedIndex(Integer.parseInt(string));
        } else {
            project.putProperty("Java11Runtime.Language", "0");
        }
    }

    static String[] toCommandArray(StringBuffer stringBuffer) {
        Vector<String> vector = new Vector<String>(10, 10);
        char c = '\u0000';
        String string = "";
        boolean bl = false;
        int n = 0;
        while (n < stringBuffer.length()) {
            char c2 = stringBuffer.charAt(n);
            if (c2 == '\"') {
                bl = !bl;
            } else if (!bl) {
                if (c2 == ' ' && c != c2) {
                    vector.addElement(string);
                    string = "";
                } else if (c2 != ' ') {
                    string = string + c2;
                }
            } else {
                string = string + c2;
            }
            c = c2;
            ++n;
        }
        if (!string.equals("")) {
            vector.addElement(string);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    static final class OutputFetcher
    extends Thread {
        BufferedReader stream;

        public OutputFetcher(BufferedReader bufferedReader) {
            super("Jedi Output Fetcher");
            this.setPriority(4);
            this.stream = bufferedReader;
        }

        public void run() {
            System.out.println(CompilerFrame.GRS("RunThread.Output"));
            try {
                int n;
                while ((n = this.stream.read()) != -1) {
                    System.out.print((char)n);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static final class ErrorFetcher
    extends Thread {
        BufferedReader stream;
        ExceptionFrame exceptionFrame;

        public ErrorFetcher(BufferedReader bufferedReader, ExceptionFrame exceptionFrame) {
            super("Jedi Error Fetcher");
            this.setPriority(1);
            this.stream = bufferedReader;
            this.exceptionFrame = exceptionFrame;
        }

        public void run() {
            String string = null;
            String string2 = "";
            try {
                int n;
                while ((n = this.stream.read()) != -1) {
                    char c = (char)n;
                    if (c == '\n') {
                        if (string2.startsWith("\tat") && string != null && (string.indexOf("Exception:") != -1 || string.indexOf("Error:") != -1)) {
                            this.exceptionFrame.addException(string);
                            this.exceptionFrame.addAtLine(string2);
                        } else if (string2.startsWith("\tat") && string != null && (string.indexOf("Exception") != -1 || string.indexOf("Error") != -1)) {
                            this.exceptionFrame.addException(string);
                            this.exceptionFrame.addAtLine(string2);
                        } else if (string2.startsWith("\tat") && string != null && string.startsWith("\tat")) {
                            this.exceptionFrame.addAtLine(string2);
                        } else {
                            System.out.println(string2);
                        }
                        string = string2;
                        string2 = "";
                        continue;
                    }
                    string2 = string2 + c;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

