/*
 * Decompiled with CFR 0.152.
 */
package jedi.compiler;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import jedi.Jedi;
import jedi.compiler.CompilerFrame;
import jedi.compiler.ExceptionFrame;
import jedi.compiler.Java11Runtime;
import jedi.compiler.JavaRuntime;
import jedi.ds.Method;
import jedi.ds.Package;
import jedi.ds.Project;
import jreqtools.JReqTools;
import swing.addon.ComboBox;
import swing.addon.FileString;
import swing.addon.Label;
import swing.addon.Panel;
import swing.addon.Prefs;
import swing.addon.TextField;
import swing.addon.util.FileUtils;

class Java2SDK12Runtime
extends Panel
implements JavaRuntime {
    private static final int ID = 1;
    FileString vm = new FileString(Prefs.isWindowsSystem() ? "C:\\jdk1.2\\bin\\java.exe" : "/opt/jdk-1.2/bin/java");
    TextField options = new TextField("");
    TextField arguments = new TextField("");
    ComboBox language = new ComboBox(Package.getSupportedLocalesAsDisplayNames());
    Process runProcess = null;

    public Java2SDK12Runtime() {
        super(new GridBagLayout());
        this.language.setEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(Prefs.getObjectSpace(), Prefs.getObjectSpace(), Prefs.getObjectSpace(), Prefs.getObjectSpace());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)new Label(CompilerFrame.GRS("Java2SDK12Runtime.Label1"), 2), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.vm, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)new Label(CompilerFrame.GRS("Java2SDK12Runtime.Label4"), 2), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.language, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)new Label(CompilerFrame.GRS("Java2SDK12Runtime.Label2"), 2), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.options, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)new Label(CompilerFrame.GRS("Java2SDK12Runtime.Label3"), 2), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.arguments, gridBagConstraints);
        Prefs.add("Java2SDK12Runtime.VM", this.vm);
    }

    public void abortProgram() {
        if (this.runProcess != null) {
            this.runProcess.destroy();
        }
    }

    public void changeValues() {
        Project project = Jedi.getEditor().getProject();
        project.putProperty("Java2SDK12Runtime.Options", this.options.getText());
        project.putProperty("Java2SDK12Runtime.Arguments", this.arguments.getText());
        project.putProperty("Java2SDK12Runtime.Language", "" + this.language.getSelectedIndex());
    }

    public String getArguments() {
        return this.arguments.getText();
    }

    public String getBinary() {
        return this.vm.getText();
    }

    public String getClasspath() {
        return Jedi.getCompilerPrefsFrame().getCompiler(1).getClasspath();
    }

    public String getID() {
        return "1";
    }

    public String getName() {
        return CompilerFrame.GRS("Java2SDK12Runtime.Name");
    }

    public Panel getOptionPanel() {
        return this;
    }

    public String getOptions() {
        return this.options.getText();
    }

    public String getShortDescription() {
        return CompilerFrame.GRS("Java2SDK12Runtime.Short");
    }

    public int runProgram(Method method, ExceptionFrame exceptionFrame) {
        if (!FileUtils.doesExist(this.vm.getText())) {
            JReqTools.showError(CompilerFrame.GRS("Java2SDK12Runtime.Error1", this.vm.getText()));
            return 0;
        }
        Project project = Jedi.getEditor().getProject();
        String string = project.getProperty("Java2SDK12Runtime.Options");
        String string2 = project.getProperty("Java2SDK12Runtime.Arguments");
        String string3 = project.getProperty("Java2SDK12Runtime.Language");
        int n = -1;
        StringBuffer stringBuffer = new StringBuffer(2000);
        stringBuffer.append(this.vm.getText());
        stringBuffer.append(" -Djedi.runfrom=1 -Djedi.directory=\"" + Jedi.getHomeDirectory() + "\"");
        if (!string3.equals("0")) {
            stringBuffer.append(Java11Runtime.makeLanguageArgument(Package.getSupportedLocales()[Integer.parseInt(string3)]));
        }
        stringBuffer.append(" -classpath ");
        stringBuffer.append("\"" + Project.compileDir.getAbsolutePath() + File.pathSeparatorChar + Jedi.getCompilerPrefsFrame().getCompiler(1).getClasspath() + "\"");
        stringBuffer.append(" " + string);
        stringBuffer.append(" \"" + method.getParent().getFullName() + "\"");
        stringBuffer.append(" " + string2);
        try {
            CompilerFrame.log("Executing '" + stringBuffer + "'");
            this.runProcess = Runtime.getRuntime().exec(Java11Runtime.toCommandArray(stringBuffer));
            Java11Runtime.OutputFetcher outputFetcher = new Java11Runtime.OutputFetcher(new BufferedReader(new InputStreamReader(this.runProcess.getInputStream())));
            outputFetcher.start();
            Java11Runtime.ErrorFetcher errorFetcher = new Java11Runtime.ErrorFetcher(new BufferedReader(new InputStreamReader(this.runProcess.getErrorStream())), exceptionFrame);
            errorFetcher.start();
            this.runProcess.waitFor();
            n = this.runProcess.exitValue();
            this.runProcess = null;
        }
        catch (Exception exception) {
            JReqTools.showException(exception);
        }
        return n;
    }

    public void setValues() {
        Project project = Jedi.getEditor().getProject();
        String string = project.getProperty("Java2SDK12Runtime.Options");
        if (string != null) {
            this.options.setText(string);
        } else {
            project.putProperty("Java2SDK12Runtime.Options", this.options.getText());
        }
        string = project.getProperty("Java2SDK12Runtime.Arguments");
        if (string != null) {
            this.arguments.setText(string);
        } else {
            project.putProperty("Java2SDK12Runtime.Arguments", this.arguments.getText());
        }
        string = project.getProperty("Java2SDK12Runtime.Language");
        if (string != null) {
            this.language.setSelectedIndex(Integer.parseInt(string));
        } else {
            project.putProperty("Java2SDK12Runtime.Language", "0");
        }
    }
}

