/*
 * Decompiled with CFR 0.152.
 */
package jedi.compiler;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import jedi.Jedi;
import jedi.compiler.CompilerFrame;
import jedi.compiler.Java11Runtime;
import jedi.compiler.Java2SDK12Runtime;
import jedi.compiler.Java2SDK13Runtime;
import jedi.compiler.JavaRuntime;
import jedi.ds.Project;
import jedi.event.PrefsChangedEvent;
import jedi.event.PrefsChangedListener;
import jedi.event.ProjectEvent;
import jedi.event.ProjectListener;
import jreqtools.JReqTools;
import swing.addon.Frame;
import swing.addon.GUISystem;
import swing.addon.OkCancelButtons;
import swing.addon.Prefs;
import swing.addon.TabbedPane;
import swing.addon.YFramePanel;

public class RuntimePrefsFrame
extends Frame
implements ActionListener,
ProjectListener {
    Vector listeners = new Vector();
    JavaRuntime[] runtimes = new JavaRuntime[]{new Java11Runtime(), new Java2SDK12Runtime(), new Java2SDK13Runtime()};
    TabbedPane tabbedPane = new TabbedPane();
    OkCancelButtons buttons = new OkCancelButtons();

    public RuntimePrefsFrame() {
        super(CompilerFrame.GRS("RuntimePrefsFrame.Title"));
        int n = 0;
        while (n < this.runtimes.length) {
            this.tabbedPane.addTab(this.runtimes[n].getName(), this.runtimes[n].getOptionPanel());
            ++n;
        }
        this.buttons.addHelpButton("prefs_runtime");
        this.buttons.addActionListener(this);
        Jedi.getEditor().addProjectListener(this);
        YFramePanel yFramePanel = new YFramePanel();
        yFramePanel.add(this.tabbedPane);
        yFramePanel.addStrut();
        yFramePanel.add(this.buttons);
        this.setContentPane(yFramePanel);
        this.pack();
        Prefs.add("RuntimePrefsFrame", this);
        Prefs.add("RuntimePrefsFrame.TabbedPane", this.tabbedPane);
        this.projectChanged(null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Project project = Jedi.getEditor().getProject();
        if (this.buttons.get() == 0) {
            if (Jedi.getCompilerFrame().getMode() != 0) {
                JReqTools.showError(this, CompilerFrame.GRS("RuntimePrefsFrame.Error1"));
                return;
            }
            int n = 0;
            while (n < this.runtimes.length) {
                this.runtimes[n].changeValues();
                ++n;
            }
            project.putProperty("Runtime", "" + this.runtimes[this.tabbedPane.getSelectedIndex()].getID());
            this.sendPrefsChangedEvent();
        } else {
            int n = 0;
            while (n < this.runtimes.length) {
                this.runtimes[n].setValues();
                ++n;
            }
            this.selectTab(project.getProperty("Runtime"));
        }
        this.setVisible(false);
    }

    public void addPrefsChangedListener(PrefsChangedListener prefsChangedListener) {
        this.listeners.addElement(prefsChangedListener);
    }

    public JavaRuntime getRuntime() {
        return this.runtimes[this.tabbedPane.getSelectedIndex()];
    }

    private static void main(String[] stringArray) {
        Prefs.init("Jedi", null);
        RuntimePrefsFrame runtimePrefsFrame = new RuntimePrefsFrame();
        runtimePrefsFrame.setVisible(true);
        runtimePrefsFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Prefs.save();
                System.exit(0);
            }
        });
    }

    public void projectChanged(ProjectEvent projectEvent) {
        Project project = Jedi.getEditor().getProject();
        String string = project.getProperty("Runtime");
        if (string != null) {
            this.selectTab(string);
        } else {
            project.putProperty("Runtime", "" + this.tabbedPane.getSelectedIndex());
        }
        int n = 0;
        while (n < this.runtimes.length) {
            this.runtimes[n].setValues();
            ++n;
        }
        this.sendPrefsChangedEvent();
    }

    public void removePrefsChangedListener(PrefsChangedListener prefsChangedListener) {
        this.listeners.removeElement(prefsChangedListener);
    }

    void selectTab(String string) {
        int n = 0;
        while (n < this.runtimes.length) {
            if (this.runtimes[n].getID().equals(string)) {
                this.tabbedPane.setSelectedIndex(n);
                return;
            }
            ++n;
        }
        GUISystem.err.println("Trying to selected an unkown runtime environment ?!?");
    }

    void sendPrefsChangedEvent() {
        int n = 0;
        while (n < this.listeners.size()) {
            ((PrefsChangedListener)this.listeners.elementAt(n)).prefsChanged(new PrefsChangedEvent(this, "RuntimePrefs"));
            ++n;
        }
    }
}

