/*
 * Decompiled with CFR 0.152.
 */
package jedi.convert;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.Vector;
import jedi.Jedi;
import jreqtools.JReqTools;
import swing.addon.util.FileUtils;
import swing.addon.util.Sorter;

public class Convert1 {
    private static final boolean DEBUG = false;

    static void convertClass(String string) {
        Object object;
        Convert1.message("-> Converting class/interface '" + string + "'");
        Properties properties = new Properties();
        try {
            object = new FileInputStream(new File(string, "Class-Properties"));
            properties.load((InputStream)object);
            ((FileInputStream)object).close();
        }
        catch (IOException iOException) {
            Convert1.exit(iOException.toString());
        }
        object = new Vector();
        ((Vector)object).addElement("# Class Data");
        ((Vector)object).addElement("Type=" + properties.getProperty("type", "1"));
        ((Vector)object).addElement("IsPublic=" + properties.getProperty("isPublic", "true"));
        ((Vector)object).addElement("IsProtected=" + properties.getProperty("isProtected", "false"));
        ((Vector)object).addElement("IsPrivate=" + properties.getProperty("isPrivate", "false"));
        ((Vector)object).addElement("IsAbstract=" + properties.getProperty("isAbstract", "false"));
        ((Vector)object).addElement("IsFinal=" + properties.getProperty("isFinal", "false"));
        ((Vector)object).addElement("IsStatic=" + properties.getProperty("isStatic", "false"));
        ((Vector)object).addElement("Extends=" + properties.getProperty("extends", ""));
        ((Vector)object).addElement("Implements=" + properties.getProperty("implements", ""));
        ((Vector)object).addElement("ImportList=" + properties.getProperty("importlist", ""));
        ((Vector)object).addElement("Variables=" + properties.getProperty("variables", "").replace('\n', '\u0000').replace('\r', '\u0000'));
        ((Vector)object).addElement("JavaDoc=" + properties.getProperty("javadoc", "").replace('\n', '\u0000').replace('\r', '\u0000'));
        ((Vector)object).addElement("DebugLevel=" + properties.getProperty("debugLevel", "0"));
        File file = new File(string + File.separator + "C");
        String[] stringArray = file.list();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        Sorter.sort(stringArray);
        int n = 0;
        while (n < stringArray.length) {
            Convert1.convertConstructor(file.getAbsolutePath() + File.separator + stringArray[n], (Vector)object);
            ++n;
        }
        file = new File(string + File.separator + "I");
        stringArray = file.list();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        Sorter.sort(stringArray);
        int n2 = 0;
        while (n2 < stringArray.length) {
            Convert1.convertInitializer(file.getAbsolutePath() + File.separator + stringArray[n2], (Vector)object);
            ++n2;
        }
        file = new File(string + File.separator + "M");
        stringArray = file.list();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        Sorter.sort(stringArray);
        int n3 = 0;
        while (n3 < stringArray.length) {
            Convert1.convertMethods(file.getAbsolutePath() + File.separator + stringArray[n3], (Vector)object);
            ++n3;
        }
        if (!FileUtils.deleteDirectory(string)) {
            Convert1.exit("ALERT! Could not delete some files.");
        }
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(new File(string)));
            int n4 = ((Vector)object).size();
            int n5 = 0;
            while (n5 < n4) {
                printWriter.println(((Vector)object).elementAt(n5));
                ++n5;
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            Convert1.exit(iOException.toString());
        }
    }

    static void convertConstructor(String string, Vector vector) {
        Convert1.convertMethod(string, vector, ".Constructor");
    }

    static void convertInitializer(String string, Vector vector) {
        Convert1.convertMethod(string, vector, ".StaticInitializer");
    }

    static void convertMethod(String string, Vector vector, String string2) {
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(new File(string));
            properties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            Convert1.exit(iOException.toString());
        }
        vector.addElement("# Method");
        vector.addElement("Name=" + string2);
        vector.addElement("Type=" + properties.getProperty("type", "1"));
        vector.addElement("IsPublic=" + properties.getProperty("isPublic", "true"));
        vector.addElement("IsProtected=" + properties.getProperty("isProtected", "false"));
        vector.addElement("IsPrivate=" + properties.getProperty("isPrivate", "false"));
        vector.addElement("IsAbstract=" + properties.getProperty("isAbstract", "false"));
        vector.addElement("IsFinal=" + properties.getProperty("isFinal", "false"));
        vector.addElement("IsStatic=" + properties.getProperty("isStatic", "false"));
        vector.addElement("IsSynchronized=" + properties.getProperty("isSynchronized", "false"));
        vector.addElement("IsNative=" + properties.getProperty("isNative", "false"));
        vector.addElement("ResultType=" + properties.getProperty("resultType", "void"));
        vector.addElement("Parameters=" + properties.getProperty("parameters", ""));
        vector.addElement("Throws=" + properties.getProperty("throws", ""));
        vector.addElement("Text=" + properties.getProperty("text", "").replace('\n', '\u0000').replace('\r', '\u0000'));
        vector.addElement("JavaDoc=" + properties.getProperty("javadoc", "").replace('\n', '\u0000').replace('\r', '\u0000'));
    }

    static void convertMethods(String string, Vector vector) {
        File file = new File(string);
        String[] stringArray = file.list();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        Sorter.sort(stringArray);
        int n = 0;
        while (n < stringArray.length) {
            Convert1.convertMethod(string + File.separator + stringArray[n], vector, file.getName());
            ++n;
        }
    }

    static void convertPackage(String string) {
        Convert1.message("-> Converting package '" + string + "'");
        String[] stringArray = new File(string).list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.startsWith("C.") || string.startsWith("I.");
            }
        });
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        Sorter.sort(stringArray);
        int n = 0;
        while (n < stringArray.length) {
            Convert1.convertClass(string + File.separator + stringArray[n]);
            ++n;
        }
    }

    static void exit(String string) {
        JReqTools.showError("Conversion failed with message:\n" + string + "\nPlease contact the author!");
        System.out.println("-> " + string);
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        String[] stringArray2;
        File file = new File(Jedi.getHomeDirectory() + File.separator + "packages");
        String string = "1";
        try {
            stringArray2 = new BufferedReader(new FileReader(file + File.separator + ".version"));
            string = stringArray2.readLine();
            stringArray2.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!string.equals("1")) {
            Convert1.exit("Wrong package version '" + string + "'.");
        }
        if (!JReqTools.showQuestion("Please confirm that you have backed up the directory\n" + file)) {
            System.exit(0);
        }
        JReqTools.showMessage("Note:\nIf something goes wrong while converting the files,\nyou'll have to restore the original files and contact the author!");
        if (!JReqTools.showQuestion("Do you still want to continue ?")) {
            System.exit(0);
        }
        Convert1.message("Converting Jedi data files to new version. Please stand by ...");
        stringArray2 = file.list();
        if (stringArray2 == null || stringArray2.length == 0) {
            Convert1.exit("No packages found.");
        }
        Sorter.sort(stringArray2);
        int n = 0;
        while (n < stringArray2.length) {
            Convert1.convertPackage(file.getAbsolutePath() + File.separator + stringArray2[n]);
            ++n;
        }
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(new File(file + File.separator + ".version")));
            printWriter.println("2");
            printWriter.close();
        }
        catch (IOException iOException) {
            Convert1.exit(iOException.toString());
        }
        JReqTools.showMessage("Conversion was successfull!");
        System.exit(0);
    }

    static void message(String string) {
        System.out.println(string);
    }
}

