/*
 * Decompiled with CFR 0.152.
 */
package jedi.ds;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Vector;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import jedi.Jedi;
import jedi.ds.ClassPrefsFrame;
import jedi.ds.LineResolver;
import jedi.ds.Method;
import jedi.ds.Package;
import jedi.ds.Project;
import jreqtools.JReqTools;
import swing.addon.GUISystem;
import swing.addon.text.JavaDocument;
import swing.addon.text.UndoableDocument;
import swing.addon.util.Sorter;
import swing.addon.util.StringArray;

public class Class
implements Sorter.Comparable {
    private static final boolean DEBUG = false;
    public static final String PROPERTIESFILENAME = "Class-Properties";
    public static final String CONSTRUCTORNAME = ".Constructor";
    public static final String INITIALIZERNAME = ".StaticInitializer";
    public static final String CLASS_PREFIX = "C.";
    public static final String INTERFACE_PREFIX = "I.";
    public static final String RECOVERY_PREFIX = "R.";
    public static final String BACKUP_PREFIX = "B.";
    public static final int CLASS = 1;
    public static final int INTERFACE = 2;
    int type = 1;
    boolean isPublic = true;
    boolean isProtected = false;
    boolean isPrivate = false;
    boolean isAbstract = false;
    boolean isFinal = false;
    boolean isStatic = false;
    String extend = "";
    String implement = "";
    String[] importlist = new String[0];
    String variables = "";
    String javadoc = "";
    int debugLevel = 0;
    String name = "";
    File sourceFile = null;
    File recoveryFile = null;
    File backupFile = null;
    File classFile = null;
    File saveFile = null;
    JavaDocument variablesDocument = null;
    UndoableDocument javadocDocument = null;
    boolean changed = false;
    LineResolver lineResolver = new LineResolver();
    Class parentClass = null;
    Method[] methods = new Method[0];
    Class[] classes = new Class[0];
    Package parent = null;
    Method lastMethod = null;
    ClassPrefsFrame prefsWindow = null;

    public Class(Package package_, String string, int n) {
        this.name = string;
        this.type = n;
        this.parent = package_;
        this.saveFile = new File(Project.packageDir + File.separator + package_.getName() + File.separator + this.getClassPrefix() + string);
        this.recoveryFile = new File(Project.packageDir + File.separator + package_.getName() + File.separator + RECOVERY_PREFIX + string);
        this.backupFile = new File(Project.packageDir + File.separator + package_.getName() + File.separator + BACKUP_PREFIX + string);
        this.sourceFile = new File(this.parent.sourcesDir, this.name + ".java");
        this.classFile = new File(Project.compileDir + File.separator + package_.getName().replace('.', File.separatorChar), this.name.replace('.', '$') + ".class");
        final String string2 = CLASS_PREFIX + this.getName() + ".";
        String[] stringArray = this.parent.classDir.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.startsWith(string2) && string.lastIndexOf(46) == string2.length() - 1;
            }
        });
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.addInnerClass(stringArray[n2].substring(string2.length()), 1);
            ++n2;
        }
        final String string3 = INTERFACE_PREFIX + this.getName() + ".";
        stringArray = this.parent.classDir.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.startsWith(string3) && string.lastIndexOf(46) == string3.length() - 1;
            }
        });
        int n3 = 0;
        while (n3 < stringArray.length) {
            this.addInnerClass(stringArray[n3].substring(string3.length()), 2);
            ++n3;
        }
        if (this.saveFile.exists()) {
            this.load();
        } else {
            this.save();
        }
    }

    private Method add(Method method) {
        Sorter.Comparable[] comparableArray = new Method[this.methods.length + 1];
        System.arraycopy(this.methods, 0, comparableArray, 0, this.methods.length);
        comparableArray[this.methods.length] = method;
        Sorter.sort(comparableArray);
        this.methods = comparableArray;
        this.changed = true;
        return method;
    }

    public Method add(String string, int n) {
        return this.add(new Method(this, string, n));
    }

    public Method addConstructor() {
        return this.add(CONSTRUCTORNAME, 2);
    }

    public void addImplements(String string) {
        if (this.implement == null || this.implement.length() == 0) {
            this.setImplements(string);
        } else {
            this.setImplements(this.implement + ", " + string);
        }
    }

    public void addImport(String string) {
        String[] stringArray = this.getImports();
        if (StringArray.contains(stringArray, string) != -1) {
            return;
        }
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length] = string;
        this.setImports(stringArray2);
    }

    public Method addInitializer() {
        return this.add(INITIALIZERNAME, 3);
    }

    public Class addInnerClass(String string, int n) {
        Class clazz = new Class(this.getParent(), this.getName() + "." + string, n);
        clazz.parentClass = this;
        Class[] classArray = new Class[this.classes.length + 1];
        System.arraycopy(this.classes, 0, classArray, 0, this.classes.length);
        classArray[this.classes.length] = clazz;
        this.classes = classArray;
        Sorter.sort(this.classes);
        this.changed = true;
        return clazz;
    }

    void addInnerClasses(Vector vector) {
        int n = 0;
        while (n < this.classes.length) {
            vector.addElement(this.classes[n]);
            this.classes[n].addInnerClasses(vector);
            ++n;
        }
    }

    public Method addMethod(String string) {
        return this.add(string, 1);
    }

    public void appendVariablesText(String string) {
        String string2 = this.getVariablesAsPlainText();
        if (string2.length() > 0 && !string2.endsWith("\n")) {
            string2 = string2 + "\n";
        }
        string2 = string2 + string;
        this.setVariables(string2);
    }

    public void cleanUp() {
        if (this.changed) {
            this.save();
        }
        if (this.prefsWindow != null) {
            this.prefsWindow.setVisible(false);
        }
        int n = 0;
        while (n < this.classes.length) {
            this.classes[n].cleanUp();
            ++n;
        }
        int n2 = 0;
        while (n2 < this.methods.length) {
            this.methods[n2].cleanUp();
            ++n2;
        }
    }

    public int compareTo(Object object) {
        return this.name.compareTo(((Class)object).name);
    }

    boolean delete() {
        File file;
        String[] stringArray;
        this.cleanUp();
        int n = 0;
        while (n < this.classes.length) {
            if (!this.classes[n].delete()) {
                return false;
            }
            ++n;
        }
        File file2 = new File(this.parent.sourcesDir, this.name + ".java");
        if (file2.exists()) {
            file2.delete();
        }
        if ((stringArray = (file = new File(Project.compileDir, this.parent.getName().replace('.', File.separatorChar))).list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                if (string.equals(Class.this.name + ".class")) {
                    return true;
                }
                if (string.startsWith(Class.this.name + "$")) {
                    return true;
                }
                if (Class.this.isInnerClass() && string.startsWith(Class.this.getParentClass().getName() + "$" + Class.this.name.substring(Class.this.name.lastIndexOf(46) + 1) + ".class")) {
                    return true;
                }
                return Class.this.isInnerClass() && string.startsWith(Class.this.getParentClass().getName() + "$" + Class.this.name.substring(Class.this.name.lastIndexOf(46) + 1) + "$");
            }
        })) != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                file2 = new File(file, stringArray[n2]);
                file2.delete();
                ++n2;
            }
        }
        return this.backupFile.delete() && this.saveFile.delete();
    }

    public boolean delete(Method method) {
        int n = 0;
        n = 0;
        while (n < this.methods.length && this.methods[n] != method) {
            ++n;
        }
        if (n == this.methods.length) {
            return false;
        }
        Method[] methodArray = new Method[this.methods.length - 1];
        System.arraycopy(this.methods, 0, methodArray, 0, n);
        System.arraycopy(this.methods, n + 1, methodArray, n, this.methods.length - n - 1);
        this.methods = methodArray;
        this.changed = true;
        if (this.lastMethod == method) {
            this.lastMethod = null;
        }
        return true;
    }

    public boolean delete(Class clazz) {
        int n = 0;
        n = 0;
        while (n < this.classes.length && this.classes[n] != clazz) {
            ++n;
        }
        if (n == this.classes.length) {
            return false;
        }
        Class[] classArray = new Class[this.classes.length - 1];
        System.arraycopy(this.classes, 0, classArray, 0, n);
        System.arraycopy(this.classes, n + 1, classArray, n, this.classes.length - n - 1);
        this.classes = classArray;
        this.changed = true;
        return clazz.delete();
    }

    public ClassPrefsFrame editPrefs() {
        if (this.prefsWindow == null) {
            this.prefsWindow = new ClassPrefsFrame(this);
        }
        this.prefsWindow.setVisible(true);
        return this.prefsWindow;
    }

    protected synchronized boolean export(File file) {
        try {
            File file2 = new File(file, this.name + ".java");
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file2));
            return this.export(printWriter, true);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public synchronized boolean export(PrintWriter printWriter, boolean bl) {
        boolean bl2 = true;
        try {
            String string = this.parent.getName();
            printWriter.println("package " + string + ";\n");
            int n = 0;
            while (n < this.importlist.length) {
                printWriter.println("import " + this.importlist[n] + ";");
                ++n;
            }
            printWriter.println("");
            if (!this.export(printWriter, "", bl)) {
                bl2 = false;
            }
            printWriter.flush();
            printWriter.close();
        }
        catch (IOException iOException) {
            bl2 = false;
        }
        return bl2;
    }

    private synchronized boolean export(PrintWriter printWriter, String string, boolean bl) throws IOException {
        int n;
        int n2;
        String string2;
        String string3;
        boolean bl2 = true;
        String string4 = string3 = bl ? this.getJavaDocAsPlainText() : "";
        if (!string3.trim().equals("")) {
            printWriter.println(string + "/**");
            while (string3 != null) {
                string2 = null;
                n2 = string3.indexOf(10);
                if (n2 != -1) {
                    string2 = string3.substring(0, n2);
                    string3 = string3.substring(n2 + 1);
                    printWriter.println(string + "* " + string2);
                    continue;
                }
                string2 = string3;
                string3 = null;
                if (string2.equals("")) continue;
                printWriter.println(string + "* " + string2);
            }
            printWriter.println(string + "*/\n");
        }
        string2 = this.getName();
        if (this.isInnerClass()) {
            string2 = string2.substring(string2.lastIndexOf(46) + 1);
        }
        printWriter.println(string + this.getSignature() + "{");
        if (!this.isInnerClass() && !this.isInterface()) {
            n2 = this.getDebugLevel();
            if (n2 == 0) {
                n2 = this.getParent().getDebugLevel();
            }
            switch (n2) {
                case 0: {
                    break;
                }
                case 1: {
                    printWriter.println(string + "\tprivate static final boolean DEBUG = false;\n");
                    break;
                }
                case 2: {
                    printWriter.println(string + "\tprivate static final boolean DEBUG = true;\n");
                    break;
                }
                case 3: {
                    printWriter.println(string + "\tprivate static final boolean DEBUG = true;\n");
                }
            }
        }
        String string5 = this.getVariablesAsPlainText();
        while (string5 != null) {
            String string6 = null;
            n = string5.indexOf(10);
            if (n != -1) {
                string6 = string5.substring(0, n);
                string5 = string5.substring(n + 1);
            } else {
                string6 = string5;
                string5 = null;
            }
            printWriter.println(string + "\t" + string6);
        }
        int n3 = 0;
        while (n3 < this.classes.length) {
            this.classes[n3].export(printWriter, string + "\t", bl);
            printWriter.println("");
            ++n3;
        }
        n = 0;
        while (n < this.methods.length) {
            if (!this.methods[n].export(printWriter, string + "\t", bl)) {
                bl2 = false;
            }
            printWriter.println("");
            ++n;
        }
        printWriter.println(string + "}");
        return bl2;
    }

    public String getClassPrefix() {
        return this.type == 1 ? CLASS_PREFIX : INTERFACE_PREFIX;
    }

    public int getDebugLevel() {
        return this.debugLevel;
    }

    public String getExtends() {
        return this.extend;
    }

    public String getFullName() {
        return this.parent.getName() + "." + this.name;
    }

    public String getImplements() {
        return this.implement;
    }

    public String[] getImports() {
        if (this.isInnerClass()) {
            return this.getParentClass().getImports();
        }
        return this.importlist;
    }

    public String getInterfaces() {
        String string = this.getImplements();
        if (string.equals("")) {
            return "";
        }
        return "implements " + string + " ";
    }

    public UndoableDocument getJavaDocAsDocument() {
        if (this.javadocDocument == null) {
            this.javadocDocument = new UndoableDocument();
            this.javadocDocument.setText(this.getJavaDocAsPlainText());
            this.javadocDocument.addDocumentListener(new DocumentListener(){

                private void gt() {
                    Class.this.javadoc = Class.this.javadocDocument.getText();
                    Class.this.changed = true;
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.gt();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.gt();
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    this.gt();
                }
            });
        }
        return this.javadocDocument;
    }

    public String getJavaDocAsPlainText() {
        return this.javadoc;
    }

    public Method getLastSelectedMethod() {
        if (this.lastMethod != null) {
            return this.lastMethod;
        }
        if (this.methods.length == 0) {
            return null;
        }
        return this.methods[0];
    }

    public LineResolver getLineResolver() {
        return this.lineResolver;
    }

    public String[] getMethodList() {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < this.methods.length) {
            if (!vector.contains(this.methods[n].getName())) {
                vector.addElement(this.methods[n].getName());
            }
            ++n;
        }
        String[] stringArray = new String[vector.size()];
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray[n2] = (String)vector.elementAt(n2);
            ++n2;
        }
        return stringArray;
    }

    public Method[] getMethods() {
        return this.methods;
    }

    public String getModifiers() {
        String string = "";
        if (this.isPublic()) {
            string = string + "public ";
        }
        if (this.isProtected()) {
            string = string + "protected ";
        }
        if (this.isPrivate()) {
            string = string + "private ";
        }
        if (this.isAbstract()) {
            string = string + "abstract ";
        }
        if (this.isFinal()) {
            string = string + "final ";
        }
        if (this.isStatic()) {
            string = string + "static ";
        }
        return string;
    }

    public String getName() {
        return this.name;
    }

    public boolean getNeedsCompilation() {
        return this.classFile.lastModified() < this.sourceFile.lastModified();
    }

    public Package getParent() {
        return this.parent;
    }

    public Class getParentClass() {
        return this.parentClass;
    }

    public ClassPrefsFrame getPrefsFrame() {
        if (this.prefsWindow == null) {
            this.prefsWindow = new ClassPrefsFrame(this);
        }
        return this.prefsWindow;
    }

    public String getSignature() {
        String string = this.getName();
        if (this.isInnerClass()) {
            string = string.substring(string.lastIndexOf(46) + 1);
        }
        return this.getModifiers() + (this.isClass() ? "class " : "interface ") + string + " " + this.getSuper() + this.getInterfaces();
    }

    public String getSourceFilename() {
        return this.parent.sourcesDir + File.separator + this.name + ".java";
    }

    public String getSuper() {
        String string = this.getExtends();
        if (string.equals("")) {
            return "";
        }
        return "extends " + string + " ";
    }

    public int getType() {
        return this.type;
    }

    public JavaDocument getVariablesAsJavaDocument() {
        if (this.variablesDocument == null) {
            this.variablesDocument = new JavaDocument();
            this.variablesDocument.setText(this.getVariablesAsPlainText());
            this.variablesDocument.addDocumentListener(new DocumentListener(){

                private void gt() {
                    Class.this.variables = Class.this.variablesDocument.getText();
                    Class.this.changed = true;
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.gt();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.gt();
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    this.gt();
                }
            });
        }
        return this.variablesDocument;
    }

    public String getVariablesAsPlainText() {
        return this.variables;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isChanged() {
        if (this.changed) {
            return true;
        }
        int n = 0;
        while (n < this.classes.length) {
            if (this.classes[n].isChanged()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isClass() {
        return this.type == 1;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public boolean isInnerClass() {
        return this.parentClass != null;
    }

    public boolean isInterface() {
        return this.type == 2;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    void load() {
        try {
            if (this.recoveryFile.exists() && JReqTools.showQuestion(Project.GRS("Class.RecoveryError", this.recoveryFile.toString(), this.saveFile.toString()))) {
                this.saveFile.delete();
                GUISystem.out.println("Renaming " + this.recoveryFile + " to " + this.saveFile);
                this.recoveryFile.renameTo(this.saveFile);
            } else {
                this.recoveryFile.delete();
            }
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.saveFile));
            this.type = Integer.parseInt(Project.readLine(bufferedReader, "Type"));
            this.isPublic = Boolean.valueOf(Project.readLine(bufferedReader, "IsPublic"));
            this.isProtected = Boolean.valueOf(Project.readLine(bufferedReader, "IsProtected"));
            this.isPrivate = Boolean.valueOf(Project.readLine(bufferedReader, "IsPrivate"));
            this.isAbstract = Boolean.valueOf(Project.readLine(bufferedReader, "IsAbstract"));
            this.isFinal = Boolean.valueOf(Project.readLine(bufferedReader, "IsFinal"));
            this.isStatic = Boolean.valueOf(Project.readLine(bufferedReader, "IsStatic"));
            this.extend = Project.readLine(bufferedReader, "Extends");
            this.implement = Project.readLine(bufferedReader, "Implements");
            this.importlist = StringArray.parseFromString(Project.readLine(bufferedReader, "ImportList"));
            this.variables = Project.readLine(bufferedReader, "Variables").replace('\u0000', '\n');
            this.javadoc = Project.readLine(bufferedReader, "JavaDoc").replace('\u0000', '\n');
            this.debugLevel = Integer.parseInt(Project.readLine(bufferedReader, "DebugLevel"));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                Method method = new Method(this, bufferedReader);
                this.add(method);
            }
            bufferedReader.close();
            this.changed = false;
        }
        catch (IOException iOException) {
            JReqTools.showException(iOException);
        }
    }

    public void markChanged() {
        this.changed = true;
        int n = 0;
        while (n < this.classes.length) {
            this.classes[n].markChanged();
            ++n;
        }
    }

    boolean needsSaveSource() {
        if (this.changed) {
            return true;
        }
        int n = 0;
        while (n < this.classes.length) {
            if (this.classes[n].needsSaveSource()) {
                return true;
            }
            ++n;
        }
        File file = this.sourceFile;
        Class clazz = this;
        while (clazz.isInnerClass()) {
            clazz = clazz.getParentClass();
            file = clazz.sourceFile;
        }
        return this.saveFile.lastModified() > file.lastModified();
    }

    public void refreshPrefsFrame() {
        if (this.prefsWindow != null) {
            this.prefsWindow.refresh();
        }
    }

    synchronized void save() {
        try {
            this.recoveryFile.delete();
            this.saveFile.renameTo(this.recoveryFile);
            PrintWriter printWriter = new PrintWriter(new FileWriter(this.saveFile));
            printWriter.println("# Class Data");
            printWriter.println("Type=" + this.getType());
            printWriter.println("IsPublic=" + this.isPublic);
            printWriter.println("IsProtected=" + this.isProtected);
            printWriter.println("IsPrivate=" + this.isPrivate);
            printWriter.println("IsAbstract=" + this.isAbstract);
            printWriter.println("IsFinal=" + this.isFinal);
            printWriter.println("IsStatic=" + this.isStatic);
            printWriter.println("Extends=" + this.extend);
            printWriter.println("Implements=" + this.implement);
            printWriter.println("ImportList=" + StringArray.toString(this.importlist));
            printWriter.println("Variables=" + this.getVariablesAsPlainText().replace('\n', '\u0000').replace('\r', '\u0000'));
            printWriter.println("JavaDoc=" + this.getJavaDocAsPlainText().replace('\n', '\u0000').replace('\r', '\u0000'));
            printWriter.println("DebugLevel=" + this.debugLevel);
            int n = 0;
            while (n < this.methods.length) {
                this.methods[n].saveTo(printWriter);
                ++n;
            }
            printWriter.close();
            this.backupFile.delete();
            this.recoveryFile.renameTo(this.backupFile);
            this.changed = false;
        }
        catch (IOException iOException) {
            JReqTools.showException(iOException);
            this.changed = true;
        }
    }

    public void saveChanges() {
        if (this.changed) {
            this.save();
        }
        int n = 0;
        while (n < this.classes.length) {
            this.classes[n].saveChanges();
            ++n;
        }
    }

    protected synchronized boolean saveSource() {
        if (!this.needsSaveSource()) {
            return false;
        }
        Jedi.getCompilerFrame().setMessage(Project.GRS("Class.Message3", this.getFullName()));
        this.lineResolver.reset();
        try {
            File file = new File(this.parent.sourcesDir, this.name + ".java");
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
            int n = 0;
            String string = this.parent.getName();
            ++n;
            printWriter.println("/*");
            ++n;
            printWriter.println(" * GENERATED BY JEDI: " + new Date());
            ++n;
            printWriter.println(" */");
            ++n;
            printWriter.println("");
            printWriter.println("package " + string + ";");
            this.lineResolver.add(++n, 1, this, -1);
            int n2 = 0;
            while (n2 < this.importlist.length) {
                printWriter.println("import " + this.importlist[n2] + ";");
                this.lineResolver.add(++n, 1, this, -2);
                ++n2;
            }
            n = this.saveSource(printWriter, n, this.lineResolver, "");
            printWriter.flush();
            printWriter.close();
        }
        catch (IOException iOException) {
            JReqTools.showException(Jedi.getEditor(), iOException);
        }
        return true;
    }

    private int saveSource(PrintWriter printWriter, int n, LineResolver lineResolver, String string) throws IOException {
        int n2;
        int n3;
        printWriter.println(string + this.getSignature() + "{");
        lineResolver.add(++n, 1, this, -3);
        if (!this.isInnerClass() && !this.isInterface()) {
            n3 = this.getDebugLevel();
            if (n3 == 0) {
                n3 = this.getParent().getDebugLevel();
            }
            switch (n3) {
                case 0: {
                    break;
                }
                case 1: {
                    printWriter.println("\tprivate static final boolean DEBUG = false;");
                    lineResolver.add(++n, 1, this, -3);
                    break;
                }
                case 2: {
                    printWriter.println("\tprivate static final boolean DEBUG = true;");
                    lineResolver.add(++n, 1, this, -3);
                    break;
                }
                case 3: {
                    printWriter.println("\tprivate static final boolean DEBUG = true;");
                    lineResolver.add(++n, 1, this, -3);
                }
            }
        }
        n3 = 0;
        String string2 = this.getVariablesAsPlainText();
        while (string2 != null) {
            String string3 = null;
            n2 = string2.indexOf(10);
            if (n2 != -1) {
                string3 = string2.substring(0, n2);
                string2 = string2.substring(n2 + 1);
            } else {
                string3 = string2;
                string2 = null;
            }
            printWriter.println(string + "\t" + string3);
            lineResolver.add(++n, 2, this, ++n3);
        }
        int n4 = 0;
        while (n4 < this.classes.length) {
            n = this.classes[n4].saveSource(printWriter, n, lineResolver, string + "\t");
            ++n;
            printWriter.println("");
            ++n4;
        }
        n2 = 0;
        while (n2 < this.methods.length) {
            n = this.methods[n2].saveSource(printWriter, n, lineResolver, string + "\t");
            ++n2;
        }
        printWriter.println(string + "}");
        return ++n;
    }

    public void setAbstract(boolean bl) {
        this.isAbstract = bl;
        this.changed = true;
    }

    public void setDataFrom(Class clazz) {
        Sorter.Comparable comparable;
        boolean bl = this.isInnerClass();
        this.setPublic(clazz.isPublic());
        this.setAbstract(clazz.isAbstract());
        this.setFinal(clazz.isFinal());
        this.setProtected(bl ? clazz.isProtected() : false);
        this.setPrivate(bl ? clazz.isPrivate() : false);
        this.setStatic(bl ? clazz.isStatic() : false);
        this.setExtends(clazz.getExtends());
        this.setImplements(clazz.getImplements());
        if (!bl) {
            this.setImports(clazz.getImports());
        }
        this.setJavaDoc(clazz.getJavaDocAsPlainText());
        this.setVariables(clazz.getVariablesAsPlainText());
        this.setDebugLevel(clazz.getDebugLevel());
        int n = 0;
        while (n < clazz.classes.length) {
            String string = clazz.classes[n].getName();
            comparable = this.addInnerClass(string.substring(string.lastIndexOf(46) + 1), clazz.classes[n].getType());
            ((Class)comparable).setDataFrom(clazz.classes[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < clazz.methods.length) {
            comparable = this.add(clazz.methods[n2].getName(), clazz.methods[n2].getType());
            ((Method)comparable).setDataFrom(clazz.methods[n2]);
            ++n2;
        }
    }

    public void setDebugLevel(int n) {
        if (this.debugLevel == n) {
            return;
        }
        this.markChanged();
        this.debugLevel = n;
        this.changed = true;
    }

    public void setExtends(String string) {
        this.extend = string;
        this.changed = true;
    }

    public void setFinal(boolean bl) {
        this.isFinal = bl;
        this.changed = true;
    }

    public void setImplements(String string) {
        this.implement = string;
        this.changed = true;
    }

    public void setImports(String[] stringArray) {
        if (!this.isInnerClass()) {
            this.importlist = stringArray;
            this.changed = true;
        } else {
            this.getParentClass().setImports(stringArray);
        }
    }

    public void setJavaDoc(String string) {
        this.javadoc = string;
        if (this.javadocDocument != null) {
            try {
                this.javadocDocument.remove(0, this.javadocDocument.getLength());
                ((AbstractDocument)this.javadocDocument).insertString(0, string, null);
            }
            catch (Throwable throwable) {
                GUISystem.err.println(throwable);
            }
        }
        this.changed = true;
    }

    public void setLastSelectedMethod(Method method) {
        this.lastMethod = method;
    }

    public void setPrivate(boolean bl) {
        this.isPrivate = bl;
        this.changed = true;
    }

    public void setProtected(boolean bl) {
        this.isProtected = bl;
        this.changed = true;
    }

    public void setPublic(boolean bl) {
        this.isPublic = bl;
        this.changed = true;
    }

    public void setStatic(boolean bl) {
        this.isStatic = bl;
        this.changed = true;
    }

    public void setVariables(String string) {
        this.variables = string;
        if (this.variablesDocument != null) {
            try {
                this.variablesDocument.remove(0, this.variablesDocument.getLength());
                ((AbstractDocument)this.variablesDocument).insertString(0, string, null);
            }
            catch (Throwable throwable) {
                GUISystem.err.println(throwable);
            }
        }
        this.changed = true;
    }

    public String toString() {
        return this.getName() + (this.isClass() ? " [Class]" : " [Interface]");
    }
}

