/*
 * Decompiled with CFR 0.152.
 */
package jedi.ds;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Modifier;
import java.util.StringTokenizer;
import javax.swing.Box;
import jedi.Jedi;
import jedi.JediClassLoader;
import jedi.JediUtils;
import jedi.ds.Class;
import jedi.ds.Method;
import jedi.ds.Project;
import jedi.prefs.JediPrefs;
import jreqtools.JReqTools;
import swing.addon.ComboBox;
import swing.addon.EditableListview;
import swing.addon.Frame;
import swing.addon.GUISystem;
import swing.addon.OkCancelButtons;
import swing.addon.PopupMenu;
import swing.addon.Prefs;
import swing.addon.Separator;
import swing.addon.Strut;
import swing.addon.TextField;
import swing.addon.ToggleButton;
import swing.addon.Utils;
import swing.addon.YFramePanel;
import swing.addon.util.StringArray;

public class ClassPrefsFrame
extends Frame
implements ActionListener {
    private static final boolean DEBUG = false;
    OkCancelButtons buttons = new OkCancelButtons();
    ToggleButton tb_public = new ToggleButton("public", false);
    ToggleButton tb_protected = new ToggleButton("proteced", false);
    ToggleButton tb_private = new ToggleButton("private", false);
    ToggleButton tb_final = new ToggleButton("final", false);
    ToggleButton tb_abstract = new ToggleButton("abstract", false);
    ToggleButton tb_static = new ToggleButton("static", false);
    ComboBox debuglevel = new ComboBox(new String[]{Project.GRS("ClassPrefsFrame.ComboBox.1"), Project.GRS("ClassPrefsFrame.ComboBox.2"), Project.GRS("ClassPrefsFrame.ComboBox.3"), Project.GRS("ClassPrefsFrame.ComboBox.4")});
    public TextField te_extends = new TextField("");
    public TextField te_implements = new TextField("");
    public EditableListview lv_import = new EditableListview();
    Class klasse = null;
    boolean isclass = false;

    public ClassPrefsFrame(Class clazz) {
        super(clazz.isClass() ? Project.GRS("ClassPrefsFrame.Title1", clazz.getFullName()) : Project.GRS("ClassPrefsFrame.Title2", clazz.getFullName()));
        this.klasse = clazz;
        this.isclass = this.klasse.isClass();
        this.te_extends.setAlignmentY(0.5f);
        this.te_implements.setAlignmentY(0.5f);
        this.lv_import.createPopupMenuFrom(StringArray.parseFromString(JediPrefs.getProperty("ContextMenu.Import")));
        this.debuglevel.setSelectedIndex(0);
        this.buttons.addHelpButton("prefs_class");
        this.createPopupMenuForImplementsClause(this.te_implements);
        this.tb_public.addActionListener(this);
        this.tb_protected.addActionListener(this);
        this.tb_private.addActionListener(this);
        this.tb_final.addActionListener(this);
        this.tb_static.addActionListener(this);
        this.tb_abstract.addActionListener(this);
        this.buttons.addActionListener(this);
        YFramePanel yFramePanel = new YFramePanel();
        yFramePanel.add(new Separator(Project.GRS("ClassPrefsFrame.Separator1")));
        Box box = Box.createHorizontalBox();
        Box box2 = Box.createHorizontalBox();
        if (this.klasse.isInnerClass()) {
            box2.add(this.tb_public);
            box2.add(this.tb_protected);
            box2.add(this.tb_private);
            yFramePanel.add(box2);
            box.add(this.tb_final);
            box.add(this.tb_static);
            box.add(this.tb_abstract);
        } else if (this.isclass) {
            box.add(this.tb_public);
            box.add(this.tb_final);
            box.add(this.tb_abstract);
        } else {
            box.add(this.tb_public);
        }
        yFramePanel.add(box);
        yFramePanel.add(new Strut());
        yFramePanel.add(new Separator(Project.GRS("ClassPrefsFrame.Separator2")));
        yFramePanel.add(this.te_extends);
        yFramePanel.add(new Strut());
        if (this.isclass) {
            yFramePanel.add(new Separator(Project.GRS("ClassPrefsFrame.Separator3")));
            yFramePanel.add(this.te_implements);
            yFramePanel.add(new Strut());
        }
        if (!clazz.isInnerClass()) {
            yFramePanel.add(new Separator(Project.GRS("ClassPrefsFrame.Separator4")));
            yFramePanel.add(this.lv_import);
            yFramePanel.add(new Strut());
            yFramePanel.add(new Separator(Project.GRS("ClassPrefsFrame.Separator5")));
            yFramePanel.add(this.debuglevel);
            yFramePanel.add(new Strut());
        }
        yFramePanel.add(Box.createVerticalGlue());
        yFramePanel.add(this.buttons);
        this.setContentPane(yFramePanel);
        this.pack();
        this.setValues();
        String string = ".";
        if (clazz.isInnerClass()) {
            string = string + "Inner";
        }
        string = string + (this.isclass ? ".Class" : ".Interface");
        Prefs.add("ClassPrefsWindow" + string, this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.tb_public) {
            if (this.tb_public.isSelected()) {
                this.tb_protected.setSelected(false);
            }
            this.tb_private.setSelected(false);
        } else if (object == this.tb_protected) {
            if (this.tb_protected.isSelected()) {
                this.tb_public.setSelected(false);
                this.tb_private.setSelected(false);
            }
        } else if (object == this.tb_private) {
            if (this.tb_private.isSelected()) {
                this.tb_protected.setSelected(false);
                this.tb_public.setSelected(false);
                this.tb_abstract.setSelected(false);
            }
        } else if (object == this.tb_static) {
            if (this.tb_static.isSelected()) {
                this.tb_abstract.setSelected(false);
            }
        } else if (object == this.tb_final) {
            if (this.tb_final.isSelected()) {
                this.tb_abstract.setSelected(false);
            }
        } else if (object == this.tb_abstract) {
            if (this.tb_abstract.isSelected()) {
                this.tb_private.setSelected(false);
                this.tb_static.setSelected(false);
                this.tb_final.setSelected(false);
            }
        } else if (object == this.buttons) {
            Prefs.snapshot();
            if (this.buttons.get() == 0) {
                this.ok();
            } else {
                this.setValues();
            }
            this.setVisible(false);
        } else {
            GUISystem.err.println(this.getClass().getName() + ".actionPerformed(): internal error");
        }
    }

    PopupMenu createPopupMenuForImplementsClause(final TextField textField) {
        PopupMenu popupMenu = Utils.createPopupMenu(textField, "Implements");
        Utils.addMenuItemsFrom(StringArray.parseFromString(JediPrefs.getProperty("ContextMenu.Implements")), null, null, popupMenu, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = textField.getText();
                String string2 = actionEvent.getActionCommand();
                int n = string2.lastIndexOf(".");
                String string3 = n > 0 ? string2.substring(n + 1) : string2;
                textField.setText(string.equals("") ? string3 : string + ", " + string3);
                ClassPrefsFrame.this.klasse.addImport(string2);
                ClassPrefsFrame.this.lv_import.set(ClassPrefsFrame.this.klasse.getImports());
            }
        });
        return popupMenu;
    }

    private void ok() {
        this.klasse.setAbstract(this.tb_abstract.isSelected());
        this.klasse.setFinal(this.tb_final.isSelected());
        this.klasse.setStatic(this.tb_static.isSelected());
        this.klasse.setPublic(this.tb_public.isSelected());
        this.klasse.setProtected(this.tb_protected.isSelected());
        this.klasse.setPrivate(this.tb_private.isSelected());
        this.klasse.setImplements(this.te_implements.getText());
        this.klasse.setExtends(this.te_extends.getText());
        if (!this.klasse.isInnerClass()) {
            this.klasse.setImports(this.lv_import.get());
            this.klasse.setDebugLevel(this.debuglevel.getSelectedIndex());
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.klasse.getImplements(), ", ");
        JediClassLoader jediClassLoader = new JediClassLoader();
        while (stringTokenizer.hasMoreTokens()) {
            Object[] objectArray;
            String string = stringTokenizer.nextToken();
            java.lang.Class<?> clazz = null;
            if (string.indexOf(".") != -1) {
                try {
                    clazz = jediClassLoader.loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            } else {
                objectArray = this.klasse.getImports();
                int n = 0;
                while (clazz == null && n < objectArray.length) {
                    try {
                        Object object = null;
                        if (((String)objectArray[n]).endsWith("." + string)) {
                            object = objectArray[n];
                        } else if (((String)objectArray[n]).endsWith(".*")) {
                            object = ((String)objectArray[n]).substring(0, ((String)objectArray[n]).length() - 2) + "." + string;
                        }
                        if (object != null) {
                            clazz = jediClassLoader.loadClass((String)object);
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    ++n;
                }
            }
            if (clazz == null) continue;
            objectArray = clazz.getDeclaredMethods();
            String[] stringArray = this.klasse.getMethodList();
            boolean bl = true;
            int n = 0;
            while (bl && n < objectArray.length) {
                if (StringArray.contains(stringArray, ((java.lang.reflect.Method)objectArray[n]).getName()) >= 0) {
                    bl = false;
                }
                ++n;
            }
            if (objectArray.length == 0) {
                bl = false;
            }
            if (!bl || !JReqTools.showQuestion(this, Project.GRS("ClassPrefsFrame.Question1", string))) continue;
            int n2 = 0;
            while (n2 < objectArray.length) {
                Object object = objectArray[n2];
                Method method = this.klasse.add(((java.lang.reflect.Method)object).getName(), 1);
                if (method != null) {
                    int n3 = ((java.lang.reflect.Method)object).getModifiers();
                    method.setPublic(Modifier.isPublic(n3));
                    method.setProtected(Modifier.isProtected(n3));
                    method.setPrivate(Modifier.isPrivate(n3));
                    method.setAbstract(false);
                    method.setFinal(Modifier.isFinal(n3));
                    method.setStatic(Modifier.isStatic(n3));
                    method.setNative(false);
                    method.setSynchronized(Modifier.isSynchronized(n3));
                    method.setResultType(((java.lang.reflect.Method)object).getReturnType().getName());
                    method.setParameters(JediUtils.convertClassArrayToArgumentString(((java.lang.reflect.Method)object).getParameterTypes(), true));
                    method.setThrows(JediUtils.convertClassArrayToArgumentString(((java.lang.reflect.Method)object).getExceptionTypes(), false));
                    Jedi.getEditor().refreshMethod(method);
                } else {
                    JReqTools.showError(this, Project.GRS("ClassPrefsFrame.Error1"));
                }
                ++n2;
            }
        }
        Jedi.getEditor().classModified(this.klasse);
    }

    public void refresh() {
        this.setValues();
    }

    private void setValues() {
        this.tb_abstract.setSelected(this.klasse.isAbstract());
        this.tb_final.setSelected(this.klasse.isFinal());
        this.tb_static.setSelected(this.klasse.isStatic());
        this.tb_public.setSelected(this.klasse.isPublic());
        this.tb_protected.setSelected(this.klasse.isProtected());
        this.tb_private.setSelected(this.klasse.isPrivate());
        this.te_implements.setText(this.klasse.getImplements());
        this.te_extends.setText(this.klasse.getExtends());
        this.lv_import.set(this.klasse.getImports());
        this.debuglevel.setSelectedIndex(this.klasse.getDebugLevel());
    }
}

