/*
 * Decompiled with CFR 0.152.
 */
package jedi.ds;

import java.io.BufferedReader;
import java.io.PrintWriter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import jedi.ds.Class;
import jedi.ds.LineResolver;
import jedi.ds.MethodPrefsFrame;
import jedi.ds.Project;
import jreqtools.JReqTools;
import swing.addon.GUISystem;
import swing.addon.text.JavaDocument;
import swing.addon.text.UndoableDocument;
import swing.addon.util.Sorter;
import swing.addon.util.StringArray;

public class Method
implements DocumentListener,
Sorter.Comparable {
    private static final boolean DEBUG = false;
    public static final int METHOD = 1;
    public static final int CONSTRUCTOR = 2;
    public static final int STATIC_INITIALIZER = 3;
    int type = 1;
    boolean isPublic = true;
    boolean isProtected = false;
    boolean isPrivate = false;
    boolean isAbstract = false;
    boolean isFinal = false;
    boolean isStatic = false;
    boolean isNative = false;
    boolean isSynchronized = false;
    String resultType = "void";
    String[] parameters = new String[0];
    String[] throwslist = new String[0];
    String text = "";
    String javadoc = "";
    String name = "";
    JavaDocument bodyDocument = null;
    UndoableDocument javadocDocument = null;
    Class parent = null;
    MethodPrefsFrame prefsWindow = null;

    public Method(Class clazz, BufferedReader bufferedReader) {
        this.parent = clazz;
        this.name = Project.readLine(bufferedReader, "Name");
        this.type = Integer.parseInt(Project.readLine(bufferedReader, "Type"));
        this.isPublic = Boolean.valueOf(Project.readLine(bufferedReader, "IsPublic"));
        this.isProtected = Boolean.valueOf(Project.readLine(bufferedReader, "IsProtected"));
        this.isPrivate = Boolean.valueOf(Project.readLine(bufferedReader, "IsPrivate"));
        this.isAbstract = Boolean.valueOf(Project.readLine(bufferedReader, "IsAbstract"));
        this.isFinal = Boolean.valueOf(Project.readLine(bufferedReader, "IsFinal"));
        this.isStatic = Boolean.valueOf(Project.readLine(bufferedReader, "IsStatic"));
        this.isSynchronized = Boolean.valueOf(Project.readLine(bufferedReader, "IsSynchronized"));
        this.isNative = Boolean.valueOf(Project.readLine(bufferedReader, "IsNative"));
        this.resultType = Project.readLine(bufferedReader, "ResultType");
        this.parameters = StringArray.parseFromString(Project.readLine(bufferedReader, "Parameters"));
        this.throwslist = StringArray.parseFromString(Project.readLine(bufferedReader, "Throws"));
        this.text = Project.readLine(bufferedReader, "Text").replace('\u0000', '\n');
        this.javadoc = Project.readLine(bufferedReader, "JavaDoc").replace('\u0000', '\n');
    }

    public Method(Class clazz, String string, int n) {
        this.parent = clazz;
        this.type = n;
        this.name = string;
        if (string.equals("main")) {
            this.setPublic(true);
            this.setStatic(true);
            this.setResultType("void");
            this.setParameters(new String[]{"String [] args"});
        } else if (string.equals("toString")) {
            this.setPublic(true);
            this.setResultType("String");
            this.setText("return getClass().getName();\n");
        } else if (string.equals("finalize")) {
            this.setPublic(false);
            this.setProtected(true);
            this.setResultType("void");
            this.setThrows(new String[]{"Throwable"});
            this.setText("super.finalize();\n");
        } else if (string.equals("clone")) {
            this.setPublic(false);
            this.setProtected(true);
            this.setResultType("Object");
            this.setThrows(new String[]{"CloneNotSupportedException"});
            this.setText("return super.clone();\n");
        } else if (string.equals("equals")) {
            this.setPublic(true);
            this.setResultType("boolean");
            this.setParameters(new String[]{"Object obj"});
            this.setText("return super.equals(obj);\n");
        } else if (string.equals("hashCode")) {
            this.setPublic(true);
            this.setResultType("int");
            this.setText("return super.hashCode();\n");
        } else if (string.equals("classFinalize")) {
            this.setPublic(false);
            this.setProtected(false);
            this.setPrivate(false);
            this.setStatic(true);
            this.setResultType("void");
            this.setThrows(new String[]{"Throwable"});
        }
        if (n == 3) {
            this.setPublic(false);
        }
    }

    public void addParameter(String string) {
        String[] stringArray = this.getParameters();
        if (StringArray.contains(stringArray, string) != -1) {
            return;
        }
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length] = string;
        this.setParameters(stringArray2);
    }

    public void appendBodyText(String string) {
        String string2 = this.getBodyAsPlainText();
        if (string2.length() > 0 && !string2.endsWith("\n")) {
            string2 = string2 + "\n";
        }
        string2 = string2 + string;
        this.setText(string2);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.parent.changed = true;
    }

    public void cleanUp() {
        if (this.prefsWindow != null) {
            this.prefsWindow.setVisible(false);
        }
    }

    public int compareTo(Object object) {
        Method method = (Method)object;
        int n = this.name.compareTo(method.name);
        if (n != 0) {
            return n;
        }
        return this.parameters.length - method.parameters.length;
    }

    public MethodPrefsFrame editPrefs() {
        if (this.isStaticInitializer()) {
            return null;
        }
        if (this.prefsWindow == null) {
            this.prefsWindow = new MethodPrefsFrame(this);
        }
        this.prefsWindow.setVisible(true);
        return this.prefsWindow;
    }

    public synchronized boolean export(PrintWriter printWriter, boolean bl) {
        return this.export(printWriter, "", bl);
    }

    public synchronized boolean export(PrintWriter printWriter, String string, boolean bl) {
        String string2;
        String string3 = this.parent.getParent().getName();
        String string4 = this.parent.getName() + " " + this.parent.getType();
        String string5 = string2 = bl ? this.getJavaDocAsPlainText() : "";
        if (!string2.trim().equals("")) {
            printWriter.println(string + "/**");
            while (string2 != null) {
                String string6 = null;
                int n = string2.indexOf(10);
                if (n != -1) {
                    string6 = string2.substring(0, n);
                    string2 = string2.substring(n + 1);
                    printWriter.println(string + "* " + string6);
                    continue;
                }
                string6 = string2;
                string2 = null;
                if (string6.equals("")) continue;
                printWriter.println(string + "* " + string6);
            }
            printWriter.println(string + "*/\n");
        }
        printWriter.println(string + this.getSignature() + (this.parent.isInterface() || this.isNative() || this.isAbstract() ? ";" : " {"));
        if (this.parent.isInterface() || this.isNative() || this.isAbstract()) {
            return true;
        }
        try {
            int n = this.getParent().getDebugLevel();
            if (n == 0) {
                n = this.getParent().getParent().getDebugLevel();
            }
            if (this.isConstructor() || this.isStaticInitializer()) {
                n = 0;
            }
            if (this.getName().equals("toString") && this.getParameters().length == 0) {
                n = 0;
            }
            if (n == 3) {
                printWriter.println(string + "\tSystem.out.println(\"---\\n" + this.getFullName() + this.makeParameters() + "\");");
                String[] stringArray = this.getParameters();
                if (stringArray.length > 0) {
                    printWriter.print(string + "\tSystem.out.println(\"\\t");
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        printWriter.print(stringArray[n2].substring(stringArray[n2].lastIndexOf(32) + 1) + " = \" + " + stringArray[n2].substring(stringArray[n2].lastIndexOf(32) + 1) + "  + \" (instanceof " + Method.getInstanceOf(stringArray[n2]) + ")\"");
                        if (n2 + 1 < stringArray.length) {
                            printWriter.print(" + \"\\n\t");
                        }
                        ++n2;
                    }
                    printWriter.println(");\n");
                }
            }
        }
        catch (Throwable throwable) {
            JReqTools.showException(throwable);
        }
        boolean bl2 = false;
        String string7 = this.getBodyAsPlainText();
        while (string7 != null) {
            String string8 = null;
            int n = string7.indexOf(10);
            if (n != -1) {
                string8 = string7.substring(0, n);
                string7 = string7.substring(n + 1);
                printWriter.println(string + "\t" + string8);
                continue;
            }
            string8 = string7;
            string7 = null;
            if (string8.equals("")) continue;
            printWriter.println(string + "\t" + string8);
        }
        printWriter.println(string + "}");
        return true;
    }

    public JavaDocument getBodyAsJavaDocument() {
        if (this.bodyDocument == null) {
            this.bodyDocument = new JavaDocument();
            this.bodyDocument.setText(this.text);
            this.bodyDocument.addDocumentListener(this);
        }
        return this.bodyDocument;
    }

    public String getBodyAsPlainText() {
        return this.bodyDocument == null ? this.text : this.bodyDocument.getText();
    }

    public String getFullName() {
        return this.parent.getFullName() + "." + this.getName();
    }

    private static final String getInstanceOf(String string) {
        String string2 = string.substring(0, string.indexOf(32));
        if (string2.equals("int")) {
            return "int";
        }
        if (string2.equals("boolean")) {
            return "boolean";
        }
        if (string2.equals("byte")) {
            return "byte";
        }
        if (string2.equals("char ")) {
            return "char";
        }
        if (string2.equals("double")) {
            return "double";
        }
        if (string2.equals("float")) {
            return "float";
        }
        if (string2.equals("long ")) {
            return "long";
        }
        if (string2.equals("short")) {
            return "short";
        }
        return "\" + ((" + string.substring(string.lastIndexOf(32) + 1) + " == null) ? \"null\" : " + string.substring(string.lastIndexOf(32) + 1) + ".getClass().getName()) + \"";
    }

    public UndoableDocument getJavaDocAsDocument() {
        if (this.javadocDocument == null) {
            this.javadocDocument = new UndoableDocument();
            this.javadocDocument.setText(this.javadoc);
            this.javadocDocument.addDocumentListener(this);
        }
        return this.javadocDocument;
    }

    public String getJavaDocAsPlainText() {
        return this.javadocDocument == null ? this.javadoc : this.javadocDocument.getText();
    }

    public String getName() {
        return this.name;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public Class getParent() {
        return this.parent;
    }

    public MethodPrefsFrame getPrefsFrame() {
        if (this.isStaticInitializer()) {
            return null;
        }
        if (this.prefsWindow == null) {
            this.prefsWindow = new MethodPrefsFrame(this);
        }
        return this.prefsWindow;
    }

    public String getResultType() {
        return this.resultType;
    }

    public String getSignature() {
        if (this.isMethod()) {
            return this.makeModifiers() + this.getResultType() + " " + this.getName() + this.makeParameters() + this.makeThrows();
        }
        if (this.isConstructor()) {
            String string = this.parent.getName();
            if (this.parent.isInnerClass()) {
                string = string.substring(string.lastIndexOf(46) + 1);
            }
            return this.makeModifiers() + string + this.makeParameters() + this.makeThrows();
        }
        return "static";
    }

    public String[] getThrows() {
        return this.throwslist;
    }

    public int getType() {
        return this.type;
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.parent.changed = true;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isConstructor() {
        return this.getType() == 2;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public boolean isMethod() {
        return this.getType() == 1;
    }

    public boolean isNative() {
        return this.isNative;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isStaticInitializer() {
        return this.getType() == 3;
    }

    public boolean isSynchronized() {
        return this.isSynchronized;
    }

    private String makeModifiers() {
        String string = "";
        if (this.isPublic()) {
            string = string + "public ";
        } else if (this.isProtected()) {
            string = string + "protected ";
        } else if (this.isPrivate()) {
            string = string + "private ";
        }
        if (!this.isAbstract()) {
            if (this.isStatic()) {
                string = string + "static ";
            }
            if (this.isFinal()) {
                string = string + "final ";
            }
            if (this.isSynchronized()) {
                string = string + "synchronized ";
            }
            if (this.isNative()) {
                string = string + "native ";
            }
        } else {
            string = string + "abstract ";
        }
        return string;
    }

    private String makeParameters() {
        String string = "(";
        String[] stringArray = this.getParameters();
        if (stringArray.length == 0) {
            return "() ";
        }
        int n = 0;
        while (n < stringArray.length) {
            string = string + stringArray[n];
            if (n + 1 < stringArray.length) {
                string = string + ", ";
            }
            ++n;
        }
        string = string + ") ";
        return string;
    }

    private String makeThrows() {
        String string = "throws ";
        String[] stringArray = this.getThrows();
        if (stringArray.length == 0) {
            return "";
        }
        int n = 0;
        while (n < stringArray.length) {
            string = string + stringArray[n];
            if (n + 1 < stringArray.length) {
                string = string + ", ";
            }
            ++n;
        }
        return string;
    }

    public void refreshPrefsFrame() {
        if (this.prefsWindow != null) {
            this.prefsWindow.refresh();
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.parent.changed = true;
    }

    public synchronized int saveSource(PrintWriter printWriter, int n, LineResolver lineResolver, String string) {
        String[] stringArray;
        String string2 = this.parent.getParent().getName();
        String string3 = this.parent.getName() + " " + this.parent.getType();
        printWriter.println(string + this.getSignature() + (this.parent.isInterface() || this.isNative() || this.isAbstract() ? ";" : " {"));
        lineResolver.add(++n, 3, this, -1);
        if (this.parent.isInterface() || this.isNative() || this.isAbstract()) {
            return n;
        }
        try {
            int n2 = this.getParent().getDebugLevel();
            if (n2 == 0) {
                n2 = this.getParent().getParent().getDebugLevel();
            }
            if (this.isConstructor() || this.isStaticInitializer()) {
                n2 = 0;
            }
            if (this.getName().equals("toString") && this.getParameters().length == 0) {
                n2 = 0;
            }
            if (n2 == 3) {
                printWriter.println(string + "System.out.println(\"---\\n" + this.getFullName() + this.makeParameters() + "\");");
                lineResolver.add(++n, 1, this, -3);
                stringArray = this.getParameters();
                if (stringArray.length > 0) {
                    ++n;
                    printWriter.print(string + "System.out.println(\"\\t");
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        printWriter.print(stringArray[n3].substring(stringArray[n3].lastIndexOf(32) + 1) + " = \" + " + stringArray[n3].substring(stringArray[n3].lastIndexOf(32) + 1) + "  + \" (instanceof " + Method.getInstanceOf(stringArray[n3]) + ")\"");
                        if (n3 + 1 < stringArray.length) {
                            printWriter.print(" + \"\\n\t");
                        }
                        ++n3;
                    }
                    printWriter.println(");");
                    lineResolver.add(n, 1, this, -3);
                }
            }
        }
        catch (Throwable throwable) {
            JReqTools.showException(throwable);
        }
        int n4 = 0;
        stringArray = this.getBodyAsPlainText();
        while (stringArray != null) {
            String[] stringArray2 = null;
            int n5 = stringArray.indexOf(10);
            if (n5 != -1) {
                stringArray2 = stringArray.substring(0, n5);
                stringArray = stringArray.substring(n5 + 1);
            } else {
                stringArray2 = stringArray;
                stringArray = null;
            }
            printWriter.println(string + (String)stringArray2);
            lineResolver.add(++n, 4, this, ++n4);
        }
        printWriter.println(string + "}");
        return ++n;
    }

    void saveTo(PrintWriter printWriter) {
        printWriter.println("# Method");
        printWriter.println("Name=" + this.name);
        printWriter.println("Type=" + this.type);
        printWriter.println("IsPublic=" + this.isPublic);
        printWriter.println("IsProtected=" + this.isProtected);
        printWriter.println("IsPrivate=" + this.isPrivate);
        printWriter.println("IsAbstract=" + this.isAbstract);
        printWriter.println("IsFinal=" + this.isFinal);
        printWriter.println("IsStatic=" + this.isStatic);
        printWriter.println("IsSynchronized=" + this.isSynchronized);
        printWriter.println("IsNative=" + this.isNative);
        printWriter.println("ResultType=" + this.resultType);
        printWriter.println("Parameters=" + StringArray.toString(this.parameters));
        printWriter.println("Throws=" + StringArray.toString(this.throwslist));
        printWriter.println("Text=" + this.getBodyAsPlainText().replace('\n', '\u0000').replace('\r', '\u0000'));
        printWriter.println("JavaDoc=" + this.getJavaDocAsPlainText().replace('\n', '\u0000').replace('\r', '\u0000'));
    }

    public void setAbstract(boolean bl) {
        this.isAbstract = bl;
        this.parent.changed = true;
    }

    public void setDataFrom(Method method) {
        this.setAbstract(method.isAbstract());
        this.setFinal(method.isFinal());
        this.setJavaDoc(method.getJavaDocAsPlainText());
        this.setNative(method.isNative());
        this.setParameters(method.getParameters());
        this.setPrivate(method.isPrivate());
        this.setProtected(method.isProtected());
        this.setPublic(method.isPublic());
        this.setResultType(method.getResultType());
        this.setStatic(method.isStatic());
        this.setSynchronized(method.isSynchronized());
        this.setText(method.getBodyAsPlainText());
        this.setThrows(method.getThrows());
    }

    public void setFinal(boolean bl) {
        this.isFinal = bl;
        this.parent.changed = true;
    }

    public void setJavaDoc(String string) {
        this.javadoc = string;
        this.parent.changed = true;
        if (this.javadocDocument != null) {
            try {
                this.javadocDocument.remove(0, this.javadocDocument.getLength());
                ((AbstractDocument)this.javadocDocument).insertString(0, string, null);
            }
            catch (BadLocationException badLocationException) {
                GUISystem.err.println(badLocationException);
            }
        }
    }

    public void setNative(boolean bl) {
        this.isNative = bl;
        this.parent.changed = true;
    }

    public void setParameters(String[] stringArray) {
        this.parameters = stringArray;
        this.parent.changed = true;
    }

    public void setPrivate(boolean bl) {
        this.isPrivate = bl;
        this.parent.changed = true;
    }

    public void setProtected(boolean bl) {
        this.isProtected = bl;
        this.parent.changed = true;
    }

    public void setPublic(boolean bl) {
        this.isPublic = bl;
        this.parent.changed = true;
    }

    public void setResultType(String string) {
        this.resultType = string;
        this.parent.changed = true;
    }

    public void setStatic(boolean bl) {
        this.isStatic = bl;
        this.parent.changed = true;
    }

    public void setSynchronized(boolean bl) {
        this.isSynchronized = bl;
        this.parent.changed = true;
    }

    public void setText(String string) {
        this.text = string;
        this.parent.changed = true;
        if (this.bodyDocument != null) {
            try {
                this.bodyDocument.remove(0, this.bodyDocument.getLength());
                ((AbstractDocument)this.bodyDocument).insertString(0, string, null);
            }
            catch (BadLocationException badLocationException) {
                GUISystem.err.println(badLocationException);
            }
        }
    }

    public void setThrows(String[] stringArray) {
        this.throwslist = stringArray;
        this.parent.changed = true;
    }

    public String toString() {
        return this.getName();
    }
}

