/*
 * Decompiled with CFR 0.152.
 */
package jedi.ds;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import jedi.Jedi;
import jedi.ds.Method;
import jedi.ds.Project;
import jedi.prefs.JediPrefs;
import swing.addon.EditableListview;
import swing.addon.Frame;
import swing.addon.GUISystem;
import swing.addon.OkCancelButtons;
import swing.addon.PopupMenu;
import swing.addon.Prefs;
import swing.addon.Separator;
import swing.addon.Strut;
import swing.addon.TextField;
import swing.addon.ToggleButton;
import swing.addon.Utils;
import swing.addon.YFramePanel;
import swing.addon.util.StringArray;

public class MethodPrefsFrame
extends Frame
implements ActionListener {
    private static final boolean DEBUG = false;
    OkCancelButtons buttons = new OkCancelButtons();
    ToggleButton tb_public = new ToggleButton("public", true);
    ToggleButton tb_protected = new ToggleButton("protected", false);
    ToggleButton tb_private = new ToggleButton("private", false);
    ToggleButton tb_static = new ToggleButton("static", false);
    ToggleButton tb_final = new ToggleButton("final", false);
    ToggleButton tb_abstract = new ToggleButton("abstract", false);
    ToggleButton tb_native = new ToggleButton("native", false);
    ToggleButton tb_synchronized = new ToggleButton("synchronized", false);
    public TextField te_result = new TextField("");
    public EditableListview lv_parameters = new EditableListview();
    public EditableListview lv_throws = new EditableListview();
    Method currentMethod = null;

    public MethodPrefsFrame(Method method) {
        super(Project.GRS("MethodPrefsFrame.Title", (method.isMethod() ? method.getFullName() : method.getParent().getFullName() + "." + method.getParent().getName()) + "()"));
        this.currentMethod = method;
        this.buttons.addHelpButton("prefs_method");
        this.tb_public.addActionListener(this);
        this.tb_protected.addActionListener(this);
        this.tb_private.addActionListener(this);
        this.tb_abstract.addActionListener(this);
        this.tb_static.addActionListener(this);
        this.tb_final.addActionListener(this);
        this.tb_native.addActionListener(this);
        this.tb_synchronized.addActionListener(this);
        this.buttons.addActionListener(this);
        MethodPrefsFrame.createPopupMenuForResultType(this.te_result);
        this.lv_parameters.createPopupMenuFrom(StringArray.parseFromString(JediPrefs.getProperty("ContextMenu.Parameters")));
        this.lv_throws.createPopupMenuFrom(StringArray.parseFromString(JediPrefs.getProperty("ContextMenu.Throws")));
        YFramePanel yFramePanel = new YFramePanel();
        yFramePanel.add(new Separator(Project.GRS("MethodPrefsFrame.Separator1")));
        Box box = Box.createHorizontalBox();
        if (method.getParent().isClass()) {
            box.add(this.tb_public);
            box.add(new Strut());
            box.add(this.tb_protected);
            box.add(new Strut());
            box.add(this.tb_private);
        } else {
            box.add(new Strut());
            box.add(this.tb_public);
            box.add(new Strut());
            box.add(this.tb_abstract);
        }
        yFramePanel.add(box);
        yFramePanel.add(new Strut());
        if (method.isMethod() && method.getParent().isClass()) {
            box.add(new Strut());
            box.add(this.tb_abstract);
            Box box2 = Box.createHorizontalBox();
            box2.add(this.tb_static);
            box2.add(new Strut());
            box2.add(this.tb_final);
            box2.add(new Strut());
            box2.add(this.tb_native);
            box2.add(new Strut());
            box2.add(this.tb_synchronized);
            yFramePanel.add(box2);
            yFramePanel.add(new Strut());
        }
        if (method.isMethod()) {
            yFramePanel.add(new Separator(Project.GRS("MethodPrefsFrame.Separator2")));
            yFramePanel.add(this.te_result);
            yFramePanel.add(new Strut());
        }
        yFramePanel.add(new Separator(Project.GRS("MethodPrefsFrame.Separator3")));
        yFramePanel.add(this.lv_parameters);
        yFramePanel.add(new Strut());
        yFramePanel.add(new Separator(Project.GRS("MethodPrefsFrame.Separator4")));
        yFramePanel.add(this.lv_throws);
        yFramePanel.add(new Strut());
        yFramePanel.add(this.buttons);
        this.setContentPane(yFramePanel);
        this.pack();
        this.setValues();
        Prefs.add("MethodPrefsWindow", this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.tb_public) {
            if (this.tb_public.isSelected()) {
                this.tb_protected.setSelected(false);
                this.tb_private.setSelected(false);
            }
        } else if (object == this.tb_protected) {
            if (this.tb_protected.isSelected()) {
                this.tb_public.setSelected(false);
                this.tb_private.setSelected(false);
            }
        } else if (object == this.tb_private) {
            if (this.tb_private.isSelected()) {
                this.tb_protected.setSelected(false);
                this.tb_public.setSelected(false);
                this.tb_abstract.setSelected(false);
            }
        } else if (object == this.tb_static) {
            if (this.tb_static.isSelected()) {
                this.tb_abstract.setSelected(false);
            }
        } else if (object == this.tb_final) {
            if (this.tb_final.isSelected()) {
                this.tb_abstract.setSelected(false);
            }
        } else if (object == this.tb_abstract) {
            if (this.tb_abstract.isSelected()) {
                this.tb_private.setSelected(false);
                this.tb_static.setSelected(false);
                this.tb_final.setSelected(false);
                this.tb_native.setSelected(false);
                this.tb_synchronized.setSelected(false);
            }
        } else if (object == this.tb_native) {
            if (this.tb_native.isSelected()) {
                this.tb_abstract.setSelected(false);
            }
        } else if (object == this.tb_synchronized) {
            if (this.tb_synchronized.isSelected()) {
                this.tb_abstract.setSelected(false);
            }
        } else if (object == this.buttons) {
            Prefs.snapshot();
            if (this.buttons.get() == 0) {
                this.ok();
            } else {
                this.setValues();
            }
            this.setVisible(false);
        } else {
            GUISystem.err.println(this.getClass().getName() + ".actionPerformed(): internal error");
        }
    }

    static PopupMenu createPopupMenuForResultType(final TextField textField) {
        PopupMenu popupMenu = Utils.createPopupMenu(textField, "Result Type");
        Utils.addMenuItemsFrom(StringArray.parseFromString(JediPrefs.getProperty("ContextMenu.ResultType")), null, null, popupMenu, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                textField.setText(actionEvent.getActionCommand());
            }
        });
        return popupMenu;
    }

    private void ok() {
        this.currentMethod.setPublic(this.tb_public.isSelected());
        this.currentMethod.setProtected(this.tb_protected.isSelected());
        this.currentMethod.setPrivate(this.tb_private.isSelected());
        this.currentMethod.setAbstract(this.tb_abstract.isSelected());
        this.currentMethod.setStatic(this.tb_static.isSelected());
        this.currentMethod.setFinal(this.tb_final.isSelected());
        this.currentMethod.setNative(this.tb_native.isSelected());
        this.currentMethod.setSynchronized(this.tb_synchronized.isSelected());
        String string = this.te_result.getText();
        if (string.equals("")) {
            string = "void";
        }
        this.currentMethod.setResultType(string);
        this.currentMethod.setParameters(this.lv_parameters.get());
        this.currentMethod.setThrows(this.lv_throws.get());
        Jedi.getEditor().methodModified(this.currentMethod);
    }

    public void refresh() {
        this.setValues();
    }

    public void set(Method method) {
        this.currentMethod = method;
        this.setValues();
    }

    private void setValues() {
        this.tb_public.setSelected(this.currentMethod.isPublic());
        this.tb_protected.setSelected(this.currentMethod.isProtected());
        this.tb_private.setSelected(this.currentMethod.isPrivate());
        this.tb_abstract.setSelected(this.currentMethod.isAbstract());
        this.tb_static.setSelected(this.currentMethod.isStatic());
        this.tb_final.setSelected(this.currentMethod.isFinal());
        this.tb_native.setSelected(this.currentMethod.isNative());
        this.tb_synchronized.setSelected(this.currentMethod.isSynchronized());
        this.te_result.setText(this.currentMethod.getResultType());
        this.lv_parameters.set(this.currentMethod.getParameters());
        this.lv_throws.set(this.currentMethod.getThrows());
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.te_result.requestFocus();
        }
    }
}

