/*
 * Decompiled with CFR 0.152.
 */
package jedi.ds;

import javax.swing.text.StyledEditorKit;
import jedi.ds.Method;
import jedi.parser.ASTCompilationUnit;
import jedi.parser.JavaParser;
import jedi.parser.ParseException;
import swing.addon.GUISystem;
import swing.addon.util.StringInputStream;

class MethodSyntaxChecker
extends Thread {
    private static final boolean DEBUG = false;
    boolean running = true;
    Method method = null;
    StyledEditorKit kit;

    public MethodSyntaxChecker() {
        super("Jedi Method Syntax Checker");
        this.setPriority(1);
        this.setDaemon(true);
    }

    synchronized void checkSyntax() {
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            System.out.println(interruptedException);
        }
        Method method = this.method;
        String string = this.method.parent.getSignature() + " { " + this.method.getSignature() + " {\n" + this.method.bodyDocument.getText() + "\n} }";
        try {
            StringInputStream stringInputStream = new StringInputStream(string);
            JavaParser javaParser = new JavaParser(stringInputStream);
            ASTCompilationUnit aSTCompilationUnit = javaParser.CompilationUnit();
            stringInputStream.close();
        }
        catch (ParseException parseException) {
            int n = parseException.currentToken.next.beginLine - 1;
            int n2 = parseException.currentToken.next.beginColumn;
        }
        catch (Exception exception) {
            GUISystem.err.println(exception);
        }
        this.method = null;
    }

    public void run() {
        System.out.println("Starting Method Syntax Checker Thread");
        while (this.running) {
            this.checkSyntax();
        }
    }

    public synchronized void setMethod(Method method) {
        this.method = method;
        this.notify();
    }
}

