/*
 * Decompiled with CFR 0.152.
 */
package jedi.ds;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jedi.Jedi;
import jedi.ds.Class;
import jedi.ds.MessageReceiver;
import jedi.ds.PackagePrefsFrame;
import jedi.ds.Project;
import jedi.ds.ProjectSaver;
import jreqtools.JReqTools;
import swing.addon.GUISystem;
import swing.addon.text.UndoableDocument;
import swing.addon.util.FileUtils;
import swing.addon.util.Sorter;
import swing.addon.util.StringArray;

public class Package
implements DocumentListener,
Sorter.Comparable {
    private static final boolean DEBUG = false;
    protected static final String PROPERTIESFILENAME = "Package-Properties";
    protected File classDir;
    protected File sourcesDir;
    String name = "";
    boolean changed = false;
    boolean saveResource = true;
    boolean saveIcons = true;
    boolean loaded = false;
    Class[] classes = new Class[0];
    Class lastClass = null;
    Properties properties = null;
    PackagePrefsFrame prefsWindow = null;
    UndoableDocument[] resourceDocument = new UndoableDocument[Package.getSupportedLocales().length];
    private static final String[] locales = new String[]{"default", "de", "en", "es", "fr", "it", "ja", "nl", "no", "pt", "ar_EG", "be_BY", "bg_BG", "ca_ES", "cs_CZ", "da_DK", "de_AT", "de_AT_EURO", "de_CH", "de_DE", "de_DE_EURO", "de_LU", "de_LU_EURO", "el_GR", "en_AU", "en_CA", "en_GB", "en_IE", "en_IE_EURO", "en_NZ", "en_US", "en_ZA", "es_AR", "es_BO", "es_CL", "es_CO", "es_CR", "es_DO", "es_EC", "es_ES", "es_ES_EURO", "es_GT", "es_HN", "es_MX", "es_NI", "es_PA", "es_PE", "es_PR", "es_PY", "es_SV", "es_UY", "es_VE", "et_EE", "fi_FI", "fi_FI_EURO", "fr_BE", "fr_BE_EURO", "fr_CA", "fr_CH", "fr_FR", "fr_FR_EURO", "fr_LU", "fr_LU_EURO", "hr_HR", "hu_HU", "is_IS", "it_CH", "it_IT", "it_IT_EURO", "iw_IL", "ja_JP", "ko_KR", "lt_LT", "lv_LV", "mk_MK", "nl_BE", "nl_BE_EURO", "nl_NL", "nl_NL_EURO", "no_NO_B", "no_NO_NY", "pl_PL", "pt_BR", "pt_PT", "pt_PT_EURO", "ro_RO", "ru_RU", "sh_YU", "sk_SK", "sl_SI", "sq_AL", "sr_YU", "sv_SE", "th_TH", "tr_TR", "uk_UA", "zh_CN", "zh_TW"};

    public Package(String string) {
        this(string, null);
    }

    public Package(String string, MessageReceiver messageReceiver) {
        this.classDir = new File(Project.packageDir, string);
        this.classDir.mkdirs();
        this.sourcesDir = new File(Project.sourcesDir, string.replace('.', File.separatorChar));
        this.sourcesDir.mkdirs();
        this.name = string;
        this.changed = false;
        this.loadProperties();
        this.load(messageReceiver);
    }

    public Class add(String string, int n) {
        Class clazz = this.get(string);
        if (clazz != null) {
            return clazz;
        }
        clazz = new Class(this, string, n);
        Sorter.Comparable[] comparableArray = new Class[this.classes.length + 1];
        System.arraycopy(this.classes, 0, comparableArray, 0, this.classes.length);
        comparableArray[this.classes.length] = clazz;
        Sorter.sort(comparableArray);
        this.classes = comparableArray;
        this.changed = true;
        return clazz;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.changed = true;
        this.saveResource = true;
    }

    public void cleanUp() {
        if (this.changed) {
            this.saveProperties();
        }
        if (this.prefsWindow != null) {
            this.prefsWindow.setVisible(false);
        }
        int n = 0;
        while (n < this.classes.length) {
            this.classes[n].cleanUp();
            ++n;
        }
    }

    public int compareTo(Object object) {
        Package package_ = (Package)object;
        return this.name.compareTo(package_.name);
    }

    boolean delete() {
        this.cleanUp();
        return FileUtils.deleteDirectory(this.classDir);
    }

    public boolean delete(Class clazz) {
        int n = 0;
        n = 0;
        while (n < this.classes.length && this.classes[n] != clazz) {
            ++n;
        }
        if (n == this.classes.length) {
            return false;
        }
        Class[] classArray = new Class[this.classes.length - 1];
        System.arraycopy(this.classes, 0, classArray, 0, n);
        System.arraycopy(this.classes, n + 1, classArray, n, this.classes.length - n - 1);
        this.classes = classArray;
        this.changed = true;
        if (this.lastClass == clazz) {
            this.lastClass = null;
        }
        return clazz.delete();
    }

    public PackagePrefsFrame editPrefs() {
        if (this.prefsWindow == null) {
            this.prefsWindow = new PackagePrefsFrame(this);
        }
        this.prefsWindow.setVisible(true);
        return this.prefsWindow;
    }

    synchronized boolean export(File file, ProjectSaver projectSaver) {
        File file2 = new File(file, this.getName().replace('.', File.separatorChar));
        file2.mkdirs();
        boolean bl = true;
        if (projectSaver != null) {
            projectSaver.currentText = Project.GRS("Package.Message2");
        }
        this.saveResourceBundles(file);
        if (projectSaver != null) {
            projectSaver.currentText = Project.GRS("Package.Message6");
        }
        this.saveIcons(file);
        int n = 0;
        while (n < this.classes.length) {
            if (projectSaver != null) {
                projectSaver.currentText = Project.GRS("Package.Message3", this.classes[n].getName());
                ++projectSaver.current;
            }
            if (!this.classes[n].export(file2)) {
                bl = false;
            }
            ++n;
        }
        return bl;
    }

    public Class get(String string) {
        int n = 0;
        while (n < this.classes.length) {
            if (this.classes[n].getName().equals(string)) {
                return this.classes[n];
            }
            ++n;
        }
        return null;
    }

    public String[] getClassList() {
        String[] stringArray = this.classDir.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.startsWith("C.") && string.substring("C.".length()).indexOf(46) == -1;
            }
        });
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray2[n2] = stringArray[n2].substring(2, stringArray[n2].length());
            ++n2;
        }
        Sorter.sort(stringArray2);
        return stringArray2;
    }

    public synchronized Vector getClasses() {
        String[] stringArray = this.getClassList();
        String[] stringArray2 = this.getInterfaceList();
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        Sorter.sort(stringArray3);
        Vector<Class> vector = new Vector<Class>(stringArray3.length, 10);
        int n = 0;
        while (n < stringArray3.length) {
            Class clazz = this.get(stringArray3[n]);
            vector.addElement(clazz);
            clazz.addInnerClasses(vector);
            ++n;
        }
        return vector;
    }

    public int getDebugLevel() {
        return Integer.parseInt(this.properties.getProperty("debugLevel", "0"));
    }

    public String[] getIcons() {
        return StringArray.parseFromString(this.properties.getProperty("icons", ""));
    }

    public String[] getInterfaceList() {
        String[] stringArray = this.classDir.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.startsWith("I.") && string.substring("C.".length()).indexOf(46) == -1;
            }
        });
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray2[n2] = stringArray[n2].substring(2, stringArray[n2].length());
            ++n2;
        }
        Sorter.sort(stringArray2);
        return stringArray2;
    }

    public Class getLastSelectedClass() {
        if (this.lastClass != null) {
            return this.lastClass;
        }
        if (this.classes.length == 0) {
            return null;
        }
        return this.classes[0];
    }

    public String getName() {
        return this.name;
    }

    public UndoableDocument getResource(int n) {
        if (this.resourceDocument[n] == null) {
            this.resourceDocument[n] = new UndoableDocument();
            this.resourceDocument[n].setText(this.properties.getProperty("Resource_" + Package.getSupportedLocales()[n], ""));
            this.resourceDocument[n].addDocumentListener(this);
        }
        return this.resourceDocument[n];
    }

    public String getResourceAsPlainText(int n) {
        return this.resourceDocument[n] == null ? this.properties.getProperty("Resource_" + Package.getSupportedLocales()[n], "") : this.resourceDocument[n].getText();
    }

    public static String getResourceDescription(int n) {
        try {
            if (n == 0) {
                return Project.GRS("DefaultLocale");
            }
            StringTokenizer stringTokenizer = new StringTokenizer(locales[n], "_");
            String string = stringTokenizer.nextToken();
            String string2 = stringTokenizer.hasMoreElements() ? stringTokenizer.nextToken() : "";
            String string3 = stringTokenizer.hasMoreElements() ? stringTokenizer.nextToken() : "";
            Locale locale = new Locale(string, string2, string3);
            return locale.getDisplayName();
        }
        catch (Exception exception) {
            return "Exception ocurred";
        }
    }

    public String getResourceName() {
        String string = this.getName();
        if (string.indexOf(".") > 0) {
            string = string.substring(string.lastIndexOf(".") + 1);
        }
        return this.getName() + ".resources." + string;
    }

    public static String[] getSupportedLocales() {
        return locales;
    }

    public static String[] getSupportedLocalesAsDisplayNames() {
        String[] stringArray = new String[locales.length];
        stringArray[0] = Project.GRS("DefaultLocale");
        int n = 1;
        while (n < locales.length) {
            stringArray[n] = Package.getResourceDescription(n) + " [" + locales[n] + "]";
            ++n;
        }
        return stringArray;
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.changed = true;
        this.saveResource = true;
    }

    public boolean isChanged() {
        if (this.changed) {
            return true;
        }
        int n = 0;
        while (n < this.classes.length) {
            if (this.classes[n].isChanged()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean isIdentifier(String string) {
        int n = string.length();
        boolean bl = true;
        if (n == 0) {
            return false;
        }
        if (!Character.isUnicodeIdentifierStart(string.charAt(0))) {
            return false;
        }
        int n2 = 1;
        while (n2 < n) {
            if (!Character.isUnicodeIdentifierPart(string.charAt(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    void load(MessageReceiver messageReceiver) {
        String[] stringArray = this.getClassList();
        String[] stringArray2 = this.getInterfaceList();
        int n = 0;
        while (n < stringArray.length) {
            if (messageReceiver != null) {
                messageReceiver.setCurrent(messageReceiver.getCurrent() + 1);
                messageReceiver.setCurrentText(Project.GRS("Package.Message4", this.getName() + "." + stringArray[n]));
            }
            this.add(stringArray[n], 1);
            ++n;
        }
        int n2 = 0;
        while (n2 < stringArray2.length) {
            if (messageReceiver != null) {
                messageReceiver.setCurrent(messageReceiver.getCurrent() + 1);
                messageReceiver.setCurrentText(Project.GRS("Package.Message5", stringArray2[n2]));
            }
            this.add(stringArray2[n2], 2);
            ++n2;
        }
    }

    private void loadProperties() {
        if (this.changed) {
            GUISystem.err.println(this.getClass().getName() + ".loadProperties(): internal error");
        }
        this.properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(new File(this.classDir, PROPERTIESFILENAME));
            this.properties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Throwable throwable) {
            JReqTools.showException(Jedi.getEditor(), throwable);
        }
    }

    public void markChanged() {
        this.changed = true;
        this.saveResource = true;
        this.saveIcons = true;
        int n = 0;
        while (n < this.classes.length) {
            this.classes[n].markChanged();
            ++n;
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.changed = true;
        this.saveResource = true;
    }

    public void saveChanges() {
        if (this.changed) {
            this.saveProperties();
        }
        int n = 0;
        while (n < this.classes.length) {
            this.classes[n].saveChanges();
            ++n;
        }
    }

    void saveIcons(File file) {
        Object object;
        int n;
        String[] stringArray = this.getIcons();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        String string = this.getName();
        if (string.indexOf(".") > 0) {
            string = string.substring(string.lastIndexOf(".") + 1);
        }
        File file2 = new File(file, this.getName().replace('.', File.separatorChar) + File.separator + "icons");
        file2.mkdirs();
        String[] stringArray2 = file2.list();
        if (stringArray2 != null) {
            n = 0;
            while (n < stringArray2.length) {
                boolean bl = false;
                int n2 = 0;
                while (n2 < stringArray.length) {
                    object = new File(stringArray[n2]);
                    if (((File)object).getName().equals(stringArray2[n])) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (!bl) {
                    new File(file2, stringArray2[n]).delete();
                }
                ++n;
            }
        }
        n = 0;
        while (n < stringArray.length) {
            File file3 = new File(stringArray[n]);
            File file4 = new File(file2, file3.getName());
            if (!file4.exists() || file3.length() != file4.length()) {
                try {
                    object = new FileInputStream(file3);
                    FileOutputStream fileOutputStream = new FileOutputStream(file4);
                    int n3 = -1;
                    while ((n3 = ((FileInputStream)object).read()) != -1) {
                        fileOutputStream.write(n3);
                    }
                    fileOutputStream.close();
                    ((FileInputStream)object).close();
                }
                catch (Exception exception) {
                    JReqTools.showException(exception);
                }
            }
            ++n;
        }
    }

    private void saveProperties() {
        if (!this.changed) {
            return;
        }
        int n = 0;
        while (n < this.resourceDocument.length) {
            if (this.resourceDocument[n] != null) {
                ((Hashtable)this.properties).put("Resource_" + Package.getSupportedLocales()[n], this.resourceDocument[n].getText());
            }
            ++n;
        }
        ((Hashtable)this.properties).put("noOfClasses", Integer.toString(this.classes.length));
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(this.classDir, PROPERTIESFILENAME));
            this.properties.store(fileOutputStream, "Automatically written, please do not edit manually !!!");
            fileOutputStream.close();
            this.changed = false;
        }
        catch (IOException iOException) {
            JReqTools.showException(Jedi.getEditor(), iOException);
        }
        this.changed = false;
    }

    void saveResourceBundles(File file) {
        String string = this.getName();
        if (string.indexOf(".") > 0) {
            string = string.substring(string.lastIndexOf(".") + 1);
        }
        File file2 = new File(file, this.getName().replace('.', File.separatorChar) + File.separator + "resources");
        file2.mkdirs();
        int n = 0;
        while (n < this.resourceDocument.length) {
            String string2 = this.getResourceAsPlainText(n);
            if (string2.length() != 0) {
                String string3 = n == 0 ? "" : "_" + Package.getSupportedLocales()[n];
                try {
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2.toString() + File.separator + string + string3 + ".properties"));
                    bufferedWriter.write(string2, 0, string2.length());
                    bufferedWriter.close();
                }
                catch (Exception exception) {
                    JReqTools.showException(Jedi.getEditor(), exception);
                }
            }
            ++n;
        }
    }

    public void saveSource() {
        this.sourcesDir.mkdirs();
        if (this.saveResource) {
            this.saveResourceBundles(Project.compileDir);
            this.saveResource = false;
        }
        if (this.saveIcons) {
            this.saveIcons(Project.compileDir);
            this.saveIcons = false;
        }
        int n = 0;
        while (n < this.classes.length) {
            this.classes[n].saveSource();
            ++n;
        }
    }

    public void setDataFrom(Package package_) {
        this.setDebugLevel(package_.getDebugLevel());
        this.setIcons(package_.getIcons());
        int n = 0;
        while (n < locales.length) {
            this.setResource(n, package_.getResourceAsPlainText(n));
            ++n;
        }
        int n2 = 0;
        while (n2 < package_.classes.length) {
            Class clazz = this.add(package_.classes[n2].getName(), package_.classes[n2].getType());
            clazz.setDataFrom(package_.classes[n2]);
            ++n2;
        }
    }

    public void setDebugLevel(int n) {
        ((Hashtable)this.properties).put("debugLevel", "" + n);
        this.markChanged();
    }

    public void setIcons(String[] stringArray) {
        ((Hashtable)this.properties).put("icons", StringArray.toString(stringArray));
        this.saveIcons = true;
        this.changed = true;
    }

    public void setLastSelectedClass(Class clazz) {
        this.lastClass = clazz;
    }

    public void setResource(int n, String string) {
        this.resourceDocument[n] = null;
        ((Hashtable)this.properties).put("Resource_" + Package.getSupportedLocales()[n], string);
    }

    public String toString() {
        return this.getName();
    }
}

