/*
 * Decompiled with CFR 0.152.
 */
package jedi.ds;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import jedi.Jedi;
import jedi.compiler.JavaCompiler;
import jedi.compiler.JavaRuntime;
import jedi.ds.Class;
import jedi.ds.MessageReceiver;
import jedi.ds.Method;
import jedi.ds.Package;
import jedi.ds.ProjectLoader;
import jedi.ds.ProjectSaver;
import jedi.javadoc.JavaDocCompiler;
import jreqtools.JReqTools;
import swing.addon.GUISystem;
import swing.addon.util.FileUtils;
import swing.addon.util.Sorter;
import swing.addon.util.StringArray;

public class Project {
    private static final boolean DEBUG = false;
    public static final int EXPORT_COMPLETE_PACKAGE = 1;
    public static final int EXPORT_SOURCES_ONLY = 2;
    static final ResourceBundle resources;
    public static File projectDir;
    public static File packageDir;
    public static File sourcesDir;
    public static File compileDir;
    String name;
    Package[] packages = new Package[0];
    Properties properties = new Properties();
    ProjectLoader projectLoader = null;
    boolean stopCompilation = false;

    public Project(String string) {
        this(string, null);
    }

    public Project(String string, MessageReceiver messageReceiver) {
        this.name = string;
        this.loadProperties();
        if (messageReceiver != null) {
            messageReceiver.setCurrentText(Project.GRS("Project.Message1"));
        }
        if (messageReceiver != null) {
            messageReceiver.setCurrent(0);
        }
        if (messageReceiver != null) {
            messageReceiver.setMaximum(Integer.parseInt(this.properties.getProperty("noOfClasses", "10")));
        }
        String[] stringArray = StringArray.parseFromString(this.properties.getProperty("packages", ""));
        int n = 0;
        while (n < stringArray.length) {
            if (messageReceiver != null) {
                messageReceiver.setCurrentText(Project.GRS("Project.Message2", stringArray[n]));
            }
            this.add(stringArray[n], messageReceiver);
            ++n;
        }
    }

    static final String GRS(String string) {
        try {
            return resources.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            JReqTools.showMessage(missingResourceException.getLocalizedMessage() + ":\n\n'" + string + "'");
            return "MISSING RESOURCE: " + string;
        }
    }

    static final String GRS(String string, String string2) {
        String string3 = Project.GRS(string);
        try {
            string3 = MessageFormat.format(string3, string2);
        }
        catch (Exception exception) {
            JReqTools.showException(exception);
        }
        return string3;
    }

    static final String GRS(String string, String string2, String string3) {
        String string4 = Project.GRS(string);
        try {
            string4 = MessageFormat.format(string4, string2, string3);
        }
        catch (Exception exception) {
            JReqTools.showException(exception);
        }
        return string4;
    }

    public Package add(String string) {
        return this.add(string, null);
    }

    Package add(String string, MessageReceiver messageReceiver) {
        Package package_ = this.get(string);
        if (package_ != null) {
            return package_;
        }
        package_ = new Package(string, messageReceiver);
        Sorter.Comparable[] comparableArray = new Package[this.packages.length + 1];
        System.arraycopy(this.packages, 0, comparableArray, 0, this.packages.length);
        comparableArray[this.packages.length] = package_;
        Sorter.sort(comparableArray);
        this.packages = comparableArray;
        return package_;
    }

    public int countClasses() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.packages.length) {
            n += this.packages[n2].classes.length;
            ++n2;
        }
        return n;
    }

    private void createBinaryFiles(File file) {
        JavaRuntime javaRuntime = Jedi.getRuntime();
        Vector vector = this.getMainMethods();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            try {
                String string = ((Method)enumeration.nextElement()).getFullName();
                string = string.substring(0, string.length() - 5);
                String string2 = string.substring(string.lastIndexOf(46) + 1);
                PrintWriter printWriter = new PrintWriter(new FileOutputStream(new File(file, string2)));
                printWriter.println("#!/bin/csh");
                printWriter.println();
                printWriter.println("set PROGDIR = " + new File(file.getParent()).getAbsolutePath());
                printWriter.println("set NAME = " + this.getName());
                printWriter.println("set CPATH = $PROGDIR/lib/$NAME.jar" + File.pathSeparator + javaRuntime.getClasspath());
                printWriter.println("set ARGS = \"" + javaRuntime.getArguments() + "\"");
                printWriter.println("set VMOPTS = \"" + javaRuntime.getOptions() + "\"");
                printWriter.println();
                printWriter.println(javaRuntime.getBinary() + " -classpath $CPATH $VMOPTS " + string + " $ARGS $*");
                printWriter.flush();
                printWriter.close();
            }
            catch (Throwable throwable) {
                JReqTools.showException(Jedi.getEditor(), throwable);
            }
        }
    }

    private void createMakefile(File file) {
        JavaCompiler javaCompiler = Jedi.getCompiler();
        JavaDocCompiler javaDocCompiler = Jedi.getJavaDocCompiler();
        String[] stringArray = this.getAllClassNames();
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(new File(file, "Makefile")));
            printWriter.println("JAVAC = " + javaCompiler.getBinary());
            printWriter.println("JAVAC_ARGS = -d ../classes " + javaCompiler.getArguments());
            printWriter.println("JAVADOC = " + javaDocCompiler.getBinary());
            printWriter.println("JAVADOC_ARGS = -d ../doc " + javaDocCompiler.getArguments());
            printWriter.println("NAME = " + this.getName());
            printWriter.println("CPATH = -classpath " + javaCompiler.getClasspath());
            printWriter.println();
            printWriter.println("CLASSFILES = \\");
            int n = 0;
            while (n < stringArray.length) {
                String string = n < stringArray.length - 1 ? ".class \\" : ".class";
                printWriter.println("\t../classes/" + stringArray[n].replace('.', '/') + string);
                ++n;
            }
            printWriter.println();
            printWriter.println("all: $(CLASSFILES) ../lib/$(NAME).jar attributes");
            printWriter.println();
            int n2 = 0;
            while (n2 < stringArray.length) {
                printWriter.println("../classes/" + stringArray[n2].replace('.', '/') + ".class: " + stringArray[n2].replace('.', '/') + ".java");
                printWriter.println("\t$(JAVAC) $(CPATH):../classes:. $(JAVAC_ARGS) " + stringArray[n2].replace('.', '/') + ".java");
                printWriter.println("");
                ++n2;
            }
            printWriter.println("../lib/$(NAME).jar: $(CLASSFILES)");
            printWriter.println("\tcd ../classes; jar c0f ../lib/$(NAME).jar *");
            printWriter.println();
            printWriter.println("attributes:");
            printWriter.println("\tchmod -R 755 ../bin ../. ../lib ../doc ../bin/* ../lib/*");
            printWriter.println("\tchmod -R 700 ../classes ../src");
            printWriter.println();
            printWriter.println("doc:");
            printWriter.print("\t$(JAVADOC) $(CPATH):. $(JAVADOC_ARGS)");
            int n3 = 0;
            while (n3 < this.packages.length) {
                printWriter.print(" " + this.packages[n3].getName());
                ++n3;
            }
            printWriter.println("\n\tfind ../doc -type d -exec chmod 755 {} \\;");
            printWriter.println("\tfind ../doc -type f -exec chmod 644 {} \\;");
            printWriter.println();
            printWriter.println("clean:");
            printWriter.println("\t-find ../classes -name \\*.class -exec rm -f {} \\;");
            printWriter.println("\t-rm ../lib/$(NAME).jar");
            printWriter.println();
            printWriter.flush();
            printWriter.close();
        }
        catch (Throwable throwable) {
            JReqTools.showException(Jedi.getEditor(), throwable);
        }
    }

    public static boolean delete(String string) {
        File file = new File(projectDir, string);
        if (!file.exists()) {
            return false;
        }
        return file.delete();
    }

    public boolean delete(Package package_) {
        int n = 0;
        n = 0;
        while (n < this.packages.length && this.packages[n] != package_) {
            ++n;
        }
        if (n == this.packages.length) {
            return false;
        }
        Package[] packageArray = new Package[this.packages.length - 1];
        System.arraycopy(this.packages, 0, packageArray, 0, n);
        System.arraycopy(this.packages, n + 1, packageArray, n, this.packages.length - n - 1);
        this.packages = packageArray;
        return package_.delete();
    }

    public void deleteAllCompiledClasses() {
        String[] stringArray = sourcesDir.list();
        int n = 0;
        while (stringArray != null && n < stringArray.length) {
            File file = new File(sourcesDir, stringArray[n]);
            if (!FileUtils.deleteDirectory(file)) {
                JReqTools.showError(Jedi.getEditor(), Project.GRS("Project.Error1", file.getAbsolutePath()));
            }
            ++n;
        }
        stringArray = compileDir.list();
        int n2 = 0;
        while (stringArray != null && n2 < stringArray.length) {
            File file = new File(compileDir, stringArray[n2]);
            if (!FileUtils.deleteDirectory(file)) {
                JReqTools.showError(Jedi.getEditor(), Project.GRS("Project.Error1", file.getAbsolutePath()));
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.packages.length) {
            this.packages[n3].markChanged();
            ++n3;
        }
    }

    public boolean export(File file, int n, ProjectSaver projectSaver) {
        File file2 = null;
        File file3 = null;
        if (n == 1) {
            file = new File(file, this.getName());
            file.mkdirs();
            File file4 = new File(file, "bin");
            file4.mkdirs();
            this.createBinaryFiles(file4);
            file3 = new File(file, "classes");
            file3.mkdirs();
            File file5 = new File(file, "doc");
            file5.mkdirs();
            File file6 = new File(file, "lib");
            file6.mkdirs();
            file2 = new File(file, "src");
            file2.mkdirs();
            this.createMakefile(file2);
        }
        boolean bl = true;
        int n2 = 0;
        while (n2 < this.packages.length) {
            if (n == 1) {
                this.packages[n2].saveResourceBundles(file3);
                this.packages[n2].saveIcons(file3);
            }
            if (!this.packages[n2].export(n == 2 ? file : file2, projectSaver)) {
                bl = false;
            }
            ++n2;
        }
        return bl;
    }

    public Package get(String string) {
        int n = 0;
        while (n < this.packages.length) {
            if (this.packages[n].getName().equals(string)) {
                return this.packages[n];
            }
            ++n;
        }
        return null;
    }

    protected String[] getAllClassNames() {
        Object[] objectArray;
        Vector<String> vector = new Vector<String>();
        Package[] packageArray = this.getPackages();
        int n = 0;
        while (n < packageArray.length) {
            objectArray = packageArray[n].getClasses();
            int n2 = 0;
            while (n2 < objectArray.size()) {
                Class clazz = (Class)objectArray.elementAt(n2);
                if (!clazz.isInnerClass()) {
                    vector.addElement(clazz.getFullName());
                }
                ++n2;
            }
            ++n;
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public File getCompileDirectory() {
        return compileDir;
    }

    public String[] getExtendsList() {
        return StringArray.parseFromString(this.properties.getProperty("extendsList", ""));
    }

    public String[] getImplementsList() {
        return StringArray.parseFromString(this.properties.getProperty("implementsList", ""));
    }

    public Vector getMainMethods() {
        Vector<Method> vector = new Vector<Method>(5, 5);
        int n = 0;
        while (n < this.packages.length) {
            int n2 = 0;
            while (n2 < this.packages[n].classes.length) {
                int n3 = 0;
                while (n3 < this.packages[n].classes[n2].methods.length) {
                    Method method = this.packages[n].classes[n2].methods[n3];
                    if (method.getName().equals("main") && method.isPublic() && method.isStatic() && method.getResultType().equals("void") && method.getParameters().length == 1) {
                        vector.addElement(method);
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        return vector;
    }

    public String getName() {
        return this.name;
    }

    public static String[] getPackageList() {
        String[] stringArray = packageDir.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return !string.startsWith(".");
            }
        });
        Sorter.sort(stringArray);
        return stringArray;
    }

    public String[] getPackageNames() {
        String[] stringArray = new String[this.packages.length];
        int n = 0;
        while (n < this.packages.length) {
            stringArray[n] = this.packages[n].getName();
            ++n;
        }
        Sorter.sort(stringArray);
        return stringArray;
    }

    public Package[] getPackages() {
        return this.packages;
    }

    public static String[] getProjectList() {
        String[] stringArray = projectDir.list();
        Sorter.sort(stringArray);
        return stringArray;
    }

    public String getProperty(String string) {
        return this.properties.getProperty(string);
    }

    public boolean isChanged() {
        int n = 0;
        while (n < this.packages.length) {
            if (this.packages[n].isChanged()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void loadProperties() {
        try {
            FileInputStream fileInputStream = new FileInputStream(new File(projectDir, this.getName()));
            this.properties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Date date = new Date();
            ((Hashtable)this.properties).put("creationDate", date.toString());
            ((Hashtable)this.properties).put("lastModified", date.toString());
        }
        catch (IOException iOException) {
            GUISystem.err.println(iOException);
        }
    }

    public void putProperty(String string, String string2) {
        ((Hashtable)this.properties).put(string, string2);
    }

    static String readLine(BufferedReader bufferedReader, String string) {
        try {
            String string2 = null;
            while ((string2 = bufferedReader.readLine()).startsWith("#")) {
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "=");
            String string3 = stringTokenizer.nextToken();
            if (!string3.equals(string)) {
                System.err.println("Wrong tag (internal error). Expected '" + string + "', but found '" + string3 + "'");
                System.exit(5);
            }
            return string2.substring(string3.length() + 1);
        }
        catch (Exception exception) {
            JReqTools.showException(exception);
            return null;
        }
    }

    public void remove(String string) {
        Package package_ = this.get(string);
        if (package_ == null) {
            return;
        }
        int n = 0;
        n = 0;
        while (n < this.packages.length && this.packages[n] != package_) {
            ++n;
        }
        Package[] packageArray = new Package[this.packages.length - 1];
        System.arraycopy(this.packages, 0, packageArray, 0, n);
        System.arraycopy(this.packages, n + 1, packageArray, n, this.packages.length - n - 1);
        this.packages = packageArray;
        package_.cleanUp();
    }

    public void saveChanges() {
        this.saveProperties();
        int n = 0;
        while (n < this.packages.length) {
            this.packages[n].saveChanges();
            ++n;
        }
    }

    public void saveProperties() {
        ((Hashtable)this.properties).put("packages", StringArray.toString(this.getPackageNames()));
        ((Hashtable)this.properties).put("noOfClasses", "" + this.countClasses());
        ((Hashtable)this.properties).put("lastModified", new Date().toString());
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(projectDir, this.getName()));
            this.properties.store(fileOutputStream, "Automatically written, please do not edit manually !!!");
            fileOutputStream.close();
        }
        catch (Exception exception) {
            GUISystem.err.println(this.getClass().getName() + ".saveProperties(): " + exception);
        }
    }

    public void setExtendsList(String[] stringArray) {
        ((Hashtable)this.properties).put("extendsList", StringArray.toString(stringArray));
    }

    public void setImplementsList(String[] stringArray) {
        ((Hashtable)this.properties).put("implementsList", StringArray.toString(stringArray));
    }

    static {
        Object object;
        resources = ResourceBundle.getBundle("jedi.ds.resources.ds");
        projectDir = new File(Jedi.getHomeDirectory(), "projects");
        packageDir = new File(Jedi.getHomeDirectory(), "packages");
        sourcesDir = new File(Jedi.getHomeDirectory(), "sources");
        compileDir = new File(Jedi.getHomeDirectory(), "classes");
        projectDir.mkdirs();
        packageDir.mkdirs();
        sourcesDir.mkdirs();
        if (packageDir.list().length == 0) {
            try {
                object = new PrintWriter(new FileWriter(packageDir + File.separator + ".version"));
                ((PrintWriter)object).println("3");
                ((PrintWriter)object).close();
            }
            catch (IOException iOException) {
                JReqTools.showException(iOException);
            }
        }
        object = "1";
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(packageDir + File.separator + ".version"));
            object = bufferedReader.readLine();
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (((String)object).equals("1")) {
            JReqTools.showError(Project.GRS("Package.WrongVersionError1"));
            System.exit(0);
        } else if (((String)object).equals("20000")) {
            JReqTools.showError(Project.GRS("Package.WrongVersionError2"));
            System.exit(0);
        }
    }
}

