/*
 * Decompiled with CFR 0.152.
 */
package jedi.ds;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jedi.Jedi;
import jedi.ds.Project;
import jreqtools.JReqTools;
import jreqtools.StringChecker;
import jreqtools.StringCheckers;
import jreqtools.StringRequester;
import swing.addon.Dialog;
import swing.addon.Frame;
import swing.addon.Insets;
import swing.addon.Label;
import swing.addon.Listview;
import swing.addon.NButtons;
import swing.addon.Panel;
import swing.addon.Prefs;
import swing.addon.Text;
import swing.addon.TextField;
import swing.addon.XPanel;
import swing.addon.YFramePanel;
import swing.addon.util.StringArray;

public class ProjectManager
extends Dialog
implements ActionListener,
ListSelectionListener,
MouseListener {
    private static final boolean DEBUG = false;
    public static final int OK = 1;
    int answer = 0;
    String projectName = Jedi.getLastProject();
    NButtons buttons = new NButtons(Project.GRS("ProjectManager.Load"), Project.GRS("ProjectManager.New"), Project.GRS("ProjectManager.Delete"), Project.GRS("ProjectManager.Dismiss"));
    Listview list = new Listview();
    TextField author = new TextField();
    Text creationDate = new Text("", 2);
    Text modificationDate = new Text("", 2);
    TextField comment = new TextField();
    StringRequester dialog = null;

    public ProjectManager(Frame frame) {
        super(frame, Project.GRS("ProjectManager.Title"));
        this.buttons.getComponentNumber(0).setIcon(Prefs.getIcon("ok"));
        this.buttons.getComponentNumber(1).setIcon(Prefs.getIcon("apply"));
        this.buttons.getComponentNumber(2).setIcon(Prefs.getIcon("cancel"));
        this.buttons.getComponentNumber(3).setIcon(Prefs.getIcon("dismiss"));
        this.buttons.addHelpButton("project_manager");
        this.buttons.addActionListener(this);
        this.author.addActionListener(this);
        this.comment.addActionListener(this);
        this.list.addListSelectionListener(this);
        this.list.addMouseListener(this);
        XPanel xPanel = new XPanel();
        xPanel.add(this.list);
        xPanel.addStrut();
        xPanel.add(this.createInfoPanel());
        YFramePanel yFramePanel = new YFramePanel();
        this.setContentPane(yFramePanel);
        yFramePanel.add(xPanel);
        yFramePanel.addStrut();
        yFramePanel.add(this.buttons);
        this.setData();
        ((Component)this).setBounds(100, 100, 600, 400);
        Prefs.add("ProjectManager", this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.buttons) {
            switch (this.buttons.get()) {
                case 0: {
                    this.loadProject();
                    break;
                }
                case 1: {
                    this.newProject();
                    break;
                }
                case 2: {
                    this.deleteProject();
                    break;
                }
                case 3: {
                    this.setVisible(false);
                }
            }
        } else if (object == this.author || object == this.comment) {
            this.saveProjectData();
        }
    }

    private Panel createInfoPanel() {
        Panel panel = new Panel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(Project.GRS("ProjectManager.Separator")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(Prefs.getObjectSpace(), Prefs.getObjectSpace(), Prefs.getObjectSpace(), Prefs.getObjectSpace());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        panel.add((Component)new Label(Project.GRS("ProjectManager.Label1"), 2), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        panel.add((Component)this.author, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        panel.add((Component)new Label(Project.GRS("ProjectManager.Label2"), 2), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        panel.add((Component)this.creationDate, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        panel.add((Component)new Label(Project.GRS("ProjectManager.Label3"), 2), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        panel.add((Component)this.modificationDate, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        panel.add((Component)new Label(Project.GRS("ProjectManager.Label4"), 2), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        panel.add((Component)this.comment, gridBagConstraints);
        return panel;
    }

    void deleteProject() {
        String string = (String)this.list.getSelectedValue();
        Project project = Jedi.getEditor().getProject();
        if (project != null && project.getName().equals(string)) {
            JReqTools.showError(Project.GRS("ProjectManager.Error1"));
            return;
        }
        if (string != null) {
            File file = new File(Project.projectDir, string);
            file.delete();
            this.setData();
        } else {
            JReqTools.showError(Project.GRS("ProjectManager.Error2"));
        }
    }

    public String getProjectName() {
        return this.projectName;
    }

    void loadProject() {
        String string = (String)this.list.getSelectedValue();
        Project project = Jedi.getEditor().getProject();
        if (project != null && project.getName().equals(string)) {
            JReqTools.showError(Project.GRS("ProjectManager.Error3"));
            return;
        }
        if (string != null) {
            this.projectName = string;
            this.answer = 1;
            this.setVisible(false);
        } else {
            JReqTools.showError(Project.GRS("ProjectManager.Error2"));
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1) {
            this.loadProject();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    void newProject() {
        if (this.dialog == null) {
            this.dialog = new StringRequester();
            this.dialog.setTitle(Project.GRS("ProjectManager.New.DialogTitle"));
            this.dialog.setMessage(Project.GRS("ProjectManager.New.DialogMessage"));
            this.dialog.setStringChecker(new StringChecker(){

                public boolean accept(String string) {
                    return StringCheckers.getJavaPackageChecker().accept(string);
                }

                public String getFailMessage() {
                    return Project.GRS("ProjectManager.FailMessage");
                }
            });
            Prefs.add("ProjectManager.New.Dialog", this.dialog);
        }
        this.dialog.setString("");
        if (this.dialog.request(Jedi.getEditor()) != 0) {
            return;
        }
        String string = this.dialog.getString();
        boolean bl = true;
        if (StringArray.contains(Project.getProjectList(), string) != -1) {
            if (!JReqTools.showQuestion(Project.GRS("ProjectManager.New.Question1", string))) {
                return;
            }
            bl = false;
        }
        if (bl) {
            Project project = new Project(string);
            project.saveProperties();
            this.setData();
            this.list.setSelectedValue(string);
            this.author.requestFocus();
        } else {
            this.list.setSelectedValue(string);
            this.loadProject();
        }
    }

    public int request() {
        this.answer = 0;
        this.setVisible(true);
        return this.answer;
    }

    void saveProjectData() {
        String string = (String)this.list.getSelectedValue();
        if (string != null) {
            Properties properties = new Properties();
            Project project = Jedi.getEditor().getProject();
            if (project == null || !project.getName().equals(string)) {
                try {
                    FileInputStream fileInputStream = new FileInputStream(new File(Project.projectDir, string));
                    properties.load(fileInputStream);
                    fileInputStream.close();
                    ((Hashtable)properties).put("author", this.author.getText());
                    ((Hashtable)properties).put("comment", this.comment.getText());
                    ((Hashtable)properties).put("lastModified", new Date().toString());
                    FileOutputStream fileOutputStream = new FileOutputStream(new File(Project.projectDir, string));
                    properties.store(fileOutputStream, "Please do not edit manually");
                    fileOutputStream.close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException iOException) {
                    JReqTools.showException(iOException);
                }
            } else {
                ((Hashtable)project.properties).put("author", this.author.getText());
                ((Hashtable)project.properties).put("comment", this.comment.getText());
                ((Hashtable)project.properties).put("lastModified", new Date().toString());
            }
        } else {
            JReqTools.showError(Project.GRS("ProjectManager.Error2"));
        }
    }

    void setData() {
        Object[] objectArray = Project.getProjectList();
        this.projectName = Jedi.getLastProject();
        this.list.setElements(objectArray);
        this.list.setSelectedValue(this.projectName);
        this.setProjectData();
    }

    void setProjectData() {
        String string = (String)this.list.getSelectedValue();
        if (string != null) {
            Properties properties = new Properties();
            Project project = Jedi.getEditor().getProject();
            if (project == null || !project.getName().equals(string)) {
                try {
                    FileInputStream fileInputStream = new FileInputStream(new File(Project.projectDir, string));
                    properties.load(fileInputStream);
                    fileInputStream.close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException iOException) {
                    JReqTools.showException(iOException);
                }
            } else {
                properties = project.properties;
            }
            this.author.setText(properties.getProperty("author", "n/a"));
            this.creationDate.setText(properties.getProperty("creationDate", "n/a"));
            this.modificationDate.setText(properties.getProperty("lastModified", "n/a"));
            this.comment.setText(properties.getProperty("comment", "n/a"));
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.setProjectData();
    }
}

