/*
 * Decompiled with CFR 0.152.
 */
package jedi.editor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import jedi.Jedi;
import jedi.ds.Class;
import jedi.ds.Method;
import jedi.editor.EditorFrame;
import jedi.prefs.JediPrefs;
import jreqtools.StringCheckers;
import swing.addon.CheckBox;
import swing.addon.ComboBox;
import swing.addon.Dialog;
import swing.addon.GridBagConstraints;
import swing.addon.GridBagLayout;
import swing.addon.Insets;
import swing.addon.Label;
import swing.addon.OkCancelButtons;
import swing.addon.Panel;
import swing.addon.Prefs;
import swing.addon.TextField;
import swing.addon.YFramePanel;
import swing.addon.util.StringArray;

public class Action_AddProperty
extends AbstractAction {
    PropertyDialog dialog;

    public Action_AddProperty() {
        super("jedi-add-property");
        this.putValue("ShortDescription", EditorFrame.GRS("Action_AddProperty.Description"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        EditorFrame editorFrame = Jedi.getEditor();
        Class clazz = editorFrame.getCurrentClass();
        if (clazz == null) {
            Jedi.getEditor().getToolkit().beep();
            return;
        }
        if (this.dialog == null) {
            this.dialog = new PropertyDialog();
            Prefs.add("Editor.Action_AddProperty.Dialog", this.dialog);
            Prefs.add("Editor.Action_AddProperty.Dialog.Type", this.dialog.proptype);
            Prefs.add("Editor.Action_AddProperty.Dialog.Name", this.dialog.propname);
            Prefs.add("Editor.Action_AddProperty.Dialog.Get", this.dialog.addGetMethod);
            Prefs.add("Editor.Action_AddProperty.Dialog.Set", this.dialog.addSetMethod);
        }
        if (!this.dialog.request()) {
            return;
        }
        String string = this.dialog.getPropertyType();
        String string2 = this.dialog.getPropertyName();
        String string3 = string2.substring(0, 1).toUpperCase() + string2.substring(1);
        editorFrame.getCurrentClass().appendVariablesText("// Property: " + string2);
        editorFrame.getCurrentClass().appendVariablesText(string + " " + string2 + ";");
        Method method = editorFrame.makeNewMethod("get" + string3, null);
        method.setResultType(string);
        method.setText("return " + string2 + ";\n");
        method.setJavaDoc("Returns the value of the " + string2 + " property.");
        method = editorFrame.makeNewMethod("set" + string3, null);
        method.setResultType("void");
        method.addParameter(string + " arg");
        method.setText(string2 + " = arg;\n");
        method.setJavaDoc("Assigns the value of the " + string2 + " property.");
        editorFrame.setClass(editorFrame.getCurrentClass());
    }

    class PropertyDialog
    extends Dialog {
        boolean answer = false;
        OkCancelButtons buttons = new OkCancelButtons();
        ComboBox proptype = new ComboBox(this.getTypes());
        TextField propname = new TextField();
        CheckBox addGetMethod = new CheckBox(EditorFrame.GRS("Action_AddProperty.Checkbox1"), true);
        CheckBox addSetMethod = new CheckBox(EditorFrame.GRS("Action_AddProperty.Checkbox2"), true);

        public PropertyDialog() {
            super(Jedi.getEditor(), EditorFrame.GRS("Action_AddProperty.DialogTitle"));
            this.proptype.setEditable(true);
            this.buttons.setShowSeparator(false);
            this.buttons.addActionListener(new ActionListener(this){
                private final /* synthetic */ PropertyDialog this$1;
                {
                    this.this$1 = propertyDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.this$1.buttons.get() == 0) {
                        this.this$1.ok();
                    } else {
                        this.this$1.cancel();
                    }
                }
            });
            this.propname.addActionListener(new ActionListener(this){
                private final /* synthetic */ PropertyDialog this$1;
                {
                    this.this$1 = propertyDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.ok();
                }
            });
            YFramePanel yFramePanel = new YFramePanel();
            yFramePanel.add(this.createOptionPanel());
            yFramePanel.addStrut();
            yFramePanel.add(this.buttons);
            this.setContentPane(yFramePanel);
            this.pack();
        }

        void cancel() {
            this.answer = false;
            this.setVisible(false);
        }

        private Panel createOptionPanel() {
            Panel panel = new Panel(new GridBagLayout());
            panel.setBorder(BorderFactory.createTitledBorder(EditorFrame.GRS("Action_AddProperty.Title")));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(Prefs.getObjectSpace(), Prefs.getObjectSpace(), Prefs.getObjectSpace(), Prefs.getObjectSpace());
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            panel.add((Component)new Label(EditorFrame.GRS("Action_AddProperty.Label1"), 2), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            panel.add((Component)this.proptype, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            panel.add((Component)new Label(EditorFrame.GRS("Action_AddProperty.Label2"), 2), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            panel.add((Component)this.propname, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            panel.add((Component)this.addGetMethod, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            panel.add((Component)this.addSetMethod, gridBagConstraints);
            return panel;
        }

        public String getPropertyName() {
            return this.propname.getText();
        }

        public String getPropertyType() {
            return (String)this.proptype.getSelectedItem();
        }

        String[] getTypes() {
            String[] stringArray = StringArray.parseFromString(JediPrefs.getProperty("ContextMenu.ResultType"));
            return StringArray.remove(stringArray, "void");
        }

        void ok() {
            if (!StringCheckers.getJavaIdentifierChecker().accept(this.propname.getText())) {
                this.getToolkit().beep();
                this.propname.requestFocus();
                return;
            }
            this.answer = true;
            this.setVisible(false);
        }

        public boolean request() {
            this.answer = false;
            this.setVisible(true);
            return this.answer;
        }

        public void setVisible(boolean bl) {
            if (bl) {
                this.propname.requestFocus();
            }
            super.setVisible(bl);
        }
    }
}

