/*
 * Decompiled with CFR 0.152.
 */
package jedi.editor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import jedi.Jedi;
import jedi.ds.Package;
import jedi.ds.Project;
import jedi.editor.EditorFrame;
import jreqtools.FileRequester;
import swing.addon.Dialog;
import swing.addon.Frame;
import swing.addon.GridBagConstraints;
import swing.addon.GridBagLayout;
import swing.addon.Insets;
import swing.addon.Label;
import swing.addon.Listview;
import swing.addon.NButtons;
import swing.addon.OkCancelButtons;
import swing.addon.Panel;
import swing.addon.Prefs;
import swing.addon.TextArea;
import swing.addon.YFramePanel;
import swing.addon.util.Sorter;
import swing.addon.util.StringArray;

public class Action_CheckResources
extends AbstractAction {
    Frame frame = null;
    TextArea ta = new TextArea();
    NButtons buttons = null;
    FileRequester fileRequester = null;
    LanguageDialog languageDialog = null;

    public Action_CheckResources() {
        super("jedi-check-resources");
        this.putValue("ShortDescription", EditorFrame.GRS("Action_CheckResources.Description"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.languageDialog == null) {
            this.languageDialog = new LanguageDialog();
            Prefs.add("CheckResources.Dialog", this.languageDialog);
        }
        if (!this.languageDialog.request()) {
            return;
        }
        this.ta.setText("### " + EditorFrame.GRS("Action_CheckResources.ToTranslate") + "\n\n");
        Project project = Jedi.getEditor().getProject();
        Package[] packageArray = project.getPackages();
        int n = 0;
        while (n < packageArray.length) {
            Hashtable hashtable = this.getIDs(packageArray[n], 0);
            if (hashtable != null) {
                int n2 = Package.getSupportedLocales().length;
                int n3 = 1;
                while (n3 < n2) {
                    String string = Package.getSupportedLocales()[n3];
                    if (this.languageDialog.checkLanguage(string)) {
                        Hashtable hashtable2 = this.getIDs(packageArray[n], n3);
                        this.ta.append("### " + packageArray[n].getName() + ": " + string + "\n");
                        this.check(hashtable, hashtable2, this.ta);
                        this.ta.append("\n");
                    }
                    ++n3;
                }
            }
            ++n;
        }
        if (this.frame == null) {
            this.initFrame();
        }
        this.frame.setVisible(true);
    }

    void check(Hashtable hashtable, Hashtable hashtable2, TextArea textArea) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (hashtable2.containsKey(string)) continue;
            textArea.append(hashtable.get(string) + "\n");
        }
    }

    Hashtable getIDs(Package package_, int n) {
        String string = package_.getResourceAsPlainText(n);
        if (string == null) {
            string = "";
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n2 = string2.indexOf("=");
            if (n2 == -1) continue;
            hashtable.put(string2.substring(0, n2), string2);
        }
        return hashtable;
    }

    private void initFrame() {
        this.buttons = new NButtons(EditorFrame.GRS("Action_CheckResources.Close"), EditorFrame.GRS("Action_CheckResources.Save"));
        this.buttons.getComponentNumber(0).setIcon(Prefs.getIcon("dismiss"));
        this.buttons.getComponentNumber(1).setIcon(Prefs.getIcon("apply"));
        this.frame = new Frame(EditorFrame.GRS("Action_CheckResources.Title"));
        YFramePanel yFramePanel = new YFramePanel();
        this.buttons.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Action_CheckResources.this.buttons.get() == 1) {
                    Action_CheckResources.this.save();
                } else {
                    Action_CheckResources.this.frame.setVisible(false);
                }
            }
        });
        yFramePanel.add(this.ta);
        yFramePanel.addStrut();
        yFramePanel.add(this.buttons);
        this.frame.setContentPane(yFramePanel);
        ((Component)this.frame).setBounds(100, 100, 400, 300);
        Prefs.add("CheckResources", this.frame);
    }

    void save() {
        if (this.fileRequester == null) {
            this.fileRequester = new FileRequester();
            this.fileRequester.setSaveMode();
            this.fileRequester.setTitle(EditorFrame.GRS("Action_CheckResources.FileRequester.Title"));
            Prefs.add("Action_CheckResources.FileRequester", this.fileRequester);
        }
        if (this.fileRequester.request(Jedi.getEditor()) != 0) {
            return;
        }
        this.ta.saveTo(this.fileRequester.getFile());
    }

    class LanguageDialog
    extends Dialog {
        boolean answer = false;
        OkCancelButtons buttons = new OkCancelButtons();
        Listview selected = new Listview();
        Listview available = new Listview();

        public LanguageDialog() {
            super(Jedi.getEditor(), EditorFrame.GRS("Action_CheckResources.DialogTitle"));
            this.buttons.setShowSeparator(false);
            this.buttons.addActionListener(new ActionListener(this){
                private final /* synthetic */ LanguageDialog this$1;
                {
                    this.this$1 = languageDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.this$1.buttons.get() == 0) {
                        this.this$1.ok();
                    } else {
                        this.this$1.cancel();
                    }
                }
            });
            this.available.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ LanguageDialog this$1;
                {
                    this.this$1 = languageDialog;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() < 2) {
                        return;
                    }
                    String string = (String)this.this$1.available.getSelectedValue();
                    if (string == null) {
                        return;
                    }
                    this.this$1.available.removeElement(string);
                    this.this$1.selected.addElement(string);
                    Object[] objectArray = this.this$1.selected.getElements();
                    Object[] objectArray2 = new String[objectArray.length];
                    System.arraycopy(objectArray, 0, objectArray2, 0, objectArray2.length);
                    Sorter.sort((String[])objectArray2);
                    this.this$1.selected.setElements(objectArray2);
                }
            });
            this.selected.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ LanguageDialog this$1;
                {
                    this.this$1 = languageDialog;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() < 2) {
                        return;
                    }
                    String string = (String)this.this$1.selected.getSelectedValue();
                    if (string == null) {
                        return;
                    }
                    this.this$1.selected.removeElement(string);
                    this.this$1.available.addElement(string);
                    Object[] objectArray = this.this$1.available.getElements();
                    Object[] objectArray2 = new String[objectArray.length];
                    System.arraycopy(objectArray, 0, objectArray2, 0, objectArray2.length);
                    Sorter.sort((String[])objectArray2);
                    this.this$1.available.setElements(objectArray2);
                }
            });
            YFramePanel yFramePanel = new YFramePanel();
            yFramePanel.add(this.createOptionPanel());
            yFramePanel.addStrut();
            yFramePanel.add(this.buttons);
            this.setContentPane(yFramePanel);
            this.pack();
        }

        void cancel() {
            this.answer = false;
            this.setVisible(false);
        }

        boolean checkLanguage(String string) {
            Project project = Jedi.getEditor().getProject();
            String[] stringArray = StringArray.parseFromString(project.getProperty("SelectedLanguages"));
            return StringArray.contains(stringArray, string) != -1;
        }

        private Panel createOptionPanel() {
            Panel panel = new Panel(new GridBagLayout());
            panel.setBorder(BorderFactory.createTitledBorder(EditorFrame.GRS("Action_CheckResources.Title2")));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(Prefs.getObjectSpace(), Prefs.getObjectSpace(), Prefs.getObjectSpace(), Prefs.getObjectSpace());
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            panel.add((Component)new Label(EditorFrame.GRS("Action_CheckResources.Selected"), 0), gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            panel.add((Component)this.selected, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            panel.add((Component)new Label(EditorFrame.GRS("Action_CheckResources.Available"), 0), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            panel.add((Component)this.available, gridBagConstraints);
            return panel;
        }

        void ok() {
            Object object;
            Object[] objectArray = this.selected.getElements();
            String[] stringArray = new String[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                object = (String)objectArray[n];
                object = ((String)object).substring(((String)object).lastIndexOf("[") + 1);
                stringArray[n] = object = ((String)object).substring(0, ((String)object).length() - 1);
                ++n;
            }
            object = Jedi.getEditor().getProject();
            ((Project)object).putProperty("SelectedLanguages", StringArray.toString(stringArray));
            this.answer = true;
            this.setVisible(false);
        }

        public boolean request() {
            this.answer = false;
            this.reset();
            this.setVisible(true);
            return this.answer;
        }

        void reset() {
            Project project = Jedi.getEditor().getProject();
            Vector<String> vector = new Vector<String>();
            Vector<String> vector2 = new Vector<String>();
            String[] stringArray = StringArray.parseFromString(project.getProperty("SelectedLanguages"));
            String[] stringArray2 = Package.getSupportedLocales();
            String[] stringArray3 = Package.getSupportedLocalesAsDisplayNames();
            int n = 1;
            while (n < stringArray2.length) {
                if (StringArray.contains(stringArray, stringArray2[n]) != -1) {
                    vector.addElement(stringArray3[n]);
                } else {
                    vector2.addElement(stringArray3[n]);
                }
                ++n;
            }
            this.selected.setElements(vector);
            this.available.setElements(vector2);
        }
    }
}

