/*
 * Decompiled with CFR 0.152.
 */
package jedi.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import jedi.Jedi;
import jedi.ds.Class;
import jedi.ds.Package;
import jedi.ds.Project;
import jedi.editor.EditorFrame;
import jreqtools.StringCheckers;
import swing.addon.ComboBox;
import swing.addon.Dialog;
import swing.addon.Label;
import swing.addon.OkCancelButtons;
import swing.addon.Panel;
import swing.addon.Prefs;
import swing.addon.TextField;
import swing.addon.YFramePanel;

public class Action_CopyClass
extends AbstractAction {
    CopyDialog dialog;

    public Action_CopyClass() {
        super("jedi-copy-class");
        this.putValue("ShortDescription", EditorFrame.GRS("Action_CopyClass.Description"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Class clazz = Jedi.getEditor().getCurrentClass();
        if (clazz == null) {
            Jedi.getEditor().getToolkit().beep();
            return;
        }
        if (this.dialog == null) {
            this.dialog = new CopyDialog();
            Prefs.add("Editor.Action_CopyClass.Dialog", this.dialog);
        }
        if (!this.dialog.request()) {
            return;
        }
        Jedi.getEditor().setPackage(this.dialog.getSelectedPackage());
        if (clazz.isClass()) {
            Jedi.getEditor().makeNewClass(this.dialog.getSelectedClass() == null ? this.dialog.getClassName() : this.dialog.getSelectedClass().getName() + "." + this.dialog.getClassName(), clazz);
        } else {
            Jedi.getEditor().makeNewInterface(this.dialog.getSelectedClass() == null ? this.dialog.getClassName() : this.dialog.getSelectedClass().getName() + "." + this.dialog.getClassName(), clazz);
        }
    }

    class CopyDialog
    extends Dialog {
        boolean answer = false;
        boolean events = false;
        OkCancelButtons buttons = new OkCancelButtons();
        ComboBox packages = new ComboBox();
        ComboBox classes = new ComboBox();
        TextField classname = new TextField();

        public CopyDialog() {
            super(Jedi.getEditor(), EditorFrame.GRS("Action_CopyClass.DialogTitle"));
            this.buttons.setShowSeparator(false);
            this.buttons.addHelpButton("copy_class");
            this.packages.addActionListener(new ActionListener(this){
                private final /* synthetic */ CopyDialog this$1;
                {
                    this.this$1 = copyDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.this$1.events) {
                        this.this$1.setClassNames();
                    }
                }
            });
            this.buttons.addActionListener(new ActionListener(this){
                private final /* synthetic */ CopyDialog this$1;
                {
                    this.this$1 = copyDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.this$1.buttons.get() == 0) {
                        this.this$1.ok();
                    } else {
                        this.this$1.cancel();
                    }
                }
            });
            this.classname.addActionListener(new ActionListener(this){
                private final /* synthetic */ CopyDialog this$1;
                {
                    this.this$1 = copyDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.ok();
                }
            });
            YFramePanel yFramePanel = new YFramePanel();
            yFramePanel.add(this.createOptionPanel());
            yFramePanel.addStrut();
            yFramePanel.add(this.buttons);
            this.setContentPane(yFramePanel);
            this.pack();
        }

        void cancel() {
            this.answer = false;
            this.setVisible(false);
        }

        private Panel createOptionPanel() {
            Panel panel = new Panel(new GridBagLayout());
            panel.setBorder(BorderFactory.createTitledBorder(EditorFrame.GRS("Action_CopyClass.Title")));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(Prefs.getObjectSpace(), Prefs.getObjectSpace(), Prefs.getObjectSpace(), Prefs.getObjectSpace());
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            panel.add((Component)new Label(EditorFrame.GRS("Action_CopyClass.Label1"), 2), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            panel.add((Component)this.packages, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            panel.add((Component)new Label(EditorFrame.GRS("Action_CopyClass.Label2"), 2), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            panel.add((Component)this.classes, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            panel.add((Component)new Label(EditorFrame.GRS("Action_CopyClass.Label3"), 2), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            panel.add((Component)this.classname, gridBagConstraints);
            return panel;
        }

        public String getClassName() {
            return this.classname.getText();
        }

        public Class getSelectedClass() {
            return this.classes.getSelectedIndex() == 0 ? null : (Class)this.classes.getSelectedItem();
        }

        public Package getSelectedPackage() {
            return (Package)this.packages.getSelectedItem();
        }

        void ok() {
            if (!StringCheckers.getJavaIdentifierChecker().accept(this.classname.getText())) {
                this.getToolkit().beep();
                this.classname.requestFocus();
                return;
            }
            this.answer = true;
            this.setVisible(false);
        }

        public boolean request() {
            this.answer = false;
            this.events = false;
            String string = Jedi.getEditor().getCurrentClass().getName();
            if (string.indexOf(".") != -1) {
                string = string.substring(string.indexOf(".") + 1);
            }
            this.setPackageNames();
            this.setClassNames();
            this.classname.setText(string);
            this.events = true;
            this.setVisible(true);
            return this.answer;
        }

        void setClassNames() {
            Vector vector = this.getSelectedPackage().getClasses();
            vector.insertElementAt(new String("---"), 0);
            this.classes.setItems(vector);
            this.classes.setSelectedIndex(0);
        }

        void setPackageNames() {
            Project project = Jedi.getEditor().getProject();
            this.packages.setItems(project.getPackages());
            this.packages.setSelectedItem(Jedi.getEditor().getCurrentPackage());
        }

        public void setVisible(boolean bl) {
            if (bl) {
                this.classname.requestFocus();
            }
            super.setVisible(bl);
        }
    }
}

