/*
 * Decompiled with CFR 0.152.
 */
package jedi.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import jedi.Jedi;
import jedi.ds.Class;
import jedi.ds.Method;
import jedi.ds.Package;
import jedi.editor.EditorFrame;
import jreqtools.StringCheckers;
import swing.addon.ComboBox;
import swing.addon.Dialog;
import swing.addon.Label;
import swing.addon.OkCancelButtons;
import swing.addon.Panel;
import swing.addon.Prefs;
import swing.addon.TextField;
import swing.addon.YFramePanel;

public class Action_CopyMethod
extends AbstractAction {
    CopyDialog dialog;

    public Action_CopyMethod() {
        super("jedi-copy-method");
        this.putValue("ShortDescription", EditorFrame.GRS("Action_CopyMethod.Description"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Method method = Jedi.getEditor().getCurrentMethod();
        if (method == null) {
            Jedi.getEditor().getToolkit().beep();
            return;
        }
        if (this.dialog == null) {
            this.dialog = new CopyDialog();
            Prefs.add("Editor.Action_CopyMethod.Dialog", this.dialog);
        }
        if (!this.dialog.request()) {
            return;
        }
        if (this.dialog.getSelectedClass() == null) {
            this.dialog.getToolkit().beep();
            return;
        }
        Jedi.getEditor().setPackage(this.dialog.getSelectedPackage());
        Jedi.getEditor().setClass(this.dialog.getSelectedClass());
        if (method.getType() == 2) {
            Jedi.getEditor().makeNewConstructor(method);
        } else if (method.getType() == 3) {
            Jedi.getEditor().makeNewInitializer(method);
        } else {
            Jedi.getEditor().makeNewMethod(this.dialog.getMethodName(), method).editPrefs();
        }
    }

    class CopyDialog
    extends Dialog {
        boolean answer = false;
        boolean events = false;
        OkCancelButtons buttons = new OkCancelButtons();
        ComboBox packages = new ComboBox();
        ComboBox classes = new ComboBox();
        TextField methodname = new TextField();

        public CopyDialog() {
            super(Jedi.getEditor(), EditorFrame.GRS("Action_CopyMethod.DialogTitle"));
            this.buttons.setShowSeparator(false);
            this.buttons.addHelpButton("copy_method");
            this.packages.addActionListener(new ActionListener(this){
                private final /* synthetic */ CopyDialog this$1;
                {
                    this.this$1 = copyDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.this$1.events) {
                        this.this$1.setClassNames();
                    }
                }
            });
            this.buttons.addActionListener(new ActionListener(this){
                private final /* synthetic */ CopyDialog this$1;
                {
                    this.this$1 = copyDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.this$1.buttons.get() == 0) {
                        this.this$1.ok();
                    } else {
                        this.this$1.cancel();
                    }
                }
            });
            this.methodname.addActionListener(new ActionListener(this){
                private final /* synthetic */ CopyDialog this$1;
                {
                    this.this$1 = copyDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.ok();
                }
            });
            YFramePanel yFramePanel = new YFramePanel();
            yFramePanel.add(this.createOptionPanel());
            yFramePanel.addStrut();
            yFramePanel.add(this.buttons);
            this.setContentPane(yFramePanel);
            this.pack();
        }

        void cancel() {
            this.answer = false;
            this.setVisible(false);
        }

        private Panel createOptionPanel() {
            Panel panel = new Panel(new GridBagLayout());
            panel.setBorder(BorderFactory.createTitledBorder(EditorFrame.GRS("Action_CopyMethod.Title")));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(Prefs.getObjectSpace(), Prefs.getObjectSpace(), Prefs.getObjectSpace(), Prefs.getObjectSpace());
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            panel.add((Component)new Label(EditorFrame.GRS("Action_CopyMethod.Label1"), 2), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            panel.add((Component)this.packages, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            panel.add((Component)new Label(EditorFrame.GRS("Action_CopyMethod.Label2"), 2), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            panel.add((Component)this.classes, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            panel.add((Component)new Label(EditorFrame.GRS("Action_CopyMethod.Label3"), 2), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            panel.add((Component)this.methodname, gridBagConstraints);
            return panel;
        }

        public String getMethodName() {
            return this.methodname.getText();
        }

        public Class getSelectedClass() {
            return (Class)this.classes.getSelectedItem();
        }

        public Package getSelectedPackage() {
            return (Package)this.packages.getSelectedItem();
        }

        void ok() {
            if (this.methodname.isEnabled() && !StringCheckers.getJavaIdentifierChecker().accept(this.methodname.getText())) {
                this.getToolkit().beep();
                this.methodname.requestFocus();
                return;
            }
            this.answer = true;
            this.setVisible(false);
        }

        public boolean request() {
            this.answer = false;
            this.events = false;
            this.setPackageNames();
            this.setClassNames();
            this.methodname.setText(Jedi.getEditor().getCurrentMethod().getName());
            this.methodname.setEnabled(Jedi.getEditor().getCurrentMethod().getType() == 1);
            this.events = true;
            this.setVisible(true);
            return this.answer;
        }

        void setClassNames() {
            this.classes.setItems(this.getSelectedPackage().getClasses());
            this.classes.setSelectedItem(this.getSelectedPackage().getLastSelectedClass());
        }

        void setPackageNames() {
            this.packages.setItems(Jedi.getEditor().getProject().getPackages());
            this.packages.setSelectedItem(Jedi.getEditor().getCurrentPackage());
        }

        public void setVisible(boolean bl) {
            if (bl && this.methodname.isEnabled()) {
                this.methodname.requestFocus();
            }
            super.setVisible(bl);
        }
    }
}

