/*
 * Decompiled with CFR 0.152.
 */
package jedi.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import jedi.Jedi;
import jedi.ds.Package;
import jedi.editor.EditorFrame;
import jreqtools.StringCheckers;
import swing.addon.Dialog;
import swing.addon.Label;
import swing.addon.OkCancelButtons;
import swing.addon.Panel;
import swing.addon.Prefs;
import swing.addon.TextField;
import swing.addon.YFramePanel;

public class Action_CopyPackage
extends AbstractAction {
    CopyDialog dialog;

    public Action_CopyPackage() {
        super("jedi-copy-package");
        this.putValue("ShortDescription", EditorFrame.GRS("Action_CopyPackage.Description"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Package package_ = Jedi.getEditor().getCurrentPackage();
        if (package_ == null) {
            Jedi.getEditor().getToolkit().beep();
            return;
        }
        if (this.dialog == null) {
            this.dialog = new CopyDialog();
            Prefs.add("Editor.Action_CopyPackage.Dialog", this.dialog);
        }
        if (!this.dialog.request()) {
            return;
        }
        Jedi.getEditor().makeNewPackage(this.dialog.getPackageName(), package_);
    }

    class CopyDialog
    extends Dialog {
        boolean answer = false;
        OkCancelButtons buttons = new OkCancelButtons();
        TextField packagename = new TextField();

        public CopyDialog() {
            super(Jedi.getEditor(), EditorFrame.GRS("Action_CopyPackage.DialogTitle"));
            this.buttons.setShowSeparator(false);
            this.buttons.addHelpButton("copy_package");
            this.buttons.addActionListener(new ActionListener(this){
                private final /* synthetic */ CopyDialog this$1;
                {
                    this.this$1 = copyDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.this$1.buttons.get() == 0) {
                        this.this$1.ok();
                    } else {
                        this.this$1.cancel();
                    }
                }
            });
            this.packagename.addActionListener(new ActionListener(this){
                private final /* synthetic */ CopyDialog this$1;
                {
                    this.this$1 = copyDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.ok();
                }
            });
            YFramePanel yFramePanel = new YFramePanel();
            yFramePanel.add(this.createOptionPanel());
            yFramePanel.addStrut();
            yFramePanel.add(this.buttons);
            this.setContentPane(yFramePanel);
            this.pack();
        }

        void cancel() {
            this.answer = false;
            this.setVisible(false);
        }

        private Panel createOptionPanel() {
            Panel panel = new Panel(new GridBagLayout());
            panel.setBorder(BorderFactory.createTitledBorder(EditorFrame.GRS("Action_CopyPackage.Title")));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(Prefs.getObjectSpace(), Prefs.getObjectSpace(), Prefs.getObjectSpace(), Prefs.getObjectSpace());
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            panel.add((Component)new Label(EditorFrame.GRS("Action_CopyPackage.Label1"), 2), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            panel.add((Component)this.packagename, gridBagConstraints);
            return panel;
        }

        public String getPackageName() {
            return this.packagename.getText();
        }

        void ok() {
            if (!StringCheckers.getJavaPackageChecker().accept(this.packagename.getText())) {
                this.getToolkit().beep();
                this.packagename.requestFocus();
                return;
            }
            this.answer = true;
            this.setVisible(false);
        }

        public boolean request() {
            this.answer = false;
            this.packagename.setText(Jedi.getEditor().getCurrentPackage().getName());
            this.setVisible(true);
            return this.answer;
        }

        public void setVisible(boolean bl) {
            if (bl) {
                this.packagename.requestFocus();
            }
            super.setVisible(bl);
        }
    }
}

