/*
 * Decompiled with CFR 0.152.
 */
package jedi.editor;

import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.text.Document;
import jedi.Jedi;
import jedi.ds.Class;
import jedi.ds.ClassPrefsFrame;
import jedi.ds.Method;
import jedi.ds.MethodPrefsFrame;
import jedi.ds.Package;
import jedi.editor.EditorFrame;
import jreqtools.JReqTools;
import swing.addon.Button;
import swing.addon.ButtonGroup;
import swing.addon.CheckBox;
import swing.addon.ComboBox;
import swing.addon.EditableListview;
import swing.addon.Frame;
import swing.addon.GUISystem;
import swing.addon.Label;
import swing.addon.NButtons;
import swing.addon.Prefs;
import swing.addon.Separator;
import swing.addon.Strut;
import swing.addon.Table;
import swing.addon.TextEditor;
import swing.addon.TextField;
import swing.addon.YFramePanel;

public class Action_Search
extends AbstractAction
implements ListSelectionListener {
    private final Integer METHOD_BODY = new Integer(-1);
    private final Integer METHOD_RESULT = new Integer(-2);
    private final Integer METHOD_PARAMS = new Integer(-3);
    private final Integer METHOD_THROWS = new Integer(-4);
    private final Integer METHOD_JAVADOC = new Integer(-5);
    private final Integer CLASS_EXTENDS = new Integer(-6);
    private final Integer CLASS_IMPLEMENTS = new Integer(-7);
    private final Integer CLASS_IMPORT = new Integer(-8);
    private final Integer CLASS_VARIABLES = new Integer(-9);
    private final Integer CLASS_JAVADOC = new Integer(-10);
    private final Integer PACKAGE_RESOURCES = new Integer(-11);
    EditorFrame editor = null;
    Object lastSelectedComponent = null;
    int lastSelectedIndex1 = 0;
    int lastSelectedIndex2 = 0;
    Frame frame = null;
    ComboBox search = null;
    ComboBox replace = null;
    CheckBox forward = null;
    CheckBox backward = null;
    CheckBox sensitive = null;
    Button searchproject = null;
    Button searchpackage = null;
    Button searchclass = null;
    Table table = null;
    NButtons buttons = null;

    public Action_Search() {
        super("search");
        this.putValue("ShortDescription", EditorFrame.GRS("Action_Search.Description"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Object object2 = object = actionEvent == null ? this : actionEvent.getSource();
        if (object == this.search) {
            this.editor.setBusy(true);
            String string = (String)this.search.getSelectedItem();
            this.table.clear();
            this.searchMethod(this.editor.listviews.currentMethod, string, this.sensitive.isSelected());
            int n = this.search.getItemCount();
            this.editor.setBusy(false);
            int n2 = 0;
            while (n2 < n) {
                if (this.search.getItemAt(n2).equals(string)) {
                    return;
                }
                ++n2;
            }
            this.search.addItem(string);
        } else if (object == this.replace) {
            String string = (String)this.replace.getSelectedItem();
            int n = this.replace.getItemCount();
            int n3 = 0;
            while (n3 < n) {
                if (this.replace.getItemAt(n3).equals(string)) {
                    return;
                }
                ++n3;
            }
            this.replace.addItem(string);
        } else if (object == this.searchclass) {
            this.frame.setBusy(true);
            this.searchClass((String)this.search.getSelectedItem());
            this.frame.setBusy(false);
        } else if (object == this.searchpackage) {
            this.frame.setBusy(true);
            this.searchPackage((String)this.search.getSelectedItem());
            this.frame.setBusy(false);
        } else if (object == this.searchproject) {
            this.frame.setBusy(true);
            this.searchProject((String)this.search.getSelectedItem());
            this.frame.setBusy(false);
        } else if (object == this.buttons) {
            switch (this.buttons.get()) {
                case 0: {
                    this.frame.setVisible(false);
                    break;
                }
                case 1: {
                    this.search((String)this.search.getSelectedItem());
                    break;
                }
                case 2: {
                    this.replace((String)this.replace.getSelectedItem());
                }
            }
        } else if (object != this) {
            if (this.editor == null) {
                this.editor = Jedi.getEditor();
            }
            if (!this.editor.tabbedPane.methodeditor.isEnabled()) {
                this.editor.getToolkit().beep();
                return;
            }
            if (this.frame == null) {
                this.createFrame();
            }
            this.frame.setVisible(true);
        }
    }

    private void createFrame() {
        this.frame = new Frame(EditorFrame.GRS("Action_Search.Frame.Title"));
        this.search = new ComboBox();
        this.replace = new ComboBox();
        this.forward = new CheckBox(EditorFrame.GRS("Action_Search.Frame.CheckBox1"));
        this.backward = new CheckBox(EditorFrame.GRS("Action_Search.Frame.CheckBox2"));
        this.sensitive = new CheckBox(EditorFrame.GRS("Action_Search.Frame.CheckBox3"));
        this.searchproject = new Button(EditorFrame.GRS("Action_Search.Frame.Button1"));
        this.searchpackage = new Button(EditorFrame.GRS("Action_Search.Frame.Button2"));
        this.searchclass = new Button(EditorFrame.GRS("Action_Search.Frame.Button3"));
        this.table = new Table(new String[]{EditorFrame.GRS("Action_Search.Frame.Table.1"), EditorFrame.GRS("Action_Search.Frame.Table.2"), EditorFrame.GRS("Action_Search.Frame.Table.3"), EditorFrame.GRS("Action_Search.Frame.Table.4")});
        this.buttons = new NButtons(new String[]{EditorFrame.GRS("Action_Search.Frame.NButtons.1"), EditorFrame.GRS("Action_Search.Frame.NButtons.2"), EditorFrame.GRS("Action_Search.Frame.NButtons.3")});
        this.table.setPreferredWidthForColumn(0, 50);
        this.table.setPreferredWidthForColumn(1, 50);
        this.table.setPreferredWidthForColumn(2, 50);
        this.table.setPreferredWidthForColumn(3, 200);
        this.search.setEditable(true);
        this.replace.setEditable(true);
        this.forward.setSelected(true);
        this.backward.setSelected(false);
        this.buttons.getComponentNumber(0).setIcon(Prefs.getIcon("dismiss"));
        this.buttons.getComponentNumber(1).setIcon(Prefs.getIcon("ok"));
        this.buttons.getComponentNumber(2).setIcon(Prefs.getIcon("apply"));
        this.buttons.addHelpButton("search");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.forward);
        buttonGroup.add(this.backward);
        this.table.addListSelectionListener(this);
        this.search.addActionListener(this);
        this.replace.addActionListener(this);
        this.searchclass.addActionListener(this);
        this.searchpackage.addActionListener(this);
        this.searchproject.addActionListener(this);
        this.buttons.addActionListener(this);
        Box box = Box.createHorizontalBox();
        box.add(this.forward);
        box.add(Box.createHorizontalGlue());
        box.add(this.backward);
        box.add(Box.createHorizontalGlue());
        box.add(this.sensitive);
        Box box2 = Box.createHorizontalBox();
        box2.add(this.searchproject);
        box2.add(Box.createHorizontalGlue());
        box2.add(this.searchpackage);
        box2.add(Box.createHorizontalGlue());
        box2.add(this.searchclass);
        YFramePanel yFramePanel = new YFramePanel();
        yFramePanel.add(new Label(EditorFrame.GRS("Action_Search.Frame.Label1")));
        yFramePanel.add(this.search);
        yFramePanel.add(new Strut());
        yFramePanel.add(new Label(EditorFrame.GRS("Action_Search.Frame.Label2")));
        yFramePanel.add(this.replace);
        yFramePanel.add(new Strut());
        yFramePanel.add(new Separator());
        yFramePanel.add(new Strut());
        yFramePanel.add(box);
        yFramePanel.add(new Strut());
        yFramePanel.add(new Separator());
        yFramePanel.add(new Strut());
        yFramePanel.add(box2);
        yFramePanel.add(new Strut());
        yFramePanel.add(this.table);
        yFramePanel.add(new Strut());
        yFramePanel.add(this.buttons);
        this.frame.setContentPane(yFramePanel);
        this.frame.pack();
        Prefs.add("SearchFrame", this.frame);
    }

    private String getLine(String string, int n) {
        int n2;
        int n3 = string.indexOf(10, n);
        if (n3 == -1) {
            n3 = n;
        }
        if ((n2 = string.lastIndexOf(10, n)) == -1) {
            n2 = 0;
        }
        return string.substring(n2, n3).replace('\t', ' ').trim();
    }

    void replace(String string) {
        if (string == null) {
            string = "";
        }
        if (this.lastSelectedComponent == null) {
            this.editor.getToolkit().beep();
            return;
        }
        if (this.lastSelectedComponent instanceof TextEditor) {
            if (((TextEditor)this.lastSelectedComponent).getSelectedText() == null) {
                this.editor.getToolkit().beep();
                return;
            }
            ((TextEditor)this.lastSelectedComponent).replaceSelection(string);
        } else if (this.lastSelectedComponent instanceof TextField) {
            ((TextField)this.lastSelectedComponent).select(this.lastSelectedIndex1, this.lastSelectedIndex2);
            ((TextField)this.lastSelectedComponent).replaceSelection(string);
        } else if (this.lastSelectedComponent instanceof EditableListview) {
            TextField textField = ((EditableListview)this.lastSelectedComponent).getTextField();
            textField.select(this.lastSelectedIndex1, this.lastSelectedIndex2);
            textField.replaceSelection(string);
            ((EditableListview)this.lastSelectedComponent).changeSelectedItem(textField.getText());
        } else {
            GUISystem.err.println("BrowserWindow.SearchActrion.replace(): internal error");
        }
    }

    void search(String string) {
        this.lastSelectedComponent = null;
        if (string == null || string.equals("")) {
            this.editor.getToolkit().beep();
            return;
        }
        if (!this.sensitive.isSelected()) {
            string = string.toUpperCase();
        }
        this.editor.tabbedPane.setSelectedIndex(4);
        try {
            int n = this.editor.tabbedPane.methodeditor.getCaretPosition();
            Document document = this.editor.tabbedPane.methodeditor.getDocument();
            if (this.forward.isSelected()) {
                int n2;
                String string2 = document.getText(n, document.getLength() - n);
                if (!this.sensitive.isSelected()) {
                    string2 = string2.toUpperCase();
                }
                if ((n2 = string2.indexOf(string)) != -1) {
                    this.editor.tabbedPane.methodeditor.setCaretPosition(n + n2 + string.length());
                    this.editor.tabbedPane.methodeditor.select(n + n2, n + n2 + string.length());
                } else {
                    this.editor.getToolkit().beep();
                    this.backward.setSelected(true);
                }
            } else {
                int n3;
                int n4 = this.editor.tabbedPane.methodeditor.getSelectionStart();
                if (n4 == 0) {
                    this.editor.getToolkit().beep();
                    this.forward.setSelected(true);
                    return;
                }
                if (n4 != 0) {
                    n = n4;
                }
                String string3 = document.getText(0, n);
                if (!this.sensitive.isSelected()) {
                    string3 = string3.toUpperCase();
                }
                if ((n3 = string3.lastIndexOf(string)) != -1) {
                    this.editor.tabbedPane.methodeditor.setCaretPosition(n3 + string.length());
                    this.editor.tabbedPane.methodeditor.select(n3, n3 + string.length());
                } else {
                    this.editor.getToolkit().beep();
                    this.forward.setSelected(true);
                }
            }
        }
        catch (Throwable throwable) {
            JReqTools.showException(Jedi.getEditor(), throwable);
        }
    }

    void searchClass(String string) {
        this.lastSelectedComponent = null;
        if (this.editor.listviews.currentClass == null || string == null || string.equals("")) {
            this.editor.getToolkit().beep();
            return;
        }
        this.table.clear();
        this.searchClass(this.editor.listviews.currentClass, string, this.sensitive.isSelected());
    }

    private void searchClass(Class clazz, String string, boolean bl) {
        int n;
        Object[] objectArray;
        this.lastSelectedComponent = null;
        int n2 = 0;
        String string2 = string;
        if (!bl) {
            string2 = string2.toUpperCase();
        }
        Object object = clazz.getExtends();
        if (!bl) {
            object = ((String)object).toUpperCase();
        }
        if ((n2 = ((String)object).indexOf(string2)) != -1) {
            this.table.addItem(new Object[]{clazz.getParent(), clazz, null, EditorFrame.GRS("Action_Search.Extends"), this.CLASS_EXTENDS, new Integer(n2), new Integer(n2 + string2.length())});
        }
        object = clazz.getImplements();
        if (!bl) {
            object = ((String)object).toUpperCase();
        }
        if ((n2 = ((String)object).indexOf(string2)) != -1) {
            this.table.addItem(new Object[]{clazz.getParent(), clazz, null, EditorFrame.GRS("Action_Search.Implements"), this.CLASS_IMPLEMENTS, new Integer(n2), new Integer(n2 + string2.length())});
        }
        object = clazz.getVariablesAsPlainText();
        String string3 = object;
        n2 = 0;
        if (!bl) {
            object = ((String)object).toUpperCase();
        }
        while ((n2 = ((String)object).indexOf(string2, n2)) != -1) {
            this.table.addItem(new Object[]{clazz.getParent(), clazz, null, this.getLine(string3, n2), this.CLASS_VARIABLES, new Integer(n2), new Integer(n2 + string2.length())});
            n2 += string2.length();
        }
        object = clazz.getJavaDocAsPlainText();
        string3 = object;
        n2 = 0;
        if (!bl) {
            object = ((String)object).toUpperCase();
        }
        while ((n2 = ((String)object).indexOf(string2, n2)) != -1) {
            this.table.addItem(new Object[]{clazz.getParent(), clazz, null, this.getLine(string3, n2), this.CLASS_JAVADOC, new Integer(n2), new Integer(n2 + string2.length())});
            n2 += string2.length();
        }
        if (!clazz.isInnerClass()) {
            objectArray = clazz.getImports();
            n = 0;
            while (n < objectArray.length) {
                object = objectArray[n];
                if (!bl) {
                    object = ((String)object).toUpperCase();
                }
                if ((n2 = ((String)object).indexOf(string2)) != -1) {
                    this.table.addItem(new Object[]{clazz.getParent(), clazz, null, EditorFrame.GRS("Action_Search.Imported"), this.CLASS_IMPORT, new Integer(n), new Integer(n2), new Integer(n2 + string2.length())});
                }
                ++n;
            }
        }
        objectArray = clazz.getMethods();
        n = 0;
        while (n < objectArray.length) {
            this.searchMethod((Method)objectArray[n], string, bl);
            ++n;
        }
    }

    private void searchMethod(Method method, String string, boolean bl) {
        this.lastSelectedComponent = null;
        String string2 = method.getBodyAsPlainText();
        String string3 = string;
        String string4 = string2;
        if (!bl) {
            string3 = string3.toUpperCase();
            string4 = string4.toUpperCase();
        }
        int n = 0;
        while ((n = string4.indexOf(string3, n)) != -1) {
            this.table.addItem(new Object[]{method.getParent().getParent(), method.getParent(), method, this.getLine(string2, n += string3.length()), this.METHOD_BODY, new Integer(n - string3.length()), new Integer(n)});
        }
        string2 = string4 = method.getJavaDocAsPlainText();
        n = 0;
        if (!bl) {
            string4 = string4.toUpperCase();
        }
        while ((n = string4.indexOf(string3, n)) != -1) {
            this.table.addItem(new Object[]{method.getParent().getParent(), method.getParent(), method, this.getLine(string2, n), this.METHOD_JAVADOC, new Integer(n), new Integer(n + string3.length())});
            n += string3.length();
        }
        string4 = method.getResultType();
        if (!bl) {
            string4 = string4.toUpperCase();
        }
        if ((n = string4.indexOf(string3)) != -1) {
            this.table.addItem(new Object[]{method.getParent().getParent(), method.getParent(), method, EditorFrame.GRS("Action_Search.ResultType"), this.METHOD_RESULT, new Integer(n), new Integer(n + string3.length())});
        }
        String[] stringArray = method.getParameters();
        int n2 = 0;
        while (n2 < stringArray.length) {
            string4 = stringArray[n2];
            if (!bl) {
                string4 = string4.toUpperCase();
            }
            if ((n = string4.indexOf(string3)) != -1) {
                this.table.addItem(new Object[]{method.getParent().getParent(), method.getParent(), method, EditorFrame.GRS("Action_Search.ParameterList"), this.METHOD_PARAMS, new Integer(n2), new Integer(n), new Integer(n + string3.length())});
            }
            ++n2;
        }
        stringArray = method.getThrows();
        int n3 = 0;
        while (n3 < stringArray.length) {
            string4 = stringArray[n3];
            if (!bl) {
                string4 = string4.toUpperCase();
            }
            if ((n = string4.indexOf(string3)) != -1) {
                this.table.addItem(new Object[]{method.getParent().getParent(), method.getParent(), method, EditorFrame.GRS("Action_Search.ThrowsList"), this.METHOD_THROWS, new Integer(n3), new Integer(n), new Integer(n + string3.length())});
            }
            ++n3;
        }
    }

    void searchPackage(String string) {
        this.lastSelectedComponent = null;
        if (this.editor.listviews.currentPackage == null || string == null || string.equals("")) {
            this.editor.getToolkit().beep();
            return;
        }
        this.table.clear();
        Vector vector = this.editor.listviews.currentPackage.getClasses();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            this.searchClass((Class)vector.elementAt(n2), string, this.sensitive.isSelected());
            ++n2;
        }
    }

    void searchProject(String string) {
        this.lastSelectedComponent = null;
        if (this.editor.project == null || string == null || string.equals("")) {
            this.editor.getToolkit().beep();
            return;
        }
        this.table.clear();
        Package[] packageArray = this.editor.project.getPackages();
        int n = 0;
        while (n < packageArray.length) {
            Vector vector = packageArray[n].getClasses();
            int n2 = vector.size();
            int n3 = 0;
            while (n3 < n2) {
                this.searchClass((Class)vector.elementAt(n3), string, this.sensitive.isSelected());
                ++n3;
            }
            ++n;
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        int n = this.table.getSelectedRow();
        if (n == -1) {
            return;
        }
        TableModel tableModel = this.table.getModel();
        if (n >= tableModel.getRowCount()) {
            return;
        }
        Package package_ = (Package)tableModel.getValueAt(n, 0);
        Class clazz = (Class)tableModel.getValueAt(n, 1);
        Method method = (Method)tableModel.getValueAt(n, 2);
        Integer n2 = (Integer)tableModel.getValueAt(n, 4);
        if (n2 == this.METHOD_BODY) {
            int n3 = (Integer)tableModel.getValueAt(n, 5);
            int n4 = (Integer)tableModel.getValueAt(n, 6);
            if (package_ != this.editor.listviews.currentPackage) {
                this.editor.setPackage(package_);
            }
            if (clazz != this.editor.listviews.currentClass) {
                this.editor.setClass(clazz);
            }
            if (method != this.editor.listviews.currentMethod) {
                this.editor.setMethod(method);
            }
            this.editor.tabbedPane.setSelectedIndex(4);
            this.editor.tabbedPane.methodeditor.setCaretPosition(n3);
            this.editor.tabbedPane.methodeditor.select(n3, n4);
            this.lastSelectedComponent = this.editor.tabbedPane.methodeditor;
        } else if (n2 == this.METHOD_JAVADOC) {
            int n5 = (Integer)tableModel.getValueAt(n, 5);
            int n6 = (Integer)tableModel.getValueAt(n, 6);
            if (package_ != this.editor.listviews.currentPackage) {
                this.editor.setPackage(package_);
            }
            if (clazz != this.editor.listviews.currentClass) {
                this.editor.setClass(clazz);
            }
            if (method != this.editor.listviews.currentMethod) {
                this.editor.setMethod(method);
            }
            this.editor.tabbedPane.setSelectedIndex(5);
            this.editor.tabbedPane.methoddoceditor.setCaretPosition(n5);
            this.editor.tabbedPane.methoddoceditor.select(n5, n6);
            this.lastSelectedComponent = this.editor.tabbedPane.methoddoceditor;
        } else if (n2 == this.METHOD_RESULT) {
            this.lastSelectedIndex1 = (Integer)tableModel.getValueAt(n, 5);
            this.lastSelectedIndex2 = (Integer)tableModel.getValueAt(n, 6);
            MethodPrefsFrame methodPrefsFrame = method.editPrefs();
            methodPrefsFrame.te_result.setCaretPosition(this.lastSelectedIndex1);
            methodPrefsFrame.te_result.select(this.lastSelectedIndex1, this.lastSelectedIndex1);
            methodPrefsFrame.te_result.requestFocus();
            this.lastSelectedComponent = methodPrefsFrame.te_result;
        } else if (n2 == this.METHOD_PARAMS) {
            int n7 = (Integer)tableModel.getValueAt(n, 5);
            this.lastSelectedIndex1 = (Integer)tableModel.getValueAt(n, 6);
            this.lastSelectedIndex2 = (Integer)tableModel.getValueAt(n, 7);
            MethodPrefsFrame methodPrefsFrame = method.editPrefs();
            methodPrefsFrame.lv_parameters.setSelectedIndex(n7);
            methodPrefsFrame.lv_parameters.getTextField().setCaretPosition(this.lastSelectedIndex1);
            methodPrefsFrame.lv_parameters.getTextField().select(this.lastSelectedIndex1, this.lastSelectedIndex2);
            methodPrefsFrame.lv_parameters.getTextField().requestFocus();
            this.lastSelectedComponent = methodPrefsFrame.lv_parameters;
        } else if (n2 == this.METHOD_THROWS) {
            int n8 = (Integer)tableModel.getValueAt(n, 5);
            this.lastSelectedIndex1 = (Integer)tableModel.getValueAt(n, 6);
            this.lastSelectedIndex2 = (Integer)tableModel.getValueAt(n, 7);
            MethodPrefsFrame methodPrefsFrame = method.editPrefs();
            methodPrefsFrame.lv_throws.setSelectedIndex(n8);
            methodPrefsFrame.lv_throws.getTextField().setCaretPosition(this.lastSelectedIndex1);
            methodPrefsFrame.lv_throws.getTextField().select(this.lastSelectedIndex1, this.lastSelectedIndex2);
            methodPrefsFrame.lv_throws.getTextField().requestFocus();
            this.lastSelectedComponent = methodPrefsFrame.lv_throws;
        } else if (n2 == this.CLASS_EXTENDS) {
            this.lastSelectedIndex1 = (Integer)tableModel.getValueAt(n, 5);
            this.lastSelectedIndex2 = (Integer)tableModel.getValueAt(n, 6);
            ClassPrefsFrame classPrefsFrame = clazz.editPrefs();
            classPrefsFrame.te_extends.setCaretPosition(this.lastSelectedIndex1);
            classPrefsFrame.te_extends.select(this.lastSelectedIndex1, this.lastSelectedIndex2);
            classPrefsFrame.te_extends.requestFocus();
            this.lastSelectedComponent = classPrefsFrame.te_extends;
        } else if (n2 == this.CLASS_IMPLEMENTS) {
            this.lastSelectedIndex1 = (Integer)tableModel.getValueAt(n, 5);
            this.lastSelectedIndex2 = (Integer)tableModel.getValueAt(n, 6);
            ClassPrefsFrame classPrefsFrame = clazz.editPrefs();
            classPrefsFrame.te_implements.setCaretPosition(this.lastSelectedIndex1);
            classPrefsFrame.te_implements.select(this.lastSelectedIndex1, this.lastSelectedIndex2);
            classPrefsFrame.te_implements.requestFocus();
            this.lastSelectedComponent = classPrefsFrame.te_implements;
        } else if (n2 == this.CLASS_IMPORT) {
            int n9 = (Integer)tableModel.getValueAt(n, 5);
            this.lastSelectedIndex1 = (Integer)tableModel.getValueAt(n, 6);
            this.lastSelectedIndex2 = (Integer)tableModel.getValueAt(n, 7);
            ClassPrefsFrame classPrefsFrame = clazz.editPrefs();
            classPrefsFrame.lv_import.setSelectedIndex(n9);
            classPrefsFrame.lv_import.getTextField().setCaretPosition(this.lastSelectedIndex1);
            classPrefsFrame.lv_import.getTextField().select(this.lastSelectedIndex1, this.lastSelectedIndex2);
            classPrefsFrame.lv_import.getTextField().requestFocus();
            this.lastSelectedComponent = classPrefsFrame.lv_import;
        } else if (n2 == this.CLASS_VARIABLES) {
            int n10 = (Integer)tableModel.getValueAt(n, 5);
            int n11 = (Integer)tableModel.getValueAt(n, 6);
            if (package_ != this.editor.listviews.currentPackage) {
                this.editor.setPackage(package_);
            }
            if (clazz != this.editor.listviews.currentClass) {
                this.editor.setClass(clazz);
            }
            this.editor.tabbedPane.setSelectedIndex(2);
            this.editor.tabbedPane.classeditor.setCaretPosition(n10);
            this.editor.tabbedPane.classeditor.select(n10, n11);
            this.lastSelectedComponent = this.editor.tabbedPane.classeditor;
        } else if (n2 == this.CLASS_JAVADOC) {
            int n12 = (Integer)tableModel.getValueAt(n, 5);
            int n13 = (Integer)tableModel.getValueAt(n, 6);
            if (package_ != this.editor.listviews.currentPackage) {
                this.editor.setPackage(package_);
            }
            if (clazz != this.editor.listviews.currentClass) {
                this.editor.setClass(clazz);
            }
            this.editor.tabbedPane.setSelectedIndex(3);
            this.editor.tabbedPane.classdoceditor.setCaretPosition(n12);
            this.editor.tabbedPane.classdoceditor.select(n12, n13);
            this.lastSelectedComponent = this.editor.tabbedPane.classdoceditor;
        } else {
            GUISystem.err.println("BrowserWindow.SearchAction.valueChanged(): internal error -> encountered an unknown Integer(" + n2 + ")");
        }
    }
}

