/*
 * Decompiled with CFR 0.152.
 */
package jedi.editor;

import java.awt.Component;
import java.awt.event.WindowListener;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.text.EditorKit;
import jedi.Jedi;
import jedi.ds.Class;
import jedi.ds.CompileError;
import jedi.ds.Method;
import jedi.ds.Package;
import jedi.ds.Project;
import jedi.editor.EditorFrame_Listviews;
import jedi.editor.EditorFrame_MenuBar;
import jedi.editor.EditorFrame_TabbedPane;
import jedi.event.ClassEvent;
import jedi.event.ClassListener;
import jedi.event.MethodEvent;
import jedi.event.MethodListener;
import jedi.event.PackageEvent;
import jedi.event.PackageListener;
import jedi.event.ProjectEvent;
import jedi.event.ProjectListener;
import jedi.pluginmanager.PluginManager;
import jreqtools.JReqTools;
import swing.addon.Frame;
import swing.addon.GUISystem;
import swing.addon.JavaEditor;
import swing.addon.Menu;
import swing.addon.Prefs;
import swing.addon.SplitPane;
import swing.addon.TabbedPane;
import swing.addon.TextEditor;
import swing.addon.ToolBar;
import swing.addon.YFramePanel;
import swing.addon.text.UndoableDocument;

public class EditorFrame
extends Frame {
    private static final boolean DEBUG = false;
    static final ResourceBundle resources = ResourceBundle.getBundle("jedi.editor.resources.editor");
    public static final int PACKAGE_RESOURCES = 0;
    public static final int PACKAGE_ICONS = 1;
    public static final int CLASS_VARIABLES = 2;
    public static final int CLASS_JAVADOC = 3;
    public static final int METHOD_BODY = 4;
    public static final int METHOD_JAVADOC = 5;
    private static final int PROJECT_CHANGED = 100;
    private static final int PACKAGE_CHANGED = 101;
    private static final int CLASS_CHANGED = 102;
    private static final int METHOD_CHANGED = 103;
    final Vector projectListeners = new Vector();
    final Vector packageListeners = new Vector();
    final Vector classListeners = new Vector();
    final Vector methodListeners = new Vector();
    final UndoableDocument emptyDoc = new UndoableDocument();
    final EditorFrame_MenuBar menubar = new EditorFrame_MenuBar();
    final EditorFrame_Listviews listviews = new EditorFrame_Listviews(this);
    final EditorFrame_TabbedPane tabbedPane = new EditorFrame_TabbedPane(this);
    final SplitPane splitPane = new SplitPane(0);
    Project project = null;

    public EditorFrame() {
        super(EditorFrame.GRS("Title1"));
        Prefs.setInitializerMessage(EditorFrame.GRS("Initializing"));
        this.splitPane.setBorder(BorderFactory.createEmptyBorder());
        this.splitPane.setTopComponent(this.listviews);
        this.splitPane.setBottomComponent(this.tabbedPane);
        YFramePanel yFramePanel = new YFramePanel();
        yFramePanel.add(this.splitPane);
        this.setMenuBar(this.menubar);
        this.setContentPane(yFramePanel);
        this.addWindowListener((WindowListener)((Object)Jedi.getAction("jedi-quit")));
        this.setDefaultCloseOperation(0);
        this.pack();
        Prefs.add("BrowserWindow", this);
        Prefs.add("BrowserWindow.SplitPanel", this.splitPane);
        Prefs.add("BrowserWindow.TabbedPane", this.tabbedPane);
    }

    static final String GRS(String string) {
        try {
            return resources.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            JReqTools.showMessage(missingResourceException.getLocalizedMessage() + ":\n\n'" + string + "'");
            return "MISSING RESOURCE: " + string;
        }
    }

    static final String GRS(String string, String string2) {
        String string3 = EditorFrame.GRS(string);
        try {
            string3 = MessageFormat.format(string3, string2);
        }
        catch (Exception exception) {
            JReqTools.showException(exception);
        }
        return string3;
    }

    public void addClassListener(ClassListener classListener) {
        this.classListeners.addElement(classListener);
    }

    public Method addMethod(String string) {
        if (this.listviews.currentClass == null) {
            return null;
        }
        return this.makeNewMethod(string, null);
    }

    public void addMethodListener(MethodListener methodListener) {
        this.methodListeners.addElement(methodListener);
    }

    public void addPackageListener(PackageListener packageListener) {
        this.packageListeners.addElement(packageListener);
    }

    public void addPluginActions() {
        JavaEditor javaEditor = this.tabbedPane.classeditor;
        Jedi.getPluginManager();
        javaEditor.addActions(PluginManager.getPluginsAsActions());
        TextEditor textEditor = this.tabbedPane.classdoceditor;
        Jedi.getPluginManager();
        textEditor.addActions(PluginManager.getPluginsAsActions());
        JavaEditor javaEditor2 = this.tabbedPane.methodeditor;
        Jedi.getPluginManager();
        javaEditor2.addActions(PluginManager.getPluginsAsActions());
        TextEditor textEditor2 = this.tabbedPane.methoddoceditor;
        Jedi.getPluginManager();
        textEditor2.addActions(PluginManager.getPluginsAsActions());
    }

    public void addProjectListener(ProjectListener projectListener) {
        this.projectListeners.addElement(projectListener);
    }

    public void classModified(Class clazz) {
        if (clazz != null && clazz == this.listviews.currentClass) {
            this.setClass(clazz);
        }
    }

    public synchronized Class getCurrentClass() {
        return this.listviews.currentClass;
    }

    public synchronized Method getCurrentMethod() {
        return this.listviews.currentMethod;
    }

    public synchronized Package getCurrentPackage() {
        return this.listviews.currentPackage;
    }

    public JavaEditor getEditor() {
        return this.tabbedPane.methodeditor;
    }

    public EditorKit getEditorKit() {
        return this.tabbedPane.methodeditor.getEditorKit();
    }

    public Menu getPluginMenu() {
        return this.menubar.mn_plugins;
    }

    public synchronized Project getProject() {
        return this.project;
    }

    public TabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public ToolBar getToolBar() {
        return this.tabbedPane.methodeditor.getToolBar();
    }

    public synchronized Class makeNewClass(String string, Class clazz) {
        return this.makeNewInterfaceOrClass(string, 1, clazz);
    }

    public synchronized Method makeNewConstructor(Method method) {
        Method method2 = this.listviews.currentClass.add(".Constructor", 2);
        if (method != null) {
            method2.setDataFrom(method);
        }
        this.listviews.methods.setElements(this.listviews.currentClass.getMethods());
        this.setMethod(method2);
        return method2;
    }

    public synchronized Method makeNewInitializer(Method method) {
        Method method2 = this.listviews.currentClass.add(".StaticInitializer", 3);
        if (method != null) {
            method2.setDataFrom(method);
        }
        this.listviews.methods.setElements(this.listviews.currentClass.getMethods());
        this.setMethod(method2);
        return method2;
    }

    public synchronized Class makeNewInnerClass(Class clazz, String string) {
        return this.makeNewInnerInterfaceOrClass(clazz, string, 1);
    }

    public synchronized Class makeNewInnerInterface(Class clazz, String string) {
        return this.makeNewInnerInterfaceOrClass(clazz, string, 2);
    }

    private Class makeNewInnerInterfaceOrClass(Class clazz, String string, int n) {
        Class clazz2 = clazz.addInnerClass(string, n);
        this.listviews.classes.setElements(this.listviews.currentPackage.getClasses());
        this.setClass(clazz2);
        return clazz2;
    }

    public synchronized Class makeNewInterface(String string, Class clazz) {
        return this.makeNewInterfaceOrClass(string, 2, clazz);
    }

    private Class makeNewInterfaceOrClass(String string, int n, Class clazz) {
        Object object;
        Object object2;
        Class clazz2 = null;
        if (string.indexOf(46) != -1) {
            object2 = new StringTokenizer(string, ".");
            clazz2 = this.listviews.currentPackage.add(((StringTokenizer)object2).nextToken(), 1);
            while (((StringTokenizer)object2).hasMoreTokens()) {
                object = ((StringTokenizer)object2).nextToken();
                clazz2 = clazz2.addInnerClass((String)object, ((StringTokenizer)object2).hasMoreTokens() ? 1 : n);
            }
        } else {
            clazz2 = this.listviews.currentPackage.add(string, n);
        }
        if (clazz2 == clazz) {
            GUISystem.err.println(EditorFrame.GRS("Error1"));
            return clazz2;
        }
        object2 = clazz2;
        object = clazz;
        while (((Class)object2).getParentClass() != null) {
            object2 = ((Class)object2).getParentClass();
        }
        if (object != null) {
            while (((Class)object).getParentClass() != null) {
                object = ((Class)object).getParentClass();
            }
        }
        if (object2 == object) {
            GUISystem.err.println(EditorFrame.GRS("Error2"));
        }
        if (clazz != null && object2 != object) {
            clazz2.setDataFrom(clazz);
        }
        this.listviews.classes.setElements(this.listviews.currentPackage.getClasses());
        this.setClass(clazz2);
        return clazz2;
    }

    public synchronized Method makeNewMethod(String string, Method method) {
        Method method2 = this.listviews.currentClass.add(string, 1);
        if (method != null) {
            method2.setDataFrom(method);
        }
        this.listviews.methods.setElements(this.listviews.currentClass.getMethods());
        this.setMethod(method2);
        return method2;
    }

    public synchronized Package makeNewPackage(String string, Package package_) {
        Package package_2 = this.project.add(string);
        if (package_2 == package_) {
            GUISystem.err.println(EditorFrame.GRS("Error1"));
            return package_2;
        }
        if (package_ != null) {
            package_2.setDataFrom(package_);
        }
        this.listviews.packages.setElements(this.project.getPackages());
        this.setPackage(package_2);
        return package_2;
    }

    public synchronized void methodModified(Method method) {
        if (method != null && method == this.listviews.currentMethod) {
            this.setMethod(method);
        }
    }

    public synchronized void refreshMethod(Method method) {
        if (method == this.listviews.currentMethod) {
            this.setMethod(method);
        }
        method.refreshPrefsFrame();
    }

    private void sendEvents(int n) {
        switch (n) {
            case 100: {
                Enumeration enumeration = this.projectListeners.elements();
                while (enumeration.hasMoreElements()) {
                    ((ProjectListener)enumeration.nextElement()).projectChanged(new ProjectEvent(this, this.project));
                }
                break;
            }
            case 101: {
                Enumeration enumeration = this.packageListeners.elements();
                while (enumeration.hasMoreElements()) {
                    ((PackageListener)enumeration.nextElement()).packageChanged(new PackageEvent(this, this.listviews.currentPackage));
                }
                break;
            }
            case 102: {
                Enumeration enumeration = this.classListeners.elements();
                while (enumeration.hasMoreElements()) {
                    ((ClassListener)enumeration.nextElement()).classChanged(new ClassEvent(this, this.listviews.currentClass));
                }
                break;
            }
            case 103: {
                Enumeration enumeration = this.methodListeners.elements();
                while (enumeration.hasMoreElements()) {
                    ((MethodListener)enumeration.nextElement()).methodChanged(new MethodEvent(this, this.listviews.currentMethod));
                }
                break;
            }
            default: {
                GUISystem.err.println(this.getClass().getName() + ".sendEvents(): internal error");
            }
        }
    }

    public synchronized void setClass(Class clazz) {
        if (this.listviews.currentClass != null) {
            this.listviews.currentClass.saveChanges();
        }
        this.listviews.classes.setSelectedValue(clazz);
        this.listviews.currentClass = clazz;
        this.listviews.lastClass = clazz;
        this.listviews.doNotListen = true;
        this.sendEvents(102);
        if (clazz != null) {
            UndoableDocument undoableDocument = clazz.getVariablesAsJavaDocument();
            this.tabbedPane.classsignature1.setText(clazz.getSignature());
            this.tabbedPane.classsignature1.setEditable(true);
            this.tabbedPane.classeditor.setDocument(undoableDocument);
            this.tabbedPane.classeditor.setEnabled(true);
            this.tabbedPane.setIconAt(2, undoableDocument.getLength() == 0 ? this.tabbedPane.redDot : this.tabbedPane.greenDot);
            undoableDocument = clazz.getJavaDocAsDocument();
            this.tabbedPane.classsignature2.setText(clazz.getSignature());
            this.tabbedPane.classsignature2.setEditable(true);
            this.tabbedPane.classdoceditor.setDocument(undoableDocument);
            this.tabbedPane.classdoceditor.setEnabled(true);
            this.tabbedPane.setIconAt(3, undoableDocument.getLength() == 0 ? this.tabbedPane.redDot : this.tabbedPane.greenDot);
            this.listviews.methods.setElements(clazz.getMethods());
            if (this.listviews.methods.length() > 0) {
                Method method = clazz.getLastSelectedMethod();
                this.setMethod(method);
            } else {
                this.setMethod(null);
            }
        } else {
            this.tabbedPane.classsignature1.setText("-");
            this.tabbedPane.classsignature1.setEditable(false);
            this.tabbedPane.classeditor.setEnabled(false);
            this.tabbedPane.classeditor.setDocument(this.emptyDoc);
            this.tabbedPane.setIconAt(2, this.tabbedPane.redDot);
            this.tabbedPane.classsignature2.setText("-");
            this.tabbedPane.classsignature2.setEditable(false);
            this.tabbedPane.classdoceditor.setEnabled(false);
            this.tabbedPane.classdoceditor.setDocument(this.emptyDoc);
            this.tabbedPane.setIconAt(3, this.tabbedPane.redDot);
            this.listviews.methods.setElements(new Vector());
            this.setMethod(null);
        }
        this.listviews.doNotListen = false;
    }

    public synchronized void setCompileError(CompileError compileError) {
        Package package_ = compileError.errPackage;
        Class clazz = compileError.errClass;
        Method method = compileError.errMethod;
        if (package_ == null && clazz == null && method == null) {
            GUISystem.err.println("Jedi internal error: Cannot process compiler error \"" + compileError.errText + "\"");
            return;
        }
        if (this.listviews.currentPackage != package_ && package_ != null) {
            this.setPackage(package_);
            this.listviews.packages.setSelectedValue(package_);
        }
        if (this.listviews.currentClass != clazz && clazz != null) {
            this.setClass(clazz);
            this.listviews.classes.setSelectedValue(clazz);
        }
        if (this.listviews.currentMethod != method && method != null) {
            this.setMethod(method);
            this.listviews.methods.setSelectedValue(method);
        }
        switch (compileError.errType) {
            case 1: {
                compileError.errClass.editPrefs();
                break;
            }
            case 2: {
                this.tabbedPane.setSelectedIndex(2);
                break;
            }
            case 3: {
                compileError.errMethod.editPrefs();
                break;
            }
            case 4: {
                this.tabbedPane.setSelectedIndex(4);
                String string = method.getBodyAsPlainText();
                int n = 1;
                int n2 = 0;
                int n3 = string.length();
                int n4 = 0;
                while (n4 < n3) {
                    if (string.charAt(n4) == '\n') {
                        ++n;
                    }
                    ++n2;
                    if (n == compileError.errLine) break;
                    ++n4;
                }
                try {
                    this.tabbedPane.methodeditor.setCaretPosition(n2);
                    if (compileError.errColumn == -1) {
                        n4 = n2;
                        while (n4 < n3 && string.charAt(n4) != '\n') {
                            ++n4;
                        }
                        this.tabbedPane.methodeditor.select(n2, n4);
                        break;
                    }
                    this.tabbedPane.methodeditor.select(n2 + compileError.errColumn, n2 + compileError.errColumn + 1);
                    break;
                }
                catch (Throwable throwable) {
                    GUISystem.err.println("Jedi internal error: " + throwable.getLocalizedMessage());
                }
            }
        }
    }

    public synchronized void setMethod(Method method) {
        if (this.listviews.currentClass != null) {
            this.listviews.currentClass.saveChanges();
        }
        this.listviews.methods.setSelectedValue(method);
        this.listviews.currentMethod = method;
        this.listviews.lastMethod = method;
        this.sendEvents(103);
        if (method != null) {
            this.tabbedPane.methodsignature1.setText(method.getSignature());
            this.tabbedPane.methodsignature2.setText(method.getSignature());
            this.tabbedPane.methodsignature1.setEditable(method.isMethod() || method.isConstructor());
            this.tabbedPane.methodsignature2.setEditable(method.isMethod() || method.isConstructor());
            UndoableDocument undoableDocument = method.getBodyAsJavaDocument();
            this.tabbedPane.methodeditor.setEnabled(!method.isNative() && !method.isAbstract() && !this.listviews.currentClass.isInterface());
            this.tabbedPane.methodeditor.setDocument(undoableDocument);
            this.tabbedPane.setIconAt(4, undoableDocument.getLength() == 0 ? this.tabbedPane.redDot : this.tabbedPane.greenDot);
            undoableDocument = method.getJavaDocAsDocument();
            this.tabbedPane.methoddoceditor.setEnabled(true);
            this.tabbedPane.methoddoceditor.setDocument(undoableDocument);
            this.tabbedPane.setIconAt(5, undoableDocument.getLength() == 0 ? this.tabbedPane.redDot : this.tabbedPane.greenDot);
        } else {
            this.tabbedPane.methodsignature1.setText("-");
            this.tabbedPane.methodsignature2.setText("-");
            this.tabbedPane.methodsignature1.setEditable(false);
            this.tabbedPane.methodsignature2.setEditable(false);
            this.tabbedPane.methodeditor.setEnabled(false);
            this.tabbedPane.methodeditor.setDocument(this.emptyDoc);
            this.tabbedPane.setIconAt(4, this.tabbedPane.redDot);
            this.tabbedPane.methoddoceditor.setEnabled(false);
            this.tabbedPane.methoddoceditor.setDocument(this.emptyDoc);
            this.tabbedPane.setIconAt(5, this.tabbedPane.redDot);
        }
    }

    public synchronized void setPackage(Package package_) {
        this.listviews.packages.setSelectedValue(package_);
        this.listviews.currentPackage = package_;
        this.listviews.lastPackage = null;
        this.listviews.doNotListen = true;
        this.sendEvents(101);
        if (package_ != null) {
            this.tabbedPane.editResource.setDocument(package_.getResource(this.tabbedPane.selectResource.getSelectedIndex()));
            this.tabbedPane.selectResource.setEnabled(true);
            this.tabbedPane.resourceName.setText("Resource Name = '" + package_.getResourceName() + "'");
            this.tabbedPane.setIconAt(0, this.tabbedPane.editResource.getDocument().getLength() == 0 ? this.tabbedPane.redDot : this.tabbedPane.greenDot);
            String[] stringArray = package_.getIcons();
            this.tabbedPane.iconpath.setText("Icon Resource Path = '" + package_.getName() + ".icons'");
            ((Component)this.tabbedPane.icons).setEnabled(true);
            this.tabbedPane.icons.set(stringArray);
            this.tabbedPane.setIconAt(1, stringArray.length == 0 ? this.tabbedPane.redDot : this.tabbedPane.greenDot);
            this.listviews.classes.setElements(package_.getClasses());
            if (this.listviews.classes.length() > 0) {
                Class clazz = package_.getLastSelectedClass();
                this.listviews.classes.setSelectedValue(clazz);
                this.setClass(clazz);
            } else {
                this.setClass(null);
            }
        } else {
            this.tabbedPane.resourceName.setText("-");
            this.tabbedPane.editResource.setDocument(this.emptyDoc);
            this.tabbedPane.selectResource.setEnabled(false);
            this.tabbedPane.setIconAt(0, this.tabbedPane.redDot);
            this.tabbedPane.iconpath.setText("-");
            ((Component)this.tabbedPane.icons).setEnabled(false);
            this.tabbedPane.icons.removeAllItems();
            this.tabbedPane.setIconAt(1, this.tabbedPane.redDot);
            this.listviews.classes.setElements(new Vector());
            this.listviews.methods.setElements(new Vector());
            this.setClass(null);
        }
        this.listviews.doNotListen = false;
    }

    public synchronized void setProject(Project project) {
        this.setBusy(true);
        if (this.project != null) {
            this.project.saveChanges();
        }
        Jedi.setLastProject(project.getName());
        this.project = project;
        this.sendEvents(100);
        this.listviews.currentPackage = null;
        this.listviews.currentClass = null;
        this.listviews.currentMethod = null;
        this.listviews.lastPackage = null;
        this.listviews.lastClass = null;
        this.listviews.lastMethod = null;
        this.setTitle(EditorFrame.GRS("Title2", project.getName()));
        this.listviews.packages.setElements(project.getPackages());
        if (this.listviews.packages.length() > 0) {
            this.listviews.packages.setSelectedIndex(0);
            this.setPackage((Package)this.listviews.packages.getSelectedValue());
        } else {
            this.setPackage(null);
        }
        this.setBusy(false);
    }
}

