/*
 * Decompiled with CFR 0.152.
 */
package jedi.editor;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jedi.Jedi;
import jedi.ds.Class;
import jedi.ds.Method;
import jedi.ds.Package;
import jedi.editor.Action_AddTag;
import jedi.editor.EditorFrame;
import jedi.help.Action_FetchDoc;
import jedi.parser.ASTClassDeclaration;
import jedi.parser.ASTCompilationUnit;
import jedi.parser.ASTConstructorDeclaration;
import jedi.parser.ASTInterfaceDeclaration;
import jedi.parser.ASTMethodDeclaration;
import jedi.parser.ASTNestedClassDeclaration;
import jedi.parser.ASTNestedInterfaceDeclaration;
import jedi.parser.JavaParser;
import jreqtools.JReqTools;
import swing.addon.Button;
import swing.addon.ComboBox;
import swing.addon.EditableListview;
import swing.addon.ImageViewer;
import swing.addon.JavaEditor;
import swing.addon.MenuItem;
import swing.addon.Prefs;
import swing.addon.Strut;
import swing.addon.TabbedPane;
import swing.addon.TextEditor;
import swing.addon.TextField;
import swing.addon.ToolBar;
import swing.addon.XPanel;
import swing.addon.YFramePanel;
import swing.addon.YPanel;
import swing.addon.util.StringArray;
import swing.addon.util.StringInputStream;

final class EditorFrame_TabbedPane
extends TabbedPane
implements ActionListener,
ChangeListener,
MouseListener,
FocusListener {
    EditorFrame editor = null;
    boolean processingEvent = false;
    Icon redDot = Prefs.getIcon("redDot");
    Icon greenDot = Prefs.getIcon("greenDot");
    ComboBox selectResource = new ComboBox(Package.getSupportedLocalesAsDisplayNames()){

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    };
    TextEditor editResource = new TextEditor();
    TextField resourceName = new TextField("");
    EditableListview icons = new EditableListview();
    TextField iconpath = new TextField("");
    MenuItem addItem = new MenuItem(EditorFrame.GRS("TabbedPane.Icons.MenuItem1"));
    ImageViewer imageViewer = new ImageViewer();
    Button addImageLoader = new Button(EditorFrame.GRS("TabbedPane.Icons.Button")){

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    };
    TextField methodsignature1 = new TextField("");
    JavaEditor methodeditor = new JavaEditor();
    TextEditor methoddoceditor = new TextEditor();
    TextField methodsignature2 = new TextField("");
    TextField classsignature1 = new TextField("");
    JavaEditor classeditor = new JavaEditor();
    TextField classsignature2 = new TextField("");
    TextEditor classdoceditor = new TextEditor();

    public EditorFrame_TabbedPane(EditorFrame editorFrame) {
        this.editor = editorFrame;
        this.classeditor.addActions(Jedi.getActions());
        this.classdoceditor.addActions(Jedi.getActions());
        this.methodeditor.addActions(Jedi.getActions());
        this.methoddoceditor.addActions(Jedi.getActions());
        this.resourceName.setEditable(false);
        this.iconpath.setEditable(false);
        this.classsignature1.setFont(Prefs.getLargeFont());
        this.classsignature2.setFont(Prefs.getLargeFont());
        this.methodsignature1.setFont(Prefs.getLargeFont());
        this.methodsignature2.setFont(Prefs.getLargeFont());
        this.resourceName.setFont(Prefs.getLargeFont());
        this.iconpath.setFont(Prefs.getLargeFont());
        this.icons.add(this.addItem);
        this.selectResource.addActionListener(this);
        this.addItem.addActionListener(Jedi.getAction("jedi-add-icon"));
        this.icons.addChangeListener(this);
        this.icons.addMouseListener(this);
        this.methodsignature1.addActionListener(this);
        this.methodsignature2.addActionListener(this);
        this.classsignature1.addActionListener(this);
        this.classsignature2.addActionListener(this);
        this.addImageLoader.addActionListener(Jedi.getAction("jedi-add-image-loader"));
        ToolBar toolBar = this.editResource.getDefaultToolBar();
        toolBar.add(this.selectResource);
        toolBar.add(Prefs.getIcon("insert"), Jedi.getAction("jedi-add-resource-loader"));
        toolBar.add(Prefs.getIcon("information"), Jedi.getAction("jedi-check-resources"));
        this.editResource.setToolBar(toolBar);
        toolBar = this.classeditor.getDefaultToolBar();
        toolBar.add(Jedi.getAction("search"));
        toolBar.addSeparator();
        toolBar.add(Jedi.getAction("print"));
        toolBar.addSeparator();
        toolBar.add(this.methodeditor.getAction("text-editor-prefs"));
        toolBar.addSeparator();
        toolBar.add(Jedi.getIcon("jedi-compile"), Jedi.getAction("jedi-compile"));
        toolBar.add(Jedi.getIcon("jedi-run"), Jedi.getAction("jedi-run"));
        toolBar.add(Jedi.getIcon("jedi-abort"), Jedi.getAction("jedi-abort"));
        toolBar.add(Prefs.getIcon("macro"), Jedi.getAction("jedi-select-main-method"));
        toolBar.addSeparator();
        toolBar.add(((Action_FetchDoc)Jedi.getAction("jedi-show-api-help")).getButton(), Jedi.getAction("jedi-show-api-help"));
        toolBar.addSeparator();
        this.classeditor.setToolBar(toolBar);
        toolBar = this.classdoceditor.getDefaultToolBar();
        toolBar.add(Jedi.getIcon("@author"), (Action)new Action_AddTag("@author", this.classdoceditor));
        toolBar.add(Jedi.getIcon("@version"), (Action)new Action_AddTag("@version", this.classdoceditor));
        toolBar.addSeparator();
        toolBar.add(Jedi.getIcon("jedi-compile"), Jedi.getAction("jedi-open-javadoc-window"));
        this.classdoceditor.setToolBar(toolBar);
        toolBar = this.methodeditor.getDefaultToolBar();
        toolBar.add(Jedi.getAction("search"));
        toolBar.addSeparator();
        toolBar.add(Jedi.getAction("print"));
        toolBar.addSeparator();
        toolBar.add(this.methodeditor.getAction("text-editor-prefs"));
        toolBar.addSeparator();
        toolBar.add(Jedi.getIcon("jedi-compile"), Jedi.getAction("jedi-compile"));
        toolBar.add(Jedi.getIcon("jedi-run"), Jedi.getAction("jedi-run"));
        toolBar.add(Jedi.getIcon("jedi-abort"), Jedi.getAction("jedi-abort"));
        toolBar.add(Prefs.getIcon("macro"), Jedi.getAction("jedi-select-main-method"));
        toolBar.addSeparator();
        toolBar.add(((Action_FetchDoc)Jedi.getAction("jedi-show-api-help")).getButton(), Jedi.getAction("jedi-show-api-help"));
        toolBar.addSeparator();
        this.methodeditor.setToolBar(toolBar);
        toolBar = this.methoddoceditor.getDefaultToolBar();
        toolBar.add(Jedi.getIcon("@param"), (Action)new Action_AddTag("@param", this.methoddoceditor));
        toolBar.add(Jedi.getIcon("@return"), (Action)new Action_AddTag("@return", this.methoddoceditor));
        toolBar.add(Jedi.getIcon("@exception"), (Action)new Action_AddTag("@exception", this.methoddoceditor));
        toolBar.add(Jedi.getIcon("@see"), (Action)new Action_AddTag("@see", this.methoddoceditor));
        toolBar.add(Jedi.getIcon("@since"), (Action)new Action_AddTag("@since", this.methoddoceditor));
        toolBar.addSeparator();
        toolBar.add(Jedi.getIcon("jedi-compile"), Jedi.getAction("jedi-open-javadoc-window"));
        this.methoddoceditor.setToolBar(toolBar);
        YFramePanel yFramePanel = new YFramePanel();
        yFramePanel.add(this.resourceName);
        yFramePanel.add(new Strut());
        yFramePanel.add(this.editResource);
        YFramePanel yFramePanel2 = new YFramePanel();
        yFramePanel2.add(this.classsignature1);
        yFramePanel2.add(new Strut());
        yFramePanel2.add(this.classeditor);
        YFramePanel yFramePanel3 = new YFramePanel();
        yFramePanel3.add(this.classsignature2);
        yFramePanel3.add(new Strut());
        yFramePanel3.add(this.classdoceditor);
        YFramePanel yFramePanel4 = new YFramePanel();
        yFramePanel4.add(this.methodsignature1);
        yFramePanel4.add(new Strut());
        yFramePanel4.add(this.methodeditor);
        YFramePanel yFramePanel5 = new YFramePanel();
        yFramePanel5.add(this.methodsignature2);
        yFramePanel5.add(new Strut());
        yFramePanel5.add(this.methoddoceditor);
        YPanel yPanel = new YPanel();
        yPanel.add(this.imageViewer);
        yPanel.add(Box.createVerticalGlue());
        yPanel.add(this.addImageLoader);
        XPanel xPanel = new XPanel();
        xPanel.add(this.icons);
        xPanel.add(new Strut());
        xPanel.add(yPanel);
        YFramePanel yFramePanel6 = new YFramePanel();
        yFramePanel6.add(this.iconpath);
        yFramePanel6.add(new Strut());
        yFramePanel6.add(xPanel);
        this.addTab(EditorFrame.GRS("TabbedPane.1"), this.redDot, yFramePanel);
        this.addTab(EditorFrame.GRS("TabbedPane.6"), this.redDot, yFramePanel6);
        this.addTab(EditorFrame.GRS("TabbedPane.2"), this.redDot, yFramePanel2);
        this.addTab(EditorFrame.GRS("TabbedPane.3"), this.redDot, yFramePanel3);
        this.addTab(EditorFrame.GRS("TabbedPane.4"), this.redDot, yFramePanel4);
        this.addTab(EditorFrame.GRS("TabbedPane.5"), this.redDot, yFramePanel5);
        this.methodsignature1.setNextFocusableComponent(this.methodeditor.getTextComponent());
        this.methodsignature2.setNextFocusableComponent(this.methoddoceditor.getTextComponent());
        this.classsignature1.setNextFocusableComponent(this.classeditor.getTextComponent());
        this.classsignature2.setNextFocusableComponent(this.classdoceditor.getTextComponent());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.selectResource) {
            int n = this.selectResource.getSelectedIndex();
            Package package_ = this.editor.getCurrentPackage();
            this.editResource.setDocument(package_.getResource(n));
            this.setIconAt(0, this.editResource.getDocument().getLength() == 0 ? this.redDot : this.greenDot);
        } else if (object == this.methodsignature1 || object == this.methodsignature2) {
            this.processSignatureEvent((TextField)object);
        } else if (object == this.classsignature1 || object == this.classsignature2) {
            this.processSignatureEvent((TextField)object);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.processSignatureEvent((TextField)focusEvent.getSource());
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        String string = this.icons.getSelectedItem();
        this.imageViewer.setImage(string != null ? string : null);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private void processSignatureEvent(TextField textField) {
        if (this.processingEvent) {
            return;
        }
        try {
            this.processingEvent = true;
            if (textField == this.classsignature1 || textField == this.classsignature2) {
                Class clazz = this.editor.getCurrentClass();
                if (clazz == null) {
                    return;
                }
                clazz.getPrefsFrame().setVisible(false);
                if (clazz.isInnerClass()) {
                    this.signatureChanged2(clazz, textField);
                } else {
                    this.signatureChanged1(clazz, textField);
                }
            } else {
                Method method = this.editor.getCurrentMethod();
                if (method == null) {
                    return;
                }
                method.getPrefsFrame().setVisible(false);
                this.signatureChanged(method, textField);
            }
        }
        catch (Exception exception) {
            JReqTools.showException(exception);
        }
        this.processingEvent = false;
    }

    private final void signatureChanged(Method method, TextField textField) {
        try {
            String string = textField.getText();
            StringInputStream stringInputStream = new StringInputStream("class X { " + string + " {} }");
            JavaParser javaParser = new JavaParser(stringInputStream);
            ASTCompilationUnit aSTCompilationUnit = javaParser.CompilationUnit();
            if (method.isConstructor()) {
                ASTClassDeclaration aSTClassDeclaration = (ASTClassDeclaration)aSTCompilationUnit.getClasses().elementAt(0);
                ASTConstructorDeclaration aSTConstructorDeclaration = (ASTConstructorDeclaration)aSTClassDeclaration.getConstructors().elementAt(0);
                method.setPublic(aSTConstructorDeclaration.isPublic());
                method.setProtected(aSTConstructorDeclaration.isProtected());
                method.setPrivate(aSTConstructorDeclaration.isPrivate());
                method.setParameters(StringArray.createFromVector(aSTConstructorDeclaration.getParameters()));
                method.setThrows(StringArray.createFromVector(aSTConstructorDeclaration.getThrows()));
                if (!aSTConstructorDeclaration.getName().equals(this.editor.getCurrentClass().getName())) {
                    JReqTools.showError(EditorFrame.GRS("TabbedPane.Error1"));
                }
                this.methodsignature1.setText(method.getSignature());
                this.methodsignature2.setText(method.getSignature());
            } else if (method.isMethod()) {
                ASTClassDeclaration aSTClassDeclaration = (ASTClassDeclaration)aSTCompilationUnit.getClasses().elementAt(0);
                ASTMethodDeclaration aSTMethodDeclaration = (ASTMethodDeclaration)aSTClassDeclaration.getMethods().elementAt(0);
                method.setPublic(aSTMethodDeclaration.isPublic());
                method.setProtected(aSTMethodDeclaration.isProtected());
                method.setPrivate(aSTMethodDeclaration.isPrivate());
                method.setStatic(aSTMethodDeclaration.isStatic());
                method.setFinal(aSTMethodDeclaration.isFinal());
                method.setAbstract(aSTMethodDeclaration.isAbstract());
                method.setNative(aSTMethodDeclaration.isNative());
                method.setSynchronized(aSTMethodDeclaration.isSynchronized());
                method.setResultType(aSTMethodDeclaration.getResultType());
                method.setParameters(StringArray.createFromVector(aSTMethodDeclaration.getParameters()));
                method.setThrows(StringArray.createFromVector(aSTMethodDeclaration.getThrows()));
                if (!aSTMethodDeclaration.getName().equals(method.getName())) {
                    JReqTools.showError(EditorFrame.GRS("TabbedPane.Error2"));
                }
                this.methodsignature1.setText(method.getSignature());
                this.methodsignature2.setText(method.getSignature());
            }
            method.refreshPrefsFrame();
        }
        catch (Throwable throwable) {
            JReqTools.showError(throwable.getLocalizedMessage());
        }
    }

    private final void signatureChanged1(Class clazz, TextField textField) {
        try {
            String string = textField.getText();
            StringInputStream stringInputStream = new StringInputStream(string + "{}");
            JavaParser javaParser = new JavaParser(stringInputStream);
            ASTCompilationUnit aSTCompilationUnit = javaParser.CompilationUnit();
            if (clazz.isClass()) {
                ASTClassDeclaration aSTClassDeclaration = (ASTClassDeclaration)aSTCompilationUnit.getClasses().elementAt(0);
                clazz.setPublic(aSTClassDeclaration.isPublic());
                clazz.setFinal(aSTClassDeclaration.isFinal());
                clazz.setAbstract(aSTClassDeclaration.isAbstract());
                clazz.setExtends(aSTClassDeclaration.getExtends());
                clazz.setImplements(aSTClassDeclaration.getImplements());
                if (!aSTClassDeclaration.getName().equals(clazz.getName())) {
                    JReqTools.showError(EditorFrame.GRS("TabbedPane.Error1"));
                }
                this.classsignature1.setText(clazz.getSignature());
                this.classsignature2.setText(clazz.getSignature());
            } else if (clazz.isInterface()) {
                ASTInterfaceDeclaration aSTInterfaceDeclaration = (ASTInterfaceDeclaration)aSTCompilationUnit.getInterfaces().elementAt(0);
                clazz.setPublic(aSTInterfaceDeclaration.isPublic());
                clazz.setExtends(aSTInterfaceDeclaration.getExtends());
                if (!aSTInterfaceDeclaration.getName().equals(clazz.getName())) {
                    JReqTools.showError(EditorFrame.GRS("TabbedPane.Error3"));
                }
                this.classsignature1.setText(clazz.getSignature());
                this.classsignature2.setText(clazz.getSignature());
            }
            clazz.refreshPrefsFrame();
        }
        catch (Throwable throwable) {
            JReqTools.showError(throwable.getLocalizedMessage());
        }
    }

    private final void signatureChanged2(Class clazz, TextField textField) {
        try {
            String string = textField.getText();
            StringInputStream stringInputStream = new StringInputStream("class X { " + string + "{} }");
            JavaParser javaParser = new JavaParser(stringInputStream);
            ASTCompilationUnit aSTCompilationUnit = javaParser.CompilationUnit();
            if (clazz.isClass()) {
                ASTClassDeclaration aSTClassDeclaration = (ASTClassDeclaration)aSTCompilationUnit.getClasses().elementAt(0);
                ASTNestedClassDeclaration aSTNestedClassDeclaration = (ASTNestedClassDeclaration)aSTClassDeclaration.getInnerClasses().elementAt(0);
                clazz.setPublic(aSTNestedClassDeclaration.isPublic());
                clazz.setProtected(aSTNestedClassDeclaration.isProtected());
                clazz.setPrivate(aSTNestedClassDeclaration.isPrivate());
                clazz.setFinal(aSTNestedClassDeclaration.isFinal());
                clazz.setAbstract(aSTNestedClassDeclaration.isAbstract());
                clazz.setStatic(aSTNestedClassDeclaration.isStatic());
                clazz.setExtends(aSTNestedClassDeclaration.getExtends());
                clazz.setImplements(aSTNestedClassDeclaration.getImplements());
                if (!clazz.getName().equals(clazz.getParentClass().getName() + "." + aSTNestedClassDeclaration.getName())) {
                    JReqTools.showError(EditorFrame.GRS("TabbedPane.Error1"));
                }
                this.classsignature1.setText(clazz.getSignature());
                this.classsignature2.setText(clazz.getSignature());
            } else if (clazz.isInterface()) {
                ASTClassDeclaration aSTClassDeclaration = (ASTClassDeclaration)aSTCompilationUnit.getClasses().elementAt(0);
                ASTNestedInterfaceDeclaration aSTNestedInterfaceDeclaration = (ASTNestedInterfaceDeclaration)aSTClassDeclaration.getInnerClasses().elementAt(0);
                clazz.setPublic(aSTNestedInterfaceDeclaration.isPublic());
                clazz.setProtected(aSTNestedInterfaceDeclaration.isProtected());
                clazz.setPrivate(aSTNestedInterfaceDeclaration.isPrivate());
                clazz.setFinal(aSTNestedInterfaceDeclaration.isFinal());
                clazz.setAbstract(aSTNestedInterfaceDeclaration.isAbstract());
                clazz.setStatic(aSTNestedInterfaceDeclaration.isStatic());
                clazz.setExtends(aSTNestedInterfaceDeclaration.getExtends());
                if (!clazz.getName().equals(clazz.getParentClass().getName() + "." + aSTNestedInterfaceDeclaration.getName())) {
                    JReqTools.showError(EditorFrame.GRS("TabbedPane.Error3"));
                }
                this.classsignature1.setText(clazz.getSignature());
                this.classsignature2.setText(clazz.getSignature());
            }
            clazz.refreshPrefsFrame();
        }
        catch (Throwable throwable) {
            JReqTools.showError(throwable.getLocalizedMessage());
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.editor.listviews.currentPackage == null) {
            return;
        }
        String[] stringArray = this.icons.get();
        this.editor.listviews.currentPackage.setIcons(stringArray);
        if (stringArray.length == 0) {
            this.setIconAt(1, this.redDot);
            this.imageViewer.setImage("NoImage");
        } else {
            this.setIconAt(1, this.greenDot);
            String string = this.icons.getSelectedItem();
            this.imageViewer.setImage(string != null ? string : "NoImage");
        }
    }
}

