/*
 * Decompiled with CFR 0.152.
 */
package jedi.editor;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import javax.swing.Box;
import jedi.Jedi;
import jedi.ds.Class;
import jedi.ds.Method;
import jedi.editor.EditorFrame;
import swing.addon.ButtonGroup;
import swing.addon.CheckBox;
import swing.addon.Frame;
import swing.addon.GUISystem;
import swing.addon.Label;
import swing.addon.OkCancelButtons;
import swing.addon.Panel;
import swing.addon.Prefs;
import swing.addon.Separator;
import swing.addon.Slider;
import swing.addon.Strut;
import swing.addon.TabbedPane;
import swing.addon.Text;
import swing.addon.TextField;
import swing.addon.YFramePanel;
import swing.addon.util.HardcopyWriter;

class PrintFrame
extends Frame
implements ActionListener {
    Class currentClass = null;
    Method currentMethod = null;
    Text classname = new Text("", 2);
    Text methodname = new Text("", 2);
    CheckBox printclass = new CheckBox(EditorFrame.GRS("PrintFrame.Checkbox1"));
    CheckBox printmethod = new CheckBox(EditorFrame.GRS("PrintFrame.Checkbox2"));
    CheckBox printjavadoc = new CheckBox(EditorFrame.GRS("PrintFrame.Checkbox3"));
    Slider fontsize = new Slider(0, 6, 20, 8);
    TextField leftmargin = new TextField("0.75");
    TextField topmargin = new TextField("0.75");
    TextField rightmargin = new TextField("0.75");
    TextField bottommargin = new TextField("0.75");
    Slider tabwidth = new Slider(0, 1, 20, 3);
    OkCancelButtons buttons = new OkCancelButtons();

    public PrintFrame() {
        super(EditorFrame.GRS("PrintFrame.Title"));
        this.classname.setBorder(true);
        this.methodname.setBorder(true);
        this.printclass.setSelected(true);
        this.printjavadoc.setSelected(false);
        this.fontsize.setMajorTickSpacing(2);
        this.fontsize.setMinorTickSpacing(1);
        this.buttons.addHelpButton("print");
        ButtonGroup.makeGroup(this.printclass, this.printmethod);
        this.buttons.addActionListener(this);
        YFramePanel yFramePanel = new YFramePanel();
        yFramePanel.add(new Separator(EditorFrame.GRS("PrintFrame.Separator1")));
        yFramePanel.add(this.classname);
        yFramePanel.add(new Strut());
        yFramePanel.add(new Separator(EditorFrame.GRS("PrintFrame.Separator2")));
        yFramePanel.add(this.methodname);
        yFramePanel.add(new Strut());
        yFramePanel.add(new Separator(EditorFrame.GRS("PrintFrame.Separator3")));
        yFramePanel.add(this.createTabbedPane());
        yFramePanel.add(new Strut());
        yFramePanel.add(this.buttons);
        this.setContentPane(yFramePanel);
        this.pack();
        Prefs.add("PrintFrame", this);
        Prefs.add("PrintFrame.FontSize", this.fontsize);
        Prefs.add("PrintFrame.Tabulator", this.tabwidth);
        Prefs.add("PrintFrame.LeftMargin", this.leftmargin);
        Prefs.add("PrintFrame.RightMargin", this.rightmargin);
        Prefs.add("PrintFrame.TopMargin", this.topmargin);
        Prefs.add("PrintFrame.BottomMargin", this.bottommargin);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        switch (this.buttons.get()) {
            case 0: {
                this.setVisible(false);
                this.print();
                break;
            }
            case 1: {
                this.setVisible(false);
                break;
            }
            default: {
                GUISystem.err.println(this.getClass().getName() + ".actionPerformed(): internal error");
            }
        }
    }

    private TabbedPane createTabbedPane() {
        TabbedPane tabbedPane = new TabbedPane();
        YFramePanel yFramePanel = new YFramePanel();
        yFramePanel.add(Box.createVerticalGlue());
        yFramePanel.add(this.printclass);
        yFramePanel.add(this.printmethod);
        yFramePanel.add(new Strut());
        yFramePanel.add(this.printjavadoc);
        yFramePanel.add(Box.createVerticalGlue());
        tabbedPane.add(EditorFrame.GRS("PrintFrame.TabbedPane1"), yFramePanel);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(2, 4, Prefs.getObjectSpace(), Prefs.getObjectSpace()));
        panel.add(new Text(EditorFrame.GRS("PrintFrame.LeftMargin")));
        panel.add(this.leftmargin);
        panel.add(new Text(EditorFrame.GRS("PrintFrame.RightMargin")));
        panel.add(this.rightmargin);
        panel.add(new Text(EditorFrame.GRS("PrintFrame.TopMargin")));
        panel.add(this.topmargin);
        panel.add(new Text(EditorFrame.GRS("PrintFrame.BottomMargin")));
        panel.add(this.bottommargin);
        yFramePanel = new YFramePanel();
        yFramePanel.add(Box.createVerticalGlue());
        yFramePanel.add(panel);
        yFramePanel.add(Box.createVerticalGlue());
        tabbedPane.add(EditorFrame.GRS("PrintFrame.TabbedPane2"), yFramePanel);
        yFramePanel = new YFramePanel();
        yFramePanel.add(Box.createVerticalGlue());
        yFramePanel.add(new Label(EditorFrame.GRS("PrintFrame.FontSize")));
        yFramePanel.add(this.fontsize);
        yFramePanel.add(Box.createVerticalGlue());
        tabbedPane.add(EditorFrame.GRS("PrintFrame.TabbedPane3"), yFramePanel);
        yFramePanel = new YFramePanel();
        yFramePanel.add(Box.createVerticalGlue());
        yFramePanel.add(new Label(EditorFrame.GRS("PrintFrame.TabWidth")));
        yFramePanel.add(this.tabwidth);
        yFramePanel.add(Box.createVerticalGlue());
        tabbedPane.add(EditorFrame.GRS("PrintFrame.TabbedPane4"), yFramePanel);
        Prefs.add("PrintFrame.TabbedPane", tabbedPane);
        return tabbedPane;
    }

    private double getMargin(TextField textField) {
        double d = 0.75;
        try {
            String string;
            StringTokenizer stringTokenizer = new StringTokenizer(textField.getText(), ",.");
            String string2 = stringTokenizer.nextToken();
            String string3 = string = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "0";
            if (string.length() == 1) {
                string = string + "0";
            } else if (string.length() > 2) {
                string = string.substring(0, 2);
            }
            int n = 100 * Integer.parseInt(string2) + Integer.parseInt(string);
            d = (double)n / 100.0;
            textField.setText(Double.toString(d));
        }
        catch (Throwable throwable) {
            textField.getToolkit().beep();
        }
        return d;
    }

    private void print() {
        HardcopyWriter hardcopyWriter;
        String string = this.printclass.isSelected() ? this.currentClass.getFullName() : this.currentMethod.getFullName();
        try {
            hardcopyWriter = new HardcopyWriter(Jedi.getEditor(), string, this.fontsize.getValue(), this.getMargin(this.leftmargin), this.getMargin(this.rightmargin), this.getMargin(this.topmargin), this.getMargin(this.bottommargin), this.tabwidth.getValue());
        }
        catch (HardcopyWriter.PrintCanceledException printCanceledException) {
            return;
        }
        PrintWriter printWriter = new PrintWriter(hardcopyWriter);
        int n = hardcopyWriter.getLinesPerPage();
        int n2 = hardcopyWriter.getCharactersPerLine();
        if (this.printclass.isSelected()) {
            this.currentClass.export(printWriter, this.printjavadoc.isSelected());
        } else {
            this.currentMethod.export(printWriter, this.printjavadoc.isSelected());
        }
        printWriter.close();
    }

    void setClass(Class clazz) {
        this.currentClass = clazz;
    }

    void setMethod(Method method) {
        this.currentMethod = method;
    }

    public void setVisible(boolean bl) {
        if (this.currentMethod == null && this.currentClass == null) {
            return;
        }
        if (bl) {
            this.classname.setText(EditorFrame.GRS("PrintFrame.ClassPrefix") + " " + this.currentClass.getFullName());
            this.methodname.setText(EditorFrame.GRS("PrintFrame.MethodPrefix") + " " + (this.currentMethod == null ? "---" : this.currentMethod.getFullName()));
            this.printmethod.setEnabled(this.currentMethod != null);
            if (this.currentMethod == null) {
                this.printclass.setSelected(true);
            }
        }
        super.setVisible(bl);
    }
}

