/*
 * Decompiled with CFR 0.152.
 */
package jedi.export;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import jedi.Jedi;
import jedi.ds.Project;
import swing.addon.CheckBox;
import swing.addon.Dialog;
import swing.addon.FileString;
import swing.addon.GridBagConstraints;
import swing.addon.GridBagLayout;
import swing.addon.Insets;
import swing.addon.Label;
import swing.addon.OkCancelButtons;
import swing.addon.Panel;
import swing.addon.Prefs;
import swing.addon.YFramePanel;

class ExportDialog
extends Dialog {
    static final ResourceBundle resources = ResourceBundle.getBundle("jedi.export.resources.export");
    boolean answer = false;
    OkCancelButtons buttons = new OkCancelButtons();
    FileString path = new FileString("", 1);
    CheckBox sources = new CheckBox(ExportDialog.GRS("ExportDialog.CreateSourceFiles"), true);
    CheckBox documentation = new CheckBox(ExportDialog.GRS("ExportDialog.CreateDocumentation"), true);
    CheckBox classes = new CheckBox(ExportDialog.GRS("ExportDialog.CreateClassFiles"), true);
    CheckBox jar = new CheckBox(ExportDialog.GRS("ExportDialog.CreateJarFile"), true);
    CheckBox scripts = new CheckBox(ExportDialog.GRS("ExportDialog.CreateScripts"), true);

    public ExportDialog() {
        super(Jedi.getEditor(), ExportDialog.GRS("ExportDialog.DialogTitle"));
        this.buttons.setShowSeparator(false);
        this.buttons.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ExportDialog.this.buttons.get() == 0) {
                    ExportDialog.this.ok();
                } else {
                    ExportDialog.this.cancel();
                }
            }
        });
        YFramePanel yFramePanel = new YFramePanel();
        yFramePanel.add(this.createOptionPanel());
        yFramePanel.addStrut();
        yFramePanel.add(this.buttons);
        this.setContentPane(yFramePanel);
        this.pack();
        Prefs.add("ExportDialog", this);
    }

    static String GRS(String string) {
        try {
            return resources.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println(missingResourceException.getLocalizedMessage() + ": '" + string + "'");
            return "MISSING RESOURCE: " + string;
        }
    }

    static String GRS(String string, String string2) {
        String string3 = ExportDialog.GRS(string);
        try {
            string3 = MessageFormat.format(string3, string2);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        return string3;
    }

    void cancel() {
        this.answer = false;
        this.setVisible(false);
    }

    private Panel createOptionPanel() {
        Panel panel = new Panel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(ExportDialog.GRS("ExportDialog.Title")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(Prefs.getObjectSpace(), Prefs.getObjectSpace(), Prefs.getObjectSpace(), Prefs.getObjectSpace());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        panel.add((Component)new Label(ExportDialog.GRS("ExportDialog.Path"), 2), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        panel.add((Component)this.path, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        panel.add((Component)this.sources, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        panel.add((Component)this.documentation, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        panel.add((Component)this.classes, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        panel.add((Component)this.jar, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        panel.add((Component)this.scripts, gridBagConstraints);
        return panel;
    }

    public boolean getCreateClasses() {
        return this.classes.isSelected();
    }

    public boolean getCreateDocumentation() {
        return this.documentation.isSelected();
    }

    public boolean getCreateJar() {
        return this.jar.isSelected();
    }

    public boolean getCreateSources() {
        return this.sources.isSelected();
    }

    public File getPath() {
        return this.path.getFile();
    }

    void ok() {
        this.answer = true;
        this.setVisible(false);
        Project project = Jedi.getEditor().getProject();
        project.putProperty("Export.Path", this.path.getFile().toString());
        project.putProperty("Export.Sources", this.sources.isSelected() ? "true" : "false");
        project.putProperty("Export.Classes", this.classes.isSelected() ? "true" : "false");
        project.putProperty("Export.Jar", this.jar.isSelected() ? "true" : "false");
        project.putProperty("Export.StartScripts", this.scripts.isSelected() ? "true" : "false");
    }

    public boolean request() {
        this.answer = false;
        this.setVisible(true);
        return this.answer;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            Project project = Jedi.getEditor().getProject();
            String string = project.getProperty("Export.Path");
            if (string != null) {
                this.path.setFile(string);
            }
            if ((string = project.getProperty("Export.Sources")) != null) {
                this.sources.setSelected(string.equals("true"));
            }
            if ((string = project.getProperty("Export.Documentation")) != null) {
                this.documentation.setSelected(string.equals("true"));
            }
            if ((string = project.getProperty("Export.Classes")) != null) {
                this.classes.setSelected(string.equals("true"));
            }
            if ((string = project.getProperty("Export.Jar")) != null) {
                this.jar.setSelected(string.equals("true"));
            }
            if ((string = project.getProperty("Export.StartScripts")) != null) {
                this.scripts.setSelected(string.equals("true"));
            }
        }
        super.setVisible(bl);
    }
}

