/*
 * Decompiled with CFR 0.152.
 */
package jedi.fetchdoc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamTokenizer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import swing.addon.Utils;

public class FetchDoc
implements FilenameFilter {
    String indexDir;
    Vector urlStrings;
    protected String[] files;
    public static int START_BUILD = 1;
    public static int SCAN_PATH = 2;
    public static int SCAN_FILE = 3;
    public static int WRITE_INDEX = 4;
    public static int WRITE_FILE = 5;
    public static int FILE_ACCESS_ERROR = 1;
    public static int NO_HITS_ERROR = 2;
    public static int NO_MORE_HITS = 3;
    public static int NO_DOC_DIRECTORY = 4;

    public FetchDoc(String string) {
        this.indexDir = string;
    }

    public boolean accept(File file, String string) {
        if (string.equals("AllNames.html")) {
            return true;
        }
        if (string.endsWith("index.html")) {
            return true;
        }
        return string.startsWith("index") && string.endsWith(".html");
    }

    protected Hashtable buildIndexTable(Hashtable hashtable, String string, String string2) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));
            StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
            this.setupTokenizer(streamTokenizer);
            int n = streamTokenizer.nextToken();
            while (n != -1) {
                if (n == -3 && streamTokenizer.sval.equalsIgnoreCase("dt")) {
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    n = streamTokenizer.nextToken();
                    if (n != 34) continue;
                    String string3 = string + File.separator + streamTokenizer.sval;
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    streamTokenizer.nextToken();
                    n = streamTokenizer.nextToken();
                    if (n != -3) continue;
                    String string4 = streamTokenizer.sval;
                    this.sortIn(hashtable, string4, string3);
                    continue;
                }
                n = streamTokenizer.nextToken();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.error(FILE_ACCESS_ERROR, "Cannot find index-file. Invalid javadoc-directory?");
        }
        catch (IOException iOException) {
            this.error(FILE_ACCESS_ERROR, "Unexpected end of index. Corrupted javadoc-directory?");
        }
        return hashtable;
    }

    protected String checkPath(String string) {
        File file = new File(string);
        if (!file.isDirectory()) {
            this.error(FILE_ACCESS_ERROR, "javadoc-directory is not a directory");
            return null;
        }
        if (!file.canRead()) {
            this.error(FILE_ACCESS_ERROR, "Cannot read javadoc-directory");
            return null;
        }
        File file2 = new File(string + File.separator + "index-files");
        if (file2.exists() && file2.isDirectory() && file2.canRead()) {
            return string + File.separator + "index-files";
        }
        return string;
    }

    public void deleteDirectory(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            int n = 0;
            while (n < stringArray.length) {
                File file2 = new File(file.getPath() + stringArray[n]);
                this.deleteDirectory(file2);
                ++n;
            }
        }
        file.delete();
    }

    protected void error(int n, String string) {
        System.err.println(string);
    }

    protected String[] findIndexFiles(String string) {
        File file = new File(string);
        if (!file.isDirectory()) {
            this.error(FILE_ACCESS_ERROR, "Stated javadoc-directory is not a directory");
            return null;
        }
        if (!file.canRead()) {
            this.error(FILE_ACCESS_ERROR, "Cannot read javadoc-directory");
            return null;
        }
        File file2 = new File(string + File.separator + "index-files");
        if (file2.exists() && file2.isDirectory() && file2.canRead()) {
            String[] stringArray = file2.list(this);
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = "index-files" + File.separator + stringArray[n];
                ++n;
            }
            return stringArray;
        }
        return file.list(this);
    }

    public void generateIndex(Vector vector) {
        Enumeration enumeration = vector.elements();
        if (enumeration.hasMoreElements()) {
            this.progress(START_BUILD, "Building index for javadoc-files...");
            Hashtable hashtable = new Hashtable();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string.length() <= 0) continue;
                String string2 = this.checkPath(string);
                this.files = this.findIndexFiles(string2);
                if (this.files == null || this.files.length == 0) {
                    this.error(NO_DOC_DIRECTORY, string);
                }
                this.progress(SCAN_PATH, string);
                int n = 0;
                while (n < this.files.length) {
                    this.progress(SCAN_FILE, this.files[n]);
                    hashtable = this.buildIndexTable(hashtable, string2, string2 + File.separator + this.files[n]);
                    ++n;
                }
            }
            this.writeHashtable(this.indexDir + File.separator, hashtable);
        }
    }

    protected Vector getAllHits(String string) {
        StringBuffer stringBuffer = new StringBuffer(this.indexDir);
        stringBuffer.append(File.separator);
        stringBuffer.append(this.getHashcode(string));
        Hashtable hashtable = new Hashtable();
        try {
            FileInputStream fileInputStream = new FileInputStream(stringBuffer.toString());
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            hashtable = (Hashtable)objectInputStream.readObject();
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            this.error(FILE_ACCESS_ERROR, "Index file is corrupted.\nCheck documentation paths and create a new index please.");
        }
        return (Vector)hashtable.get(string);
    }

    public String getFirstURL(String string) {
        this.urlStrings = this.getAllHits(string);
        if (this.urlStrings == null) {
            this.error(NO_HITS_ERROR, "No hits found for key \"" + string + "\".");
            return null;
        }
        return this.getNextURL();
    }

    public String getHashcode(String string) {
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            n += string.charAt(n3);
            ++n3;
        }
        return new Integer(n % 237).toString();
    }

    public String getNextURL() {
        if (this.urlStrings.isEmpty()) {
            this.error(NO_HITS_ERROR, "No index found. Try another keyword.");
            return null;
        }
        if (this.urlStrings.isEmpty()) {
            this.error(NO_MORE_HITS, "No more hits. Try another keyword or restart.");
            return null;
        }
        String string = (String)this.urlStrings.firstElement();
        this.urlStrings.removeElementAt(0);
        return Utils.makeFileURL(string);
    }

    public boolean hasMoreHits() {
        return !this.urlStrings.isEmpty();
    }

    public void progress(int n, String string) {
        if (string != null) {
            System.err.println(string);
        }
    }

    public void setupTokenizer(StreamTokenizer streamTokenizer) {
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(48, 57);
        streamTokenizer.wordChars(36, 36);
        streamTokenizer.wordChars(65, 90);
        streamTokenizer.wordChars(95, 95);
        streamTokenizer.wordChars(97, 122);
        streamTokenizer.wordChars(192, 214);
        streamTokenizer.wordChars(216, 246);
        streamTokenizer.wordChars(248, 255);
        streamTokenizer.whitespaceChars(32, 32);
        streamTokenizer.whitespaceChars(9, 9);
        streamTokenizer.whitespaceChars(10, 10);
        streamTokenizer.whitespaceChars(13, 13);
        streamTokenizer.whitespaceChars(12, 12);
        streamTokenizer.quoteChar(34);
    }

    protected void sortIn(Hashtable hashtable, String string, String string2) {
        Vector<String> vector;
        Hashtable hashtable2 = (Hashtable)hashtable.get(this.getHashcode(string));
        if (hashtable2 == null) {
            hashtable2 = new Hashtable();
            hashtable.put(this.getHashcode(string), hashtable2);
        }
        if ((vector = (Vector<String>)hashtable2.get(string)) == null) {
            vector = new Vector<String>();
            hashtable2.put(string, vector);
        }
        if (!vector.contains(string2)) {
            vector.addElement(string2);
        }
    }

    protected void writeHashtable(String string, Hashtable hashtable) {
        if (string.equals("-")) {
            return;
        }
        this.progress(WRITE_INDEX, "Writing index to directory " + string);
        File file = new File(string);
        try {
            this.deleteDirectory(file);
            file.mkdirs();
        }
        catch (SecurityException securityException) {
            this.error(FILE_ACCESS_ERROR, "Could not create directory " + string + ".\n Please check path and permissions.");
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Hashtable hashtable2 = (Hashtable)hashtable.get(string2);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string + string2, false);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                this.progress(WRITE_FILE, string + string2);
                objectOutputStream.writeObject(hashtable2);
                objectOutputStream.close();
            }
            catch (Exception exception) {
                this.error(FILE_ACCESS_ERROR, "Could not write Index file. Probably no write-permission.");
                return;
            }
        }
    }
}

