/*
 * Decompiled with CFR 0.152.
 */
package jedi.help;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import jedi.Jedi;
import jedi.fetchdoc.FetchDoc;
import jedi.help.JediHelpBrowser;
import jedi.prefs.JediPrefs;
import jreqtools.JReqTools;
import swing.addon.GUISystem;
import swing.addon.MenuItem;
import swing.addon.PopupMenu;
import swing.addon.Prefs;
import swing.addon.ToolBarButton;

public class Action_FetchDoc
extends TextAction {
    char[] type;

    public Action_FetchDoc() {
        super("jedi-show-api-help");
        this.putValue("ShortDescription", JediHelpBrowser.GRS("Action_FetchDoc.Description"));
        this.type = new char[256];
        this.buildTypeHash(this.type);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.doit(null);
    }

    void buildTypeHash(char[] cArray) {
        this.insertTypeHash(cArray, 'i', '0', '9');
        this.insertTypeHash(cArray, 'i', '$', '$');
        this.insertTypeHash(cArray, 'i', 'A', 'Z');
        this.insertTypeHash(cArray, 'i', '_', '_');
        this.insertTypeHash(cArray, 'i', 'a', 'z');
        this.insertTypeHash(cArray, 'i', '\u00c0', '\u00d6');
        this.insertTypeHash(cArray, 'i', '\u00d8', '\u00f6');
        this.insertTypeHash(cArray, 'i', '\u00f8', '\u00ff');
    }

    void doit(ToolBarButton toolBarButton) {
        JTextComponent jTextComponent = this.getFocusedComponent();
        if (jTextComponent == null) {
            Jedi.getEditor().getToolkit().beep();
            return;
        }
        final String string = this.getKeyword(jTextComponent);
        if (string == null) {
            Jedi.getEditor().getToolkit().beep();
            return;
        }
        FetchDoc fetchDoc = new FetchDoc(Jedi.getSaveDirectory() + File.separator + "fetchdoc_index"){

            public void error(int n, String string2) {
                if (n == FetchDoc.NO_HITS_ERROR) {
                    JReqTools.showError(JediHelpBrowser.GRS("Action_FetchDoc.Error1", string));
                } else {
                    GUISystem.err.println(string2);
                }
            }
        };
        String string2 = fetchDoc.getFirstURL(string);
        if (string2 == null) {
            return;
        }
        if (toolBarButton != null) {
            PopupMenu popupMenu = new PopupMenu(string);
            URLMenuItem uRLMenuItem = new URLMenuItem(string2);
            uRLMenuItem.addActionListener(this);
            popupMenu.add(uRLMenuItem);
            while (fetchDoc.hasMoreHits()) {
                final String string3 = fetchDoc.getNextURL();
                uRLMenuItem = new URLMenuItem(string3);
                uRLMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        JediPrefs.getHelpBrowser().setURL(string3);
                    }
                });
                popupMenu.add(uRLMenuItem);
            }
            popupMenu.show(toolBarButton, 0, 0);
        } else {
            JediPrefs.getHelpBrowser().setURL(string2);
        }
    }

    public ToolBarButton getButton() {
        final ToolBarButton toolBarButton = new ToolBarButton(Prefs.getIcon("fhelp"));
        toolBarButton.addActionListener(this);
        if (Prefs.isWindowsSystem()) {
            toolBarButton.addMouseListener(new MouseAdapter(){

                public void mouseReleased(MouseEvent mouseEvent) {
                    if (mouseEvent.isPopupTrigger()) {
                        Action_FetchDoc.this.doit(toolBarButton);
                    }
                }
            });
        } else {
            toolBarButton.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.isPopupTrigger()) {
                        Action_FetchDoc.this.doit(toolBarButton);
                    }
                }
            });
        }
        return toolBarButton;
    }

    String getKeyword(JTextComponent jTextComponent) {
        int n;
        String string = jTextComponent.getText();
        int n2 = n = jTextComponent.getCaretPosition();
        int n3 = string.length();
        while (n2 < n3 && this.type[string.charAt(n2)] == 'i') {
            ++n2;
        }
        int n4 = n - 1;
        while (n4 >= 0 && this.type[string.charAt(n4)] == 'i') {
            --n4;
        }
        jTextComponent.select(++n4, n2);
        if (n4 < n2) {
            return string.substring(n4, n2);
        }
        return null;
    }

    void insertTypeHash(char[] cArray, char c, char n, char c2) {
        int n2 = n;
        while (n2 <= c2) {
            cArray[n2] = c;
            ++n2;
        }
    }

    class URLMenuItem
    extends MenuItem {
        URL url;

        public URLMenuItem(String string) {
            super("");
            try {
                this.url = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                JReqTools.showError("Malformed URL found in index.\nPlease regenerate index.");
            }
            this.setText(this.getTargetName(this.url, string));
        }

        public String getTarget() {
            return this.url.toString();
        }

        protected String getTargetName(URL uRL, String string) {
            String string2 = uRL.getRef();
            string2 = string2 == null || string2.length() == 0 ? "Class " : string2 + " of Class ";
            File file = new File(uRL.getFile());
            String string3 = file.getName();
            int n = string.lastIndexOf("index-files");
            if (n != -1) {
                int n2 = string.lastIndexOf("#");
                if (n2 < 0) {
                    n2 = string.length();
                }
                String string4 = string.substring(n + 12, n2);
                string3 = string4.replace(File.separatorChar, '.');
                int n3 = 0;
                while (string3.charAt(n3) == '.') {
                    ++n3;
                }
                string3 = string3.substring(n3);
            }
            if (string3.toLowerCase().endsWith(".htm")) {
                string3 = string3.substring(0, string3.length() - 4);
            } else if (string3.toLowerCase().endsWith(".html")) {
                string3 = string3.substring(0, string3.length() - 5);
            }
            return string2 + string3;
        }

        public URL getURL() {
            return this.url;
        }
    }
}

