/*
 * Decompiled with CFR 0.152.
 */
package jedi.help;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import jreqtools.JReqTools;
import swing.addon.Frame;
import swing.addon.GUISystem;
import swing.addon.HelpBrowser;
import swing.addon.Prefs;
import swing.addon.Text;
import swing.addon.TextField;
import swing.addon.YFramePanel;
import swing.addon.util.NiceThread;

public class JediHelpBrowser
extends Frame
implements HelpBrowser,
HyperlinkListener {
    static final ResourceBundle resources = ResourceBundle.getBundle("jedi.help.resources.help");
    TextField url = new TextField("");
    JEditorPane html = new JEditorPane();
    Text message = new Text(JediHelpBrowser.GRS("JediHelpBrowser.Message2"), 2);

    public JediHelpBrowser() {
        super(JediHelpBrowser.GRS("JediHelpBrowser.Title"));
        this.setDefaultCloseOperation(1);
        this.message.setFont(Prefs.getSmallFont());
        this.html.setEditable(false);
        this.html.setContentType("text/html");
        this.url.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JediHelpBrowser.this.setURL(JediHelpBrowser.this.url.getText());
            }
        });
        this.html.addHyperlinkListener(this);
        YFramePanel yFramePanel = new YFramePanel();
        this.setContentPane(yFramePanel);
        yFramePanel.add(this.url);
        yFramePanel.addStrut();
        yFramePanel.add(new JScrollPane(this.html));
        yFramePanel.addStrut();
        yFramePanel.add(this.message);
        ((Component)this).setBounds(10, 10, 300, 500);
        Prefs.add("JediHelpBrowser", this);
    }

    static String GRS(String string) {
        try {
            return resources.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println(missingResourceException.getLocalizedMessage() + ": '" + string + "'");
            return "MISSING RESOURCE: " + string;
        }
    }

    static String GRS(String string, String string2) {
        String string3 = JediHelpBrowser.GRS(string);
        try {
            string3 = MessageFormat.format(string3, string2);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        return string3;
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.setURL(hyperlinkEvent.getURL());
        }
    }

    static void main(String[] stringArray) {
        Prefs.init("Jedi", null);
        JediHelpBrowser jediHelpBrowser = new JediHelpBrowser();
        jediHelpBrowser.setVisible(true);
        jediHelpBrowser.setURL("http://localhost");
        jediHelpBrowser.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Prefs.save();
                System.exit(0);
            }
        });
    }

    public void setFilename(String string) {
        try {
            if (File.separatorChar == '\\') {
                string = string.replace('\\', '/');
                string = "file://localhost/" + string;
                this.setURL(string);
            } else {
                this.setURL(new URL("file://" + string));
            }
        }
        catch (Exception exception) {
            JReqTools.showException(exception);
        }
    }

    public void setText(String string) {
        this.url.setText("");
        this.html.setText(string);
        this.setVisible(true);
    }

    public void setURL(final URL uRL) {
        this.setVisible(true);
        if (uRL == null) {
            GUISystem.err.println(this.getClass().getName() + ".setURL(): URL was null ?!?");
            return;
        }
        this.html.setCursor(Prefs.getWaitCursor());
        this.url.setText(uRL.toString());
        new NiceThread(){

            public void runNice() {
                try {
                    JediHelpBrowser.this.message.setText(JediHelpBrowser.GRS("JediHelpBrowser.Message1", uRL.toString()));
                    JediHelpBrowser.this.html.setPage(uRL);
                    JediHelpBrowser.this.message.setText(JediHelpBrowser.GRS("JediHelpBrowser.Message2"));
                }
                catch (Exception exception) {
                    JediHelpBrowser.this.message.setText(JediHelpBrowser.GRS("JediHelpBrowser.Error1"));
                    JReqTools.showException(exception);
                }
                JediHelpBrowser.this.html.setCursor(Prefs.getNormalCursor());
            }
        }.start();
    }

    public void setURL(String string) {
        try {
            this.setURL(new URL(string));
        }
        catch (Exception exception) {
            JReqTools.showException(exception);
        }
    }
}

