/*
 * Decompiled with CFR 0.152.
 */
package jedi.imprt;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import jedi.Jedi;
import jedi.ds.Class;
import jedi.ds.Package;
import jedi.ds.Project;
import jedi.imprt.FileLocationResolver;
import jedi.imprt.ImportUtils;
import jedi.parser.ASTClassDeclaration;
import jedi.parser.ASTCompilationUnit;
import jedi.parser.ASTInterfaceDeclaration;
import jedi.parser.JavaParser;
import jedi.parser.SimpleNode;
import jreqtools.FileFilter;
import jreqtools.JReqTools;
import jreqtools.ProgressTask;
import jreqtools.ProgressTracker;
import jreqtools.StringCheckers;
import jreqtools.StringRequester;
import swing.addon.ComboBox;
import swing.addon.Dialog;
import swing.addon.FileString;
import swing.addon.GUISystem;
import swing.addon.GridBagConstraints;
import swing.addon.GridBagLayout;
import swing.addon.Insets;
import swing.addon.Label;
import swing.addon.OkCancelButtons;
import swing.addon.Panel;
import swing.addon.Prefs;
import swing.addon.TabbedPane;
import swing.addon.YFramePanel;

class ImportDialog
extends Dialog
implements ActionListener {
    static final int NO_REPLACE = 0;
    static final int DO_REPLACE = 1;
    static final int ASK_REPLACE = 2;
    static final ResourceBundle resources = ResourceBundle.getBundle("jedi.imprt.resources.imprt");
    TabbedPane tabbedPane = new TabbedPane();
    OkCancelButtons buttons = new OkCancelButtons();
    FileString file = new FileString("");
    FileString directory = new FileString("", 1);
    ComboBox behaviour = new ComboBox(new String[]{ImportDialog.GRS("ImportDialog.Tab2.Behaviour.0"), ImportDialog.GRS("ImportDialog.Tab2.Behaviour.1"), ImportDialog.GRS("ImportDialog.Tab2.Behaviour.2")});

    public ImportDialog() {
        super(Jedi.getEditor(), ImportDialog.GRS("ImportDialog.Title"));
        this.buttons.addHelpButton("import");
        this.tabbedPane.addTab(ImportDialog.GRS("ImportDialog.Tab1.Name"), this.createFileTab());
        this.tabbedPane.addTab(ImportDialog.GRS("ImportDialog.Tab2.Name"), this.createDirectoryTab());
        this.buttons.addActionListener(this);
        this.file.addChoosableFileFilter(new FileFilter.SuffixFileFilter(".java", ImportDialog.GRS("ImportDialog.FilterDescription")), true);
        YFramePanel yFramePanel = new YFramePanel();
        yFramePanel.add(this.tabbedPane);
        yFramePanel.addStrut();
        yFramePanel.add(this.buttons);
        this.setContentPane(yFramePanel);
        this.pack();
        Prefs.add("ImportDialog", this);
        Prefs.add("ImportDialog.TabbedPane", this.tabbedPane);
        Prefs.add("ImportDialog.File", this.file);
        Prefs.add("ImportDialog.Directory", this.directory);
        Prefs.add("ImportDialog.Behaviour", this.behaviour);
    }

    static String GRS(String string) {
        try {
            return resources.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println(missingResourceException.getLocalizedMessage() + ": '" + string + "'");
            return "MISSING RESOURCE: " + string;
        }
    }

    static String GRS(String string, String string2) {
        String string3 = ImportDialog.GRS(string);
        try {
            string3 = MessageFormat.format(string3, string2);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        return string3;
    }

    static String GRS(String string, String string2, String string3) {
        String string4 = ImportDialog.GRS(string);
        try {
            string4 = MessageFormat.format(string4, string2, string3);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        return string4;
    }

    static String GRS(String string, Object object, Object object2, Object object3) {
        String string2 = ImportDialog.GRS(string);
        try {
            string2 = MessageFormat.format(string2, object, object2, object3);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        return string2;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.buttons) {
            if (this.buttons.get() == 0) {
                if (this.tabbedPane.getSelectedIndex() == 0 && this.file.getFile() != null) {
                    this.doFileImport(this.file.getFile());
                } else if (this.tabbedPane.getSelectedIndex() == 1 && this.directory.getFile() != null) {
                    this.doDirectoryImport(this.directory.getFile());
                } else {
                    JReqTools.showError(ImportDialog.GRS("ImportDialog.Error1"));
                }
            } else {
                this.setVisible(false);
            }
        } else {
            GUISystem.err.println(this.getClass().getName() + ".actionPerformed(): internal error");
        }
    }

    private Panel createDirectoryTab() {
        Panel panel = new Panel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(Prefs.getObjectSpace(), Prefs.getObjectSpace(), Prefs.getObjectSpace(), Prefs.getObjectSpace());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        panel.add((Component)new Label(ImportDialog.GRS("ImportDialog.Tab2.Directory"), 2), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        panel.add((Component)this.directory, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        panel.add((Component)new Label(ImportDialog.GRS("ImportDialog.Tab2.Behaviour"), 2), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        panel.add((Component)this.behaviour, gridBagConstraints);
        return panel;
    }

    private Panel createFileTab() {
        Panel panel = new Panel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(Prefs.getObjectSpace(), Prefs.getObjectSpace(), Prefs.getObjectSpace(), Prefs.getObjectSpace());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        panel.add((Component)new Label(ImportDialog.GRS("ImportDialog.Tab1.File"), 2), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        panel.add((Component)this.file, gridBagConstraints);
        return panel;
    }

    void doDirectoryImport(final File file) {
        if (!file.isDirectory()) {
            JReqTools.showError(ImportDialog.GRS("ImportDialog.Error2", file.toString()));
            return;
        }
        this.setVisible(false);
        ProgressTask progressTask = new ProgressTask(){
            String currentText = "-";
            int current = 0;
            int maximum = 100;
            boolean abort = false;

            public void cancel() {
                this.abort = true;
            }

            public String getCurrentText() {
                return this.currentText;
            }

            public int getCurrent() {
                return this.current;
            }

            public int getMaximum() {
                return this.maximum;
            }

            public int getMinimum() {
                return 0;
            }

            public void run() {
                this.currentText = ImportDialog.GRS("ProgressTracker.Reading");
                String[] stringArray = ImportUtils.readDirectory(file);
                this.maximum = stringArray.length;
                this.current = 0;
                while (!this.abort && this.current < this.maximum) {
                    File file2 = new File(stringArray[this.current]);
                    this.currentText = ImportDialog.GRS("ProgressTracker.Converting", file2.getName());
                    if (stringArray[this.current].endsWith(".java")) {
                        ImportDialog.this.doImport(file2, ImportDialog.this.behaviour.getSelectedIndex());
                    } else if (file2.isDirectory()) {
                        ImportDialog.this.doImportProperties(file2);
                    }
                    ++this.current;
                }
                Jedi.getEditor().setProject(Jedi.getEditor().getProject());
            }
        };
        ProgressTracker progressTracker = new ProgressTracker(ImportDialog.GRS("ProgressTracker.Title"), ImportDialog.GRS("ProgressTracker.Message", file.toString()), progressTask);
        progressTracker.addCancelButton(true);
        progressTracker.start();
        this.setVisible(true);
    }

    void doFileImport(final File file) {
        if (!file.isFile()) {
            JReqTools.showError(ImportDialog.GRS("ImportDialog.Error3", this.file.toString()));
            return;
        }
        this.buttons.setEnabled(false);
        this.file.setEnabled(false);
        new Thread(){

            public void run() {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.setPriority(2);
                ImportDialog.this.doImport(file, 2);
                Jedi.getEditor().setProject(Jedi.getEditor().getProject());
                ImportDialog.this.buttons.setEnabled(true);
                ImportDialog.this.file.setEnabled(true);
            }
        }.start();
    }

    void doImport(File file, int n) {
        try {
            JavaParser javaParser = new JavaParser(new FileInputStream(file));
            ASTCompilationUnit aSTCompilationUnit = javaParser.CompilationUnit();
            aSTCompilationUnit.setFilename(file.getAbsolutePath());
            if (aSTCompilationUnit.getPackagename().equals("")) {
                JReqTools.showError(Jedi.getEditor(), ImportDialog.GRS("ImportDialog.Error4", file.getName()));
                return;
            }
            Project project = Jedi.getEditor().getProject();
            Package package_ = project.add(aSTCompilationUnit.getPackagename());
            Vector vector = aSTCompilationUnit.getClasses();
            int n2 = 0;
            while (n2 < vector.size()) {
                this.doImport(project, package_, (SimpleNode)vector.elementAt(n2), n);
                ++n2;
            }
            Vector vector2 = aSTCompilationUnit.getInterfaces();
            int n3 = 0;
            while (n3 < vector2.size()) {
                this.doImport(project, package_, (SimpleNode)vector2.elementAt(n3), n);
                ++n3;
            }
        }
        catch (Exception exception) {
            JReqTools.showError(ImportDialog.GRS("ImportDialog.Error5", file.getName(), exception.toString()));
        }
        catch (Error error) {
            JReqTools.showError(ImportDialog.GRS("ImportDialog.Error6", file.getName(), error.toString()));
        }
    }

    void doImport(Project project, Package package_, SimpleNode simpleNode, int n) {
        Class clazz = null;
        clazz = simpleNode instanceof ASTClassDeclaration ? package_.get(((ASTClassDeclaration)simpleNode).getName()) : package_.get(((ASTInterfaceDeclaration)simpleNode).getName());
        if (clazz != null && n == 2) {
            if (!JReqTools.showQuestion(Jedi.getEditor(), ImportDialog.GRS("ImportDialog.Question1", clazz.getName(), package_.getName()))) {
                return;
            }
            package_.delete(clazz);
        } else if (clazz != null && n == 1) {
            package_.delete(clazz);
        } else if (clazz != null) {
            return;
        }
        if (simpleNode instanceof ASTClassDeclaration) {
            ASTClassDeclaration aSTClassDeclaration = (ASTClassDeclaration)simpleNode;
            FileLocationResolver fileLocationResolver = new FileLocationResolver(aSTClassDeclaration.getFilename());
            clazz = package_.add(aSTClassDeclaration.getName(), 1);
            clazz.setPublic(aSTClassDeclaration.isPublic());
            clazz.setFinal(aSTClassDeclaration.isFinal());
            clazz.setAbstract(aSTClassDeclaration.isAbstract());
            clazz.setExtends(aSTClassDeclaration.getExtends());
            clazz.setImplements(aSTClassDeclaration.getImplements());
            clazz.setJavaDoc(ImportUtils.makePrettyJavaDoc(fileLocationResolver.get(aSTClassDeclaration.getJavaDoc())));
            Vector vector = aSTClassDeclaration.getImports();
            Vector vector2 = aSTClassDeclaration.getVariables();
            Vector vector3 = aSTClassDeclaration.getInnerClasses();
            Vector vector4 = aSTClassDeclaration.getMethods();
            Vector vector5 = aSTClassDeclaration.getInitializers();
            Vector vector6 = aSTClassDeclaration.getConstructors();
            ImportUtils.addImports(fileLocationResolver, clazz, vector);
            ImportUtils.addVariables(fileLocationResolver, clazz, vector2);
            ImportUtils.addInnerClasses(fileLocationResolver, clazz, vector3);
            ImportUtils.addMethods(fileLocationResolver, clazz, vector4);
            ImportUtils.addInitializers(fileLocationResolver, clazz, vector5);
            ImportUtils.addConstructors(fileLocationResolver, clazz, vector6);
        } else {
            ASTInterfaceDeclaration aSTInterfaceDeclaration = (ASTInterfaceDeclaration)simpleNode;
            FileLocationResolver fileLocationResolver = new FileLocationResolver(aSTInterfaceDeclaration.getFilename());
            clazz = package_.add(aSTInterfaceDeclaration.getName(), 2);
            clazz.setPublic(aSTInterfaceDeclaration.isPublic());
            clazz.setAbstract(aSTInterfaceDeclaration.isAbstract());
            clazz.setExtends(aSTInterfaceDeclaration.getExtends());
            clazz.setJavaDoc(ImportUtils.makePrettyJavaDoc(fileLocationResolver.get(aSTInterfaceDeclaration.getJavaDoc())));
            Vector vector = aSTInterfaceDeclaration.getImports();
            Vector vector7 = aSTInterfaceDeclaration.getVariables();
            Vector vector8 = aSTInterfaceDeclaration.getMethods();
            ImportUtils.addImports(fileLocationResolver, clazz, vector);
            ImportUtils.addVariables(fileLocationResolver, clazz, vector7);
            ImportUtils.addMethods(fileLocationResolver, clazz, vector8);
        }
    }

    void doImportProperties(File file) {
        StringRequester stringRequester = new StringRequester(ImportDialog.GRS("ImportDialog.PropertiesRequester.Title"), ImportDialog.GRS("ImportDialog.PropertiesRequester.Message", file.toString()), file.getParent().replace(File.separatorChar, '.'));
        stringRequester.setStringChecker(StringCheckers.getJavaPackageChecker());
        if (stringRequester.request() != 0) {
            return;
        }
        if (stringRequester.getString().equals("")) {
            return;
        }
        String string = stringRequester.getString();
        String string2 = string.substring(string.lastIndexOf(".") + 1);
        Project project = Jedi.getEditor().getProject();
        Package package_ = project.add(string);
        String[] stringArray = Package.getSupportedLocales();
        int n = 0;
        while (n < stringArray.length) {
            String string3;
            String string4 = n > 0 ? "_" + stringArray[n] + ".properties" : ".properties";
            File file2 = new File(file, string2 + string4);
            if (file2.exists() && ((string3 = package_.getResourceAsPlainText(n)) == null || string3.equals("") || JReqTools.showQuestion(Jedi.getEditor(), ImportDialog.GRS("ImportDialog.Question2", Package.getResourceDescription(n))))) {
                try {
                    String string5;
                    StringBuffer stringBuffer = new StringBuffer();
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
                    while ((string5 = bufferedReader.readLine()) != null) {
                        stringBuffer.append(string5 + "\n");
                    }
                    bufferedReader.close();
                    package_.setResource(n, stringBuffer.toString());
                }
                catch (Exception exception) {
                    JReqTools.showException(exception);
                }
            }
            ++n;
        }
    }
}

