/*
 * Decompiled with CFR 0.152.
 */
package jedi.imprt;

import java.io.File;
import java.io.FilenameFilter;
import java.util.StringTokenizer;
import java.util.Vector;
import jedi.ds.Class;
import jedi.ds.Method;
import jedi.imprt.FileLocationResolver;
import jedi.parser.ASTConstructorDeclaration;
import jedi.parser.ASTInitializer;
import jedi.parser.ASTMethodDeclaration;
import jedi.parser.ASTNestedClassDeclaration;
import jedi.parser.ASTNestedInterfaceDeclaration;
import jedi.parser.FileLocation;
import jedi.parser.Node;
import jedi.parser.SimpleNode;
import swing.addon.GUISystem;
import swing.addon.util.Sorter;

final class ImportUtils {
    ImportUtils() {
    }

    static final void addConstructors(FileLocationResolver fileLocationResolver, Class clazz, Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            ASTConstructorDeclaration aSTConstructorDeclaration = (ASTConstructorDeclaration)vector.elementAt(n);
            Method method = clazz.add(".Constructor", 2);
            method.setPublic(aSTConstructorDeclaration.isPublic());
            method.setProtected(aSTConstructorDeclaration.isProtected());
            method.setPrivate(aSTConstructorDeclaration.isPrivate());
            Vector vector2 = aSTConstructorDeclaration.getParameters();
            Vector vector3 = aSTConstructorDeclaration.getThrows();
            method.setParameters(ImportUtils.vector2StringArray(vector2));
            method.setThrows(ImportUtils.vector2StringArray(vector3));
            method.setText(ImportUtils.makePrettyBlock(fileLocationResolver.get(aSTConstructorDeclaration.getBlock())));
            method.setJavaDoc(ImportUtils.makePrettyJavaDoc(fileLocationResolver.get(aSTConstructorDeclaration.getJavaDoc())));
            ++n;
        }
    }

    static final void addImports(FileLocationResolver fileLocationResolver, Class clazz, Vector vector) {
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)vector.elementAt(n);
            ++n;
        }
        clazz.setImports(stringArray);
    }

    static final void addInitializers(FileLocationResolver fileLocationResolver, Class clazz, Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            ASTInitializer aSTInitializer = (ASTInitializer)vector.elementAt(n);
            Method method = clazz.add(".StaticInitializer", 3);
            method.setText(ImportUtils.makePrettyBlock(fileLocationResolver.get(aSTInitializer.getBlock())));
            method.setJavaDoc(ImportUtils.makePrettyJavaDoc(fileLocationResolver.get(aSTInitializer.getJavaDoc())));
            ++n;
        }
    }

    static final void addInnerClasses(FileLocationResolver fileLocationResolver, Class clazz, Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            Vector vector2;
            Vector vector3;
            Class clazz2;
            SimpleNode simpleNode;
            Node node = (Node)vector.elementAt(n);
            if (node instanceof ASTNestedClassDeclaration) {
                simpleNode = (ASTNestedClassDeclaration)node;
                clazz2 = clazz.addInnerClass(((ASTNestedClassDeclaration)simpleNode).getName(), 1);
                clazz2.setPublic(((ASTNestedClassDeclaration)simpleNode).isPublic());
                clazz2.setProtected(((ASTNestedClassDeclaration)simpleNode).isProtected());
                clazz2.setPrivate(((ASTNestedClassDeclaration)simpleNode).isPrivate());
                clazz2.setStatic(((ASTNestedClassDeclaration)simpleNode).isStatic());
                clazz2.setFinal(((ASTNestedClassDeclaration)simpleNode).isFinal());
                clazz2.setAbstract(((ASTNestedClassDeclaration)simpleNode).isAbstract());
                clazz2.setExtends(((ASTNestedClassDeclaration)simpleNode).getExtends());
                clazz2.setImplements(((ASTNestedClassDeclaration)simpleNode).getImplements());
                clazz2.setJavaDoc(ImportUtils.makePrettyJavaDoc(fileLocationResolver.get(simpleNode.getJavaDoc())));
                vector3 = ((ASTNestedClassDeclaration)simpleNode).getVariables();
                vector2 = ((ASTNestedClassDeclaration)simpleNode).getInnerClasses();
                Vector vector4 = ((ASTNestedClassDeclaration)simpleNode).getMethods();
                Vector vector5 = ((ASTNestedClassDeclaration)simpleNode).getInitializers();
                Vector vector6 = ((ASTNestedClassDeclaration)simpleNode).getConstructors();
                ImportUtils.addVariables(fileLocationResolver, clazz2, vector3);
                ImportUtils.addInnerClasses(fileLocationResolver, clazz2, vector2);
                ImportUtils.addMethods(fileLocationResolver, clazz2, vector4);
                ImportUtils.addInitializers(fileLocationResolver, clazz2, vector5);
                ImportUtils.addConstructors(fileLocationResolver, clazz2, vector6);
            } else {
                simpleNode = (ASTNestedInterfaceDeclaration)node;
                clazz2 = clazz.addInnerClass(((ASTNestedInterfaceDeclaration)simpleNode).getName(), 2);
                clazz2.setPublic(((ASTNestedInterfaceDeclaration)simpleNode).isPublic());
                clazz2.setProtected(((ASTNestedInterfaceDeclaration)simpleNode).isProtected());
                clazz2.setPrivate(((ASTNestedInterfaceDeclaration)simpleNode).isPrivate());
                clazz2.setStatic(((ASTNestedInterfaceDeclaration)simpleNode).isStatic());
                clazz2.setFinal(((ASTNestedInterfaceDeclaration)simpleNode).isFinal());
                clazz2.setAbstract(((ASTNestedInterfaceDeclaration)simpleNode).isAbstract());
                clazz2.setExtends(((ASTNestedInterfaceDeclaration)simpleNode).getExtends());
                clazz2.setJavaDoc(ImportUtils.makePrettyJavaDoc(fileLocationResolver.get(simpleNode.getJavaDoc())));
                vector3 = ((ASTNestedInterfaceDeclaration)simpleNode).getVariables();
                vector2 = ((ASTNestedInterfaceDeclaration)simpleNode).getMethods();
                ImportUtils.addVariables(fileLocationResolver, clazz2, vector3);
                ImportUtils.addMethods(fileLocationResolver, clazz2, vector2);
            }
            ++n;
        }
    }

    static final void addMethods(FileLocationResolver fileLocationResolver, Class clazz, Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            ASTMethodDeclaration aSTMethodDeclaration = (ASTMethodDeclaration)vector.elementAt(n);
            Method method = clazz.add(aSTMethodDeclaration.getName(), 1);
            method.setPublic(aSTMethodDeclaration.isPublic());
            method.setProtected(aSTMethodDeclaration.isProtected());
            method.setPrivate(aSTMethodDeclaration.isPrivate());
            method.setStatic(aSTMethodDeclaration.isStatic());
            method.setFinal(aSTMethodDeclaration.isFinal());
            method.setAbstract(aSTMethodDeclaration.isAbstract());
            method.setNative(aSTMethodDeclaration.isNative());
            method.setSynchronized(aSTMethodDeclaration.isSynchronized());
            method.setResultType(aSTMethodDeclaration.getResultType());
            Vector vector2 = aSTMethodDeclaration.getParameters();
            Vector vector3 = aSTMethodDeclaration.getThrows();
            method.setParameters(ImportUtils.vector2StringArray(vector2));
            method.setThrows(ImportUtils.vector2StringArray(vector3));
            method.setText(ImportUtils.makePrettyBlock(fileLocationResolver.get(aSTMethodDeclaration.getBlock())));
            method.setJavaDoc(ImportUtils.makePrettyJavaDoc(fileLocationResolver.get(aSTMethodDeclaration.getJavaDoc())));
            ++n;
        }
    }

    static final void addVariables(FileLocationResolver fileLocationResolver, Class clazz, Vector vector) {
        String string = "";
        int n = 0;
        while (n < vector.size()) {
            String string2;
            FileLocation fileLocation = (FileLocation)vector.elementAt(n);
            FileLocation fileLocation2 = (FileLocation)vector.elementAt(n + 1);
            if (fileLocation != null) {
                string = string + fileLocationResolver.get(fileLocation) + "\n";
            }
            if (!(string2 = fileLocationResolver.get(fileLocation2)).equals("private static final boolean DEBUG = false;") && !string2.equals("private static final boolean DEBUG = true;")) {
                string = string + string2 + "\n";
                if (fileLocation != null) {
                    string = string + "\n";
                }
            }
            n += 2;
        }
        clazz.setVariables(string);
    }

    static final String makePrettyBlock(String string) {
        try {
            if (string == null) {
                return "";
            }
            if ((string = string.trim()).length() < 2) {
                return "";
            }
            string = string.substring(1, string.length() - 1);
            while (string.length() > 0 && string.charAt(0) == ' ') {
                string = string.substring(1);
            }
            if (string.length() > 0 && string.charAt(0) == '\n') {
                string = string.substring(1);
            }
            int n = 0;
            int n2 = string.length();
            while (n < n2 && (string.charAt(n) == '\t' || string.charAt(n) == ' ')) {
                ++n;
            }
            if (n == 0) {
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer(n2);
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", true);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n3 = 0;
                while (string2.length() > 0 && (string2.charAt(0) == '\t' || string2.charAt(0) == ' ')) {
                    string2 = string2.substring(1);
                    if (++n3 == n) break;
                }
                stringBuffer.append(string2);
            }
            string = stringBuffer.toString();
        }
        catch (Exception exception) {
            GUISystem.err.println(exception);
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    static final String makePrettyJavaDoc(String var0) {
        if (var0 == null || var0.length() < 5) {
            return "";
        }
        var0 = var0.replace('\t', ' ');
        var1_1 = new StringTokenizer(var0, "\n");
        var2_2 = new String[var1_1.countTokens()];
        var3_3 = -1;
        while (var1_1.hasMoreElements()) {
            var2_2[++var3_3] = var1_1.nextToken().trim();
        }
        if (var2_2[0].startsWith("/*")) {
            var2_2[0] = var2_2[0].substring(2);
        }
        if (var2_2[var2_2.length - 1].endsWith("*/")) {
            var2_2[var2_2.length - 1] = var2_2[var2_2.length - 1].substring(0, var2_2[var2_2.length - 1].length() - 2);
        }
        var3_3 = 0;
        ** GOTO lbl21
        {
            var2_2[var3_3] = var2_2[var3_3].substring(1);
            do {
                if (var2_2[var3_3].startsWith("*")) continue block1;
                var2_2[var3_3] = var2_2[var3_3].trim();
                ++var3_3;
lbl21:
                // 2 sources

            } while (var3_3 < var2_2.length);
        }
        var4_4 = var2_2[0].equals("") != false ? "" : var2_2[0] + "\n";
        var3_3 = 1;
        while (var3_3 < var2_2.length) {
            var4_4 = var4_4 + var2_2[var3_3] + "\n";
            ++var3_3;
        }
        return var4_4;
    }

    static final String[] readDirectory(File file) {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = file.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return new File(file, string).isDirectory();
            }
        });
        int n = 0;
        while (stringArray != null && n < stringArray.length) {
            String[] stringArray2 = ImportUtils.readDirectory(new File(file, stringArray[n]));
            int n2 = 0;
            while (n2 < stringArray2.length) {
                vector.addElement(stringArray2[n2]);
                ++n2;
            }
            ++n;
        }
        stringArray = file.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".java");
            }
        });
        int n3 = 0;
        while (stringArray != null && n3 < stringArray.length) {
            vector.addElement(file.toString() + File.separator + stringArray[n3]);
            ++n3;
        }
        stringArray = file.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".properties");
            }
        });
        if (stringArray != null && stringArray.length > 0) {
            vector.addElement(file.toString());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        Sorter.sort((String[])objectArray);
        return objectArray;
    }

    static final String[] vector2StringArray(Vector vector) {
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            stringArray[n] = (String)vector.elementAt(n);
            ++n;
        }
        return stringArray;
    }
}

