/*
 * Decompiled with CFR 0.152.
 */
package jedi.javadoc;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import jedi.Jedi;
import jedi.ds.Package;
import jedi.ds.Project;
import jedi.javadoc.JavaDocCompiler;
import jedi.javadoc.JavaDocFrame;
import jreqtools.JReqTools;
import swing.addon.CheckBox;
import swing.addon.ComboBox;
import swing.addon.FileString;
import swing.addon.Panel;
import swing.addon.Prefs;
import swing.addon.Separator;
import swing.addon.TextArea;
import swing.addon.YFramePanel;
import swing.addon.util.FileUtils;

class JavaDoc2Compiler
extends YFramePanel
implements JavaDocCompiler {
    FileString binary = new FileString(Prefs.isWindowsSystem() ? "C:\\jdk1.2.2\\bin\\javadoc.exe" : "/opt/jdk-1.2/bin/javadoc");
    CheckBox version = new CheckBox(JavaDocFrame.GRS("JavaDoc2Compiler.CheckBox1"));
    CheckBox author = new CheckBox(JavaDocFrame.GRS("JavaDoc2Compiler.CheckBox2"));
    CheckBox nodeprecated = new CheckBox(JavaDocFrame.GRS("JavaDoc2Compiler.CheckBox3"));
    CheckBox noindex = new CheckBox(JavaDocFrame.GRS("JavaDoc2Compiler.CheckBox4"));
    CheckBox splitindex = new CheckBox(JavaDocFrame.GRS("JavaDoc2Compiler.CheckBox6"));
    CheckBox notree = new CheckBox(JavaDocFrame.GRS("JavaDoc2Compiler.CheckBox5"));
    ComboBox members = new ComboBox(new String[]{JavaDocFrame.GRS("JavaDoc2Compiler.ComboBox.Item1"), JavaDocFrame.GRS("JavaDoc2Compiler.ComboBox.Item2"), JavaDocFrame.GRS("JavaDoc2Compiler.ComboBox.Item3")});

    public JavaDoc2Compiler() {
        this.add(new Separator(JavaDocFrame.GRS("JavaDoc2Compiler.Separator4")));
        this.add(this.binary);
        this.addStrut();
        this.add(new Separator(JavaDocFrame.GRS("JavaDoc2Compiler.Separator1")));
        this.add(this.version);
        this.addStrut();
        this.add(this.author);
        this.addStrut();
        this.add(this.nodeprecated);
        this.addStrut();
        this.add(new Separator(JavaDocFrame.GRS("JavaDoc2Compiler.Separator2")));
        this.add(this.noindex);
        this.addStrut();
        this.add(this.splitindex);
        this.addStrut();
        this.add(this.notree);
        this.addStrut();
        this.add(new Separator(JavaDocFrame.GRS("JavaDoc2Compiler.Separator3")));
        this.add(this.members);
        Prefs.add("JavaDoc2Compiler.Binary", this.binary);
        Prefs.add("JavaDoc2Compiler.Version", this.version);
        Prefs.add("JavaDoc2Compiler.Author", this.author);
        Prefs.add("JavaDoc2Compiler.Deprecated", this.nodeprecated);
        Prefs.add("JavaDoc2Compiler.Index", this.noindex);
        Prefs.add("JavaDoc2Compiler.SplitIndex", this.splitindex);
        Prefs.add("JavaDoc2Compiler.Tree", this.notree);
        Prefs.add("JavaDoc2Compiler.Members", this.members);
    }

    public void compile(final TextArea textArea, File file) {
        if (!FileUtils.doesExist(this.binary.getText())) {
            JReqTools.showError(JavaDocFrame.GRS("JavaDoc2Compiler.Error1", this.binary.getText()));
            return;
        }
        Project project = Jedi.getEditor().getProject();
        Package[] packageArray = project.getPackages();
        int n = 7 + packageArray.length;
        int n2 = 0;
        if (this.version.isSelected()) {
            ++n;
        }
        if (this.author.isSelected()) {
            ++n;
        }
        if (this.nodeprecated.isSelected()) {
            ++n;
        }
        if (this.noindex.isSelected()) {
            ++n;
        }
        if (this.splitindex.isSelected()) {
            ++n;
        }
        if (this.notree.isSelected()) {
            ++n;
        }
        String[] stringArray = new String[n];
        stringArray[n2++] = this.binary.getFile().getAbsolutePath();
        stringArray[n2++] = "-J-mx64m";
        if (this.version.isSelected()) {
            stringArray[n2++] = "-version";
        }
        if (this.author.isSelected()) {
            stringArray[n2++] = "-author";
        }
        if (this.nodeprecated.isSelected()) {
            stringArray[n2++] = "-nodeprecated";
        }
        if (this.noindex.isSelected()) {
            stringArray[n2++] = "-noindex";
        }
        if (this.splitindex.isSelected()) {
            stringArray[n2++] = "-splitindex";
        }
        if (this.notree.isSelected()) {
            stringArray[n2++] = "-notree";
        }
        switch (this.members.getSelectedIndex()) {
            case 0: {
                stringArray[n2++] = "-protected";
                break;
            }
            case 1: {
                stringArray[n2++] = "-public";
                break;
            }
            case 2: {
                stringArray[n2++] = "-package";
            }
        }
        stringArray[n2++] = "-d";
        stringArray[n2++] = "\"" + file.getAbsolutePath() + "\"";
        stringArray[n2++] = "-sourcepath";
        stringArray[n2++] = "\"" + Jedi.getCompiler().getClasspath() + File.pathSeparator + Project.sourcesDir + "\"";
        int n3 = 0;
        while (n3 < packageArray.length) {
            stringArray[n2++] = packageArray[n3].getName();
            ++n3;
        }
        file.mkdirs();
        textArea.append(JavaDocFrame.GRS("JavaDoc2Compiler.Message1"));
        project.deleteAllCompiledClasses();
        textArea.append(JavaDocFrame.GRS("JavaDoc2Compiler.Message2"));
        project.export(Project.sourcesDir, 2, null);
        n2 = 0;
        while (n2 < stringArray.length) {
            textArea.append(" " + stringArray[n2]);
            ++n2;
        }
        textArea.append("'\n\n");
        try {
            final Process process = Runtime.getRuntime().exec(stringArray);
            new Thread(){

                public void run() {
                    this.setPriority(4);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    try {
                        int n;
                        while ((n = bufferedReader.read()) != -1) {
                            textArea.append("" + (char)n);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }.start();
            new Thread(){

                public void run() {
                    this.setPriority(4);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                    try {
                        int n;
                        while ((n = bufferedReader.read()) != -1) {
                            textArea.append("" + (char)n);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }.start();
            process.waitFor();
        }
        catch (Exception exception) {
            JReqTools.showException(exception);
        }
    }

    public String getArguments() {
        return "-J-mx64m -version -author";
    }

    public String getBinary() {
        return this.binary.getText();
    }

    public String getName() {
        return JavaDocFrame.GRS("JavaDoc2Compiler.Name");
    }

    public Panel getOptionPanel() {
        return this;
    }
}

