/*
 * Decompiled with CFR 0.152.
 */
package jedi.javadoc;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import jedi.Jedi;
import jedi.javadoc.JavaDoc11Compiler;
import jedi.javadoc.JavaDoc2Compiler;
import jedi.javadoc.JavaDocCompiler;
import jreqtools.JReqTools;
import swing.addon.FileString;
import swing.addon.Frame;
import swing.addon.GUISystem;
import swing.addon.NButtons;
import swing.addon.Prefs;
import swing.addon.Separator;
import swing.addon.TabbedPane;
import swing.addon.TextArea;
import swing.addon.YFramePanel;
import swing.addon.util.NiceThread;

public class JavaDocFrame
extends Frame
implements ActionListener {
    static final ResourceBundle resources = ResourceBundle.getBundle("jedi.javadoc.resources.javadoc");
    JavaDocCompiler compiler1 = new JavaDoc11Compiler();
    JavaDocCompiler compiler2 = new JavaDoc2Compiler();
    TabbedPane tabbedPane = new TabbedPane();
    FileString outdir = new FileString(Jedi.getHomeDirectory(), 1);
    TextArea messages = new TextArea();
    NButtons buttons = new NButtons(JavaDocFrame.GRS("Frame.Generate"), JavaDocFrame.GRS("Frame.Dismiss"));

    public JavaDocFrame() {
        super(JavaDocFrame.GRS("Frame.Title"));
        this.messages.setEditable(false);
        this.buttons.addHelpButton("javadoc");
        this.buttons.getComponentNumber(0).setIcon(Prefs.getIcon("ok"));
        this.buttons.getComponentNumber(1).setIcon(Prefs.getIcon("dismiss"));
        this.buttons.addActionListener(this);
        this.tabbedPane.addTab(this.compiler1.getName(), this.compiler1.getOptionPanel());
        this.tabbedPane.addTab(this.compiler2.getName(), this.compiler2.getOptionPanel());
        YFramePanel yFramePanel = new YFramePanel();
        this.setContentPane(yFramePanel);
        yFramePanel.add(new Separator(JavaDocFrame.GRS("Frame.Separator1")));
        yFramePanel.add(this.tabbedPane);
        yFramePanel.addStrut();
        yFramePanel.add(new Separator(JavaDocFrame.GRS("Frame.Separator2")));
        yFramePanel.add(this.outdir);
        yFramePanel.addStrut();
        yFramePanel.add(new Separator(JavaDocFrame.GRS("Frame.Separator3")));
        yFramePanel.add(this.messages);
        yFramePanel.addStrut();
        yFramePanel.add(this.buttons);
        this.pack();
        Prefs.add("JavaDocFrame", this);
        Prefs.add("JavaDocFrame.OutputDirectory", this.outdir);
        Prefs.add("JavaDocFrame.TabbedPane", this.tabbedPane);
    }

    static String GRS(String string) {
        try {
            return resources.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println(missingResourceException.getLocalizedMessage() + ": '" + string + "'");
            return "MISSING RESOURCE: " + string;
        }
    }

    static String GRS(String string, String string2) {
        String string3 = JavaDocFrame.GRS(string);
        try {
            string3 = MessageFormat.format(string3, string2);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        return string3;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.buttons) {
            switch (this.buttons.get()) {
                case 0: {
                    this.compile();
                    break;
                }
                case 1: {
                    this.setVisible(false);
                }
            }
        } else {
            GUISystem.err.println(this.getClass().getName() + ".actionPerformed(): internal error");
        }
    }

    public void compile() {
        this.setBusy(true);
        this.buttons.setEnabled(false);
        new NiceThread(){

            public void runNice() {
                JavaDocFrame.this.messages.setText("");
                try {
                    switch (JavaDocFrame.this.tabbedPane.getSelectedIndex()) {
                        case 0: {
                            JavaDocFrame.this.compiler1.compile(JavaDocFrame.this.messages, JavaDocFrame.this.outdir.getFile());
                            break;
                        }
                        case 1: {
                            JavaDocFrame.this.compiler2.compile(JavaDocFrame.this.messages, JavaDocFrame.this.outdir.getFile());
                        }
                    }
                }
                catch (Exception exception) {
                    JReqTools.showException(JavaDocFrame.this, exception);
                }
                JavaDocFrame.this.buttons.setEnabled(true);
                JavaDocFrame.this.setBusy(false);
            }
        }.start();
    }

    public JavaDocCompiler getJavaDocCompiler() {
        return this.getJavaDocCompiler(this.tabbedPane.getSelectedIndex());
    }

    JavaDocCompiler getJavaDocCompiler(int n) {
        switch (n) {
            case 0: {
                return this.compiler1;
            }
            case 1: {
                return this.compiler2;
            }
        }
        GUISystem.err.println(this.getClass().getName() + ".getJavaDocCompiler(): internal error");
        return this.compiler1;
    }

    private static void main(String[] stringArray) {
        Prefs.init("Jedi", null);
        JavaDocFrame javaDocFrame = new JavaDocFrame();
        javaDocFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        javaDocFrame.setVisible(true);
    }
}

