/*
 * Decompiled with CFR 0.152.
 */
package jedi.methodwizard;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JDialog;
import jedi.methodwizard.MethodData;
import jedi.methodwizard.MethodWizard;
import jedi.prefs.JediPrefs;
import jreqtools.JReqTools;
import swing.addon.EditableListview;
import swing.addon.GUISystem;
import swing.addon.OkCancelButtons;
import swing.addon.PopupMenu;
import swing.addon.Prefs;
import swing.addon.Separator;
import swing.addon.Strut;
import swing.addon.TextField;
import swing.addon.ToggleButton;
import swing.addon.Utils;
import swing.addon.YFramePanel;
import swing.addon.util.StringArray;

class AddRequester
extends JDialog
implements ActionListener {
    MethodWizard frame = null;
    TextField name = new TextField("");
    TextField result = new TextField("void");
    EditableListview parameters = new EditableListview();
    EditableListview throwslist = new EditableListview();
    ToggleButton pub = new ToggleButton("public", true);
    ToggleButton pro = new ToggleButton("protected", false);
    ToggleButton pri = new ToggleButton("private", false);
    ToggleButton abs = new ToggleButton("abstract", false);
    ToggleButton sta = new ToggleButton("static", false);
    ToggleButton fin = new ToggleButton("final", false);
    ToggleButton nat = new ToggleButton("native", false);
    ToggleButton syn = new ToggleButton("synchronized", false);
    OkCancelButtons buttons = new OkCancelButtons();
    int answer = -1;

    public AddRequester(MethodWizard methodWizard) {
        super(methodWizard, MethodWizard.GRS("Title2"), true);
        this.frame = methodWizard;
        this.buttons.addHelpButton("method_prefs");
        this.buttons.addActionListener(this);
        this.pro.addActionListener(this);
        this.pri.addActionListener(this);
        this.abs.addActionListener(this);
        this.sta.addActionListener(this);
        this.fin.addActionListener(this);
        this.nat.addActionListener(this);
        this.syn.addActionListener(this);
        AddRequester.createPopupMenuForResultType(this.result);
        this.parameters.createPopupMenuFrom(StringArray.parseFromString(JediPrefs.getProperty("ContextMenu.Parameters")));
        this.throwslist.createPopupMenuFrom(StringArray.parseFromString(JediPrefs.getProperty("ContextMenu.Throws")));
        Box box = Box.createHorizontalBox();
        box.add(this.pub);
        box.add(this.pro);
        box.add(this.pri);
        box.add(this.abs);
        Box box2 = Box.createHorizontalBox();
        box2.add(this.sta);
        box2.add(this.fin);
        box2.add(this.nat);
        box2.add(this.syn);
        YFramePanel yFramePanel = new YFramePanel();
        yFramePanel.add(new Separator(MethodWizard.GRS("MethodName")));
        yFramePanel.add(this.name);
        yFramePanel.add(new Strut());
        yFramePanel.add(new Separator(MethodWizard.GRS("Modifiers")));
        yFramePanel.add(box);
        yFramePanel.add(box2);
        yFramePanel.add(new Separator(MethodWizard.GRS("ResultType")));
        yFramePanel.add(this.result);
        yFramePanel.add(new Separator(MethodWizard.GRS("ParameterList")));
        yFramePanel.add(this.parameters);
        yFramePanel.add(new Separator(MethodWizard.GRS("ThrowsList")));
        yFramePanel.add(this.throwslist);
        yFramePanel.add(this.buttons);
        this.setContentPane(yFramePanel);
        this.pack();
        Prefs.add("MethodWizard.addRequester", this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.pub) {
            if (this.pub.isSelected()) {
                this.pro.setSelected(false);
                this.pri.setSelected(false);
            }
        } else if (object == this.pro) {
            if (this.pro.isSelected()) {
                this.pub.setSelected(false);
                this.pri.setSelected(false);
            }
        } else if (object == this.pri) {
            if (this.pri.isSelected()) {
                this.pro.setSelected(false);
                this.pub.setSelected(false);
                this.abs.setSelected(false);
            }
        } else if (object == this.abs) {
            if (this.abs.isSelected()) {
                this.pri.setSelected(false);
                this.sta.setSelected(false);
                this.fin.setSelected(false);
                this.nat.setSelected(false);
                this.syn.setSelected(false);
            }
        } else if (object == this.fin) {
            if (this.fin.isSelected()) {
                this.abs.setSelected(false);
            }
        } else if (object == this.sta) {
            if (this.sta.isSelected()) {
                this.abs.setSelected(false);
            }
        } else if (object == this.nat) {
            if (this.nat.isSelected()) {
                this.abs.setSelected(false);
            }
        } else if (object == this.syn) {
            if (this.syn.isSelected()) {
                this.abs.setSelected(false);
            }
        } else if (object == this.buttons) {
            this.answer = this.buttons.get();
            switch (this.answer) {
                case 0: {
                    if (!this.name.getText().equals("") && this.name.getText().lastIndexOf(46) != -1) {
                        if (!this.result.getText().equals("")) {
                            this.setVisible(false);
                            break;
                        }
                        JReqTools.showError(this.frame, MethodWizard.GRS("Error5"));
                        break;
                    }
                    JReqTools.showError(this.frame, MethodWizard.GRS("Error6"));
                    break;
                }
                default: {
                    this.setVisible(false);
                    break;
                }
            }
        } else {
            GUISystem.err.println(this.getClass().getName() + ".actionPerformed(): internal error");
        }
    }

    static PopupMenu createPopupMenuForResultType(final TextField textField) {
        PopupMenu popupMenu = Utils.createPopupMenu(textField, "Result Type");
        Utils.addMenuItemsFrom(StringArray.parseFromString(JediPrefs.getProperty("ContextMenu.ResultType")), null, null, popupMenu, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                textField.setText(actionEvent.getActionCommand());
            }
        });
        return popupMenu;
    }

    public MethodData get() {
        MethodData methodData = new MethodData();
        methodData.name = this.name.getText();
        methodData.result = this.result.getText();
        methodData.pub = this.pub.isSelected();
        methodData.pro = this.pro.isSelected();
        methodData.pri = this.pri.isSelected();
        methodData.abs = this.abs.isSelected();
        methodData.sta = this.sta.isSelected();
        methodData.fin = this.fin.isSelected();
        methodData.nat = this.nat.isSelected();
        methodData.syn = this.syn.isSelected();
        methodData.parameters = this.parameters.get();
        methodData.throwslist = this.throwslist.get();
        return methodData;
    }

    public int getAnswer() {
        return this.answer;
    }

    public void set(MethodData methodData) {
        this.name.setText(methodData.name);
        this.result.setText(methodData.result);
        this.pub.setSelected(methodData.pub);
        this.pro.setSelected(methodData.pro);
        this.pri.setSelected(methodData.pri);
        this.abs.setSelected(methodData.abs);
        this.sta.setSelected(methodData.sta);
        this.fin.setSelected(methodData.fin);
        this.nat.setSelected(methodData.nat);
        this.syn.setSelected(methodData.syn);
        this.parameters.set(methodData.parameters);
        this.throwslist.set(methodData.throwslist);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.answer = -1;
        }
        super.setVisible(bl);
    }
}

