/*
 * Decompiled with CFR 0.152.
 */
package jedi.parser;

import jedi.parser.FileLocation;
import jedi.parser.JavaParser;
import jedi.parser.JavaParserTreeConstants;
import jedi.parser.Node;
import jedi.parser.Token;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected JavaParser parser;
    protected Token first_token;
    protected Token last_token;

    public SimpleNode(int n) {
        this.id = n;
    }

    public SimpleNode(JavaParser javaParser, int n) {
        this(n);
        this.parser = javaParser;
    }

    public void dump(String string) {
        System.out.println(this.toString(string));
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                SimpleNode simpleNode = (SimpleNode)this.children[n];
                if (simpleNode != null) {
                    simpleNode.dump(string + " ");
                }
                ++n;
            }
        }
    }

    public FileLocation getJavaDoc() {
        if (this.first_token.specialToken == null) {
            return null;
        }
        Token token = this.first_token.specialToken;
        while (token != null) {
            if (token.kind == 10) {
                FileLocation fileLocation = new FileLocation();
                fileLocation.beginLine = token.beginLine;
                fileLocation.beginColumn = token.beginColumn;
                fileLocation.endLine = token.endLine;
                fileLocation.endColumn = token.endColumn;
                return fileLocation;
            }
            token = token.specialToken;
        }
        return null;
    }

    public void jjtAddChild(Node node, int n) {
        if (this.children == null) {
            this.children = new Node[n + 1];
        } else if (n >= this.children.length) {
            Node[] nodeArray = new Node[n + 1];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
        this.children[n] = node;
    }

    public void jjtClose() {
    }

    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtOpen() {
    }

    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    public String toString() {
        return JavaParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String string) {
        return string + this.toString();
    }
}

