/*
 * Decompiled with CFR 0.152.
 */
package jedi.pluginmanager;

import java.io.DataInputStream;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class PluginClassLoader
extends ClassLoader {
    String zipfile;

    public PluginClassLoader(String string) {
        this.zipfile = string;
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        try {
            ZipFile zipFile = new ZipFile(this.zipfile);
            ZipEntry zipEntry = zipFile.getEntry(string.replace('.', '/') + ".class");
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            int n = (int)zipEntry.getSize();
            byte[] byArray = new byte[n];
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            dataInputStream.readFully(byArray);
            dataInputStream.close();
            zipFile.close();
            return this.defineClass(string, byArray, 0, n);
        }
        catch (Exception exception) {
            throw new ClassNotFoundException(string);
        }
    }

    public InputStream getResourceAsStream(String string) {
        try {
            ZipFile zipFile = new ZipFile(this.zipfile);
            ZipEntry zipEntry = zipFile.getEntry(string);
            return zipFile.getInputStream(zipEntry);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

