/*
 * Decompiled with CFR 0.152.
 */
package jedi.pluginmanager;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import jedi.Jedi;
import jedi.JediPlugin;
import jedi.pluginmanager.PluginAction;
import jedi.pluginmanager.PluginClassLoader;
import jedi.pluginmanager.PluginManager;
import jedi.pluginmanager.PluginPrefs;
import jreqtools.JReqTools;
import swing.addon.GUISystem;
import swing.addon.MenuItem;

class PluginData
implements JediPlugin {
    String filename;
    String name;
    Class klasse;
    JediPlugin plugin;
    MenuItem item;
    Action action;
    PluginClassLoader classloader;
    PluginManager manager;

    public PluginData(String string, String string2) {
        this.name = string;
        this.filename = string2;
        this.manager = Jedi.getPluginManager();
        this.classloader = new PluginClassLoader(string2);
        try {
            this.klasse = this.classloader.findClass("jedi.plugins." + string.toLowerCase() + "." + string);
            this.plugin = (JediPlugin)this.klasse.newInstance();
            Object object = this.loadPrefs();
            if (object != null) {
                this.plugin.setPrefs(object);
            }
            this.plugin.setInstallationPath(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            JReqTools.showError("PluginManager: Can't find plugin '" + string + "' in file " + string2);
        }
        catch (Exception exception) {
            GUISystem.err.println(exception);
        }
        if (PluginManager.pluginPrefs.get(string) == null) {
            PluginManager.pluginPrefs.put(string, new PluginPrefs());
        }
    }

    public void editPrefs() {
        try {
            if (this.plugin != null) {
                this.plugin.editPrefs();
            } else {
                JReqTools.showError("PluginManager.Error1");
            }
        }
        catch (Throwable throwable) {
            JReqTools.showException(throwable);
        }
    }

    public void execute() {
        try {
            if (this.plugin != null) {
                this.plugin.execute();
            } else {
                JReqTools.showError("PluginManager.Error1");
            }
        }
        catch (Throwable throwable) {
            JReqTools.showException(throwable);
        }
    }

    public Action getAction() {
        if (this.action == null) {
            this.action = new PluginAction(this);
        }
        return this.action;
    }

    public boolean getAddToMenu() {
        PluginPrefs pluginPrefs = (PluginPrefs)PluginManager.pluginPrefs.get(this.name);
        return pluginPrefs.addToMenu;
    }

    public boolean getAddToToolbar() {
        PluginPrefs pluginPrefs = (PluginPrefs)PluginManager.pluginPrefs.get(this.name);
        return pluginPrefs.addToToolbar;
    }

    public String getAuthor() {
        try {
            return this.plugin != null ? this.plugin.getAuthor() : PluginManager.GRS("Error1");
        }
        catch (Throwable throwable) {
            JReqTools.showException(throwable);
            return "Exception occured";
        }
    }

    public JComponent getComponent() {
        try {
            return this.plugin != null ? this.plugin.getComponent() : null;
        }
        catch (Throwable throwable) {
            JReqTools.showException(throwable);
            return null;
        }
    }

    public String getDescription() {
        try {
            return this.plugin != null ? this.plugin.getDescription() : PluginManager.GRS("Error1");
        }
        catch (Throwable throwable) {
            JReqTools.showException(throwable);
            return "Exception occured";
        }
    }

    public String getDocumentation() {
        try {
            return this.plugin != null ? this.plugin.getDocumentation() : PluginManager.GRS("Error1");
        }
        catch (Throwable throwable) {
            JReqTools.showException(throwable);
            return "Exception occured";
        }
    }

    public Icon getIcon() {
        try {
            return this.plugin != null ? this.plugin.getIcon() : null;
        }
        catch (Throwable throwable) {
            JReqTools.showException(throwable);
            return null;
        }
    }

    public String getLocation() {
        return this.filename;
    }

    public MenuItem getMenuItem() {
        if (this.item == null) {
            this.item = new MenuItem(this.name);
            this.item.addActionListener(this.getAction());
        }
        return this.item;
    }

    public String getName() {
        return this.name;
    }

    public Object getPrefs() {
        try {
            return this.plugin != null ? this.plugin.getPrefs() : null;
        }
        catch (Throwable throwable) {
            JReqTools.showException(throwable);
            return null;
        }
    }

    public int getRevision() {
        try {
            return this.plugin != null ? this.plugin.getRevision() : -1;
        }
        catch (Throwable throwable) {
            JReqTools.showException(throwable);
            return -1;
        }
    }

    public int getVersion() {
        try {
            return this.plugin != null ? this.plugin.getVersion() : -1;
        }
        catch (Throwable throwable) {
            JReqTools.showException(throwable);
            return -1;
        }
    }

    public boolean hasPreferencesFrame() {
        try {
            return this.plugin != null ? this.plugin.hasPreferencesFrame() : false;
        }
        catch (Throwable throwable) {
            JReqTools.showException(throwable);
            return false;
        }
    }

    public Object loadPrefs() {
        String string = PluginManager.pluginDir1 + File.separator + this.name + ".prefs";
        Object object = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(string));
            object = objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Throwable throwable) {
            JReqTools.showException(throwable);
        }
        return object;
    }

    public void savePrefs() {
        try {
            if (this.plugin == null) {
                return;
            }
            String string = PluginManager.pluginDir1 + File.separator + this.name + ".prefs";
            Object object = this.plugin.getPrefs();
            if (object == null) {
                return;
            }
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(string));
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
        }
        catch (Throwable throwable) {
            JReqTools.showException(throwable);
        }
    }

    public void setAddToMenu(boolean bl) {
        PluginPrefs pluginPrefs = (PluginPrefs)PluginManager.pluginPrefs.get(this.name);
        pluginPrefs.addToMenu = bl;
    }

    public void setAddToToolbar(boolean bl) {
        PluginPrefs pluginPrefs = (PluginPrefs)PluginManager.pluginPrefs.get(this.name);
        pluginPrefs.addToToolbar = bl;
    }

    public void setInstallationPath(String string) {
        GUISystem.err.println("PluginManager.PluginData.setInstallationPath(): internal error");
    }

    public void setPrefs(Object object) {
        try {
            if (this.plugin != null) {
                this.plugin.setPrefs(object);
            }
        }
        catch (Throwable throwable) {
            JReqTools.showException(throwable);
        }
    }
}

