/*
 * Decompiled with CFR 0.152.
 */
package jedi.pluginmanager;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jedi.Jedi;
import jedi.pluginmanager.PluginAction;
import jedi.pluginmanager.PluginData;
import jreqtools.JReqTools;
import swing.addon.Button;
import swing.addon.CheckBox;
import swing.addon.Frame;
import swing.addon.GUISystem;
import swing.addon.Label;
import swing.addon.Listview;
import swing.addon.Menu;
import swing.addon.NButtons;
import swing.addon.Prefs;
import swing.addon.Separator;
import swing.addon.Strut;
import swing.addon.Text;
import swing.addon.ToolBar;
import swing.addon.YFramePanel;
import swing.addon.util.FileChangeListener;
import swing.addon.util.FileNotification;
import swing.addon.util.Sorter;

public class PluginManager
extends Frame
implements ActionListener,
ListSelectionListener {
    static final ResourceBundle resources = ResourceBundle.getBundle("jedi.pluginmanager.resources.pluginmanager");
    Listview list = new Listview();
    Text version = new Text("", 2);
    Text description = new Text("", 2);
    Text author = new Text("", 2);
    Text location = new Text("", 2);
    CheckBox toMenu = new CheckBox(PluginManager.GRS("CheckBox1"));
    CheckBox toToolbar = new CheckBox(PluginManager.GRS("CheckBox2"));
    Button execute = new Button(PluginManager.GRS("Button1"));
    Button prefs = new Button(PluginManager.GRS("Button2"));
    Button documentation = new Button(PluginManager.GRS("Button3"));
    Label labelVersion = new Label(PluginManager.GRS("Label1"), 2);
    Label labelDescription = new Label(PluginManager.GRS("Label2"), 2);
    Label labelAuthor = new Label(PluginManager.GRS("Label3"), 2);
    Label labelLocation = new Label(PluginManager.GRS("Label4"), 2);
    NButtons buttons = new NButtons(Prefs.getResourceString("Ok"));
    static final Hashtable plugins = new Hashtable(10, 10.0f);
    static final Hashtable pluginPrefs = new Hashtable(10, 10.0f);
    static File pluginDir1 = new File(Jedi.getHomeDirectory(), "plugins");
    static File pluginDir2 = new File(Jedi.getPluginDirectory());

    public PluginManager() {
        super(PluginManager.GRS("Title"));
        this.labelVersion.setAlignmentX(0.0f);
        this.labelDescription.setAlignmentX(0.0f);
        this.labelAuthor.setAlignmentX(0.0f);
        this.labelLocation.setAlignmentX(0.0f);
        this.buttons.getComponentNumber(0).setIcon(Prefs.getIcon("ok"));
        this.buttons.addHelpButton("plugin_manager");
        this.list.addListSelectionListener(this);
        this.toMenu.addActionListener(this);
        this.toToolbar.addActionListener(this);
        this.execute.addActionListener(this);
        this.prefs.addActionListener(this);
        this.documentation.addActionListener(this);
        this.buttons.addActionListener(this);
        Box box = Box.createVerticalBox();
        box.add(this.version);
        box.add(new Strut());
        box.add(this.description);
        box.add(new Strut());
        box.add(this.author);
        box.add(new Strut());
        box.add(this.location);
        Box box2 = Box.createVerticalBox();
        box2.add(this.labelVersion);
        box2.add(new Strut());
        box2.add(this.labelDescription);
        box2.add(new Strut());
        box2.add(this.labelAuthor);
        box2.add(new Strut());
        box2.add(this.labelLocation);
        Box box3 = Box.createHorizontalBox();
        box3.add(box2);
        box3.add(new Strut());
        box3.add(box);
        Box box4 = Box.createHorizontalBox();
        box4.add(this.execute);
        box4.add(new Strut());
        box4.add(Box.createHorizontalGlue());
        box4.add(this.prefs);
        box4.add(new Strut());
        box4.add(Box.createHorizontalGlue());
        box4.add(this.documentation);
        Box box5 = Box.createVerticalBox();
        box5.add(new Separator(PluginManager.GRS("Separator1")));
        box5.add(box3);
        box5.add(new Strut());
        box5.add(new Separator(PluginManager.GRS("Separator2")));
        box5.add(this.toMenu);
        box5.add(new Strut());
        box5.add(this.toToolbar);
        box5.add(new Strut());
        box5.add(new Separator(PluginManager.GRS("Separator3")));
        box5.add(box4);
        box5.add(Box.createVerticalGlue());
        Box box6 = Box.createHorizontalBox();
        box6.add(this.list);
        box6.add(new Strut());
        box6.add(box5);
        YFramePanel yFramePanel = new YFramePanel();
        yFramePanel.add(box6);
        yFramePanel.add(new Strut());
        yFramePanel.add(this.buttons);
        this.setContentPane(yFramePanel);
        this.pack();
        Prefs.add("PluginFrame", this);
    }

    static final String GRS(String string) {
        try {
            return resources.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            JReqTools.showMessage(missingResourceException.getLocalizedMessage() + ":\n\n'" + string + "'");
            return "MISSING RESOURCE: " + string;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        PluginData pluginData = PluginManager.getPlugin((String)this.list.getSelectedValue());
        if (pluginData == null) {
            GUISystem.err.println("PluginManager.PluginFrame.valueChanged(): internal error 1");
            return;
        }
        if (object == this.toMenu) {
            pluginData.setAddToMenu(this.toMenu.isSelected());
        } else if (object == this.toToolbar) {
            pluginData.setAddToToolbar(this.toToolbar.isSelected());
        } else if (object == this.execute) {
            pluginData.execute();
        } else if (object == this.prefs) {
            pluginData.editPrefs();
        } else if (object == this.documentation) {
            String string = pluginData.getDocumentation();
            if (string == null) {
                JReqTools.showError(PluginManager.GRS("Error2"));
            }
        } else if (object == this.buttons) {
            this.setVisible(false);
        } else {
            GUISystem.err.println("PluginManager.PluginFrame.actionPerformed(): internal error 2");
        }
    }

    public static PluginData getPlugin(String string) {
        return (PluginData)plugins.get(string);
    }

    public static String[] getPluginList() {
        int n = 0;
        String[] stringArray = new String[plugins.size()];
        Enumeration enumeration = plugins.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        Sorter.sort(stringArray);
        return stringArray;
    }

    public static Action[] getPluginsAsActions() {
        String[] stringArray = PluginManager.getPluginList();
        Action[] actionArray = new Action[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            actionArray[n] = new PluginAction(PluginManager.getPlugin(stringArray[n]));
            ++n;
        }
        return actionArray;
    }

    private static void load() {
        String string;
        int n;
        String[] stringArray = pluginDir2.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".jar") || string.endsWith(".zip");
            }
        });
        if (stringArray != null) {
            n = 0;
            while (n < stringArray.length) {
                string = stringArray[n].substring(0, stringArray[n].length() - 4);
                plugins.put(string, new PluginData(string, pluginDir2 + File.separator + stringArray[n]));
                ++n;
            }
        }
        if ((stringArray = pluginDir1.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".jar") || string.endsWith(".zip");
            }
        })) != null) {
            n = 0;
            while (n < stringArray.length) {
                string = stringArray[n].substring(0, stringArray[n].length() - 4);
                plugins.put(string, new PluginData(string, pluginDir1 + File.separator + stringArray[n]));
                ++n;
            }
        }
        PluginManager.makePluginMenu(PluginManager.getPluginList());
        PluginManager.updateToolbar(PluginManager.getPluginList());
    }

    private static void makePluginMenu(String[] stringArray) {
        Menu menu = Jedi.getEditor().getPluginMenu();
        while (menu.getItemCount() > 2) {
            menu.remove(2);
        }
        int n = 0;
        while (n < stringArray.length) {
            PluginData pluginData = PluginManager.getPlugin(stringArray[n]);
            if (pluginData != null && pluginData.getAddToMenu()) {
                menu.add(pluginData.getMenuItem());
            }
            ++n;
        }
    }

    public static void reload() {
        if (Jedi.getPluginManager().isVisible()) {
            Jedi.getPluginManager().setVisible(false);
        }
        JReqTools.showMessage(PluginManager.GRS("Reload"));
        plugins.clear();
        PluginManager.load();
    }

    private void setData() {
        PluginData pluginData = PluginManager.getPlugin((String)this.list.getSelectedValue());
        if (pluginData == null) {
            GUISystem.err.println("PluginManager.PluginFrame.setData(): internal error");
            return;
        }
        this.version.setText("" + pluginData.getVersion() + "." + pluginData.getRevision());
        this.description.setText(pluginData.getDescription());
        this.author.setText(pluginData.getAuthor());
        this.location.setText(pluginData.getLocation());
        this.toMenu.setSelected(pluginData.getAddToMenu());
        this.toToolbar.setEnabled(pluginData.getIcon() != null || pluginData.getComponent() != null);
        this.toToolbar.setSelected(pluginData.getAddToToolbar());
        this.prefs.setEnabled(pluginData.hasPreferencesFrame());
    }

    public void setVisible(boolean bl) {
        Object[] objectArray = PluginManager.getPluginList();
        if (bl) {
            this.toMenu.setEnabled(objectArray.length > 0);
            this.toToolbar.setEnabled(objectArray.length > 0);
            this.execute.setEnabled(objectArray.length > 0);
            this.prefs.setEnabled(objectArray.length > 0);
            this.list.setElements(objectArray);
            if (objectArray.length > 0) {
                this.setData();
            }
        } else {
            PluginManager.makePluginMenu((String[])objectArray);
            PluginManager.updateToolbar((String[])objectArray);
        }
        super.setVisible(bl);
    }

    public static void start() {
        pluginDir1.mkdirs();
        Prefs.add("PluginManager.prefs", pluginPrefs);
        PluginManager.load();
        FileNotification fileNotification = new FileNotification(pluginDir1, new FileChangeListener(){

            public void fileChanged(File file) {
                PluginManager.reload();
            }
        });
        FileNotification fileNotification2 = new FileNotification(pluginDir2, new FileChangeListener(){

            public void fileChanged(File file) {
                PluginManager.reload();
            }
        });
    }

    public static void stop() {
        Enumeration enumeration = plugins.keys();
        while (enumeration.hasMoreElements()) {
            ((PluginData)plugins.get(enumeration.nextElement())).savePrefs();
        }
    }

    private static void updateToolbar(String[] stringArray) {
        ToolBar toolBar = Jedi.getEditor().getToolBar();
        while (toolBar.getComponentCount() > 23) {
            toolBar.remove(23);
        }
        int n = 0;
        while (n < stringArray.length) {
            PluginData pluginData = PluginManager.getPlugin(stringArray[n]);
            if (pluginData != null && pluginData.getAddToToolbar()) {
                if (pluginData.getIcon() != null) {
                    toolBar.add(pluginData.getIcon(), pluginData.getAction());
                } else if (pluginData.getComponent() != null) {
                    toolBar.add(pluginData.getComponent(), pluginData.getAction());
                } else {
                    GUISystem.err.println("PluginManager.updateToolBar(): internal error");
                }
            }
            ++n;
        }
        toolBar.invalidate();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.setData();
    }
}

