/*
 * Decompiled with CFR 0.152.
 */
package jedi.prefs;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import jedi.Jedi;
import jedi.fetchdoc.FetchDoc;
import jedi.prefs.JediPrefs;
import jreqtools.FileRequester;
import jreqtools.JReqTools;
import jreqtools.ProgressTask;
import jreqtools.ProgressTracker;
import swing.addon.Dialog;
import swing.addon.EditableListview;
import swing.addon.GridBagConstraints;
import swing.addon.GridBagLayout;
import swing.addon.Insets;
import swing.addon.MenuItem;
import swing.addon.OkCancelButtons;
import swing.addon.Panel;
import swing.addon.Prefs;
import swing.addon.YFramePanel;
import swing.addon.util.StringArray;

public class Action_Prefs_DocumentationDirectories
extends AbstractAction {
    PrefsDialog dialog = null;

    public Action_Prefs_DocumentationDirectories() {
        super("jedi-prefs-documentation-directories");
        this.putValue("ShortDescription", JediPrefs.GRS("DocumentationDirectories.Description"));
        JediPrefs.putDefaultProperty("DocumentationDirectories", "");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.dialog == null) {
            this.dialog = new PrefsDialog();
            Prefs.add("DocumentationDirectories.Dialog", this.dialog);
        }
        this.dialog.list.set(StringArray.parseFromString(JediPrefs.getProperty("DocumentationDirectories")));
        if (!this.dialog.request()) {
            return;
        }
        JediPrefs.putProperty("DocumentationDirectories", StringArray.toString(this.dialog.list.get()));
        ProgressTracker progressTracker = new ProgressTracker(JediPrefs.GRS("DocumentationDirectories.ProgressTitle"), JediPrefs.GRS("DocumentationDirectories.ProgressMessage"), new IndexBuilder(Jedi.getSaveDirectory() + File.separator + "fetchdoc_index", this.dialog.list.get()));
        progressTracker.start();
    }

    class PrefsDialog
    extends Dialog {
        boolean answer = false;
        OkCancelButtons buttons = new OkCancelButtons();
        EditableListview list = new EditableListview();
        MenuItem request = new MenuItem(JediPrefs.GRS("Requester"));
        FileRequester requester = new FileRequester();

        public PrefsDialog() {
            super(Jedi.getEditor(), JediPrefs.GRS("DocumentationDirectories.DialogTitle"));
            this.requester.setDirectoriesOnly(true);
            this.buttons.setShowSeparator(false);
            this.buttons.addHelpButton("prefs_documentation_directories");
            this.buttons.addActionListener(new ActionListener(this){
                private final /* synthetic */ PrefsDialog this$1;
                {
                    this.this$1 = prefsDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.this$1.buttons.get() == 0) {
                        this.this$1.ok();
                    } else {
                        this.this$1.cancel();
                    }
                }
            });
            YFramePanel yFramePanel = new YFramePanel();
            yFramePanel.add(this.createOptionPanel());
            yFramePanel.addStrut();
            yFramePanel.add(this.buttons);
            this.list.add(this.request);
            this.request.addActionListener(new ActionListener(this){
                private final /* synthetic */ PrefsDialog this$1;
                {
                    this.this$1 = prefsDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.this$1.requester.request() != 0) {
                        return;
                    }
                    this.this$1.list.addItem(this.this$1.requester.getFile().toString());
                }
            });
            this.setContentPane(yFramePanel);
            this.pack();
        }

        void cancel() {
            this.answer = false;
            this.setVisible(false);
        }

        private Panel createOptionPanel() {
            Panel panel = new Panel(new GridBagLayout());
            panel.setBorder(BorderFactory.createTitledBorder(JediPrefs.GRS("DocumentationDirectories.BorderTitle")));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(Prefs.getObjectSpace(), Prefs.getObjectSpace(), Prefs.getObjectSpace(), Prefs.getObjectSpace());
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            panel.add((Component)this.list, gridBagConstraints);
            return panel;
        }

        void ok() {
            this.answer = true;
            this.setVisible(false);
        }

        public boolean request() {
            this.answer = false;
            this.setVisible(true);
            return this.answer;
        }
    }

    class IndexBuilder
    extends ProgressTask {
        FetchDoc fd = null;
        String message = "-";
        String[] data = null;
        int current = 0;
        String path;

        public IndexBuilder(String string, String[] stringArray) {
            this.fd = new FetchDoc(this, string){
                private final /* synthetic */ IndexBuilder this$1;
                {
                    this.this$1 = indexBuilder;
                }

                protected void error(int n, String string) {
                    if (n == FetchDoc.NO_HITS_ERROR) {
                        JReqTools.showError(JediPrefs.GRS("DocumentationDirectories.Error1", string));
                    } else if (n == FetchDoc.NO_MORE_HITS) {
                        JReqTools.showError(JediPrefs.GRS("DocumentationDirectories.Error2", string));
                    } else if (n == FetchDoc.NO_DOC_DIRECTORY) {
                        JReqTools.showError(JediPrefs.GRS("DocumentationDirectories.Error3", string));
                    }
                }

                public void progress(int n, String string) {
                    if (n == FetchDoc.START_BUILD) {
                        this.this$1.message = "-";
                    } else if (n == FetchDoc.SCAN_PATH) {
                        this.this$1.message = JediPrefs.GRS("DocumentationDirectories.Message1", string);
                        this.this$1.path = string;
                        this.this$1.current += 10;
                    } else if (n == FetchDoc.SCAN_FILE) {
                        this.this$1.message = JediPrefs.GRS("DocumentationDirectories.Message2", this.this$1.path + File.separator + string);
                    } else if (n == FetchDoc.WRITE_INDEX) {
                        this.this$1.message = JediPrefs.GRS("DocumentationDirectories.Message3");
                    } else if (n == FetchDoc.WRITE_FILE) {
                        this.this$1.message = JediPrefs.GRS("DocumentationDirectories.Message4");
                        ++this.this$1.current;
                    }
                }
            };
            this.data = stringArray;
        }

        public void generateIndex(String[] stringArray) {
            Vector<String> vector = new Vector<String>(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                vector.addElement(stringArray[n]);
                ++n;
            }
            this.fd.generateIndex(vector);
        }

        public int getCurrent() {
            return this.current;
        }

        public String getCurrentText() {
            return this.message;
        }

        public int getMaximum() {
            return 237 + this.data.length * 10;
        }

        public int getMinimum() {
            return 0;
        }

        public void run() {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Vector<String> vector = new Vector<String>(this.data.length);
            int n = 0;
            while (n < this.data.length) {
                File file = new File(this.data[n]);
                if (!file.exists()) {
                    JReqTools.showError(JediPrefs.GRS("DocumentationDirectories.Error4", this.data[n]));
                } else {
                    vector.addElement(this.data[n]);
                }
                ++n;
            }
            this.fd.generateIndex(vector);
        }
    }
}

