/*
 * Decompiled with CFR 0.152.
 */
package jedi.prefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import jedi.Jedi;
import jedi.help.ExternalHelpBrowser;
import jedi.help.JediHelpBrowser;
import jreqtools.JReqTools;
import swing.addon.HelpBrowser;

public final class JediPrefs {
    static final ResourceBundle resources = ResourceBundle.getBundle("jedi.prefs.resources.prefs");
    private static final Properties properties = JediPrefs.loadProperties();
    private static HelpBrowser helpBrowser = null;

    static String GRS(String string) {
        try {
            return resources.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println(missingResourceException.getLocalizedMessage() + ": '" + string + "'");
            return "MISSING RESOURCE: " + string;
        }
    }

    static String GRS(String string, String string2) {
        String string3 = JediPrefs.GRS(string);
        try {
            string3 = MessageFormat.format(string3, string2);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        return string3;
    }

    public static HelpBrowser getHelpBrowser() {
        if (JediPrefs.getProperty("HelpBrowser.External").equals("1")) {
            return new ExternalHelpBrowser(JediPrefs.getProperty("HelpBrowser.Command"), JediPrefs.getProperty("HelpBrowser.Arguments"));
        }
        if (helpBrowser == null) {
            helpBrowser = new JediHelpBrowser();
        }
        return helpBrowser;
    }

    public static String getProperty(String string) {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            System.err.println("WARNING: Jedi-Property " + string + " not found.");
            string2 = "";
        }
        return string2;
    }

    static final Properties loadProperties() {
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(new File(Jedi.getHomeDirectory(), "jedi.properties"));
            properties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            JReqTools.showException(iOException);
        }
        return properties;
    }

    public static void putDefaultProperty(String string, String string2) {
        if (((Hashtable)properties).get(string) == null) {
            ((Hashtable)properties).put(string, string2);
        }
    }

    public static void putProperty(String string, String string2) {
        ((Hashtable)properties).put(string, string2);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(Jedi.getHomeDirectory(), "jedi.properties"));
            properties.store(fileOutputStream, "Automatically written, please do not edit manually !!!");
            fileOutputStream.close();
        }
        catch (Exception exception) {
            JReqTools.showException(exception);
        }
    }
}

