/*
 * Decompiled with CFR 0.152.
 */
package jedi.wizard;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import jedi.Jedi;
import jedi.wizard.JediWizard;
import swing.addon.CardPanel;
import swing.addon.Dialog;
import swing.addon.GUISystem;
import swing.addon.NButtons;
import swing.addon.Panel;
import swing.addon.Prefs;
import swing.addon.YFramePanel;

abstract class AbstractWizard
extends Dialog
implements ActionListener {
    Vector panels = new Vector();
    int current = 0;
    CardPanel cardPanel = new CardPanel();
    NButtons buttons = new NButtons(new String[]{JediWizard.GRS("Buttons.Cancel"), JediWizard.GRS("Buttons.Previous"), JediWizard.GRS("Buttons.Next"), JediWizard.GRS("Buttons.Finish")});

    public AbstractWizard() {
        super(Jedi.getEditor(), "");
        this.buttons.getComponentNumber(0).setIcon(Prefs.getIcon("cancel"));
        this.buttons.getComponentNumber(3).setIcon(Prefs.getIcon("ok"));
        this.setTitle(this.getFrameTitle());
        YFramePanel yFramePanel = new YFramePanel();
        this.setContentPane(yFramePanel);
        yFramePanel.add(this.cardPanel);
        yFramePanel.addStrut();
        yFramePanel.add(this.buttons);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AbstractWizard.this.setVisible(false);
            }
        });
        this.buttons.addActionListener(this);
        this.pack();
        Prefs.add(this.getWizardName(), this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.buttons) {
            if (this.buttons.get() == 0) {
                this.setVisible(false);
            }
            if (this.buttons.get() == 1) {
                if (this.current == 1) {
                    this.current = 0;
                    this.cardPanel.showFirstCard();
                } else if (this.current > 1) {
                    --this.current;
                    this.cardPanel.showPreviousCard();
                }
            }
            if (this.buttons.get() == 2) {
                if (this.current == this.panels.size() - 2) {
                    this.current = this.panels.size() - 1;
                    this.cardPanel.showLastCard();
                } else {
                    ++this.current;
                    this.cardPanel.showNextCard();
                }
            }
            if (this.buttons.get() == 3) {
                if (!this.check()) {
                    return;
                }
                this.setVisible(false);
                this.generate();
            }
            this.buttons.getComponentNumber(1).setEnabled(this.current != 0);
            this.buttons.getComponentNumber(2).setEnabled(this.current != this.panels.size() - 1);
            this.buttons.getComponentNumber(3).setEnabled(this.current == this.panels.size() - 1);
        } else {
            GUISystem.err.println(this.getClass().getName() + ".actionPerformed(): internal error");
        }
    }

    protected void addWizardPanel(String string, Panel panel) {
        panel.setBorder(BorderFactory.createTitledBorder(string));
        this.panels.addElement(panel);
        this.cardPanel.add(string, panel);
    }

    protected abstract boolean check();

    protected abstract void generate();

    protected abstract String getDisplayName();

    protected abstract String getFrameTitle();

    protected abstract String getWizardName();

    protected void reset() {
        if (this.panels.size() > 0) {
            this.cardPanel.showFirstCard();
            this.current = 0;
        }
        this.buttons.getComponentNumber(0).setEnabled(true);
        this.buttons.getComponentNumber(1).setEnabled(false);
        this.buttons.getComponentNumber(2).setEnabled(this.panels.size() > 1);
        this.buttons.getComponentNumber(3).setEnabled(this.panels.size() == 1);
    }

    public void start() {
        this.reset();
        this.setVisible(true);
    }

    public String toString() {
        return this.getDisplayName();
    }
}

