/*
 * Decompiled with CFR 0.152.
 */
package jedi.wizard;

import java.awt.Component;
import jedi.Jedi;
import jedi.ds.Method;
import jedi.wizard.DefaultWizard;
import jedi.wizard.JediWizard;
import swing.addon.CheckBox;
import swing.addon.ComboBox;
import swing.addon.GridBagConstraints;
import swing.addon.GridBagLayout;
import swing.addon.Insets;
import swing.addon.Label;
import swing.addon.Panel;
import swing.addon.Prefs;
import swing.addon.TextField;

class DialogWizard_javax_swing
extends DefaultWizard {
    TextField title = new TextField("");
    CheckBox modal = new CheckBox(JediWizard.GRS("DialogWizard.Panel_01.Modal"), true);
    ComboBox layout = new ComboBox(new String[]{"java.awt.BorderLayout", "javax.swing.BoxLayout (X_AXIS)", "javax.swing.BoxLayout (Y_AXIS)", "java.awt.FlowLayout", "java.awt.GridLayout", "java.awt.GridBagLayout"});
    ComboBox actionListener = new ComboBox(new String[]{Prefs.getResourceString("Yes"), Prefs.getResourceString("No")});
    ComboBox windowListener = new ComboBox(new String[]{Prefs.getResourceString("Yes"), Prefs.getResourceString("No")});
    ComboBox main = new ComboBox(new String[]{Prefs.getResourceString("Yes"), Prefs.getResourceString("No")});

    public DialogWizard_javax_swing() {
        this.addWizardPanel(JediWizard.GRS("DialogWizard.Panel_01.Title"), this.createDialogPropertiesPanel());
        this.addWizardPanel(JediWizard.GRS("DialogWizard.Panel_02.Title"), this.createListenersPanel());
        this.addWizardPanel(JediWizard.GRS("DialogWizard.Panel_03.Title"), this.createMiscPropertiesPanel());
        this.pack();
    }

    private Panel createDialogPropertiesPanel() {
        Panel panel = new Panel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(Prefs.getObjectSpace(), Prefs.getObjectSpace(), Prefs.getObjectSpace(), Prefs.getObjectSpace());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        panel.add((Component)new Label(JediWizard.GRS("DialogWizard.Panel_01.TitleString"), 2), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        panel.add((Component)this.title, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        panel.add((Component)new Label(JediWizard.GRS("DialogWizard.Panel_01.Layout"), 2), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        panel.add((Component)this.layout, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        panel.add((Component)this.modal, gridBagConstraints);
        Prefs.add(this.getWizardName() + ".Title", this.title);
        Prefs.add(this.getWizardName() + ".Modal", this.modal);
        Prefs.add(this.getWizardName() + ".Layout", this.layout);
        return panel;
    }

    private Panel createListenersPanel() {
        Panel panel = new Panel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(Prefs.getObjectSpace(), Prefs.getObjectSpace(), Prefs.getObjectSpace(), Prefs.getObjectSpace());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        panel.add((Component)new Label(JediWizard.GRS("DialogWizard.Panel_02.ActionListener"), 2), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        panel.add((Component)this.actionListener, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        panel.add((Component)new Label(JediWizard.GRS("DialogWizard.Panel_02.WindowListener"), 2), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        panel.add((Component)this.windowListener, gridBagConstraints);
        Prefs.add(this.getWizardName() + ".ActionListener", this.actionListener);
        Prefs.add(this.getWizardName() + ".WindowListener", this.windowListener);
        return panel;
    }

    private Panel createMiscPropertiesPanel() {
        Panel panel = new Panel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(Prefs.getObjectSpace(), Prefs.getObjectSpace(), Prefs.getObjectSpace(), Prefs.getObjectSpace());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        panel.add((Component)new Label(JediWizard.GRS("DialogWizard.Panel_03.MainMethod"), 2), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        panel.add((Component)this.main, gridBagConstraints);
        Prefs.add(this.getWizardName() + ".Main", this.main);
        return panel;
    }

    protected void generate() {
        super.generate();
        this.generatedClass.setExtends("JDialog");
        this.generatedClass.addImport("java.awt.event.*");
        this.generatedClass.addImport("java.text.*");
        this.generatedClass.addImport("java.util.*");
        this.generatedClass.addImport("javax.swing.*");
        if (this.actionListener.getSelectedIndex() == 0) {
            this.generatedClass.addImplements("ActionListener");
        }
        if (this.windowListener.getSelectedIndex() == 0) {
            this.generatedClass.addImplements("WindowListener");
        }
        this.generateConstructor();
        if (this.main.getSelectedIndex() == 0) {
            this.generateMainMethod();
        }
        if (this.actionListener.getSelectedIndex() == 0) {
            this.generateActionListener();
        }
        if (this.windowListener.getSelectedIndex() == 0) {
            this.generateWindowListener();
        }
        Jedi.getEditor().setClass(this.generatedClass);
    }

    protected void generateActionListener() {
        this.generatedClass.addImport("java.awt.event.ActionListener");
        Method method = this.generatedClass.addMethod("actionPerformed");
        method.setPublic(true);
        method.setResultType("void");
        method.setParameters(new String[]{"ActionEvent event"});
        method.appendBodyText("Object source = event.getSource();");
        method.appendBodyText("\n");
        method.appendBodyText("if (source == this)");
        method.appendBodyText("\t{");
        method.appendBodyText("\t// You will have to adjust these lines to your needs");
        method.appendBodyText("\t}");
        method.appendBodyText("else System.err.println(getClass().getName() + \".actionPerformed(): internal error\");");
    }

    protected void generateConstructor() {
        Method method = this.generatedClass.addConstructor();
        method.addParameter("JFrame parent");
        method.appendBodyText("super(parent, \"" + this.title.getText() + "\", " + this.modal.isSelected() + ");");
        method.appendBodyText("\n");
        method.appendBodyText("// Properties");
        method.appendBodyText("setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);");
        method.appendBodyText("\n");
        method.appendBodyText("// create and set panel");
        method.appendBodyText("JPanel panel = new JPanel();");
        method.appendBodyText("panel.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));");
        switch (this.layout.getSelectedIndex()) {
            case 0: {
                this.generatedClass.addImport("java.awt.BorderLayout");
                method.appendBodyText("panel.setLayout(new BorderLayout());");
                break;
            }
            case 1: {
                this.generatedClass.addImport("javax.swing.BoxLayout");
                method.appendBodyText("panel.setLayout(new BoxLayout(panel, BoxLayout.X_AXIS));");
                break;
            }
            case 2: {
                this.generatedClass.addImport("javax.swing.BoxLayout");
                method.appendBodyText("panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));");
                break;
            }
            case 3: {
                this.generatedClass.addImport("java.awt.FlowLayout");
                method.appendBodyText("panel.setLayout(new FlowLayout());");
                break;
            }
            case 4: {
                this.generatedClass.addImport("java.awt.GridLayout");
                method.appendBodyText("panel.setLayout(new GridLayout());");
                break;
            }
            case 5: {
                this.generatedClass.addImport("java.awt.GridBagLayout");
                method.appendBodyText("panel.setLayout(new GridBagLayout());");
            }
        }
        method.appendBodyText("setContentPane(panel);");
        if (this.windowListener.getSelectedIndex() == 0) {
            method.appendBodyText("\n");
            method.appendBodyText("// add windows listener");
            method.appendBodyText("addWindowListener(this);");
        }
        method.appendBodyText("\n");
        method.appendBodyText("// calculate dialog size");
        method.appendBodyText("pack();");
    }

    protected void generateMainMethod() {
        Method method = this.generatedClass.addMethod("main");
        method.appendBodyText(this.generatedClass.getName() + " test = new " + this.generatedClass.getName() + "(new JFrame(\"Dummy\"));");
        method.appendBodyText("test.addWindowListener(new WindowAdapter() { public void windowClosing(WindowEvent e) { System.exit(0); }});");
        method.appendBodyText("test.setVisible(true);");
    }

    protected void generateWindowListener() {
        this.generatedClass.addImport("java.awt.event.WindowListener");
        Method method = this.generatedClass.addMethod("windowActivated");
        method.setPublic(true);
        method.setResultType("void");
        method.setParameters(new String[]{"WindowEvent event"});
        method.setText("// Insert your code here\n");
        method = this.generatedClass.addMethod("windowDeactivated");
        method.setPublic(true);
        method.setResultType("void");
        method.setParameters(new String[]{"WindowEvent event"});
        method.setText("// Insert your code here\n");
        method = this.generatedClass.addMethod("windowIconified");
        method.setPublic(true);
        method.setResultType("void");
        method.setParameters(new String[]{"WindowEvent event"});
        method.setText("// Insert your code here\n");
        method = this.generatedClass.addMethod("windowDeiconified");
        method.setPublic(true);
        method.setResultType("void");
        method.setParameters(new String[]{"WindowEvent event"});
        method.setText("// Insert your code here\n");
        method = this.generatedClass.addMethod("windowOpened");
        method.setPublic(true);
        method.setResultType("void");
        method.setParameters(new String[]{"WindowEvent event"});
        method.setText("// Insert your code here\n");
        method = this.generatedClass.addMethod("windowClosed");
        method.setResultType("void");
        method.setParameters(new String[]{"WindowEvent event"});
        method.setText("// Insert your code here\n");
        method = this.generatedClass.addMethod("windowClosing");
        method.setPublic(true);
        method.setResultType("void");
        method.setParameters(new String[]{"WindowEvent event"});
        method.setText("// Insert your code here\n");
    }

    protected String getDisplayName() {
        return JediWizard.GRS("DialogWizard_javax_swing.DisplayName");
    }

    protected String getFrameTitle() {
        return JediWizard.GRS("DialogWizard.Title");
    }

    protected String getWizardName() {
        return "DialogWizard_javax_swing";
    }
}

