/*
 * Decompiled with CFR 0.152.
 */
package jedi.wizard;

import java.awt.Component;
import jedi.Jedi;
import jedi.ds.Class;
import jedi.ds.Method;
import jedi.ds.Package;
import jedi.wizard.AbstractWizard;
import jedi.wizard.JediWizard;
import jreqtools.JReqTools;
import jreqtools.StringCheckers;
import swing.addon.GridBagConstraints;
import swing.addon.GridBagLayout;
import swing.addon.Insets;
import swing.addon.Label;
import swing.addon.Panel;
import swing.addon.Prefs;
import swing.addon.TextField;

class JediPluginWizard
extends AbstractWizard {
    protected TextField pluginname = new TextField();
    protected Class generatedClass = null;
    protected Package generatedPackage = null;

    public JediPluginWizard() {
        this.addWizardPanel(JediWizard.GRS("JediPluginWizard.Panel_01.Title"), this.createPluginPropertiesPanel());
    }

    protected boolean check() {
        if (!StringCheckers.getJavaPackageChecker().accept(this.pluginname.getText())) {
            this.cardPanel.showCard(JediWizard.GRS("JediPluginWizard.Panel_01.Title"));
            JReqTools.showError(JediWizard.GRS("Error.04"));
            return false;
        }
        this.generatedPackage = Jedi.getEditor().getProject().add("jedi.plugins." + this.pluginname.getText().toLowerCase());
        this.generatedClass = this.generatedPackage.add(this.pluginname.getText(), 1);
        return true;
    }

    private Panel createPluginPropertiesPanel() {
        Panel panel = new Panel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(Prefs.getObjectSpace(), Prefs.getObjectSpace(), Prefs.getObjectSpace(), Prefs.getObjectSpace());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        panel.add((Component)new Label(JediWizard.GRS("JediPluginWizard.Panel_01.PluginName"), 2), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        panel.add((Component)this.pluginname, gridBagConstraints);
        return panel;
    }

    protected void generate() {
        this.generatedClass.setExtends("AbstractJediPlugin");
        this.generatedClass.addImport("java.awt.event.*");
        this.generatedClass.addImport("java.text.*");
        this.generatedClass.addImport("java.util.*");
        this.generatedClass.addImport("javax.swing.*");
        this.generatedClass.addImport("jedi.*");
        this.generatedClass.addImport("jedi.ds.Class");
        this.generatedClass.addImport("jedi.ds.Method");
        this.generatedClass.addImport("jedi.ds.Package");
        this.generatedClass.addImport("jedi.ds.Project");
        this.generatedClass.addImport("jreqtools.*");
        this.generatedClass.addImport("swing.addon.*");
        this.generateMethods();
        Jedi.getEditor().setProject(Jedi.getEditor().getProject());
        Jedi.getEditor().setPackage(this.generatedPackage);
    }

    protected void generateMethods() {
        Method method = null;
        method = this.generatedClass.addMethod("editPrefs");
        method.appendBodyText("// If your plugin supports user preferences, then you will have to");
        method.appendBodyText("// pop up the prefs frame at this point, see hasPreferencesFrame()");
        method = this.generatedClass.addMethod("execute");
        method.appendBodyText("// This method is called when the plugin has to be executed");
        method = this.generatedClass.addMethod("getAuthor");
        method.setResultType("String");
        method.appendBodyText("// Return your Name and email address here");
        method.appendBodyText("return \"Your Name (your@email.address)\";");
        method = this.generatedClass.addMethod("getComponent");
        method.setResultType("JComponent");
        method.appendBodyText("// If your plugin needs a (small) swing component in the toolbar");
        method.appendBodyText("// instead of a button with an icon, then you should return a");
        method.appendBodyText("// reference to this component here, else return null");
        method.appendBodyText("return null;");
        method = this.generatedClass.addMethod("getDescription");
        method.setResultType("String");
        method.appendBodyText("// Return a one line description of your plugin.");
        method.appendBodyText("return \"Description of the plugin.\";");
        method = this.generatedClass.addMethod("getDocumentation");
        method.setResultType("String");
        method.appendBodyText("// Return a HTML String containing the plugin's documentation");
        method.appendBodyText("return null;");
        method = this.generatedClass.addMethod("getIcon");
        method.setResultType("Icon");
        method.appendBodyText("// Return an icon here for the toolbar button of this plugin.");
        method.appendBodyText("// If the plugin should nor be placed in the toolbar, return null");
        method.appendBodyText("return null;");
        method = this.generatedClass.addMethod("getRevision");
        method.setResultType("int");
        method.appendBodyText("// Return the minor program version here");
        method.appendBodyText("return 1;");
        method = this.generatedClass.addMethod("getVersion");
        method.setResultType("int");
        method.appendBodyText("// Return the major program version here");
        method.appendBodyText("return 0;");
        method = this.generatedClass.addMethod("hasPreferencesFrame");
        method.setResultType("boolean");
        method.appendBodyText("// Tell whether or not your plugin supports user preferences, see editPrefs()");
        method.appendBodyText("return false;");
    }

    protected String getDisplayName() {
        return JediWizard.GRS("JediPluginWizard.DisplayName");
    }

    protected String getFrameTitle() {
        return JediWizard.GRS("JediPluginWizard.Title");
    }

    protected String getWizardName() {
        return "JediPluginWizard";
    }
}

