/*
 * Decompiled with CFR 0.152.
 */
package jreqtools;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.UIManager;
import jreqtools.gadgets.Strut;

public abstract class AbstractRequester {
    public static final int CANCEL = -1;
    public static final int OK = 0;
    protected ActionListener listener = null;
    private Dimension size = null;
    private Point location = null;
    private String title = null;
    private JComponent parentC = null;

    public void addHelpButton(ActionListener actionListener) {
        this.listener = actionListener;
    }

    protected void addHelpButton(Container container) {
        JButton jButton = new JButton("Help", UIManager.getIcon("jreqtools.helpIcon"));
        container.add(new Strut());
        container.add(Box.createHorizontalGlue());
        container.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractRequester.this.listener.actionPerformed(new ActionEvent(AbstractRequester.this, 1001, "Help"));
            }
        });
    }

    protected abstract JDialog createJDialog(JFrame var1);

    public Point getLocation() {
        return this.location == null ? new Point(-1, -1) : this.location;
    }

    protected abstract int getReturnValue();

    public Dimension getSize() {
        return this.size == null ? new Dimension(0, 0) : this.size;
    }

    public int request() {
        return this.request(null);
    }

    public int request(JFrame jFrame) {
        Object object;
        JDialog jDialog = this.createJDialog(jFrame);
        if (this.title != null) {
            jDialog.setTitle(this.title);
        }
        jDialog.setDefaultCloseOperation(0);
        if (this.size != null) {
            object = jDialog.getSize();
            if (((Dimension)object).width > this.size.width) {
                this.size.width = ((Dimension)object).width;
            }
            if (((Dimension)object).height > this.size.height) {
                this.size.height = ((Dimension)object).height;
            }
            ((Component)jDialog).setSize(this.size);
        }
        if (this.parentC != null && this.parentC.isVisible()) {
            object = this.parentC.getLocationOnScreen();
            this.location = new Point(Math.max(0, ((Point)object).x - 10), Math.max(0, ((Point)object).y - 10));
        }
        if (this.location == null) {
            object = jDialog.getToolkit();
            Dimension dimension = ((Toolkit)object).getScreenSize();
            Dimension dimension2 = this.size != null ? this.size : jDialog.getSize();
            this.location = new Point((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        }
        ((Component)jDialog).setLocation(this.location);
        ((Component)jDialog).setVisible(true);
        this.location = jDialog.getLocation();
        this.size = jDialog.getSize();
        jDialog.dispose();
        return this.getReturnValue();
    }

    public void setLocation(Point point) {
        this.location = point == null || point.x == -1 ? null : point;
    }

    public void setLocation(int n, int n2) {
        this.location = n == -1 ? null : new Point(n, n2);
    }

    public void setParentComponent(JComponent jComponent) {
        this.parentC = jComponent;
    }

    public void setSize(Dimension dimension) {
        this.size = dimension == null || dimension.width == 0 ? null : dimension;
    }

    public void setSize(int n, int n2) {
        this.size = n == 0 ? null : new Dimension(n, n2);
    }

    public void setTitle(String string) {
        this.title = string;
    }
}

