/*
 * Decompiled with CFR 0.152.
 */
package jreqtools;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jreqtools.AbstractRequester;
import jreqtools.JReqTools;
import jreqtools.gadgets.BackgroundImage;
import jreqtools.gadgets.OkCancelButtons;
import jreqtools.gadgets.Strut;
import jreqtools.gadgets.TextField;
import jreqtools.gadgets.YFramePanel;

public class ColorRequester
extends AbstractRequester {
    private Color color = null;
    private int tabindex = 0;
    private int answer = -1;

    public ColorRequester() {
        this("JReqTools: ColorRequester", Color.red);
    }

    public ColorRequester(String string) {
        this(string, Color.red);
    }

    public ColorRequester(Color color) {
        this("JReqTools: ColorRequester", color);
    }

    public ColorRequester(String string, Color color) {
        this.color = color;
    }

    protected JDialog createJDialog(JFrame jFrame) {
        return new Dialog(jFrame);
    }

    public Color getColor() {
        return this.color;
    }

    public int getReturnValue() {
        return this.answer;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    private class Dialog
    extends JDialog {
        private JPanel colorfield = new JPanel();
        private JSlider hueslider = new JSlider(0, 0, 100, 0);
        private JSlider saturationslider = new JSlider(0, 0, 100, 0);
        private JSlider brightnessslider = new JSlider(0, 0, 100, 0);
        private JSlider redslider = new JSlider(0, 0, 255, 0);
        private JSlider greenslider = new JSlider(0, 0, 255, 0);
        private JSlider blueslider = new JSlider(0, 0, 255, 0);
        private TextField redtext = new TextField("255");
        private TextField greentext = new TextField("255");
        private TextField bluetext = new TextField("25");
        private TextField huetext = new TextField("100");
        private TextField saturationtext = new TextField("100");
        private TextField brightnesstext = new TextField("100");
        private JTabbedPane tabbedpane = new JTabbedPane();
        private boolean handleEvent = true;

        public Dialog(JFrame jFrame) {
            super(jFrame, "JReqTools: ColorRequester", true);
            this.tabbedpane.addTab(JReqTools.getResourceString("RGBModel"), this.createRGBPane());
            this.tabbedpane.addTab(JReqTools.getResourceString("HSBModel"), this.createHSBPane());
            int n = ColorRequester.this.color.getRed();
            int n2 = ColorRequester.this.color.getGreen();
            int n3 = ColorRequester.this.color.getBlue();
            float[] fArray = Color.RGBtoHSB(n, n2, n3, null);
            int n4 = (int)(100.0 * (double)fArray[0]);
            int n5 = (int)(100.0 * (double)fArray[1]);
            int n6 = (int)(100.0 * (double)fArray[2]);
            this.tabbedpane.setSelectedIndex(ColorRequester.this.tabindex);
            this.colorfield.setBackground(ColorRequester.this.color);
            this.colorfield.setPreferredSize(new Dimension(100, 100));
            this.redslider.setValue(n);
            this.greenslider.setValue(n2);
            this.blueslider.setValue(n3);
            this.hueslider.setValue(n4);
            this.saturationslider.setValue(n5);
            this.brightnessslider.setValue(n6);
            this.huetext.setEditable(false);
            this.saturationtext.setEditable(false);
            this.brightnesstext.setEditable(false);
            this.redtext.setEditable(false);
            this.greentext.setEditable(false);
            this.bluetext.setEditable(false);
            this.redtext.setText("" + n);
            this.greentext.setText("" + n2);
            this.bluetext.setText("" + n3);
            this.huetext.setText("" + n4);
            this.saturationtext.setText("" + n5);
            this.brightnesstext.setText("" + n6);
            this.redslider.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ Dialog this$1;
                {
                    this.this$1 = dialog;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    Dialog.access$200(this.this$1);
                }
            });
            this.greenslider.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ Dialog this$1;
                {
                    this.this$1 = dialog;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    Dialog.access$300(this.this$1);
                }
            });
            this.blueslider.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ Dialog this$1;
                {
                    this.this$1 = dialog;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    Dialog.access$400(this.this$1);
                }
            });
            this.hueslider.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ Dialog this$1;
                {
                    this.this$1 = dialog;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    Dialog.access$500(this.this$1);
                }
            });
            this.saturationslider.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ Dialog this$1;
                {
                    this.this$1 = dialog;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    Dialog.access$600(this.this$1);
                }
            });
            this.brightnessslider.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ Dialog this$1;
                {
                    this.this$1 = dialog;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    Dialog.access$700(this.this$1);
                }
            });
            Box box = Box.createHorizontalBox();
            box.add(this.colorfield);
            box.add(new Strut());
            box.add(this.tabbedpane);
            OkCancelButtons okCancelButtons = new OkCancelButtons(ColorRequester.this, new ActionListener(this){
                private final /* synthetic */ Dialog this$1;
                {
                    this.this$1 = dialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Dialog.access$800(this.this$1);
                }
            }, new ActionListener(this){
                private final /* synthetic */ Dialog this$1;
                {
                    this.this$1 = dialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Dialog.access$900(this.this$1);
                }
            }, ColorRequester.this.listener);
            YFramePanel yFramePanel = new YFramePanel();
            yFramePanel.add(box);
            yFramePanel.add(new Strut());
            yFramePanel.add(okCancelButtons);
            this.setContentPane(yFramePanel);
            this.getLayeredPane().add((Component)new BackgroundImage(), new Integer(Integer.MIN_VALUE));
            this.pack();
        }

        private void cancel() {
            ColorRequester.this.answer = -1;
            ColorRequester.this.tabindex = this.tabbedpane.getSelectedIndex();
            ((Component)this).setVisible(false);
        }

        private void changedBlue() {
            if (!this.handleEvent) {
                return;
            }
            this.handleEvent = false;
            int n = this.redslider.getValue();
            int n2 = this.greenslider.getValue();
            int n3 = this.blueslider.getValue();
            Color color = new Color(n, n2, n3);
            this.colorfield.setBackground(color);
            this.bluetext.setText("" + n3);
            float[] fArray = Color.RGBtoHSB(n, n2, n3, null);
            int n4 = (int)(100.0 * (double)fArray[0]);
            int n5 = (int)(100.0 * (double)fArray[1]);
            int n6 = (int)(100.0 * (double)fArray[2]);
            this.hueslider.setValue(n4);
            this.saturationslider.setValue(n5);
            this.brightnessslider.setValue(n6);
            this.huetext.setText("" + n4);
            this.saturationtext.setText("" + n5);
            this.brightnesstext.setText("" + n6);
            this.handleEvent = true;
        }

        private void changedBrightness() {
            if (!this.handleEvent) {
                return;
            }
            this.handleEvent = false;
            int n = this.hueslider.getValue();
            int n2 = this.saturationslider.getValue();
            int n3 = this.brightnessslider.getValue();
            Color color = new Color(Color.HSBtoRGB((float)n / 100.0f, (float)n2 / 100.0f, (float)n3 / 100.0f));
            this.colorfield.setBackground(color);
            int n4 = color.getRed();
            int n5 = color.getGreen();
            int n6 = color.getBlue();
            this.brightnesstext.setText("" + n3);
            this.redslider.setValue(n4);
            this.greenslider.setValue(n5);
            this.blueslider.setValue(n6);
            this.redtext.setText("" + n4);
            this.greentext.setText("" + n5);
            this.bluetext.setText("" + n6);
            this.handleEvent = true;
        }

        private void changedGreen() {
            if (!this.handleEvent) {
                return;
            }
            this.handleEvent = false;
            int n = this.redslider.getValue();
            int n2 = this.greenslider.getValue();
            int n3 = this.blueslider.getValue();
            Color color = new Color(n, n2, n3);
            this.colorfield.setBackground(color);
            this.greentext.setText("" + n2);
            float[] fArray = Color.RGBtoHSB(n, n2, n3, null);
            int n4 = (int)(100.0 * (double)fArray[0]);
            int n5 = (int)(100.0 * (double)fArray[1]);
            int n6 = (int)(100.0 * (double)fArray[2]);
            this.hueslider.setValue(n4);
            this.saturationslider.setValue(n5);
            this.brightnessslider.setValue(n6);
            this.huetext.setText("" + n4);
            this.saturationtext.setText("" + n5);
            this.brightnesstext.setText("" + n6);
            this.handleEvent = true;
        }

        private void changedHue() {
            if (!this.handleEvent) {
                return;
            }
            this.handleEvent = false;
            int n = this.hueslider.getValue();
            int n2 = this.saturationslider.getValue();
            int n3 = this.brightnessslider.getValue();
            Color color = new Color(Color.HSBtoRGB((float)n / 100.0f, (float)n2 / 100.0f, (float)n3 / 100.0f));
            this.colorfield.setBackground(color);
            int n4 = color.getRed();
            int n5 = color.getGreen();
            int n6 = color.getBlue();
            this.huetext.setText("" + n);
            this.redslider.setValue(n4);
            this.greenslider.setValue(n5);
            this.blueslider.setValue(n6);
            this.redtext.setText("" + n4);
            this.greentext.setText("" + n5);
            this.bluetext.setText("" + n6);
            this.handleEvent = true;
        }

        private void changedRed() {
            if (!this.handleEvent) {
                return;
            }
            this.handleEvent = false;
            int n = this.redslider.getValue();
            int n2 = this.greenslider.getValue();
            int n3 = this.blueslider.getValue();
            Color color = new Color(n, n2, n3);
            this.colorfield.setBackground(color);
            this.redtext.setText("" + n);
            float[] fArray = Color.RGBtoHSB(n, n2, n3, null);
            int n4 = (int)(100.0 * (double)fArray[0]);
            int n5 = (int)(100.0 * (double)fArray[1]);
            int n6 = (int)(100.0 * (double)fArray[2]);
            this.hueslider.setValue(n4);
            this.saturationslider.setValue(n5);
            this.brightnessslider.setValue(n6);
            this.huetext.setText("" + n4);
            this.saturationtext.setText("" + n5);
            this.brightnesstext.setText("" + n6);
            this.handleEvent = true;
        }

        private void changedSaturation() {
            if (!this.handleEvent) {
                return;
            }
            this.handleEvent = false;
            int n = this.hueslider.getValue();
            int n2 = this.saturationslider.getValue();
            int n3 = this.brightnessslider.getValue();
            Color color = new Color(Color.HSBtoRGB((float)n / 100.0f, (float)n2 / 100.0f, (float)n3 / 100.0f));
            this.colorfield.setBackground(color);
            int n4 = color.getRed();
            int n5 = color.getGreen();
            int n6 = color.getBlue();
            this.saturationtext.setText("" + n2);
            this.redslider.setValue(n4);
            this.greenslider.setValue(n5);
            this.blueslider.setValue(n6);
            this.redtext.setText("" + n4);
            this.greentext.setText("" + n5);
            this.bluetext.setText("" + n6);
            this.handleEvent = true;
        }

        private JPanel createHSBPane() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = JReqTools.getObjectInsets(-1, -1, -1, -1);
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 0.0;
            jPanel.add((Component)new JLabel(JReqTools.getResourceString("Hue")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            jPanel.add((Component)this.hueslider, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 0.0;
            jPanel.add((Component)this.huetext, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 0.0;
            jPanel.add((Component)new JLabel(JReqTools.getResourceString("Saturation")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            jPanel.add((Component)this.saturationslider, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 0.0;
            jPanel.add((Component)this.saturationtext, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.weightx = 0.0;
            jPanel.add((Component)new JLabel(JReqTools.getResourceString("Brightness")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            jPanel.add((Component)this.brightnessslider, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 0.0;
            jPanel.add((Component)this.brightnesstext, gridBagConstraints);
            return jPanel;
        }

        private JPanel createRGBPane() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = JReqTools.getObjectInsets(-1, -1, -1, -1);
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 0.0;
            jPanel.add((Component)new JLabel(JReqTools.getResourceString("Red")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            jPanel.add((Component)this.redslider, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 0.0;
            jPanel.add((Component)this.redtext, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 0.0;
            jPanel.add((Component)new JLabel(JReqTools.getResourceString("Green")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            jPanel.add((Component)this.greenslider, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 0.0;
            jPanel.add((Component)this.greentext, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.weightx = 0.0;
            jPanel.add((Component)new JLabel(JReqTools.getResourceString("Blue")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            jPanel.add((Component)this.blueslider, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 0.0;
            jPanel.add((Component)this.bluetext, gridBagConstraints);
            return jPanel;
        }

        private void ok() {
            ColorRequester.this.answer = 0;
            ColorRequester.this.tabindex = this.tabbedpane.getSelectedIndex();
            ColorRequester.this.color = new Color(this.redslider.getValue(), this.greenslider.getValue(), this.blueslider.getValue());
            ((Component)this).setVisible(false);
        }

        static /* synthetic */ void access$200(Dialog dialog) {
            dialog.changedRed();
        }

        static /* synthetic */ void access$300(Dialog dialog) {
            dialog.changedGreen();
        }

        static /* synthetic */ void access$400(Dialog dialog) {
            dialog.changedBlue();
        }

        static /* synthetic */ void access$500(Dialog dialog) {
            dialog.changedHue();
        }

        static /* synthetic */ void access$600(Dialog dialog) {
            dialog.changedSaturation();
        }

        static /* synthetic */ void access$700(Dialog dialog) {
            dialog.changedBrightness();
        }

        static /* synthetic */ void access$800(Dialog dialog) {
            dialog.ok();
        }

        static /* synthetic */ void access$900(Dialog dialog) {
            dialog.cancel();
        }
    }
}

