/*
 * Decompiled with CFR 0.152.
 */
package jreqtools;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import jreqtools.FileFilter;
import jreqtools.JReqTools;

public class FileRequester {
    public static final int CANCEL = -1;
    public static final int OK = 0;
    JFileChooser chooser = new JFileChooser();
    boolean loadmode = true;
    boolean dirsonly = false;
    boolean multiselect = false;

    public FileRequester() {
        this("JReqTools: FileRequester", new File(System.getProperty("user.home", "")), "");
    }

    public FileRequester(String string) {
        this(string, new File(System.getProperty("user.home", "")), "");
    }

    public FileRequester(String string, File file, String string2) {
        this.chooser.setDialogTitle(string);
        this.chooser.setSelectedFile(new File(file, string2));
        this.chooser.setAcceptAllFileFilterUsed(false);
        this.chooser.addChoosableFileFilter(new FileFilter.AllFilesFileFilter());
    }

    public void addChoosableFileFilter(FileFilter fileFilter) {
        this.chooser.addChoosableFileFilter(fileFilter);
    }

    public void addChoosableFileFilter(FileFilter fileFilter, boolean bl) {
        this.addChoosableFileFilter(fileFilter);
    }

    public File getFile() {
        return this.chooser.getSelectedFile();
    }

    public File[] getFiles() {
        return this.chooser.getSelectedFiles();
    }

    public int request() {
        return this.request(null);
    }

    public int request(JFrame jFrame) {
        int n;
        int n2 = n = this.loadmode ? this.chooser.showOpenDialog(jFrame) : this.chooser.showSaveDialog(jFrame);
        if (n == 0) {
            return 0;
        }
        return -1;
    }

    public void setDirectoriesOnly(boolean bl) {
        if (bl && this.multiselect) {
            System.err.println(this.getClass().getName() + ".setDirectoriesOnly(): multi selection and directory selection are not allowed together!");
            return;
        }
        this.dirsonly = bl;
        this.chooser.setFileSelectionMode(bl ? 1 : 0);
    }

    public void setFile(File file) {
        this.chooser.setSelectedFile(file);
    }

    public void setFile(File file, String string) {
        this.chooser.setSelectedFile(new File(file, string));
    }

    public void setLoadMode() {
        this.loadmode = true;
    }

    public void setMultiSelection(boolean bl) {
        if (bl && this.dirsonly) {
            System.err.println(this.getClass().getName() + ".setMultiSelection(): multi selection and directory selection are not allowed together!");
            return;
        }
        this.multiselect = bl;
        this.chooser.setMultiSelectionEnabled(bl);
    }

    public void setSaveMode() {
        this.loadmode = false;
    }

    public void setTitle(String string) {
        this.chooser.setDialogTitle(string);
    }

    static {
        UIManager.put("FileChooser.saveButtonText", JReqTools.getResourceString("FileChooser.Save"));
        UIManager.put("FileChooser.openButtonText", JReqTools.getResourceString("FileChooser.Open"));
        UIManager.put("FileChooser.cancelButtonText", JReqTools.getResourceString("FileChooser.Cancel"));
        UIManager.put("FileChooser.updateButtonText", JReqTools.getResourceString("FileChooser.Update"));
        UIManager.put("FileChooser.helpButtonText", JReqTools.getResourceString("FileChooser.Help"));
        UIManager.put("FileChooser.saveButtonToolTipText", JReqTools.getResourceString("FileChooser.SaveToolTip"));
        UIManager.put("FileChooser.openButtonToolTipText", JReqTools.getResourceString("FileChooser.OpenToolTip"));
        UIManager.put("FileChooser.cancelButtonToolTipText", JReqTools.getResourceString("FileChooser.CancelToolTip"));
        UIManager.put("FileChooser.updateButtonToolTipText", JReqTools.getResourceString("FileChooser.UpdateToolTip"));
        UIManager.put("FileChooser.helpButtonToolTipText", JReqTools.getResourceString("FileChooser.HelpToolTip"));
        UIManager.put("FileChooser.lookInLabelText", JReqTools.getResourceString("FileChooser.LookIn"));
        UIManager.put("FileChooser.fileNameLabelText", JReqTools.getResourceString("FileChooser.Filename"));
        UIManager.put("FileChooser.filesOfTypeLabelText", JReqTools.getResourceString("FileChooser.FilesOfType"));
        UIManager.put("FileChooser.filesLabelText", JReqTools.getResourceString("FileChooser.Files"));
        UIManager.put("FileChooser.foldersLabelText", JReqTools.getResourceString("FileChooser.Folders"));
        UIManager.put("FileChooser.pathLabelText", JReqTools.getResourceString("FileChooser.Path"));
        UIManager.put("FileChooser.filterLabelText", JReqTools.getResourceString("FileChooser.Filter"));
        UIManager.put("FileChooser.enterFileNameLabelText", JReqTools.getResourceString("FileChooser.EnterFileName"));
        UIManager.put("FileChooser.upFolderToolTipText", JReqTools.getResourceString("FileChooser.UpToolTip"));
        UIManager.put("FileChooser.homeFolderToolTipText", JReqTools.getResourceString("FileChooser.HomeToolTip"));
        UIManager.put("FileChooser.newFolderToolTipText", JReqTools.getResourceString("FileChooser.NewToolTip"));
        UIManager.put("FileChooser.listViewButtonToolTipText", JReqTools.getResourceString("FileChooser.ListViewToolTip"));
        UIManager.put("FileChooser.detailsViewButtonToolTipText", JReqTools.getResourceString("FileChooser.DetailsViewToolTip"));
    }
}

