/*
 * Decompiled with CFR 0.152.
 */
package jreqtools;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jreqtools.AbstractRequester;
import jreqtools.FileFilter;
import jreqtools.JReqTools;
import jreqtools.gadgets.BackgroundImage;
import jreqtools.gadgets.OkCancelButtons;
import jreqtools.gadgets.Panel;
import jreqtools.gadgets.Strut;
import jreqtools.gadgets.TButton;
import jreqtools.gadgets.TextField;
import jreqtools.gadgets.XPanel;
import jreqtools.gadgets.YFramePanel;
import jreqtools.utils.Sorter;

public class FileRequester2
extends AbstractRequester {
    private File directory = null;
    private String filename = null;
    private String[] filenames = null;
    private boolean loadmode = true;
    private boolean dirsonly = false;
    private boolean showdots = false;
    private int answer = -1;
    private boolean multiselect = false;
    private Vector filefilters = new Vector();
    private int filter = 0;

    public FileRequester2() {
        this("JReqTools: FileRequester", new File(System.getProperty("user.home", "")), "");
    }

    public FileRequester2(String string) {
        this(string, new File(System.getProperty("user.home", "")), "");
    }

    public FileRequester2(String string, File file, String string2) {
        this.setTitle(string);
        this.setFile(file, string2);
    }

    public void addChoosableFileFilter(FileFilter fileFilter) {
        this.addChoosableFileFilter(fileFilter, false);
    }

    public void addChoosableFileFilter(FileFilter fileFilter, boolean bl) {
        if (this.filefilters.contains(fileFilter)) {
            return;
        }
        this.filefilters.addElement(fileFilter);
        if (bl) {
            this.filter = this.filefilters.indexOf(fileFilter);
        }
    }

    protected JDialog createJDialog(JFrame jFrame) {
        return new Dialog(jFrame);
    }

    public File getFile() {
        return this.dirsonly ? this.directory : new File(this.directory, this.multiselect ? "" : this.filename);
    }

    public File[] getFiles() {
        if (!this.multiselect) {
            JReqTools.showError(JReqTools.getResourceString("MethodCallNotAllowed") + "\n\nFileRequester.getFile()");
            return null;
        }
        File[] fileArray = new File[this.filenames.length];
        int n = 0;
        while (n < this.filenames.length) {
            fileArray[n] = new File(this.directory, this.filenames[n]);
            ++n;
        }
        return fileArray;
    }

    protected int getReturnValue() {
        return this.answer;
    }

    public void setDirectoriesOnly(boolean bl) {
        if (bl && this.multiselect) {
            System.err.println(this.getClass().getName() + ".setDirectoriesOnly(): multi selection and directory selection are not allowed together!");
            return;
        }
        this.dirsonly = bl;
    }

    public void setFile(String string) {
        this.setFile(new File(string));
    }

    public void setFile(File file) {
        if (file == null) {
            this.setFile(null, "");
        } else if (file.isDirectory()) {
            this.setFile(file, "");
        } else {
            File file2 = new File(file.getParent());
            String string = file.getName();
            this.setFile(file2, string);
        }
    }

    public void setFile(File file, String string) {
        if (file != null && file.exists() && file.isDirectory()) {
            this.directory = file;
            this.filename = string != null ? string : "";
        } else {
            this.directory = new File(System.getProperty("user.home", ""));
            this.filename = string != null ? string : "";
        }
    }

    public void setLoadMode() {
        this.loadmode = true;
    }

    public void setMultiSelection(boolean bl) {
        if (bl && this.dirsonly) {
            System.err.println(this.getClass().getName() + ".setMultiSelection(): multi selection and directory selection are not allowed together!");
            return;
        }
        this.multiselect = bl;
    }

    public void setSaveMode() {
        this.loadmode = false;
    }

    static /* synthetic */ File access$000(FileRequester2 fileRequester2) {
        return fileRequester2.directory;
    }

    static /* synthetic */ String[] access$2702(FileRequester2 fileRequester2, String[] stringArray) {
        fileRequester2.filenames = stringArray;
        return stringArray;
    }

    private class FileFilenameFilter
    implements FilenameFilter {
        FileFilter filefilter;

        public FileFilenameFilter(FileFilter fileFilter) {
            this.filefilter = fileFilter;
        }

        public boolean accept(File file, String string) {
            if (string.charAt(0) == '.') {
                return false;
            }
            File file2 = new File(file, string);
            if (file2.isDirectory()) {
                return false;
            }
            return this.filefilter.accept(file2);
        }
    }

    private class DirectoryFilenameFilter
    implements FilenameFilter {
        private DirectoryFilenameFilter() {
        }

        public boolean accept(File file, String string) {
            if (!FileRequester2.this.showdots && string.charAt(0) == '.') {
                return false;
            }
            return new File(file, string).isDirectory();
        }
    }

    private class Dialog
    extends JDialog {
        private final String DIR = JReqTools.getResourceString("DIR") + " ";
        private final String PARENT = this.DIR + JReqTools.getResourceString("ParentDirectory");
        private File directory = FileRequester2.access$000(FileRequester2.this);
        private TButton home = new TButton(JReqTools.getIcon("home"));
        private TButton reload = new TButton(JReqTools.getIcon("reload"));
        private TButton mkdir = new TButton(JReqTools.getIcon("makedir"));
        private TButton parent = new TButton(JReqTools.getIcon("parent"));
        private TButton toggledot = new TButton(JReqTools.getIcon("toggledot"));
        private JList list = new JList();
        private TextField directorytf = new TextField("");
        private TextField filenametf = new TextField("");
        private JComboBox filters = new JComboBox(FileRequester2.access$100(FileRequester2.this));
        private JScrollPane scrollpane = new JScrollPane(this.list, 22, 30);
        private JPopupMenu popupmenu = new JPopupMenu();

        public Dialog(JFrame jFrame) {
            super(jFrame, "JReqTools: FileRequester", true);
            this.scrollpane.setPreferredSize(new Dimension(300, 400));
            this.directorytf.setText(this.directory.toString());
            this.filenametf.setText(FileRequester2.this.filename);
            this.filters.setSelectedIndex(FileRequester2.this.filter);
            this.list.setListData(this.getDirectory(this.directory));
            this.list.add(this.popupmenu);
            this.list.setCellRenderer(new MyRenderer());
            if (!FileRequester2.this.multiselect) {
                this.list.setSelectionMode(0);
            }
            this.list.setSelectedValue(FileRequester2.this.filename, true);
            if (this.list.getSelectedIndex() == -1) {
                this.list.setSelectedIndex(0);
            }
            this.initPopupMenu();
            this.list.addListSelectionListener(new ListSelectionListener(this){
                private final /* synthetic */ Dialog this$1;
                {
                    this.this$1 = dialog;
                }

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    Dialog.access$800(this.this$1, listSelectionEvent);
                }
            });
            this.list.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ Dialog this$1;
                {
                    this.this$1 = dialog;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    Dialog.access$900(this.this$1, mouseEvent);
                }
            });
            this.list.addKeyListener(new KeyAdapter(this){
                private final /* synthetic */ Dialog this$1;
                {
                    this.this$1 = dialog;
                }

                public void keyTyped(KeyEvent keyEvent) {
                    Dialog.access$1000(this.this$1, keyEvent);
                }
            });
            this.directorytf.addActionListener(new ActionListener(this){
                private final /* synthetic */ Dialog this$1;
                {
                    this.this$1 = dialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Dialog.access$1100(this.this$1, actionEvent);
                }
            });
            this.filenametf.addActionListener(new ActionListener(this){
                private final /* synthetic */ Dialog this$1;
                {
                    this.this$1 = dialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Dialog.access$1300(this.this$1).setSelectedValue(Dialog.access$1200(this.this$1).getText(), true);
                    Dialog.access$1400(this.this$1);
                }
            });
            this.filters.addActionListener(new ActionListener(this){
                private final /* synthetic */ Dialog this$1;
                {
                    this.this$1 = dialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    String[] stringArray = Dialog.access$1600(this.this$1, Dialog.access$1500(this.this$1));
                    Dialog.access$1300(this.this$1).setListData(stringArray);
                    if (stringArray.length > 0) {
                        Dialog.access$1300(this.this$1).setSelectedValue(stringArray[0], true);
                    }
                }
            });
            this.home.addActionListener(new ActionListener(this){
                private final /* synthetic */ Dialog this$1;
                {
                    this.this$1 = dialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Dialog.access$1700(this.this$1).setText(System.getProperty("user.home"));
                    Dialog.access$1100(this.this$1, actionEvent);
                }
            });
            this.parent.addActionListener(new ActionListener(this){
                private final /* synthetic */ Dialog this$1;
                {
                    this.this$1 = dialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Dialog.access$1800(this.this$1);
                }
            });
            this.reload.addActionListener(new ActionListener(this){
                private final /* synthetic */ Dialog this$1;
                {
                    this.this$1 = dialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Dialog.access$1900(this.this$1);
                }
            });
            this.mkdir.addActionListener(new ActionListener(this){
                private final /* synthetic */ Dialog this$1;
                {
                    this.this$1 = dialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Dialog.access$2000(this.this$1);
                    Dialog.access$1900(this.this$1);
                }
            });
            this.toggledot.addActionListener(new ActionListener(this){
                private final /* synthetic */ Dialog this$1;
                {
                    this.this$1 = dialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.toggledot(actionEvent);
                }
            });
            XPanel xPanel = new XPanel();
            xPanel.add(this.parent);
            xPanel.add(this.home);
            xPanel.add(this.reload);
            xPanel.add(this.mkdir);
            xPanel.add(this.toggledot);
            xPanel.add(Box.createHorizontalGlue());
            OkCancelButtons okCancelButtons = new OkCancelButtons(FileRequester2.this, new ActionListener(this){
                private final /* synthetic */ Dialog this$1;
                {
                    this.this$1 = dialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Dialog.access$1400(this.this$1);
                }
            }, new ActionListener(this){
                private final /* synthetic */ Dialog this$1;
                {
                    this.this$1 = dialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Dialog.access$2100(this.this$1);
                }
            }, FileRequester2.this.listener);
            okCancelButtons.setButtonText(0, FileRequester2.this.loadmode ? JReqTools.getResourceString("Load") : JReqTools.getResourceString("Save"));
            if (FileRequester2.this.dirsonly) {
                okCancelButtons.setButtonText(0, JReqTools.getResourceString("Select"));
            }
            YFramePanel yFramePanel = new YFramePanel();
            yFramePanel.add(xPanel);
            yFramePanel.add(this.scrollpane);
            yFramePanel.add(new Strut());
            yFramePanel.add(this.createPanel());
            yFramePanel.add(new Strut());
            yFramePanel.add(okCancelButtons);
            this.setContentPane(yFramePanel);
            this.getLayeredPane().add((Component)new BackgroundImage(), new Integer(Integer.MIN_VALUE));
            this.pack();
        }

        private void cancel() {
            FileRequester2.this.answer = -1;
            this.setVisible(false);
        }

        private Panel createPanel() {
            Panel panel = new Panel(this){
                private final /* synthetic */ Dialog this$1;
                {
                    this.this$1 = dialog;
                }

                public Dimension getMaximumSize() {
                    return new Dimension(Short.MAX_VALUE, this.getPreferredSize().height);
                }
            };
            panel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            if (!FileRequester2.this.dirsonly) {
                gridBagConstraints.insets = JReqTools.getObjectInsets(0, 0, -1, -1);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.weightx = 0.0;
                panel.add((Component)new JLabel(JReqTools.getResourceString("FileFilter")), gridBagConstraints);
                gridBagConstraints.insets = JReqTools.getObjectInsets(0, 0, -1, 0);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.weightx = 1.0;
                panel.add((Component)this.filters, gridBagConstraints);
            }
            gridBagConstraints.insets = JReqTools.getObjectInsets(0, 0, -1, -1);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 0.0;
            panel.add((Component)new JLabel(JReqTools.getResourceString("Directory")), gridBagConstraints);
            gridBagConstraints.insets = JReqTools.getObjectInsets(0, 0, -1, 0);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            panel.add((Component)this.directorytf, gridBagConstraints);
            if (!FileRequester2.this.dirsonly && !FileRequester2.this.multiselect) {
                gridBagConstraints.insets = JReqTools.getObjectInsets(0, 0, 0, -1);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.weightx = 0.0;
                panel.add((Component)new JLabel(JReqTools.getResourceString("Filename")), gridBagConstraints);
                gridBagConstraints.insets = JReqTools.getObjectInsets(0, 0, 0, 0);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.gridwidth = 3;
                panel.add((Component)this.filenametf, gridBagConstraints);
            }
            return panel;
        }

        private String[] getDirectory(File file) {
            String[] stringArray = file.list(new DirectoryFilenameFilter());
            String[] stringArray2 = FileRequester2.this.dirsonly ? null : file.list(new FileFilenameFilter((FileFilter)FileRequester2.this.filefilters.elementAt(this.filters.getSelectedIndex())));
            int n = 0;
            if (stringArray != null) {
                Sorter.sort(stringArray);
                n = stringArray.length;
            }
            if (stringArray2 != null) {
                Sorter.sort(stringArray2);
                n += stringArray2.length;
            }
            String[] stringArray3 = new String[n + 1];
            stringArray3[0] = this.PARENT;
            if (stringArray != null) {
                int n2 = 0;
                while (n2 < stringArray.length) {
                    stringArray3[n2 + 1] = this.DIR + stringArray[n2];
                    ++n2;
                }
            }
            if (stringArray2 != null) {
                int n3 = 0;
                while (n3 < stringArray2.length) {
                    stringArray3[n3 + stringArray.length + 1] = stringArray2[n3];
                    ++n3;
                }
            }
            return stringArray3;
        }

        private void initPopupMenu() {
            File file = new File("/");
            if (!file.exists()) {
                return;
            }
            JMenuItem jMenuItem = new JMenuItem("Root Directory");
            jMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ Dialog this$1;
                {
                    this.this$1 = dialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Dialog.access$1700(this.this$1).setText("/");
                    Dialog.access$1100(this.this$1, actionEvent);
                }
            });
            this.popupmenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Home Directory");
            jMenuItem.addActionListener(new ActionListener(this){
                private final /* synthetic */ Dialog this$1;
                {
                    this.this$1 = dialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Dialog.access$1700(this.this$1).setText(System.getProperty("user.home"));
                    Dialog.access$1100(this.this$1, actionEvent);
                }
            });
            this.popupmenu.add(jMenuItem);
            file = new File(System.getProperty("user.home"), "Desktop");
            if (file.exists() && file.isDirectory()) {
                jMenuItem = new JMenuItem("KDE Desktop Directory");
                jMenuItem.addActionListener(new ActionListener(this){
                    private final /* synthetic */ Dialog this$1;
                    {
                        this.this$1 = dialog;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        Dialog.access$1700(this.this$1).setText(System.getProperty("user.home") + File.separator + "Desktop");
                        Dialog.access$1100(this.this$1, actionEvent);
                    }
                });
                this.popupmenu.add(jMenuItem);
            }
            this.list.add(this.popupmenu);
            this.list.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ Dialog this$1;
                {
                    this.this$1 = dialog;
                }

                private void doit(MouseEvent mouseEvent) {
                    if (mouseEvent.isPopupTrigger()) {
                        Dialog.access$2600(this.this$1).show(Dialog.access$1300(this.this$1), mouseEvent.getX() - 5, mouseEvent.getY() - 5);
                        mouseEvent.consume();
                    }
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    this.doit(mouseEvent);
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    this.doit(mouseEvent);
                }
            });
        }

        private void makeDir() {
            String string = JReqTools.requestString(null, JReqTools.getResourceString("CreateDirectoryTitle"), JReqTools.getResourceString("CreateDirectoryMessage"), "");
            if (string.length() == 0) {
                return;
            }
            File file = new File(this.directory, string);
            if (file.mkdir()) {
                return;
            }
            JReqTools.showError(JReqTools.getResourceString("DirectoryNotCreated"));
        }

        private void ok() {
            if (FileRequester2.this.multiselect) {
                Object[] objectArray = this.list.getSelectedValues();
                if (objectArray == null) {
                    JReqTools.showError(JReqTools.getResourceString("NoFileName"));
                    return;
                }
                Vector<Object> vector = new Vector<Object>();
                int n = 0;
                while (n < objectArray.length) {
                    if (objectArray[n] != this.PARENT && !((String)objectArray[n]).startsWith(this.DIR)) {
                        vector.addElement(objectArray[n]);
                    }
                    ++n;
                }
                if (vector.size() == 0) {
                    JReqTools.showError(JReqTools.getResourceString("NoFileName"));
                    return;
                }
                FileRequester2.access$2702(FileRequester2.this, new String[vector.size()]);
                int n2 = 0;
                while (n2 < vector.size()) {
                    ((FileRequester2)FileRequester2.this).filenames[n2] = (String)vector.elementAt(n2);
                    ++n2;
                }
                FileRequester2.this.answer = 0;
                FileRequester2.this.directory = this.directory;
                this.setVisible(false);
                return;
            }
            if (FileRequester2.this.dirsonly) {
                FileRequester2.this.answer = 0;
                FileRequester2.this.directory = this.directory;
                this.setVisible(false);
                return;
            }
            if (this.filenametf.getText().length() == 0) {
                this.getToolkit().beep();
                JReqTools.showError(JReqTools.getResourceString("NoFileName"));
                this.filenametf.requestFocus();
                return;
            }
            File file = new File(this.directory, this.filenametf.getText());
            if (file.isDirectory()) {
                this.getToolkit().beep();
                JReqTools.showError("'" + file.toString() + "'\n" + JReqTools.getResourceString("IsADirectory"));
                this.filenametf.requestFocus();
                return;
            }
            file = new File(this.directory, this.filenametf.getText());
            if (FileRequester2.this.loadmode && !file.exists()) {
                this.getToolkit().beep();
                JReqTools.showError("'" + file.toString() + "'\n" + JReqTools.getResourceString("DoesNotExist"));
                this.filenametf.requestFocus();
                return;
            }
            FileRequester2.this.answer = 0;
            FileRequester2.this.directory = this.directory;
            FileRequester2.this.filename = this.filenametf.getText();
            FileRequester2.this.filter = this.filters.getSelectedIndex();
            this.setVisible(false);
        }

        private void parent() {
            String string;
            String string2 = string = this.directory != null ? this.directory.getParent() : null;
            if (string == null) {
                File[] fileArray = File.listRoots();
                if (this.directory != null && fileArray != null && fileArray.length > 1) {
                    String[] stringArray = new String[fileArray.length];
                    int n = 0;
                    while (n < stringArray.length) {
                        stringArray[n] = this.DIR + fileArray[n].toString();
                        ++n;
                    }
                    this.list.setListData(stringArray);
                    this.directory = null;
                    this.directorytf.setText("");
                    this.list.setSelectedValue(stringArray[0], true);
                    return;
                }
                this.getToolkit().beep();
                JReqTools.showError(JReqTools.getResourceString("ParentDoesNotExist"));
                return;
            }
            this.directory = new File(string);
            String[] stringArray = this.getDirectory(this.directory);
            this.list.setListData(stringArray);
            this.directorytf.setText(this.directory.toString());
            if (stringArray.length > 0) {
                this.list.setSelectedValue(stringArray[0], true);
            }
        }

        private void reload() {
            String[] stringArray = this.getDirectory(this.directory);
            this.list.setListData(stringArray);
            if (stringArray.length > 0) {
                this.list.setSelectedValue(stringArray[0], true);
            }
        }

        private void selected(ActionEvent actionEvent) {
            File file = new File(this.directorytf.getText());
            if (!file.isDirectory()) {
                this.getToolkit().beep();
                JReqTools.showError("'" + file.toString() + "'\n" + JReqTools.getResourceString("DoesNotExist2"));
                return;
            }
            String[] stringArray = this.getDirectory(file);
            this.list.setListData(stringArray);
            if (stringArray.length > 0) {
                this.list.setSelectedValue(stringArray[0], true);
            }
            this.directory = file;
        }

        private void selected(MouseEvent mouseEvent) {
            String string = (String)this.list.getSelectedValue();
            if (string.startsWith(this.DIR) || string == this.PARENT) {
                if (mouseEvent.getClickCount() < 2) {
                    return;
                }
                if (string == this.PARENT) {
                    this.parent();
                    return;
                }
                this.directory = this.directory != null ? new File(this.directory, string.substring(this.DIR.length())) : new File(string.substring(this.DIR.length()));
                String[] stringArray = this.getDirectory(this.directory);
                this.list.setListData(stringArray);
                this.directorytf.setText(this.directory.toString());
                if (stringArray.length > 0) {
                    this.list.setSelectedValue(stringArray[0], false);
                }
            } else {
                this.filenametf.setText(string);
                if (mouseEvent.getClickCount() > 1) {
                    this.ok();
                }
            }
        }

        private void selected(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\u001b') {
                this.cancel();
                return;
            }
            if (keyEvent.getKeyChar() != '\n') {
                return;
            }
            String string = (String)this.list.getSelectedValue();
            if (string.startsWith(this.DIR) || string == this.PARENT) {
                if (string == this.PARENT) {
                    this.parent();
                    return;
                }
                this.directory = this.directory != null ? new File(this.directory, string.substring(this.DIR.length())) : new File(string.substring(this.DIR.length()));
                String[] stringArray = this.getDirectory(this.directory);
                this.list.setListData(stringArray);
                this.directorytf.setText(this.directory.toString());
                if (stringArray.length > 0) {
                    this.list.setSelectedValue(stringArray[0], true);
                }
            } else {
                this.filenametf.setText(string);
                this.ok();
            }
        }

        private void selected(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            String string = (String)this.list.getSelectedValue();
            if (string == null) {
                return;
            }
            if (string.startsWith(this.DIR)) {
                return;
            }
            this.filenametf.setText(string);
        }

        public void setVisible(boolean bl) {
            if (bl) {
                this.list.requestFocus();
            }
            super.setVisible(bl);
        }

        public void toggledot(ActionEvent actionEvent) {
            FileRequester2.this.showdots = !FileRequester2.this.showdots;
            this.reload();
        }

        static /* synthetic */ void access$800(Dialog dialog, ListSelectionEvent listSelectionEvent) {
            dialog.selected(listSelectionEvent);
        }

        static /* synthetic */ void access$900(Dialog dialog, MouseEvent mouseEvent) {
            dialog.selected(mouseEvent);
        }

        static /* synthetic */ void access$1000(Dialog dialog, KeyEvent keyEvent) {
            dialog.selected(keyEvent);
        }

        static /* synthetic */ void access$1100(Dialog dialog, ActionEvent actionEvent) {
            dialog.selected(actionEvent);
        }

        static /* synthetic */ TextField access$1200(Dialog dialog) {
            return dialog.filenametf;
        }

        static /* synthetic */ JList access$1300(Dialog dialog) {
            return dialog.list;
        }

        static /* synthetic */ void access$1400(Dialog dialog) {
            dialog.ok();
        }

        static /* synthetic */ File access$1500(Dialog dialog) {
            return dialog.directory;
        }

        static /* synthetic */ String[] access$1600(Dialog dialog, File file) {
            return dialog.getDirectory(file);
        }

        static /* synthetic */ TextField access$1700(Dialog dialog) {
            return dialog.directorytf;
        }

        static /* synthetic */ void access$1800(Dialog dialog) {
            dialog.parent();
        }

        static /* synthetic */ void access$1900(Dialog dialog) {
            dialog.reload();
        }

        static /* synthetic */ void access$2000(Dialog dialog) {
            dialog.makeDir();
        }

        static /* synthetic */ void access$2100(Dialog dialog) {
            dialog.cancel();
        }

        static /* synthetic */ JPopupMenu access$2600(Dialog dialog) {
            return dialog.popupmenu;
        }

        private class MyRenderer
        extends DefaultListCellRenderer {
            private final Icon directory = JReqTools.getIcon("directory");
            private final Icon file = JReqTools.getIcon("file");
            private final Icon parent = JReqTools.getIcon("parent");
            private final Icon device = JReqTools.getIcon("HardDrive");

            private MyRenderer() {
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                String string = "";
                if (object instanceof String) {
                    String string2 = (String)object;
                    String string3 = string = string2.startsWith(Dialog.this.DIR) ? string2.substring(Dialog.this.DIR.length()) : string2;
                    this.setIcon(string2 == Dialog.this.PARENT ? this.parent : (string2.startsWith(Dialog.this.DIR) ? this.directory : this.file));
                } else {
                    this.setIcon(null);
                    string = object.toString();
                }
                return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
            }
        }
    }
}

